/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.expression;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import org.apache.gluten.backendsapi.BackendsApiManager$;
import org.apache.gluten.exception.GlutenNotSupportException;
import org.apache.gluten.expression.AttributeReferenceTransformer;
import org.apache.gluten.expression.BoundReferenceTransformer;
import org.apache.gluten.expression.CaseWhenTransformer;
import org.apache.gluten.expression.CastTransformer;
import org.apache.gluten.expression.CheckOverflowTransformer;
import org.apache.gluten.expression.ChildTransformer;
import org.apache.gluten.expression.CreateArrayTransformer;
import org.apache.gluten.expression.CreateMapTransformer;
import org.apache.gluten.expression.DecimalArithmeticExpressionTransformer;
import org.apache.gluten.expression.DecimalRoundTransformer;
import org.apache.gluten.expression.ExplodeTransformer;
import org.apache.gluten.expression.ExpressionMappings$;
import org.apache.gluten.expression.ExpressionTransformer;
import org.apache.gluten.expression.ExtractDateTransformer;
import org.apache.gluten.expression.GenericExpressionTransformer;
import org.apache.gluten.expression.GenericExpressionTransformer$;
import org.apache.gluten.expression.IfTransformer;
import org.apache.gluten.expression.InSetTransformer;
import org.apache.gluten.expression.InTransformer;
import org.apache.gluten.expression.JsonTupleExpressionTransformer;
import org.apache.gluten.expression.LambdaFunctionTransformer;
import org.apache.gluten.expression.LiteralTransformer;
import org.apache.gluten.expression.LiteralTransformer$;
import org.apache.gluten.expression.ScalarSubqueryTransformer;
import org.apache.gluten.expression.Transformable;
import org.apache.gluten.expression.UDFMappings$;
import org.apache.gluten.sql.shims.SparkShimLoader$;
import org.apache.gluten.test.TestStats;
import org.apache.gluten.utils.DecimalArithmeticUtil$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.ArrayExists;
import org.apache.spark.sql.catalyst.expressions.ArrayFilter;
import org.apache.spark.sql.catalyst.expressions.ArrayForAll;
import org.apache.spark.sql.catalyst.expressions.ArraySort;
import org.apache.spark.sql.catalyst.expressions.ArrayTransform;
import org.apache.spark.sql.catalyst.expressions.AtLeastNNonNulls;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.BindReferences$;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.CaseWhen;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.CheckOverflow;
import org.apache.spark.sql.catalyst.expressions.CreateArray;
import org.apache.spark.sql.catalyst.expressions.CreateMap;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.DateAdd;
import org.apache.spark.sql.catalyst.expressions.DateDiff;
import org.apache.spark.sql.catalyst.expressions.Divide;
import org.apache.spark.sql.catalyst.expressions.DynamicPruningExpression;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.EulerNumber;
import org.apache.spark.sql.catalyst.expressions.Explode;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GetArrayItem;
import org.apache.spark.sql.catalyst.expressions.GetArrayStructFields;
import org.apache.spark.sql.catalyst.expressions.GetDateField;
import org.apache.spark.sql.catalyst.expressions.GetMapValue;
import org.apache.spark.sql.catalyst.expressions.GetStructField;
import org.apache.spark.sql.catalyst.expressions.GetTimeField;
import org.apache.spark.sql.catalyst.expressions.HashExpression;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.InSet;
import org.apache.spark.sql.catalyst.expressions.Inline;
import org.apache.spark.sql.catalyst.expressions.IntegralDivide;
import org.apache.spark.sql.catalyst.expressions.JsonToStructs;
import org.apache.spark.sql.catalyst.expressions.JsonTuple;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.Like;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MakeDecimal;
import org.apache.spark.sql.catalyst.expressions.MakeTimestamp;
import org.apache.spark.sql.catalyst.expressions.MapEntries;
import org.apache.spark.sql.catalyst.expressions.MonthsBetween;
import org.apache.spark.sql.catalyst.expressions.Multiply;
import org.apache.spark.sql.catalyst.expressions.NaNvl;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.Pi;
import org.apache.spark.sql.catalyst.expressions.PosExplode;
import org.apache.spark.sql.catalyst.expressions.PreciseTimestampConversion;
import org.apache.spark.sql.catalyst.expressions.PromotePrecision;
import org.apache.spark.sql.catalyst.expressions.PythonUDF;
import org.apache.spark.sql.catalyst.expressions.RaiseError;
import org.apache.spark.sql.catalyst.expressions.RegExpReplace;
import org.apache.spark.sql.catalyst.expressions.Round;
import org.apache.spark.sql.catalyst.expressions.ScalaUDF;
import org.apache.spark.sql.catalyst.expressions.Shuffle;
import org.apache.spark.sql.catalyst.expressions.Size;
import org.apache.spark.sql.catalyst.expressions.SparkVersion;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression;
import org.apache.spark.sql.catalyst.expressions.StringSplit;
import org.apache.spark.sql.catalyst.expressions.StringToMap;
import org.apache.spark.sql.catalyst.expressions.StringTranslate;
import org.apache.spark.sql.catalyst.expressions.StringTrim;
import org.apache.spark.sql.catalyst.expressions.StringTrimBoth;
import org.apache.spark.sql.catalyst.expressions.StringTrimLeft;
import org.apache.spark.sql.catalyst.expressions.StringTrimRight;
import org.apache.spark.sql.catalyst.expressions.StructsToJson;
import org.apache.spark.sql.catalyst.expressions.Subtract;
import org.apache.spark.sql.catalyst.expressions.TaggingExpression;
import org.apache.spark.sql.catalyst.expressions.ToUnixTimestamp;
import org.apache.spark.sql.catalyst.expressions.TransformKeys;
import org.apache.spark.sql.catalyst.expressions.TruncTimestamp;
import org.apache.spark.sql.catalyst.expressions.TryEval;
import org.apache.spark.sql.catalyst.expressions.UnBase64;
import org.apache.spark.sql.catalyst.expressions.UnixTimestamp;
import org.apache.spark.sql.catalyst.expressions.Uuid;
import org.apache.spark.sql.catalyst.expressions.objects.Invoke;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.catalyst.expressions.objects.StructsToJsonInvoke$;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.catalyst.optimizer.NormalizeNaNAndZero;
import org.apache.spark.sql.execution.ScalarSubquery;
import org.apache.spark.sql.hive.HiveUDFTransformer$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class ExpressionConverter$
implements SQLConfHelper,
Logging {
    public static final ExpressionConverter$ MODULE$ = new ExpressionConverter$();
    private static final scala.collection.immutable.Map<String, String> icebergStaticInvokeMap;
    private static final scala.collection.immutable.Map<String, String> staticInvokeMap;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        SQLConfHelper.$init$((SQLConfHelper)MODULE$);
        Logging.$init$((Logging)MODULE$);
        icebergStaticInvokeMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"BucketFunction"), (Object)"bucket"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"TruncateFunction"), (Object)"truncate"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"YearsFunction"), (Object)"years"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"MonthsFunction"), (Object)"months"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DaysFunction"), (Object)"days"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"HoursFunction"), (Object)"hours")}));
        staticInvokeMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"varcharTypeWriteSideCheck"), (Object)"varchar_type_write_side_check"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"charTypeWriteSideCheck"), (Object)"char_type_write_side_check"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"readSidePadding"), (Object)"read_side_padding"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lengthOfJsonArray"), (Object)"json_array_length"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"jsonObjectKeys"), (Object)"json_object_keys")}));
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Seq<ExpressionTransformer> replaceWithExpressionTransformer(Seq<Expression> exprs, Seq<Attribute> attributeSeq) {
        scala.collection.immutable.Map<Class<?>, String> expressionsMap = ExpressionMappings$.MODULE$.expressionsMap();
        return (Seq)exprs.map((Function1 & Serializable)expr -> MODULE$.replaceWithExpressionTransformer0((Expression)expr, attributeSeq, expressionsMap));
    }

    public ExpressionTransformer replaceWithExpressionTransformer(Expression expr, Seq<Attribute> attributeSeq) {
        scala.collection.immutable.Map<Class<?>, String> expressionsMap = ExpressionMappings$.MODULE$.expressionsMap();
        return this.replaceWithExpressionTransformer0(expr, attributeSeq, expressionsMap);
    }

    public boolean canReplaceWithExpressionTransformer(Expression expr, Seq<Attribute> attributeSeq) {
        boolean bl;
        try {
            this.replaceWithExpressionTransformer(expr, attributeSeq);
            bl = true;
        }
        catch (Exception e) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> e.getMessage());
            bl = false;
        }
        return bl;
    }

    public Expression replaceAttributeReference(Expression expr) {
        Expression expression = expr;
        if (expression instanceof AttributeReference) {
            AttributeReference attributeReference = (AttributeReference)expression;
            DataType dataType = attributeReference.dataType();
            BooleanType$ booleanType$ = BooleanType$.MODULE$;
            if (!(dataType != null ? !dataType.equals(booleanType$) : booleanType$ != null)) {
                return new EqualNullSafe((Expression)attributeReference, (Expression)Literal$.MODULE$.TrueLiteral());
            }
        }
        return expression;
    }

    private ExpressionTransformer replacePythonUDFWithExpressionTransformer(PythonUDF udf, Seq<Attribute> attributeSeq, scala.collection.immutable.Map<Class<?>, String> expressionsMap) {
        Option substraitExprName = UDFMappings$.MODULE$.pythonUDFMap().get((Object)udf.name());
        Option option = substraitExprName;
        if (option instanceof Some) {
            Some some = (Some)option;
            String name = (String)some.value();
            return new GenericExpressionTransformer(name, (Seq<ExpressionTransformer>)((Seq)udf.children().map((Function1 & Serializable)x$1 -> MODULE$.replaceWithExpressionTransformer0((Expression)x$1, attributeSeq, expressionsMap))), (Expression)udf);
        }
        throw new GlutenNotSupportException("Not supported python udf: " + udf + ".");
    }

    private ExpressionTransformer replaceScalaUDFWithExpressionTransformer(ScalaUDF udf, Seq<Attribute> attributeSeq, scala.collection.immutable.Map<Class<?>, String> expressionsMap) {
        if (udf.udfName().isEmpty()) {
            throw new GlutenNotSupportException("UDF name is not found!");
        }
        Option substraitExprName = UDFMappings$.MODULE$.scalaUDFMap().get(udf.udfName().get());
        Option option = substraitExprName;
        if (option instanceof Some) {
            Some some = (Some)option;
            String name = (String)some.value();
            return new GenericExpressionTransformer(name, (Seq<ExpressionTransformer>)((Seq)udf.children().map((Function1 & Serializable)x$2 -> MODULE$.replaceWithExpressionTransformer0((Expression)x$2, attributeSeq, expressionsMap))), (Expression)udf);
        }
        throw new GlutenNotSupportException("Not supported scala udf: " + udf + ".");
    }

    private ExpressionTransformer replaceFlattenedExpressionWithExpressionTransformer(String substraitName, Expression expr, Seq<Attribute> attributeSeq, scala.collection.immutable.Map<Class<?>, String> expressionsMap) {
        Seq children = (Seq)expr.children().map((Function1 & Serializable)x$3 -> MODULE$.replaceWithExpressionTransformer0((Expression)x$3, attributeSeq, expressionsMap));
        return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genFlattenedExpressionTransformer(substraitName, (Seq<ExpressionTransformer>)children, expr);
    }

    private DecimalArithmeticExpressionTransformer genRescaleDecimalTransformer(String substraitName, BinaryArithmetic b, Seq<Attribute> attributeSeq, scala.collection.immutable.Map<Class<?>, String> expressionsMap) {
        BinaryArithmetic rescaleBinary = DecimalArithmeticUtil$.MODULE$.rescaleLiteral(b);
        Tuple2<Expression, Expression> tuple2 = DecimalArithmeticUtil$.MODULE$.rescaleCastForDecimal(DecimalArithmeticUtil$.MODULE$.removeCastForDecimal((Expression)rescaleBinary.left()), DecimalArithmeticUtil$.MODULE$.removeCastForDecimal((Expression)rescaleBinary.right()));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression left = (Expression)tuple2._1();
        Expression right = (Expression)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)left, (Object)right);
        Expression left2 = (Expression)tuple22._1();
        Expression right2 = (Expression)tuple22._2();
        DecimalType resultType = DecimalArithmeticUtil$.MODULE$.getResultType(b, (DecimalType)left2.dataType(), (DecimalType)right2.dataType());
        ExpressionTransformer leftChild = this.replaceWithExpressionTransformer0(left2, attributeSeq, expressionsMap);
        ExpressionTransformer rightChild = this.replaceWithExpressionTransformer0(right2, attributeSeq, expressionsMap);
        return new DecimalArithmeticExpressionTransformer(substraitName, leftChild, rightChild, resultType, (Expression)b);
    }

    private scala.collection.immutable.Map<String, String> icebergStaticInvokeMap() {
        return icebergStaticInvokeMap;
    }

    private scala.collection.immutable.Map<String, String> staticInvokeMap() {
        return staticInvokeMap;
    }

    private ExpressionTransformer replaceStaticInvokeWithExpressionTransformer(StaticInvoke i, Seq<Attribute> attributeSeq, scala.collection.immutable.Map<Class<?>, String> expressionsMap) {
        String funcName;
        String objName = i.objectName();
        String string = funcName = i.functionName();
        String string2 = "invoke";
        None$ icebergTransformer = !(string != null ? !string.equals(string2) : string2 != null) ? this.icebergStaticInvokeMap().collectFirst((PartialFunction)new Serializable(objName, i, attributeSeq, expressionsMap){
            private static final long serialVersionUID = 0L;
            private final String objName$1;
            private final StaticInvoke i$1;
            private final Seq attributeSeq$5;
            private final scala.collection.immutable.Map expressionsMap$5;

            public final <A1 extends Tuple2<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    String func = (String)A1._1();
                    String name = (String)A1._2();
                    if (this.objName$1.startsWith("org.apache.iceberg.spark.functions." + func)) {
                        return (B1)new GenericExpressionTransformer(name, (Seq<ExpressionTransformer>)((Seq)this.i$1.arguments().map((Function1 & Serializable)child -> ExpressionConverter$.MODULE$.org$apache$gluten$expression$ExpressionConverter$$doTransform$1((Expression)child, $this.attributeSeq$5, $this.expressionsMap$5))), (Expression)this.i$1);
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<String, String> x1) {
                String func;
                Tuple2<String, String> tuple2 = x1;
                return tuple2 != null && this.objName$1.startsWith("org.apache.iceberg.spark.functions." + (func = (String)tuple2._1()));
            }
            {
                this.objName$1 = objName$1;
                this.i$1 = i$1;
                this.attributeSeq$5 = attributeSeq$5;
                this.expressionsMap$5 = expressionsMap$5;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.gluten.expression.ExpressionConverter$$anonfun$1 org.apache.spark.sql.catalyst.expressions.Expression )}, serializedLambda);
            }
        }) : None$.MODULE$;
        return (ExpressionTransformer)icebergTransformer.getOrElse((Function0 & Serializable)() -> {
            String string;
            block11: {
                string = funcName;
                switch (string == null ? 0 : string.hashCode()) {
                    case -1335717394: {
                        if ("decode".equals(string)) {
                            break;
                        }
                        break block11;
                    }
                    case -1298776554: {
                        if ("encode".equals(string)) {
                            break;
                        }
                        break block11;
                    }
                    case -841815742: {
                        if ("isLuhnNumber".equals(string)) {
                            return ExpressionConverter$.validateAndTransform$1("luhn_check", (Function0 & Serializable)() -> new .colon.colon((Object)this.org$apache$gluten$expression$ExpressionConverter$$doTransform$1((Expression)i.arguments().head(), attributeSeq, expressionsMap), (List)Nil$.MODULE$), i, funcName);
                        }
                        break block11;
                    }
                    default: {
                        break block11;
                    }
                }
                if (objName.endsWith("UrlCodec")) {
                    return ExpressionConverter$.validateAndTransform$1("url_" + string, (Function0 & Serializable)() -> new .colon.colon((Object)this.org$apache$gluten$expression$ExpressionConverter$$doTransform$1((Expression)i.arguments().head(), attributeSeq, expressionsMap), (List)Nil$.MODULE$), i, funcName);
                }
                if (objName.endsWith("Base64") && BackendsApiManager$.MODULE$.getValidatorApiInstance().doExprValidate("base64", (Expression)i)) {
                    return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genBase64StaticInvokeTransformer("base64", this.org$apache$gluten$expression$ExpressionConverter$$doTransform$1((Expression)i.arguments().head(), attributeSeq, expressionsMap), i);
                }
            }
            if (MODULE$.staticInvokeMap().contains((Object)string)) {
                return ExpressionConverter$.validateAndTransform$1((String)MODULE$.staticInvokeMap().apply((Object)string), (Function0 & Serializable)() -> (Seq)i.arguments().map((Function1 & Serializable)child -> this.org$apache$gluten$expression$ExpressionConverter$$doTransform$1((Expression)child, attributeSeq, expressionsMap)), i, funcName);
            }
            throw new GlutenNotSupportException("Not supported to transform StaticInvoke with object: " + objName + ", function: " + funcName);
        });
    }

    private ExpressionTransformer replaceInvokeWithExpressionTransformer(Invoke invoke, Seq<Attribute> attributeSeq, scala.collection.immutable.Map<Class<?>, String> expressionsMap) {
        Option<Tuple3<scala.collection.immutable.Map<String, String>, Expression, Option<String>>> option;
        Invoke invoke2 = invoke;
        if (invoke2 != null && !(option = StructsToJsonInvoke$.MODULE$.unapply((Expression)invoke2)).isEmpty()) {
            scala.collection.immutable.Map options = (scala.collection.immutable.Map)((Tuple3)option.get())._1();
            Expression child = (Expression)((Tuple3)option.get())._2();
            Option timeZoneId = (Option)((Tuple3)option.get())._3();
            StructsToJson toJsonExpr = new StructsToJson(options, child, timeZoneId);
            String substraitExprName = this.getAndCheckSubstraitName((Expression)toJsonExpr, expressionsMap);
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genToJsonTransformer(substraitExprName, this.replaceWithExpressionTransformer0(child, attributeSeq, expressionsMap), toJsonExpr);
        }
        throw new GlutenNotSupportException("Not supported to transform Invoke with function: " + invoke);
    }

    private ExpressionTransformer replaceWithExpressionTransformer0(Expression expr, Seq<Attribute> attributeSeq, scala.collection.immutable.Map<Class<?>, String> expressionsMap) {
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "replaceWithExpressionTransformer expr: " + expr + " class: " + expr.getClass() + " name: " + expr.prettyName());
        return (ExpressionTransformer)this.tryTransformWithoutExpressionMapping(expr, attributeSeq, expressionsMap).getOrElse((Function0 & Serializable)() -> {
            String substraitExprName = MODULE$.getAndCheckSubstraitName(expr, expressionsMap);
            Option<ExpressionTransformer> backendConverted = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().extraExpressionConverter(substraitExprName, expr, attributeSeq);
            return (ExpressionTransformer)backendConverted.getOrElse((Function0 & Serializable)() -> MODULE$.transformExpression(expr, attributeSeq, expressionsMap, substraitExprName));
        });
    }

    private Option<ExpressionTransformer> tryTransformWithoutExpressionMapping(Expression expr, Seq<Attribute> attributeSeq, scala.collection.immutable.Map<Class<?>, String> expressionsMap) {
        ExpressionTransformer expressionTransformer;
        Expression expression = expr;
        if (expression instanceof PythonUDF) {
            PythonUDF pythonUDF = (PythonUDF)expression;
            expressionTransformer = this.replacePythonUDFWithExpressionTransformer(pythonUDF, attributeSeq, expressionsMap);
        } else if (expression instanceof ScalaUDF) {
            ScalaUDF scalaUDF = (ScalaUDF)expression;
            expressionTransformer = this.replaceScalaUDFWithExpressionTransformer(scalaUDF, attributeSeq, expressionsMap);
        } else if (HiveUDFTransformer$.MODULE$.isHiveUDF(expr)) {
            expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genHiveUDFTransformer(expr, attributeSeq);
        } else if (expression instanceof StaticInvoke) {
            StaticInvoke staticInvoke = (StaticInvoke)expression;
            expressionTransformer = this.replaceStaticInvokeWithExpressionTransformer(staticInvoke, attributeSeq, expressionsMap);
        } else if (expression instanceof Invoke) {
            Invoke invoke = (Invoke)expression;
            expressionTransformer = this.replaceInvokeWithExpressionTransformer(invoke, attributeSeq, expressionsMap);
        } else {
            expressionTransformer = null;
        }
        return Option$.MODULE$.apply((Object)expressionTransformer);
    }

    private ExpressionTransformer transformExpression(Expression expr2, Seq<Attribute> attributeSeq, scala.collection.immutable.Map<Class<?>, String> expressionsMap, String substraitExprName) {
        Expression a;
        Expression a2;
        Expression a3;
        BinaryArithmetic binaryArithmetic;
        PromotePrecision promotePrecision;
        Expression expression;
        Round round;
        boolean bl = false;
        CheckOverflow checkOverflow = null;
        boolean bl2 = false;
        BinaryExpression binaryExpression = null;
        boolean bl3 = false;
        TryEval tryEval = null;
        Expression expression2 = expr2;
        if (expression2 instanceof CreateArray) {
            CreateArray createArray = (CreateArray)expression2;
            Seq children = (Seq)createArray.children().map((Function1 & Serializable)x$5 -> MODULE$.replaceWithExpressionTransformer0((Expression)x$5, attributeSeq, expressionsMap));
            return new CreateArrayTransformer(substraitExprName, (Seq<ExpressionTransformer>)children, createArray);
        }
        if (expression2 instanceof GetArrayItem) {
            GetArrayItem getArrayItem = (GetArrayItem)expression2;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genGetArrayItemTransformer(substraitExprName, this.replaceWithExpressionTransformer0(getArrayItem.left(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(getArrayItem.right(), attributeSeq, expressionsMap), (Expression)getArrayItem);
        }
        if (expression2 instanceof CreateMap) {
            CreateMap createMap = (CreateMap)expression2;
            Seq children = (Seq)createMap.children().map((Function1 & Serializable)x$6 -> MODULE$.replaceWithExpressionTransformer0((Expression)x$6, attributeSeq, expressionsMap));
            return new CreateMapTransformer(substraitExprName, (Seq<ExpressionTransformer>)children, createMap);
        }
        if (expression2 instanceof GetMapValue) {
            GetMapValue getMapValue = (GetMapValue)expression2;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genGetMapValueTransformer(substraitExprName, this.replaceWithExpressionTransformer0(getMapValue.child(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(getMapValue.key(), attributeSeq, expressionsMap), getMapValue);
        }
        if (expression2 instanceof MapEntries) {
            MapEntries mapEntries = (MapEntries)expression2;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genMapEntriesTransformer(substraitExprName, this.replaceWithExpressionTransformer0(mapEntries.child(), attributeSeq, expressionsMap), (Expression)mapEntries);
        }
        if (expression2 instanceof Explode) {
            Explode explode = (Explode)expression2;
            return new ExplodeTransformer(substraitExprName, this.replaceWithExpressionTransformer0(explode.child(), attributeSeq, expressionsMap), explode);
        }
        if (expression2 instanceof PosExplode) {
            PosExplode posExplode = (PosExplode)expression2;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genPosExplodeTransformer(substraitExprName, this.replaceWithExpressionTransformer0(posExplode.child(), attributeSeq, expressionsMap), posExplode, attributeSeq);
        }
        if (expression2 instanceof Inline) {
            Inline inline = (Inline)expression2;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genInlineTransformer(substraitExprName, this.replaceWithExpressionTransformer0(inline.child(), attributeSeq, expressionsMap), (Expression)inline);
        }
        if (expression2 instanceof Alias) {
            Alias alias = (Alias)expression2;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genAliasTransformer(substraitExprName, this.replaceWithExpressionTransformer0(alias.child(), attributeSeq, expressionsMap), (Expression)alias);
        }
        if (expression2 instanceof AttributeReference) {
            AttributeReference attributeReference = (AttributeReference)expression2;
            if (attributeSeq == null) {
                throw new UnsupportedOperationException("attributeSeq should not be null.");
            }
            package.AttributeSeq input = package$.MODULE$.AttributeSeq(attributeSeq);
            if (input.indexOf(attributeReference.exprId()) == -1) {
                throw new UnsupportedOperationException("Failed to bind reference: couldn't find " + attributeReference + " in " + input.attrs().mkString("[", ",", "]"));
            }
            BoundReference b = (BoundReference)BindReferences$.MODULE$.bindReference(expr2, input, false);
            return new AttributeReferenceTransformer(substraitExprName, attributeReference, b);
        }
        if (expression2 instanceof BoundReference) {
            BoundReference boundReference = (BoundReference)expression2;
            return new BoundReferenceTransformer(substraitExprName, boundReference);
        }
        if (expression2 instanceof Literal) {
            Literal literal = (Literal)expression2;
            return new LiteralTransformer(literal);
        }
        if (expression2 instanceof DateDiff) {
            DateDiff dateDiff = (DateDiff)expression2;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genDateDiffTransformer(substraitExprName, this.replaceWithExpressionTransformer0(dateDiff.endDate(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(dateDiff.startDate(), attributeSeq, expressionsMap), dateDiff);
        }
        if (expression2 instanceof Round && (round = (Round)expression2).child().dataType() instanceof DecimalType) {
            return new DecimalRoundTransformer(substraitExprName, this.replaceWithExpressionTransformer0(round.child(), attributeSeq, expressionsMap), round);
        }
        if (expression2 instanceof ToUnixTimestamp) {
            ToUnixTimestamp toUnixTimestamp = (ToUnixTimestamp)expression2;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genToUnixTimestampTransformer(substraitExprName, this.replaceWithExpressionTransformer0(toUnixTimestamp.timeExp(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(toUnixTimestamp.format(), attributeSeq, expressionsMap), (Expression)toUnixTimestamp);
        }
        if (expression2 instanceof UnixTimestamp) {
            UnixTimestamp unixTimestamp = (UnixTimestamp)expression2;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genToUnixTimestampTransformer(substraitExprName, this.replaceWithExpressionTransformer0(unixTimestamp.timeExp(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(unixTimestamp.format(), attributeSeq, expressionsMap), (Expression)unixTimestamp);
        }
        if (expression2 instanceof TruncTimestamp) {
            TruncTimestamp truncTimestamp = (TruncTimestamp)expression2;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genTruncTimestampTransformer(substraitExprName, this.replaceWithExpressionTransformer0(truncTimestamp.format(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(truncTimestamp.timestamp(), attributeSeq, expressionsMap), (Option<String>)truncTimestamp.timeZoneId(), truncTimestamp);
        }
        if (expression2 instanceof MonthsBetween) {
            MonthsBetween monthsBetween = (MonthsBetween)expression2;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genMonthsBetweenTransformer(substraitExprName, this.replaceWithExpressionTransformer0(monthsBetween.date1(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(monthsBetween.date2(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(monthsBetween.roundOff(), attributeSeq, expressionsMap), monthsBetween);
        }
        if (expression2 instanceof If) {
            If if_ = (If)expression2;
            return new IfTransformer(substraitExprName, this.replaceWithExpressionTransformer0(if_.predicate(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(if_.trueValue(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(if_.falseValue(), attributeSeq, expressionsMap), if_);
        }
        if (expression2 instanceof CaseWhen) {
            CaseWhen caseWhen = (CaseWhen)expression2;
            return new CaseWhenTransformer(substraitExprName, (Seq<Tuple2<ExpressionTransformer, ExpressionTransformer>>)((Seq)caseWhen.branches().map((Function1 & Serializable)expr -> new Tuple2((Object)MODULE$.replaceWithExpressionTransformer0((Expression)expr._1(), attributeSeq, expressionsMap), (Object)MODULE$.replaceWithExpressionTransformer0((Expression)expr._2(), attributeSeq, expressionsMap)))), (Option<ExpressionTransformer>)caseWhen.elseValue().map((Function1 & Serializable)expr -> MODULE$.replaceWithExpressionTransformer0((Expression)expr, attributeSeq, expressionsMap)), caseWhen);
        }
        if (expression2 instanceof In) {
            In in = (In)expression2;
            if (in.list().exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ExpressionConverter$.$anonfun$transformExpression$5(x$7)))) {
                throw new GlutenNotSupportException("In list option does not support non-foldable expression, " + in.list().map((Function1 & Serializable)x$8 -> x$8.sql()));
            }
            return new InTransformer(substraitExprName, this.replaceWithExpressionTransformer0(in.value(), attributeSeq, expressionsMap), in);
        }
        if (expression2 instanceof InSet) {
            InSet inSet = (InSet)expression2;
            return new InSetTransformer(substraitExprName, this.replaceWithExpressionTransformer0(inSet.child(), attributeSeq, expressionsMap), inSet);
        }
        if (expression2 instanceof ScalarSubquery) {
            ScalarSubquery scalarSubquery = (ScalarSubquery)expression2;
            return new ScalarSubqueryTransformer(substraitExprName, scalarSubquery);
        }
        if (expression2 instanceof Cast) {
            Cast cast = (Cast)expression2;
            Cast newCast = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genCastWithNewChild(cast);
            return new CastTransformer(substraitExprName, this.replaceWithExpressionTransformer0(newCast.child(), attributeSeq, expressionsMap), newCast);
        }
        if (expression2 instanceof String2TrimExpression) {
            Tuple2 tuple2;
            String2TrimExpression string2TrimExpression = (String2TrimExpression)expression2;
            String2TrimExpression string2TrimExpression2 = string2TrimExpression;
            if (string2TrimExpression2 instanceof StringTrim) {
                StringTrim stringTrim = (StringTrim)string2TrimExpression2;
                Expression srcStr = stringTrim.srcStr();
                Option trimStr = stringTrim.trimStr();
                tuple2 = new Tuple2((Object)srcStr, (Object)trimStr);
            } else if (string2TrimExpression2 instanceof StringTrimLeft) {
                StringTrimLeft stringTrimLeft = (StringTrimLeft)string2TrimExpression2;
                Expression srcStr = stringTrimLeft.srcStr();
                Option trimStr = stringTrimLeft.trimStr();
                tuple2 = new Tuple2((Object)srcStr, (Object)trimStr);
            } else if (string2TrimExpression2 instanceof StringTrimRight) {
                StringTrimRight stringTrimRight = (StringTrimRight)string2TrimExpression2;
                Expression srcStr = stringTrimRight.srcStr();
                Option trimStr = stringTrimRight.trimStr();
                tuple2 = new Tuple2((Object)srcStr, (Object)trimStr);
            } else {
                throw new MatchError((Object)string2TrimExpression2);
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            Expression srcStr = (Expression)tuple22._1();
            Option trimStr = (Option)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)srcStr, (Object)trimStr);
            Expression srcStr2 = (Expression)tuple23._1();
            Option trimStr2 = (Option)tuple23._2();
            Seq children = (Seq)Option$.MODULE$.option2Iterable(trimStr2.map((Function1 & Serializable)x$10 -> MODULE$.replaceWithExpressionTransformer0((Expression)x$10, attributeSeq, expressionsMap))).toSeq().$plus$plus((IterableOnce)new .colon.colon((Object)this.replaceWithExpressionTransformer0(srcStr2, attributeSeq, expressionsMap), (List)Nil$.MODULE$));
            return new GenericExpressionTransformer(substraitExprName, (Seq<ExpressionTransformer>)children, (Expression)string2TrimExpression);
        }
        if (expression2 instanceof StringTrimBoth) {
            StringTrimBoth stringTrimBoth = (StringTrimBoth)expression2;
            Seq children = (Seq)Option$.MODULE$.option2Iterable(stringTrimBoth.trimStr().map((Function1 & Serializable)x$11 -> MODULE$.replaceWithExpressionTransformer0((Expression)x$11, attributeSeq, expressionsMap))).toSeq().$plus$plus((IterableOnce)new .colon.colon((Object)this.replaceWithExpressionTransformer0(stringTrimBoth.srcStr(), attributeSeq, expressionsMap), (List)Nil$.MODULE$));
            return new GenericExpressionTransformer(substraitExprName, (Seq<ExpressionTransformer>)children, (Expression)stringTrimBoth);
        }
        if (expression2 instanceof HashExpression) {
            HashExpression hashExpression = (HashExpression)expression2;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genHashExpressionTransformer(substraitExprName, (Seq<ExpressionTransformer>)((Seq)hashExpression.children().map((Function1 & Serializable)expr -> MODULE$.replaceWithExpressionTransformer0((Expression)expr, attributeSeq, expressionsMap))), hashExpression);
        }
        if (expression2 instanceof GetStructField) {
            ExpressionTransformer expressionTransformer;
            GetStructField getStructField = (GetStructField)expression2;
            try {
                BoundReference bindRef = this.bindGetStructField(getStructField, package$.MODULE$.AttributeSeq(attributeSeq));
                expressionTransformer = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genGetStructFieldTransformer(substraitExprName, this.replaceWithExpressionTransformer0(getStructField.child(), attributeSeq, expressionsMap), bindRef.ordinal(), getStructField);
            }
            catch (IllegalStateException e) {
                throw new UnsupportedOperationException("Failed to bind reference for " + getStructField + ": " + e.getMessage());
            }
            return expressionTransformer;
        }
        if (expression2 instanceof GetArrayStructFields) {
            GetArrayStructFields getArrayStructFields = (GetArrayStructFields)expression2;
            return new GenericExpressionTransformer(substraitExprName, (Seq<ExpressionTransformer>)new .colon.colon((Object)this.replaceWithExpressionTransformer0(getArrayStructFields.child(), attributeSeq, expressionsMap), (List)new .colon.colon((Object)LiteralTransformer$.MODULE$.apply(BoxesRunTime.boxToInteger((int)getArrayStructFields.ordinal())), (List)Nil$.MODULE$)), (Expression)getArrayStructFields);
        }
        if (expression2 instanceof StringTranslate) {
            StringTranslate stringTranslate = (StringTranslate)expression2;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genStringTranslateTransformer(substraitExprName, this.replaceWithExpressionTransformer0(stringTranslate.srcExpr(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(stringTranslate.matchingExpr(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(stringTranslate.replaceExpr(), attributeSeq, expressionsMap), stringTranslate);
        }
        if (expression2 instanceof RegExpReplace) {
            RegExpReplace regExpReplace = (RegExpReplace)expression2;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genRegexpReplaceTransformer(substraitExprName, (Seq<ExpressionTransformer>)new .colon.colon((Object)this.replaceWithExpressionTransformer0(regExpReplace.subject(), attributeSeq, expressionsMap), (List)new .colon.colon((Object)this.replaceWithExpressionTransformer0(regExpReplace.regexp(), attributeSeq, expressionsMap), (List)new .colon.colon((Object)this.replaceWithExpressionTransformer0(regExpReplace.rep(), attributeSeq, expressionsMap), (List)new .colon.colon((Object)this.replaceWithExpressionTransformer0(regExpReplace.pos(), attributeSeq, expressionsMap), (List)Nil$.MODULE$)))), regExpReplace);
        }
        if (expression2 instanceof Size) {
            Size size = (Size)expression2;
            ExpressionTransformer child = this.replaceWithExpressionTransformer0(size.child(), attributeSeq, expressionsMap);
            return new GenericExpressionTransformer(substraitExprName, (Seq<ExpressionTransformer>)new .colon.colon((Object)child, (List)new .colon.colon((Object)LiteralTransformer$.MODULE$.apply(BoxesRunTime.boxToBoolean((boolean)size.legacySizeOfNull())), (List)Nil$.MODULE$)), (Expression)size);
        }
        if (expression2 instanceof CreateNamedStruct) {
            CreateNamedStruct createNamedStruct = (CreateNamedStruct)expression2;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genNamedStructTransformer(substraitExprName, (Seq<ExpressionTransformer>)((Seq)createNamedStruct.children().map((Function1 & Serializable)x$12 -> MODULE$.replaceWithExpressionTransformer0((Expression)x$12, attributeSeq, expressionsMap))), createNamedStruct, attributeSeq);
        }
        if (expression2 instanceof NamedLambdaVariable) {
            NamedLambdaVariable namedLambdaVariable = (NamedLambdaVariable)expression2;
            return GenericExpressionTransformer$.MODULE$.apply(substraitExprName, LiteralTransformer$.MODULE$.apply(namedLambdaVariable.name()), (Expression)namedLambdaVariable);
        }
        if (expression2 instanceof LambdaFunction) {
            LambdaFunction lambdaFunction = (LambdaFunction)expression2;
            return new LambdaFunctionTransformer(substraitExprName, this.replaceWithExpressionTransformer0(lambdaFunction.function(), attributeSeq, expressionsMap), (Seq<ExpressionTransformer>)((Seq)lambdaFunction.arguments().map((Function1 & Serializable)x$13 -> MODULE$.replaceWithExpressionTransformer0((Expression)x$13, attributeSeq, expressionsMap))), lambdaFunction);
        }
        if (expression2 instanceof JsonTuple) {
            JsonTuple jsonTuple = (JsonTuple)expression2;
            Seq children = (Seq)jsonTuple.children().map((Function1 & Serializable)x$14 -> MODULE$.replaceWithExpressionTransformer0((Expression)x$14, attributeSeq, expressionsMap));
            return new JsonTupleExpressionTransformer(substraitExprName, (Seq<ExpressionTransformer>)children, (Expression)jsonTuple);
        }
        if (expression2 instanceof Like) {
            Like like = (Like)expression2;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genLikeTransformer(substraitExprName, this.replaceWithExpressionTransformer0(like.left(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(like.right(), attributeSeq, expressionsMap), like);
        }
        if (expression2 instanceof MakeDecimal) {
            MakeDecimal makeDecimal = (MakeDecimal)expression2;
            return new GenericExpressionTransformer(substraitExprName, (Seq<ExpressionTransformer>)new .colon.colon((Object)this.replaceWithExpressionTransformer0(makeDecimal.child(), attributeSeq, expressionsMap), (List)new .colon.colon((Object)LiteralTransformer$.MODULE$.apply(BoxesRunTime.boxToBoolean((boolean)makeDecimal.nullOnOverflow())), (List)Nil$.MODULE$)), (Expression)makeDecimal);
        }
        if (expression2 instanceof PromotePrecision && (expression = (promotePrecision = (PromotePrecision)expression2).child()) instanceof Cast) {
            Cast cast = (Cast)expression;
            Expression child = cast.child();
            if (cast.dataType() instanceof DecimalType && child.dataType() instanceof DecimalType && !BackendsApiManager$.MODULE$.getSettings().transformCheckOverflow()) {
                return this.replaceWithExpressionTransformer0(child, attributeSeq, expressionsMap);
            }
        }
        if (expression2 instanceof NormalizeNaNAndZero ? true : (expression2 instanceof PromotePrecision ? true : (expression2 instanceof TaggingExpression ? true : expression2 instanceof DynamicPruningExpression))) {
            return new ChildTransformer(substraitExprName, this.replaceWithExpressionTransformer0((Expression)expr2.children().head(), attributeSeq, expressionsMap), expr2);
        }
        if (expression2 instanceof GetDateField ? true : expression2 instanceof GetTimeField) {
            return new ExtractDateTransformer(substraitExprName, this.replaceWithExpressionTransformer0((Expression)expr2.children().head(), attributeSeq, expressionsMap), expr2);
        }
        if (expression2 instanceof StringToMap) {
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genStringToMapTransformer(substraitExprName, (Seq<ExpressionTransformer>)((Seq)expr2.children().map((Function1 & Serializable)x$15 -> MODULE$.replaceWithExpressionTransformer0((Expression)x$15, attributeSeq, expressionsMap))), expr2);
        }
        if (expression2 instanceof CheckOverflow) {
            bl = true;
            checkOverflow = (CheckOverflow)expression2;
            Expression b = checkOverflow.child();
            DecimalType decimalType = checkOverflow.dataType();
            if (b instanceof BinaryArithmetic) {
                BinaryArithmetic binaryArithmetic2 = (BinaryArithmetic)b;
                if (!BackendsApiManager$.MODULE$.getSettings().transformCheckOverflow() && DecimalArithmeticUtil$.MODULE$.isDecimalArithmetic(binaryArithmetic2)) {
                    String arithmeticExprName = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().getDecimalArithmeticExprName(this.getAndCheckSubstraitName((Expression)binaryArithmetic2, expressionsMap));
                    ExpressionTransformer left = this.replaceWithExpressionTransformer0((Expression)binaryArithmetic2.left(), attributeSeq, expressionsMap);
                    ExpressionTransformer right = this.replaceWithExpressionTransformer0((Expression)binaryArithmetic2.right(), attributeSeq, expressionsMap);
                    return new DecimalArithmeticExpressionTransformer(arithmeticExprName, left, right, decimalType, (Expression)binaryArithmetic2);
                }
            }
        }
        if (bl) {
            return new CheckOverflowTransformer(substraitExprName, this.replaceWithExpressionTransformer0(checkOverflow.child(), attributeSeq, expressionsMap), checkOverflow);
        }
        if (expression2.getClass().getSimpleName().equals("CheckOverflowInTableInsert")) {
            throw new GlutenNotSupportException("CheckOverflowInTableInsert is used in ANSI mode, but Gluten does not support ANSI mode.");
        }
        if (expression2 instanceof BinaryArithmetic && DecimalArithmeticUtil$.MODULE$.isDecimalArithmetic(binaryArithmetic = (BinaryArithmetic)expression2)) {
            String exprName = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().getDecimalArithmeticExprName(substraitExprName);
            if (!BackendsApiManager$.MODULE$.getSettings().transformCheckOverflow()) {
                return new GenericExpressionTransformer(exprName, (Seq<ExpressionTransformer>)((Seq)expr2.children().map((Function1 & Serializable)x$16 -> MODULE$.replaceWithExpressionTransformer0((Expression)x$16, attributeSeq, expressionsMap))), expr2);
            }
            return this.genRescaleDecimalTransformer(exprName, binaryArithmetic, attributeSeq, expressionsMap);
        }
        if (expression2 instanceof NaNvl) {
            NaNvl naNvl = (NaNvl)expression2;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genNaNvlTransformer(substraitExprName, this.replaceWithExpressionTransformer0(naNvl.left(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(naNvl.right(), attributeSeq, expressionsMap), naNvl);
        }
        if (expression2 instanceof AtLeastNNonNulls) {
            AtLeastNNonNulls atLeastNNonNulls = (AtLeastNNonNulls)expression2;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genAtLeastNNonNullsTransformer(substraitExprName, (Seq<ExpressionTransformer>)((Seq)atLeastNNonNulls.children().map((Function1 & Serializable)x$17 -> MODULE$.replaceWithExpressionTransformer0((Expression)x$17, attributeSeq, expressionsMap))), atLeastNNonNulls);
        }
        if (expression2 instanceof MakeTimestamp) {
            MakeTimestamp makeTimestamp = (MakeTimestamp)expression2;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genMakeTimestampTransformer(substraitExprName, (Seq<ExpressionTransformer>)((Seq)makeTimestamp.children().map((Function1 & Serializable)x$18 -> MODULE$.replaceWithExpressionTransformer0((Expression)x$18, attributeSeq, expressionsMap))), (Expression)makeTimestamp);
        }
        if (expression2 instanceof BinaryExpression) {
            bl2 = true;
            binaryExpression = (BinaryExpression)expression2;
            if (binaryExpression.getClass().getSimpleName().equals("TimestampAdd")) {
                return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genTimestampAddTransformer(substraitExprName, this.replaceWithExpressionTransformer0((Expression)binaryExpression.left(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0((Expression)binaryExpression.right(), attributeSeq, expressionsMap), (Expression)binaryExpression);
            }
        }
        if (bl2 && binaryExpression.getClass().getSimpleName().equals("TimestampDiff")) {
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genTimestampDiffTransformer(substraitExprName, this.replaceWithExpressionTransformer0((Expression)binaryExpression.left(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0((Expression)binaryExpression.right(), attributeSeq, expressionsMap), (Expression)binaryExpression);
        }
        if (expression2 instanceof Transformable) {
            Expression expression3 = expression2;
            Seq childrenTransformers = (Seq)expression3.children().map((Function1 & Serializable)x$19 -> MODULE$.replaceWithExpressionTransformer0((Expression)x$19, attributeSeq, expressionsMap));
            return ((Transformable)expression3).getTransformer((Seq<ExpressionTransformer>)childrenTransformers);
        }
        if (expression2 instanceof Uuid) {
            Uuid uuid = (Uuid)expression2;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genUuidTransformer(substraitExprName, uuid);
        }
        if (expression2 instanceof ArrayFilter) {
            ArrayFilter arrayFilter = (ArrayFilter)expression2;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genArrayFilterTransformer(substraitExprName, this.replaceWithExpressionTransformer0(arrayFilter.argument(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(arrayFilter.function(), attributeSeq, expressionsMap), arrayFilter);
        }
        if (expression2 instanceof ArrayTransform) {
            ArrayTransform arrayTransform = (ArrayTransform)expression2;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genArrayTransformTransformer(substraitExprName, this.replaceWithExpressionTransformer0(arrayTransform.argument(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(arrayTransform.function(), attributeSeq, expressionsMap), arrayTransform);
        }
        if (expression2 instanceof ArraySort) {
            ArraySort arraySort = (ArraySort)expression2;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genArraySortTransformer(substraitExprName, this.replaceWithExpressionTransformer0(arraySort.argument(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(arraySort.function(), attributeSeq, expressionsMap), arraySort);
        }
        if (expression2 instanceof TryEval) {
            bl3 = true;
            tryEval = (TryEval)expression2;
            Expression a4 = tryEval.child();
            if (a4 instanceof Add) {
                Add add = (Add)a4;
                return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genTryArithmeticTransformer(substraitExprName, this.replaceWithExpressionTransformer0(add.left(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(add.right(), attributeSeq, expressionsMap), tryEval, "checked_add");
            }
        }
        if (bl3 && (a3 = tryEval.child()) instanceof Subtract) {
            Subtract subtract = (Subtract)a3;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genTryArithmeticTransformer(substraitExprName, this.replaceWithExpressionTransformer0(subtract.left(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(subtract.right(), attributeSeq, expressionsMap), tryEval, "checked_subtract");
        }
        if (bl3 && (a2 = tryEval.child()) instanceof Divide) {
            Divide divide = (Divide)a2;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genTryArithmeticTransformer(substraitExprName, this.replaceWithExpressionTransformer0(divide.left(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(divide.right(), attributeSeq, expressionsMap), tryEval, "checked_divide");
        }
        if (bl3 && (a = tryEval.child()) instanceof Multiply) {
            Multiply multiply = (Multiply)a;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genTryArithmeticTransformer(substraitExprName, this.replaceWithExpressionTransformer0(multiply.left(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(multiply.right(), attributeSeq, expressionsMap), tryEval, "checked_multiply");
        }
        if (expression2 instanceof Add) {
            Add add = (Add)expression2;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genArithmeticTransformer(substraitExprName, this.replaceWithExpressionTransformer0(add.left(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(add.right(), attributeSeq, expressionsMap), (Expression)add, "checked_add");
        }
        if (expression2 instanceof Subtract) {
            Subtract subtract = (Subtract)expression2;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genArithmeticTransformer(substraitExprName, this.replaceWithExpressionTransformer0(subtract.left(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(subtract.right(), attributeSeq, expressionsMap), (Expression)subtract, "checked_subtract");
        }
        if (expression2 instanceof Multiply) {
            Multiply multiply = (Multiply)expression2;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genArithmeticTransformer(substraitExprName, this.replaceWithExpressionTransformer0(multiply.left(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(multiply.right(), attributeSeq, expressionsMap), (Expression)multiply, "checked_multiply");
        }
        if (expression2 instanceof Divide) {
            Divide divide = (Divide)expression2;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genArithmeticTransformer(substraitExprName, this.replaceWithExpressionTransformer0(divide.left(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(divide.right(), attributeSeq, expressionsMap), (Expression)divide, "checked_divide");
        }
        if (expression2 instanceof IntegralDivide) {
            IntegralDivide integralDivide = (IntegralDivide)expression2;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genArithmeticTransformer(substraitExprName, this.replaceWithExpressionTransformer0(integralDivide.left(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(integralDivide.right(), attributeSeq, expressionsMap), (Expression)integralDivide, "checked_div");
        }
        if (bl3) {
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genTryEvalTransformer(substraitExprName, this.replaceWithExpressionTransformer0(tryEval.child(), attributeSeq, expressionsMap), tryEval);
        }
        if (expression2 instanceof ArrayForAll) {
            ArrayForAll arrayForAll = (ArrayForAll)expression2;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genArrayForAllTransformer(substraitExprName, this.replaceWithExpressionTransformer0(arrayForAll.argument(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(arrayForAll.function(), attributeSeq, expressionsMap), arrayForAll);
        }
        if (expression2 instanceof ArrayExists) {
            ArrayExists arrayExists = (ArrayExists)expression2;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genArrayExistsTransformer(substraitExprName, this.replaceWithExpressionTransformer0(arrayExists.argument(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(arrayExists.function(), attributeSeq, expressionsMap), arrayExists);
        }
        if (expression2.getClass().getSimpleName().equals("ArrayInsert")) {
            Seq<Expression> children = SparkShimLoader$.MODULE$.getSparkShims().extractExpressionArrayInsert(expression2);
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genArrayInsertTransformer(substraitExprName, (Seq<ExpressionTransformer>)((Seq)children.map((Function1 & Serializable)x$20 -> MODULE$.replaceWithExpressionTransformer0((Expression)x$20, attributeSeq, expressionsMap))), expression2);
        }
        if (expression2 instanceof Shuffle) {
            Shuffle shuffle = (Shuffle)expression2;
            return new GenericExpressionTransformer(substraitExprName, (Seq<ExpressionTransformer>)new .colon.colon((Object)this.replaceWithExpressionTransformer0(shuffle.child(), attributeSeq, expressionsMap), (List)new .colon.colon((Object)new LiteralTransformer(Literal$.MODULE$.apply(shuffle.randomSeed().get())), (List)Nil$.MODULE$)), (Expression)shuffle);
        }
        if (expression2 instanceof PreciseTimestampConversion) {
            PreciseTimestampConversion preciseTimestampConversion = (PreciseTimestampConversion)expression2;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genPreciseTimestampConversionTransformer(substraitExprName, (Seq<ExpressionTransformer>)new .colon.colon((Object)this.replaceWithExpressionTransformer0(preciseTimestampConversion.child(), attributeSeq, expressionsMap), (List)Nil$.MODULE$), preciseTimestampConversion);
        }
        if (expression2 instanceof TransformKeys) {
            TransformKeys transformKeys = (TransformKeys)expression2;
            String mapKeyDedupPolicy = (String)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.MAP_KEY_DEDUP_POLICY());
            String string = mapKeyDedupPolicy.toString();
            String string2 = SQLConf.MapKeyDedupPolicy$.MODULE$.LAST_WIN().toString();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                throw new GlutenNotSupportException("LAST_WIN policy is not supported yet in native to deduplicate map keys");
            }
            return new GenericExpressionTransformer(substraitExprName, (Seq<ExpressionTransformer>)((Seq)transformKeys.children().map((Function1 & Serializable)x$21 -> MODULE$.replaceWithExpressionTransformer0((Expression)x$21, attributeSeq, expressionsMap))), (Expression)transformKeys);
        }
        if (expression2 instanceof EulerNumber) {
            return new LiteralTransformer(Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)Math.E)));
        }
        if (expression2 instanceof Pi) {
            return new LiteralTransformer(Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)Math.PI)));
        }
        if (expression2 instanceof SparkVersion) {
            return LiteralTransformer$.MODULE$.apply(org.apache.spark.package$.MODULE$.SPARK_VERSION_SHORT() + " " + org.apache.spark.package$.MODULE$.SPARK_REVISION());
        }
        if (expression2 instanceof DateAdd) {
            DateAdd dateAdd = (DateAdd)expression2;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genDateAddTransformer(attributeSeq, substraitExprName, (Seq<Expression>)dateAdd.children(), (Expression)dateAdd);
        }
        if (expression2 instanceof StringSplit) {
            StringSplit stringSplit = (StringSplit)expression2;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genStringSplitTransformer(substraitExprName, this.replaceWithExpressionTransformer0(stringSplit.str(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(stringSplit.regex(), attributeSeq, expressionsMap), this.replaceWithExpressionTransformer0(stringSplit.limit(), attributeSeq, expressionsMap), stringSplit);
        }
        if (expression2 instanceof JsonToStructs) {
            JsonToStructs jsonToStructs = (JsonToStructs)expression2;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genFromJsonTransformer(substraitExprName, (Seq<ExpressionTransformer>)((Seq)expr2.children().map((Function1 & Serializable)x$22 -> MODULE$.replaceWithExpressionTransformer0((Expression)x$22, attributeSeq, expressionsMap))), jsonToStructs);
        }
        if (expression2 instanceof StructsToJson) {
            StructsToJson structsToJson = (StructsToJson)expression2;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genToJsonTransformer(substraitExprName, this.replaceWithExpressionTransformer0(structsToJson.child(), attributeSeq, expressionsMap), structsToJson);
        }
        if (expression2 instanceof UnBase64) {
            UnBase64 unBase64 = (UnBase64)expression2;
            return BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().genUnbase64Transformer(substraitExprName, this.replaceWithExpressionTransformer0(unBase64.child(), attributeSeq, expressionsMap), unBase64);
        }
        if (BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().expressionFlattenSupported(expression2)) {
            return this.replaceFlattenedExpressionWithExpressionTransformer(substraitExprName, expression2, attributeSeq, expressionsMap);
        }
        if (expression2 instanceof RaiseError) {
            RaiseError raiseError = (RaiseError)expression2;
            Expression errorMessage = BackendsApiManager$.MODULE$.getSparkPlanExecApiInstance().getErrorMessage(raiseError);
            return GenericExpressionTransformer$.MODULE$.apply(substraitExprName, this.replaceWithExpressionTransformer0(errorMessage, attributeSeq, expressionsMap), (Expression)raiseError);
        }
        return new GenericExpressionTransformer(substraitExprName, (Seq<ExpressionTransformer>)((Seq)expression2.children().map((Function1 & Serializable)x$23 -> MODULE$.replaceWithExpressionTransformer0((Expression)x$23, attributeSeq, expressionsMap))), expression2);
    }

    private String getAndCheckSubstraitName(Expression expr, scala.collection.immutable.Map<Class<?>, String> expressionsMap) {
        TestStats.addExpressionClassName(expr.getClass().getName());
        return (String)expressionsMap.get((Object)expr.getClass()).filter((Function1 & Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)ExpressionConverter$.$anonfun$getAndCheckSubstraitName$1(expr, x$24))).getOrElse((Function0 & Serializable)() -> {
            throw new GlutenNotSupportException("Not supported to map spark function name to substrait function name: " + expr + ", class name: " + expr.getClass().getSimpleName() + ".");
        });
    }

    private BoundReference bindGetStructField(GetStructField structField, package.AttributeSeq input) {
        IntRef newOrdinal = IntRef.create((int)-1);
        ArrayBuffer names = new ArrayBuffer();
        GetStructField root = structField;
        while (root instanceof GetStructField) {
            GetStructField curField = root;
            String name = curField.childSchema().fields()[curField.ordinal()].name();
            names.$plus$eq((Object)name);
            root = root.child();
        }
        if (!(root instanceof AttributeReference)) {
            return new BoundReference(structField.ordinal(), structField.dataType(), structField.nullable());
        }
        names.$plus$eq((Object)((AttributeReference)root).name());
        input.attrs().foreach((Function1 & Serializable)attribute -> {
            ExpressionConverter$.$anonfun$bindGetStructField$1(names, newOrdinal, attribute);
            return BoxedUnit.UNIT;
        });
        if (newOrdinal.elem == -1) {
            throw new IllegalStateException("Couldn't find " + structField + " in " + input.attrs().mkString("[", ",", "]"));
        }
        return new BoundReference(newOrdinal.elem, structField.dataType(), structField.nullable());
    }

    public final ExpressionTransformer org$apache$gluten$expression$ExpressionConverter$$doTransform$1(Expression child, Seq attributeSeq$5, scala.collection.immutable.Map expressionsMap$5) {
        return this.replaceWithExpressionTransformer0(child, (Seq<Attribute>)attributeSeq$5, expressionsMap$5);
    }

    private static final ExpressionTransformer validateAndTransform$1(String exprName, Function0 childTransformers, StaticInvoke i$1, String funcName$1) {
        if (!BackendsApiManager$.MODULE$.getValidatorApiInstance().doExprValidate(exprName, (Expression)i$1)) {
            throw new GlutenNotSupportException("Not supported to map current " + i$1.getClass() + " call on function: " + funcName$1 + ".");
        }
        return new GenericExpressionTransformer(exprName, (Seq<ExpressionTransformer>)((Seq)childTransformers.apply()), (Expression)i$1);
    }

    public static final /* synthetic */ boolean $anonfun$transformExpression$5(Expression x$7) {
        return !x$7.foldable();
    }

    public static final /* synthetic */ boolean $anonfun$getAndCheckSubstraitName$1(Expression expr$2, String x$24) {
        return BackendsApiManager$.MODULE$.getValidatorApiInstance().doExprValidate(x$24, expr$2);
    }

    public static final /* synthetic */ void $anonfun$bindGetStructField$1(ArrayBuffer names$1, IntRef newOrdinal$1, Attribute attribute) {
        int level = names$1.size() - 1;
        Object object = names$1.apply(level);
        String string = attribute.name();
        if (!(object != null ? !object.equals(string) : string != null)) {
            ObjectRef candidateFields = ObjectRef.create(null);
            ObjectRef dtType = ObjectRef.create((Object)attribute.dataType());
            while ((DataType)dtType.elem instanceof StructType && level >= 1) {
                candidateFields.elem = ((StructType)((DataType)dtType.elem)).fields();
                String curName = (String)names$1.apply(--level);
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ((StructField[])candidateFields.elem).length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    String string = ((StructField[])candidateFields$1.elem)[i].name();
                    String string2 = curName;
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        dtType$1.elem = ((StructField[])candidateFields$1.elem)[i].dataType();
                        newOrdinal$1.elem = i;
                        return;
                    }
                });
            }
            return;
        }
    }

    private ExpressionConverter$() {
    }
}

