/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.expression;

import io.substrait.proto.Type;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.gluten.backendsapi.BackendsApiManager$;
import org.apache.gluten.exception.GlutenNotSupportException;
import org.apache.gluten.expression.ConverterUtils$FunctionConfig$;
import org.apache.gluten.expression.ExpressionType;
import org.apache.gluten.shaded.com.google.protobuf.CodedInputStream;
import org.apache.gluten.substrait.type.BinaryTypeNode;
import org.apache.gluten.substrait.type.BooleanTypeNode;
import org.apache.gluten.substrait.type.DateTypeNode;
import org.apache.gluten.substrait.type.DecimalTypeNode;
import org.apache.gluten.substrait.type.FP32TypeNode;
import org.apache.gluten.substrait.type.FP64TypeNode;
import org.apache.gluten.substrait.type.I16TypeNode;
import org.apache.gluten.substrait.type.I32TypeNode;
import org.apache.gluten.substrait.type.I64TypeNode;
import org.apache.gluten.substrait.type.I8TypeNode;
import org.apache.gluten.substrait.type.IntervalYearTypeNode;
import org.apache.gluten.substrait.type.ListNode;
import org.apache.gluten.substrait.type.MapNode;
import org.apache.gluten.substrait.type.NothingNode;
import org.apache.gluten.substrait.type.StringTypeNode;
import org.apache.gluten.substrait.type.StructNode;
import org.apache.gluten.substrait.type.TimestampTypeNode;
import org.apache.gluten.substrait.type.TypeBuilder;
import org.apache.gluten.substrait.type.TypeNode;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.FullOuter$;
import org.apache.spark.sql.catalyst.plans.Inner$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.LeftAnti$;
import org.apache.spark.sql.catalyst.plans.LeftOuter$;
import org.apache.spark.sql.catalyst.plans.LeftSemi$;
import org.apache.spark.sql.catalyst.plans.RightOuter$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class ConverterUtils$
implements Logging {
    public static final ConverterUtils$ MODULE$ = new ConverterUtils$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Attribute getAttrFromExpr(Expression expr) {
        return (Attribute)((Expression)expr.transformDown((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Alias) {
                    Alias alias = (Alias)A1;
                    return (B1)alias.toAttribute();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                return expression instanceof Alias;
            }
        })).references().head();
    }

    public String normalizeColName(String name) {
        boolean caseSensitive = SQLConf$.MODULE$.get().caseSensitiveAnalysis();
        if (caseSensitive) {
            return name;
        }
        return name.toLowerCase(Locale.ROOT);
    }

    public String getShortAttributeName(Attribute attr) {
        String name = this.normalizeColName(attr.name());
        int subIndex = name.indexOf("(");
        if (subIndex != -1) {
            return name.substring(0, subIndex);
        }
        return name;
    }

    public String genColumnNameWithoutExprId(Attribute attr) {
        return this.getShortAttributeName(attr);
    }

    public String genColumnNameWithExprId(Attribute attr) {
        return this.getShortAttributeName(attr) + "#" + attr.exprId().id();
    }

    public List<TypeNode> collectAttributeTypeNodes(List<Attribute> attributes) {
        return this.collectAttributeTypeNodes((scala.collection.immutable.Seq<Attribute>)((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(attributes).asScala()).toSeq());
    }

    public List<TypeNode> collectAttributeTypeNodes(scala.collection.immutable.Seq<Attribute> attributes) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)attributes.map((Function1 & Serializable)attr -> MODULE$.getTypeNode(attr.dataType(), attr.nullable()))).asJava();
    }

    public List<TypeNode> collectAttributeTypeNodes(StructType structType) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])structType.fields()), (Function1 & Serializable)f -> MODULE$.getTypeNode(f.dataType(), f.nullable()), ClassTag$.MODULE$.apply(TypeNode.class))).toList()).asJava();
    }

    public List<String> collectAttributeNamesWithExprId(List<Attribute> attributes) {
        return this.collectAttributeNamesWithExprId((scala.collection.immutable.Seq<Attribute>)((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(attributes).asScala()).toSeq());
    }

    public List<String> collectAttributeNamesWithExprId(scala.collection.immutable.Seq<Attribute> attributes) {
        return this.collectAttributeNamesDFS(attributes, (Function1<Attribute, String>)(Function1 & Serializable)attr -> MODULE$.genColumnNameWithExprId((Attribute)attr));
    }

    public List<String> collectAttributeNamesWithoutExprId(scala.collection.immutable.Seq<Attribute> attributes) {
        return this.collectAttributeNamesDFS(attributes, (Function1<Attribute, String>)(Function1 & Serializable)attr -> MODULE$.normalizeColName(attr.name()));
    }

    public List<String> collectAttributeNames(scala.collection.immutable.Seq<Attribute> attributes) {
        return this.collectAttributeNamesDFS(attributes, (Function1<Attribute, String>)(Function1 & Serializable)x$1 -> x$1.name());
    }

    private List<String> collectAttributeNamesDFS(scala.collection.immutable.Seq<Attribute> attributes, Function1<Attribute, String> f) {
        if (BackendsApiManager$.MODULE$.getSettings().supportStructType()) {
            ArrayList<String> nameList = new ArrayList<String>();
            attributes.foreach((Function1 & Serializable)attr -> {
                nameList.add((String)f.apply(attr));
                DataType dataType = attr.dataType();
                if (dataType instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    List<String> nestedNames = MODULE$.collectStructFieldNames((DataType)structType);
                    return BoxesRunTime.boxToBoolean((boolean)nameList.addAll(nestedNames));
                }
                return BoxedUnit.UNIT;
            });
            return nameList;
        }
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)attributes.map((Function1 & Serializable)x$2 -> (String)f.apply(x$2))).asJava();
    }

    public List<String> collectStructFieldNames(DataType dataType) {
        ArrayList<String> nameList;
        block0: {
            nameList = new ArrayList<String>();
            DataType dataType2 = dataType;
            if (!(dataType2 instanceof StructType)) break block0;
            StructType structType = (StructType)dataType2;
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])structType.fields()), (Function1 & Serializable)field -> BoxesRunTime.boxToBoolean((boolean)ConverterUtils$.$anonfun$collectStructFieldNames$1(nameList, field)));
        }
        return nameList;
    }

    public boolean isNullable(Type.Nullability nullability) {
        Type.Nullability nullability2 = nullability;
        Type.Nullability nullability3 = Type.Nullability.NULLABILITY_NULLABLE;
        return !(nullability2 != null ? !nullability2.equals(nullability3) : nullability3 != null);
    }

    public Tuple2<DataType, Object> parseFromSubstraitType(Type substraitType) {
        Type.KindCase kindCase = substraitType.getKindCase();
        if (Type.KindCase.BOOL.equals(kindCase)) {
            return new Tuple2((Object)BooleanType$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)this.isNullable(substraitType.getBool().getNullability())));
        }
        if (Type.KindCase.I8.equals(kindCase)) {
            return new Tuple2((Object)ByteType$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)this.isNullable(substraitType.getI8().getNullability())));
        }
        if (Type.KindCase.I16.equals(kindCase)) {
            return new Tuple2((Object)ShortType$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)this.isNullable(substraitType.getI16().getNullability())));
        }
        if (Type.KindCase.I32.equals(kindCase)) {
            return new Tuple2((Object)IntegerType$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)this.isNullable(substraitType.getI32().getNullability())));
        }
        if (Type.KindCase.I64.equals(kindCase)) {
            return new Tuple2((Object)LongType$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)this.isNullable(substraitType.getI64().getNullability())));
        }
        if (Type.KindCase.FP32.equals(kindCase)) {
            return new Tuple2((Object)FloatType$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)this.isNullable(substraitType.getFp32().getNullability())));
        }
        if (Type.KindCase.FP64.equals(kindCase)) {
            return new Tuple2((Object)DoubleType$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)this.isNullable(substraitType.getFp64().getNullability())));
        }
        if (Type.KindCase.STRING.equals(kindCase)) {
            return new Tuple2((Object)StringType$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)this.isNullable(substraitType.getString().getNullability())));
        }
        if (Type.KindCase.BINARY.equals(kindCase)) {
            return new Tuple2((Object)BinaryType$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)this.isNullable(substraitType.getBinary().getNullability())));
        }
        if (Type.KindCase.TIMESTAMP_TZ.equals(kindCase)) {
            return new Tuple2((Object)TimestampType$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)this.isNullable(substraitType.getTimestampTz().getNullability())));
        }
        if (Type.KindCase.DATE.equals(kindCase)) {
            return new Tuple2((Object)DateType$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)this.isNullable(substraitType.getDate().getNullability())));
        }
        if (Type.KindCase.DECIMAL.equals(kindCase)) {
            Type.Decimal decimal = substraitType.getDecimal();
            int precision = decimal.getPrecision();
            int scale = decimal.getScale();
            return new Tuple2((Object)new DecimalType(precision, scale), (Object)BoxesRunTime.boxToBoolean((boolean)this.isNullable(decimal.getNullability())));
        }
        if (Type.KindCase.STRUCT.equals(kindCase)) {
            Type.Struct struct_ = substraitType.getStruct();
            Buffer fields = (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(struct_.getTypesList()).asScala()).map((Function1 & Serializable)typ -> {
                Tuple2<DataType, Object> tuple2 = MODULE$.parseFromSubstraitType((Type)typ);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                DataType field = (DataType)tuple2._1();
                boolean nullable = tuple2._2$mcZ$sp();
                Tuple2 tuple22 = new Tuple2((Object)field, (Object)BoxesRunTime.boxToBoolean((boolean)nullable));
                DataType field2 = (DataType)tuple22._1();
                boolean nullable2 = tuple22._2$mcZ$sp();
                return new StructField("", field2, nullable2, StructField$.MODULE$.apply$default$4());
            });
            return new Tuple2((Object)StructType$.MODULE$.apply(fields.toSeq()), (Object)BoxesRunTime.boxToBoolean((boolean)this.isNullable(substraitType.getStruct().getNullability())));
        }
        if (Type.KindCase.LIST.equals(kindCase)) {
            Type.List list = substraitType.getList();
            Tuple2<DataType, Object> tuple2 = this.parseFromSubstraitType(list.getType());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            DataType elementType = (DataType)tuple2._1();
            boolean containsNull = tuple2._2$mcZ$sp();
            Tuple2 tuple22 = new Tuple2((Object)elementType, (Object)BoxesRunTime.boxToBoolean((boolean)containsNull));
            DataType elementType2 = (DataType)tuple22._1();
            boolean containsNull2 = tuple22._2$mcZ$sp();
            return new Tuple2((Object)new ArrayType(elementType2, containsNull2), (Object)BoxesRunTime.boxToBoolean((boolean)this.isNullable(substraitType.getList().getNullability())));
        }
        if (Type.KindCase.MAP.equals(kindCase)) {
            Type.Map map = substraitType.getMap();
            Tuple2<DataType, Object> tuple2 = this.parseFromSubstraitType(map.getKey());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            DataType keyType = (DataType)tuple2._1();
            DataType keyType2 = keyType;
            Tuple2<DataType, Object> tuple23 = this.parseFromSubstraitType(map.getValue());
            if (tuple23 == null) {
                throw new MatchError(tuple23);
            }
            DataType valueType = (DataType)tuple23._1();
            boolean valueContainsNull = tuple23._2$mcZ$sp();
            Tuple2 tuple24 = new Tuple2((Object)valueType, (Object)BoxesRunTime.boxToBoolean((boolean)valueContainsNull));
            DataType valueType2 = (DataType)tuple24._1();
            boolean valueContainsNull2 = tuple24._2$mcZ$sp();
            return new Tuple2((Object)new MapType(keyType2, valueType2, valueContainsNull2), (Object)BoxesRunTime.boxToBoolean((boolean)this.isNullable(substraitType.getMap().getNullability())));
        }
        if (Type.KindCase.NOTHING.equals(kindCase)) {
            return new Tuple2((Object)NullType$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        throw new GlutenNotSupportException("Type " + kindCase + " not supported.");
    }

    public TypeNode getTypeNode(DataType datatype, boolean nullable) {
        DataType dataType = datatype;
        if (BooleanType$.MODULE$.equals(dataType)) {
            return TypeBuilder.makeBoolean(Predef$.MODULE$.boolean2Boolean(nullable));
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return TypeBuilder.makeFP32(Predef$.MODULE$.boolean2Boolean(nullable));
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return TypeBuilder.makeFP64(Predef$.MODULE$.boolean2Boolean(nullable));
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return TypeBuilder.makeI64(Predef$.MODULE$.boolean2Boolean(nullable));
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return TypeBuilder.makeI32(Predef$.MODULE$.boolean2Boolean(nullable));
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return TypeBuilder.makeI16(Predef$.MODULE$.boolean2Boolean(nullable));
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return TypeBuilder.makeI8(Predef$.MODULE$.boolean2Boolean(nullable));
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return TypeBuilder.makeString(Predef$.MODULE$.boolean2Boolean(nullable));
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return TypeBuilder.makeBinary(Predef$.MODULE$.boolean2Boolean(nullable));
        }
        if (DateType$.MODULE$.equals(dataType)) {
            return TypeBuilder.makeDate(Predef$.MODULE$.boolean2Boolean(nullable));
        }
        YearMonthIntervalType yearMonthIntervalType = YearMonthIntervalType$.MODULE$.DEFAULT();
        DataType dataType2 = dataType;
        if (!(yearMonthIntervalType != null ? !yearMonthIntervalType.equals(dataType2) : dataType2 != null)) {
            return TypeBuilder.makeIntervalYear(Predef$.MODULE$.boolean2Boolean(nullable));
        }
        if (dataType != null && DecimalType$.MODULE$.unapply(dataType)) {
            DecimalType decimalType = (DecimalType)datatype;
            int precision = decimalType.precision();
            int scale = decimalType.scale();
            return TypeBuilder.makeDecimal(Predef$.MODULE$.boolean2Boolean(nullable), Predef$.MODULE$.int2Integer(precision), Predef$.MODULE$.int2Integer(scale));
        }
        if (TimestampType$.MODULE$.equals(dataType)) {
            return TypeBuilder.makeTimestamp(Predef$.MODULE$.boolean2Boolean(nullable));
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            return TypeBuilder.makeMap(Predef$.MODULE$.boolean2Boolean(nullable), this.getTypeNode(mapType.keyType(), false), this.getTypeNode(mapType.valueType(), mapType.valueContainsNull()));
        }
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            return TypeBuilder.makeList(Predef$.MODULE$.boolean2Boolean(nullable), this.getTypeNode(arrayType.elementType(), arrayType.containsNull()));
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            Function1 & Serializable normalizeStructFieldName = BackendsApiManager$.MODULE$.getSettings().structFieldToLowerCase() ? (Function1 & Serializable)name -> MODULE$.normalizeColName((String)name) : (Function1 & Serializable)name -> name;
            Tuple2 tuple2 = ((IterableOps)structType.map((Function1 & Serializable)f -> new Tuple2((Object)MODULE$.getTypeNode(f.dataType(), f.nullable()), normalizeStructFieldName.apply((Object)f.name())))).unzip(Predef$.MODULE$.$conforms());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            scala.collection.immutable.Seq fieldNodes = (scala.collection.immutable.Seq)tuple2._1();
            scala.collection.immutable.Seq fieldNames = (scala.collection.immutable.Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)fieldNodes, (Object)fieldNames);
            scala.collection.immutable.Seq fieldNodes2 = (scala.collection.immutable.Seq)tuple22._1();
            scala.collection.immutable.Seq fieldNames2 = (scala.collection.immutable.Seq)tuple22._2();
            return TypeBuilder.makeStruct(Predef$.MODULE$.boolean2Boolean(nullable), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)fieldNodes2).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)fieldNames2).asJava());
        }
        if (dataType instanceof NullType) {
            return TypeBuilder.makeNothing();
        }
        throw new GlutenNotSupportException("Type " + dataType + " not supported.");
    }

    public DataType parseFromTypeNode(TypeNode typeNode) {
        TypeNode typeNode2 = typeNode;
        if (typeNode2 instanceof BooleanTypeNode) {
            return BooleanType$.MODULE$;
        }
        if (typeNode2 instanceof FP32TypeNode) {
            return FloatType$.MODULE$;
        }
        if (typeNode2 instanceof FP64TypeNode) {
            return DoubleType$.MODULE$;
        }
        if (typeNode2 instanceof I64TypeNode) {
            return LongType$.MODULE$;
        }
        if (typeNode2 instanceof I32TypeNode) {
            return IntegerType$.MODULE$;
        }
        if (typeNode2 instanceof I16TypeNode) {
            return ShortType$.MODULE$;
        }
        if (typeNode2 instanceof I8TypeNode) {
            return ByteType$.MODULE$;
        }
        if (typeNode2 instanceof StringTypeNode) {
            return StringType$.MODULE$;
        }
        if (typeNode2 instanceof BinaryTypeNode) {
            return BinaryType$.MODULE$;
        }
        if (typeNode2 instanceof DateTypeNode) {
            return DateType$.MODULE$;
        }
        if (typeNode2 instanceof IntervalYearTypeNode) {
            return YearMonthIntervalType$.MODULE$.DEFAULT();
        }
        if (typeNode2 instanceof DecimalTypeNode) {
            DecimalTypeNode decimalTypeNode = (DecimalTypeNode)typeNode2;
            return new DecimalType(decimalTypeNode.precision, decimalTypeNode.scale);
        }
        if (typeNode2 instanceof TimestampTypeNode) {
            return TimestampType$.MODULE$;
        }
        if (typeNode2 instanceof MapNode) {
            MapNode mapNode = (MapNode)typeNode2;
            DataType keyType = this.parseFromTypeNode(mapNode.getKeyType());
            DataType valueType = this.parseFromTypeNode(mapNode.getValueType());
            Boolean valueContainsNull = mapNode.getValueType().nullable();
            return new MapType(keyType, valueType, Predef$.MODULE$.Boolean2boolean(valueContainsNull));
        }
        if (typeNode2 instanceof ListNode) {
            ListNode listNode = (ListNode)typeNode2;
            DataType elementType = this.parseFromTypeNode(listNode.getNestedType());
            return new ArrayType(elementType, Predef$.MODULE$.Boolean2boolean(listNode.getNestedType().nullable()));
        }
        if (typeNode2 instanceof StructNode) {
            StructNode structNode = (StructNode)typeNode2;
            Buffer fields = (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(structNode.getFieldTypes()).asScala()).map((Function1 & Serializable)typ -> {
                DataType field = MODULE$.parseFromTypeNode((TypeNode)typ);
                return new StructField("", field, Predef$.MODULE$.Boolean2boolean(typ.nullable()), StructField$.MODULE$.apply$default$4());
            });
            return StructType$.MODULE$.apply(fields.toSeq());
        }
        if (typeNode2 instanceof NothingNode) {
            return NullType$.MODULE$;
        }
        throw new GlutenNotSupportException("Type " + typeNode2 + " not supported.");
    }

    public ExpressionType parseFromBytes(byte[] bytes) {
        CodedInputStream input = CodedInputStream.newInstance(bytes);
        Type parsed = Type.parseFrom(input);
        Tuple2<DataType, Object> tuple2 = this.parseFromSubstraitType(parsed);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        DataType dataType = (DataType)tuple2._1();
        boolean nullable = tuple2._2$mcZ$sp();
        Tuple2 tuple22 = new Tuple2((Object)dataType, (Object)BoxesRunTime.boxToBoolean((boolean)nullable));
        DataType dataType2 = (DataType)tuple22._1();
        boolean nullable2 = tuple22._2$mcZ$sp();
        return new ExpressionType(dataType2, nullable2);
    }

    public void printBatch(ColumnarBatch cb) {
        ObjectRef batch = ObjectRef.create((Object)"");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), cb.numRows()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)rowId -> {
            ObjectRef row = ObjectRef.create((Object)"");
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), cb.numCols()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)colId -> {
                row$1.elem = (String)row$1.elem + Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)cb.column(colId).getUTF8String(rowId)), " ");
            });
            batch$1.elem = (String)batch$1.elem + (String)row.elem + "\n";
        });
        this.logWarning((Function0<String>)(Function0 & Serializable)() -> "batch:\n" + (String)batch$1.elem);
    }

    public boolean ifEquals(scala.collection.immutable.Seq<AttributeReference> left, scala.collection.immutable.Seq<NamedExpression> right) {
        boolean bl;
        Object object = new Object();
        try {
            if (left.size() != right.size()) {
                return false;
            }
            left.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                ExprId exprId = ((AttributeReference)left.apply(i)).exprId();
                ExprId exprId2 = ((NamedExpression)right.apply(i)).exprId();
                if (exprId == null ? exprId2 != null : !exprId.equals(exprId2)) {
                    throw new NonLocalReturnControl.mcZ.sp(object, false);
                }
            });
            bl = true;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public String toString() {
        return "ConverterUtils";
    }

    public Tuple3<String, Object, Object> powerOfTen(int pow) {
        Tuple3[] POWERS_OF_10 = (Tuple3[])((Object[])new Tuple3[]{new Tuple3((Object)"1", (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"10", (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"100", (Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"1000", (Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"10000", (Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"100000", (Object)BoxesRunTime.boxToInteger((int)6), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"1000000", (Object)BoxesRunTime.boxToInteger((int)7), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"10000000", (Object)BoxesRunTime.boxToInteger((int)8), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"100000000", (Object)BoxesRunTime.boxToInteger((int)9), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"1000000000", (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"10000000000", (Object)BoxesRunTime.boxToInteger((int)11), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"100000000000", (Object)BoxesRunTime.boxToInteger((int)12), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"1000000000000", (Object)BoxesRunTime.boxToInteger((int)13), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"10000000000000", (Object)BoxesRunTime.boxToInteger((int)14), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"100000000000000", (Object)BoxesRunTime.boxToInteger((int)15), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"1000000000000000", (Object)BoxesRunTime.boxToInteger((int)16), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"10000000000000000", (Object)BoxesRunTime.boxToInteger((int)17), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"100000000000000000", (Object)BoxesRunTime.boxToInteger((int)18), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"1000000000000000000", (Object)BoxesRunTime.boxToInteger((int)19), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"10000000000000000000", (Object)BoxesRunTime.boxToInteger((int)20), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"100000000000000000000", (Object)BoxesRunTime.boxToInteger((int)21), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"1000000000000000000000", (Object)BoxesRunTime.boxToInteger((int)22), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"10000000000000000000000", (Object)BoxesRunTime.boxToInteger((int)23), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"100000000000000000000000", (Object)BoxesRunTime.boxToInteger((int)24), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"1000000000000000000000000", (Object)BoxesRunTime.boxToInteger((int)25), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"10000000000000000000000000", (Object)BoxesRunTime.boxToInteger((int)26), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"100000000000000000000000000", (Object)BoxesRunTime.boxToInteger((int)27), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"1000000000000000000000000000", (Object)BoxesRunTime.boxToInteger((int)28), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"10000000000000000000000000000", (Object)BoxesRunTime.boxToInteger((int)29), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"100000000000000000000000000000", (Object)BoxesRunTime.boxToInteger((int)30), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"1000000000000000000000000000000", (Object)BoxesRunTime.boxToInteger((int)31), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"10000000000000000000000000000000", (Object)BoxesRunTime.boxToInteger((int)32), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"100000000000000000000000000000000", (Object)BoxesRunTime.boxToInteger((int)33), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"1000000000000000000000000000000000", (Object)BoxesRunTime.boxToInteger((int)34), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"10000000000000000000000000000000000", (Object)BoxesRunTime.boxToInteger((int)35), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"100000000000000000000000000000000000", (Object)BoxesRunTime.boxToInteger((int)36), (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple3((Object)"1000000000000000000000000000000000000", (Object)BoxesRunTime.boxToInteger((int)37), (Object)BoxesRunTime.boxToInteger((int)0))});
        return POWERS_OF_10[pow];
    }

    public String getTypeSigName(DataType dataType) {
        DataType dataType2 = dataType;
        if (BooleanType$.MODULE$.equals(dataType2)) {
            return "bool";
        }
        if (ByteType$.MODULE$.equals(dataType2)) {
            return "i8";
        }
        if (ShortType$.MODULE$.equals(dataType2)) {
            return "i16";
        }
        if (IntegerType$.MODULE$.equals(dataType2)) {
            return "i32";
        }
        if (LongType$.MODULE$.equals(dataType2)) {
            return "i64";
        }
        if (FloatType$.MODULE$.equals(dataType2)) {
            return "fp32";
        }
        if (DoubleType$.MODULE$.equals(dataType2)) {
            return "fp64";
        }
        if (DateType$.MODULE$.equals(dataType2)) {
            return "date";
        }
        if (TimestampType$.MODULE$.equals(dataType2)) {
            return "ts";
        }
        if (StringType$.MODULE$.equals(dataType2)) {
            return "str";
        }
        if (BinaryType$.MODULE$.equals(dataType2)) {
            return "vbin";
        }
        if (dataType2 != null && DecimalType$.MODULE$.unapply(dataType2)) {
            DecimalType decimalType = (DecimalType)dataType;
            int precision = decimalType.precision();
            int scale = decimalType.scale();
            return "dec<" + precision + "," + scale + ">";
        }
        if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            return "list<" + this.getTypeSigName(elementType) + ">";
        }
        if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            StructField[] fields = structType.fields();
            ObjectRef sigName = ObjectRef.create((Object)"struct<");
            IntRef index = IntRef.create((int)0);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)field -> {
                ConverterUtils$.$anonfun$getTypeSigName$1(sigName, index, fields, field);
                return BoxedUnit.UNIT;
            });
            sigName.elem = ((String)sigName.elem).concat(">");
            return (String)sigName.elem;
        }
        if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            String sigName = "map<";
            sigName = sigName.concat(this.getTypeSigName(keyType));
            sigName = sigName.concat(",");
            sigName = sigName.concat(this.getTypeSigName(valueType));
            sigName = sigName.concat(">");
            return sigName;
        }
        if (dataType2 instanceof CharType) {
            return "fchar";
        }
        if (NullType$.MODULE$.equals(dataType2)) {
            return "nothing";
        }
        throw new GlutenNotSupportException("Type " + dataType2 + " not supported.");
    }

    public String makeFuncName(String funcName, scala.collection.immutable.Seq<DataType> datatypes, Enumeration.Value config) {
        String string;
        Enumeration.Value value = config;
        Enumeration.Value value2 = ConverterUtils$FunctionConfig$.MODULE$.REQ();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            string = funcName.concat(":req_");
        } else {
            Enumeration.Value value4 = ConverterUtils$FunctionConfig$.MODULE$.OPT();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                string = funcName.concat(":opt_");
            } else {
                Enumeration.Value value6 = ConverterUtils$FunctionConfig$.MODULE$.NON();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    string = funcName.concat(":");
                } else {
                    throw new GlutenNotSupportException(value + " is not supported.");
                }
            }
        }
        ObjectRef typedFuncName = ObjectRef.create((Object)string);
        datatypes.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)idx -> {
            typedFuncName$1.elem = ((String)typedFuncName$1.elem).concat(MODULE$.getTypeSigName((DataType)datatypes.apply(idx)));
            if (idx < datatypes.size() - 1) {
                typedFuncName$1.elem = ((String)typedFuncName$1.elem).concat("_");
                return;
            }
        });
        return (String)typedFuncName.elem;
    }

    public Enumeration.Value makeFuncName$default$3() {
        return ConverterUtils$FunctionConfig$.MODULE$.NON();
    }

    public String convertJoinType(JoinType joinType) {
        JoinType joinType2 = joinType;
        if (Inner$.MODULE$.equals(joinType2)) {
            return "Inner";
        }
        if (FullOuter$.MODULE$.equals(joinType2)) {
            return "Outer";
        }
        if (LeftOuter$.MODULE$.equals(joinType2) ? true : RightOuter$.MODULE$.equals(joinType2)) {
            return "Left";
        }
        if (LeftSemi$.MODULE$.equals(joinType2)) {
            return "Semi";
        }
        if (LeftAnti$.MODULE$.equals(joinType2)) {
            return "Anti";
        }
        throw new GlutenNotSupportException("Unsupported join type: " + joinType2);
    }

    public final String ITERATOR_PREFIX() {
        return "iterator:";
    }

    public static final /* synthetic */ boolean $anonfun$collectStructFieldNames$1(ArrayList nameList$2, StructField field) {
        nameList$2.add(MODULE$.normalizeColName(field.name()));
        List<String> nestedNames = MODULE$.collectStructFieldNames(field.dataType());
        return nameList$2.addAll(nestedNames);
    }

    public static final /* synthetic */ void $anonfun$getTypeSigName$1(ObjectRef sigName$1, IntRef index$1, StructField[] fields$1, StructField field) {
        sigName$1.elem = ((String)sigName$1.elem).concat(MODULE$.getTypeSigName(field.dataType()));
        sigName$1.elem = ((String)sigName$1.elem).concat(index$1.elem < fields$1.length - 1 ? "," : "");
        ++index$1.elem;
    }

    private ConverterUtils$() {
    }
}

