/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.expression;

import java.io.Serializable;
import org.apache.gluten.backendsapi.BackendsApiManager$;
import org.apache.gluten.exception.GlutenNotSupportException;
import org.apache.gluten.expression.ConverterUtils$;
import org.apache.gluten.expression.ConverterUtils$FunctionConfig$;
import org.apache.gluten.expression.ExpressionMappings$;
import org.apache.gluten.substrait.SubstraitContext;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateFunction;
import org.apache.spark.sql.catalyst.expressions.aggregate.First;
import org.apache.spark.sql.catalyst.expressions.aggregate.Last;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Seq;

public final class AggregateFunctionsBuilder$ {
    public static final AggregateFunctionsBuilder$ MODULE$ = new AggregateFunctionsBuilder$();

    public long create(SubstraitContext context, AggregateFunction aggregateFunc) {
        String substraitAggFuncName = this.getSubstraitFunctionName(aggregateFunc);
        if (!BackendsApiManager$.MODULE$.getValidatorApiInstance().doExprValidate(substraitAggFuncName, (Expression)aggregateFunc)) {
            throw new GlutenNotSupportException("Aggregate function not supported for " + aggregateFunc + ".");
        }
        Seq inputTypes = (Seq)aggregateFunc.children().map((Function1 & Serializable)child -> child.dataType());
        return Predef$.MODULE$.Long2long(context.registerFunction(ConverterUtils$.MODULE$.makeFuncName(substraitAggFuncName, (Seq<DataType>)inputTypes, ConverterUtils$FunctionConfig$.MODULE$.REQ())));
    }

    public String getSubstraitFunctionName(AggregateFunction aggregateFunc) {
        Last last;
        boolean ignoreNulls;
        First first;
        boolean ignoreNulls2;
        AggregateFunction aggregateFunction = aggregateFunc;
        if (aggregateFunction instanceof First && (ignoreNulls2 = (first = (First)aggregateFunction).ignoreNulls())) {
            return "first_ignore_null";
        }
        if (aggregateFunction instanceof Last && (ignoreNulls = (last = (Last)aggregateFunction).ignoreNulls())) {
            return "last_ignore_null";
        }
        Option nameOpt = ExpressionMappings$.MODULE$.expressionsMap().get((Object)aggregateFunc.getClass());
        if (nameOpt.isEmpty()) {
            throw new GlutenNotSupportException("Could not find a valid substrait mapping name for " + aggregateFunc + ".");
        }
        String string = (String)nameOpt.get();
        switch (string == null ? 0 : string.hashCode()) {
            case -852309848: {
                if (!"udaf_placeholder".equals(string)) break;
                return aggregateFunc.prettyName();
            }
        }
        return string;
    }

    private AggregateFunctionsBuilder$() {
    }
}

