/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.execution;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.arrow.c.ArrowSchema;
import org.apache.gluten.backendsapi.BackendsApiManager$;
import org.apache.gluten.columnarbatch.ColumnarBatches;
import org.apache.gluten.execution.RowToVeloxColumnarExec;
import org.apache.gluten.iterator.Iterators$;
import org.apache.gluten.memory.arrow.alloc.ArrowBufferAllocators;
import org.apache.gluten.runtime.Runtime;
import org.apache.gluten.runtime.Runtimes$;
import org.apache.gluten.shaded.org.apache.arrow.memory.ArrowBuf;
import org.apache.gluten.shaded.org.apache.arrow.memory.BufferAllocator;
import org.apache.gluten.shaded.org.apache.arrow.vector.types.pojo.Schema;
import org.apache.gluten.utils.ArrowAbiUtil$;
import org.apache.gluten.vectorized.NativeRowToColumnarJniWrapper;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.metric.SQLMetric$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.utils.SparkArrowUtil$;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.task.TaskResources$;
import org.apache.spark.unsafe.Platform;
import scala.;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

public final class RowToVeloxColumnarExec$
implements Serializable {
    public static final RowToVeloxColumnarExec$ MODULE$ = new RowToVeloxColumnarExec$();

    public Iterator<ColumnarBatch> toColumnarBatchIterator(Iterator<InternalRow> it, StructType schema, int columnBatchSize, long columnBatchBytes) {
        SQLMetric numInputRows = new SQLMetric("numInputRows", SQLMetric$.MODULE$.$lessinit$greater$default$2());
        SQLMetric numOutputBatches = new SQLMetric("numOutputBatches", SQLMetric$.MODULE$.$lessinit$greater$default$2());
        SQLMetric convertTime = new SQLMetric("convertTime", SQLMetric$.MODULE$.$lessinit$greater$default$2());
        return this.toColumnarBatchIterator(it, schema, numInputRows, numOutputBatches, convertTime, columnBatchSize, columnBatchBytes);
    }

    public Iterator<ColumnarBatch> toColumnarBatchIterator(Iterator<InternalRow> it, StructType schema, SQLMetric numInputRows, SQLMetric numOutputBatches, SQLMetric convertTime, int columnBatchSize, long columnBatchBytes) {
        long l;
        if (it.isEmpty()) {
            return package$.MODULE$.Iterator().empty();
        }
        Schema arrowSchema = SparkArrowUtil$.MODULE$.toArrowSchema(schema, SQLConf$.MODULE$.get().sessionLocalTimeZone());
        Runtime runtime = Runtimes$.MODULE$.contextInstance(BackendsApiManager$.MODULE$.getBackendName(), "RowToColumnar");
        NativeRowToColumnarJniWrapper jniWrapper = NativeRowToColumnarJniWrapper.create(runtime);
        BufferAllocator arrowAllocator = ArrowBufferAllocators.contextInstance();
        ArrowSchema cSchema = ArrowSchema.allocateNew(arrowAllocator);
        UnsafeProjection$ factory = UnsafeProjection$.MODULE$;
        UnsafeProjection converter = factory.create(schema);
        try {
            ArrowAbiUtil$.MODULE$.exportSchema(arrowAllocator, arrowSchema, cSchema);
            l = jniWrapper.init(cSchema.memoryAddress());
        }
        finally {
            cSchema.close();
        }
        long r2cHandle = l;
        Iterator<ColumnarBatch> res = new Iterator<ColumnarBatch>(it, converter, columnBatchSize, columnBatchBytes, arrowAllocator, convertTime, numInputRows, numOutputBatches, jniWrapper, r2cHandle){
            private boolean finished;
            private final Iterator it$1;
            private final UnsafeProjection converter$1;
            private final int columnBatchSize$1;
            private final long columnBatchBytes$1;
            private final BufferAllocator arrowAllocator$1;
            private final SQLMetric convertTime$3;
            private final SQLMetric numInputRows$3;
            private final SQLMetric numOutputBatches$3;
            private final NativeRowToColumnarJniWrapper jniWrapper$1;
            private final long r2cHandle$1;

            public final boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public final Iterator<ColumnarBatch> iterator() {
                return Iterator.iterator$((Iterator)this);
            }

            public Option<ColumnarBatch> nextOption() {
                return Iterator.nextOption$((Iterator)this);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public BufferedIterator<ColumnarBatch> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator<B> padTo(int len, B elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Tuple2<Iterator<ColumnarBatch>, Iterator<ColumnarBatch>> partition(Function1<ColumnarBatch, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, ColumnarBatch, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<ColumnarBatch, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public int indexWhere(Function1<ColumnarBatch, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public int indexWhere$default$2() {
                return Iterator.indexWhere$default$2$((Iterator)this);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public final int length() {
                return Iterator.length$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public Iterator<ColumnarBatch> filter(Function1<ColumnarBatch, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public Iterator<ColumnarBatch> filterNot(Function1<ColumnarBatch, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public Iterator<ColumnarBatch> filterImpl(Function1<ColumnarBatch, Object> p, boolean isFlipped) {
                return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
            }

            public Iterator<ColumnarBatch> withFilter(Function1<ColumnarBatch, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<ColumnarBatch, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public Iterator<ColumnarBatch> distinct() {
                return Iterator.distinct$((Iterator)this);
            }

            public <B> Iterator<ColumnarBatch> distinctBy(Function1<ColumnarBatch, B> f) {
                return Iterator.distinctBy$((Iterator)this, f);
            }

            public <B> Iterator<B> map(Function1<ColumnarBatch, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> flatMap(Function1<ColumnarBatch, IterableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public <B> Iterator<B> flatten(Function1<ColumnarBatch, IterableOnce<B>> ev) {
                return Iterator.flatten$((Iterator)this, ev);
            }

            public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
                return Iterator.concat$((Iterator)this, xs);
            }

            public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
                return Iterator.$plus$plus$((Iterator)this, xs);
            }

            public Iterator<ColumnarBatch> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<ColumnarBatch> takeWhile(Function1<ColumnarBatch, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Iterator<ColumnarBatch> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<ColumnarBatch> dropWhile(Function1<ColumnarBatch, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<ColumnarBatch>, Iterator<ColumnarBatch>> span(Function1<ColumnarBatch, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<ColumnarBatch> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<ColumnarBatch> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<Tuple2<ColumnarBatch, B>> zip(IterableOnce<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public Iterator<Tuple2<ColumnarBatch, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B> boolean sameElements(IterableOnce<B> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Tuple2<Iterator<ColumnarBatch>, Iterator<ColumnarBatch>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <U> Iterator<ColumnarBatch> tapEach(Function1<ColumnarBatch, U> f) {
                return Iterator.tapEach$((Iterator)this, f);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public Iterator<ColumnarBatch> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public Tuple2<Iterator<ColumnarBatch>, Iterator<ColumnarBatch>> splitAt(int n) {
                return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
            }

            public boolean isTraversableAgain() {
                return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
            }

            public <U> void foreach(Function1<ColumnarBatch, U> f) {
                IterableOnceOps.foreach$((IterableOnceOps)this, f);
            }

            public boolean forall(Function1<ColumnarBatch, Object> p) {
                return IterableOnceOps.forall$((IterableOnceOps)this, p);
            }

            public boolean exists(Function1<ColumnarBatch, Object> p) {
                return IterableOnceOps.exists$((IterableOnceOps)this, p);
            }

            public int count(Function1<ColumnarBatch, Object> p) {
                return IterableOnceOps.count$((IterableOnceOps)this, p);
            }

            public Option<ColumnarBatch> find(Function1<ColumnarBatch, Object> p) {
                return IterableOnceOps.find$((IterableOnceOps)this, p);
            }

            public <B> B foldLeft(B z, Function2<B, ColumnarBatch, B> op) {
                return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
            }

            public <B> B foldRight(B z, Function2<ColumnarBatch, B, B> op) {
                return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
            }

            public final <B> B $div$colon(B z, Function2<B, ColumnarBatch, B> op) {
                return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
            }

            public final <B> B $colon$bslash(B z, Function2<ColumnarBatch, B, B> op) {
                return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
            }

            public <B> B reduce(Function2<B, B, B> op) {
                return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
            }

            public <B> B reduceLeft(Function2<B, ColumnarBatch, B> op) {
                return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
            }

            public <B> B reduceRight(Function2<ColumnarBatch, B, B> op) {
                return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, ColumnarBatch, B> op) {
                return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<ColumnarBatch, B, B> op) {
                return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
            }

            public boolean nonEmpty() {
                return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
            }

            public int size() {
                return IterableOnceOps.size$((IterableOnceOps)this);
            }

            public final <B> void copyToBuffer(Buffer<B> dest) {
                IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
            }

            public <B> int copyToArray(Object dest) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)dest);
            }

            public <B> int copyToArray(Object dest, int start) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)dest, (int)start);
            }

            public <B> int copyToArray(Object dest, int start, int n) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)dest, (int)start, (int)n);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
            }

            public Object min(Ordering ord) {
                return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<ColumnarBatch> minOption(Ordering<B> ord) {
                return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
            }

            public Object max(Ordering ord) {
                return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<ColumnarBatch> maxOption(Ordering<B> ord) {
                return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
            }

            public Object maxBy(Function1 f, Ordering ord) {
                return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
            }

            public <B> Option<ColumnarBatch> maxByOption(Function1<ColumnarBatch, B> f, Ordering<B> ord) {
                return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, ord);
            }

            public Object minBy(Function1 f, Ordering ord) {
                return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
            }

            public <B> Option<ColumnarBatch> minByOption(Function1<ColumnarBatch, B> f, Ordering<B> ord) {
                return IterableOnceOps.minByOption$((IterableOnceOps)this, f, ord);
            }

            public <B> Option<B> collectFirst(PartialFunction<ColumnarBatch, B> pf) {
                return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, ColumnarBatch, B> seqop, Function2<B, B, B> combop) {
                return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
            }

            public <B> boolean corresponds(IterableOnce<B> that, Function2<ColumnarBatch, B, Object> p) {
                return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
            }

            public final String mkString(String start, String sep, String end) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
            }

            public final String mkString(String sep) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
            }

            public final String mkString() {
                return IterableOnceOps.mkString$((IterableOnceOps)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public final StringBuilder addString(StringBuilder b, String sep) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
            }

            public final StringBuilder addString(StringBuilder b) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
            }

            public <C1> C1 to(Factory<ColumnarBatch, C1> factory) {
                return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
            }

            public final Iterator<ColumnarBatch> toIterator() {
                return IterableOnceOps.toIterator$((IterableOnceOps)this);
            }

            public List<ColumnarBatch> toList() {
                return IterableOnceOps.toList$((IterableOnceOps)this);
            }

            public Vector<ColumnarBatch> toVector() {
                return IterableOnceOps.toVector$((IterableOnceOps)this);
            }

            public <K, V> Map<K, V> toMap(.less.colon.less<ColumnarBatch, Tuple2<K, V>> ev) {
                return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
            }

            public <B> Set<B> toSet() {
                return IterableOnceOps.toSet$((IterableOnceOps)this);
            }

            public Seq<ColumnarBatch> toSeq() {
                return IterableOnceOps.toSeq$((IterableOnceOps)this);
            }

            public IndexedSeq<ColumnarBatch> toIndexedSeq() {
                return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
            }

            public final Stream<ColumnarBatch> toStream() {
                return IterableOnceOps.toStream$((IterableOnceOps)this);
            }

            public final <B> Buffer<B> toBuffer() {
                return IterableOnceOps.toBuffer$((IterableOnceOps)this);
            }

            public <B> Object toArray(ClassTag<B> evidence$2) {
                return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
            }

            public Iterable<ColumnarBatch> reversed() {
                return IterableOnceOps.reversed$((IterableOnceOps)this);
            }

            public <S extends Stepper<?>> S stepper(StepperShape<ColumnarBatch, S> shape) {
                return (S)IterableOnce.stepper$((IterableOnce)this, shape);
            }

            public int knownSize() {
                return IterableOnce.knownSize$((IterableOnce)this);
            }

            private boolean finished() {
                return this.finished;
            }

            private void finished_$eq(boolean x$1) {
                this.finished = x$1;
            }

            public boolean hasNext() {
                if (this.finished()) {
                    return false;
                }
                return this.it$1.hasNext();
            }

            private UnsafeRow convertToUnsafeRow(InternalRow row) {
                InternalRow internalRow = row;
                if (internalRow instanceof UnsafeRow) {
                    UnsafeRow unsafeRow = (UnsafeRow)internalRow;
                    return unsafeRow;
                }
                return this.converter$1.apply(row);
            }

            public ColumnarBatch next() {
                ColumnarBatch columnarBatch;
                ObjectRef arrowBuf = ObjectRef.create(null);
                TaskResources$.MODULE$.addRecycler("RowToColumnar_arrowBuf", 100, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    if ((ArrowBuf)arrowBuf$1.elem != null && ((ArrowBuf)arrowBuf$1.elem).refCnt() != 0) {
                        ((ArrowBuf)arrowBuf$1.elem).close();
                        return;
                    }
                });
                ListBuffer rowLength = new ListBuffer();
                int rowCount = 0;
                long offset = 0L;
                while (rowCount < this.columnBatchSize$1 && offset < this.columnBatchBytes$1 && !this.finished()) {
                    if (!this.it$1.hasNext()) {
                        this.finished_$eq(true);
                        continue;
                    }
                    InternalRow row = (InternalRow)this.it$1.next();
                    long start = System.currentTimeMillis();
                    UnsafeRow unsafeRow = this.convertToUnsafeRow(row);
                    int sizeInBytes = unsafeRow.getSizeInBytes();
                    if (rowCount == 0) {
                        double estimatedBufSize = Math.min(Math.max(Math.min((double)sizeInBytes * (double)this.columnBatchSize$1 * 1.2, (double)(31760L * (long)this.columnBatchSize$1)), (double)sizeInBytes * (double)10), (double)Math.max(this.columnBatchBytes$1, (long)sizeInBytes));
                        arrowBuf.elem = this.arrowAllocator$1.buffer((long)estimatedBufSize);
                    }
                    if (offset + (long)sizeInBytes > ((ArrowBuf)arrowBuf.elem).capacity()) {
                        long bufSize = offset + (long)sizeInBytes > this.columnBatchBytes$1 ? offset + (long)sizeInBytes : Math.min(offset + (long)(sizeInBytes * 2), this.columnBatchBytes$1);
                        ArrowBuf tmpBuf = this.arrowAllocator$1.buffer(bufSize);
                        tmpBuf.setBytes(0L, (ArrowBuf)arrowBuf.elem, 0L, offset);
                        ((ArrowBuf)arrowBuf.elem).close();
                        arrowBuf.elem = tmpBuf;
                    }
                    Platform.copyMemory((Object)unsafeRow.getBaseObject(), (long)unsafeRow.getBaseOffset(), null, (long)(((ArrowBuf)arrowBuf.elem).memoryAddress() + offset), (long)sizeInBytes);
                    offset += (long)sizeInBytes;
                    rowLength.$plus$eq((Object)BoxesRunTime.boxToLong((long)sizeInBytes));
                    ++rowCount;
                    this.convertTime$3.$plus$eq(System.currentTimeMillis() - start);
                }
                this.numInputRows$3.$plus$eq((long)rowCount);
                this.numOutputBatches$3.$plus$eq(1L);
                long startNative = System.currentTimeMillis();
                try {
                    long handle = this.jniWrapper$1.nativeConvertRowToColumnar(this.r2cHandle$1, (long[])rowLength.toArray((ClassTag)ClassTag$.MODULE$.Long()), ((ArrowBuf)arrowBuf.elem).memoryAddress());
                    ColumnarBatch cb = ColumnarBatches.create(handle);
                    this.convertTime$3.$plus$eq(System.currentTimeMillis() - startNative);
                    columnarBatch = cb;
                }
                finally {
                    ((ArrowBuf)arrowBuf.elem).close();
                    arrowBuf.elem = null;
                }
                return columnarBatch;
            }
            {
                this.it$1 = it$1;
                this.converter$1 = converter$1;
                this.columnBatchSize$1 = columnBatchSize$1;
                this.columnBatchBytes$1 = columnBatchBytes$1;
                this.arrowAllocator$1 = arrowAllocator$1;
                this.convertTime$3 = convertTime$3;
                this.numInputRows$3 = numInputRows$3;
                this.numOutputBatches$3 = numOutputBatches$3;
                this.jniWrapper$1 = jniWrapper$1;
                this.r2cHandle$1 = r2cHandle$1;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
                this.finished = false;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$next$1(scala.runtime.ObjectRef )}, serializedLambda);
            }
        };
        return Iterators$.MODULE$.wrap(res).protectInvocationFlow().recycleIterator((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> jniWrapper.close(r2cHandle)).recyclePayload((Function1<ColumnarBatch, BoxedUnit>)(Function1 & Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        }).create();
    }

    public RowToVeloxColumnarExec apply(SparkPlan child) {
        return new RowToVeloxColumnarExec(child);
    }

    public Option<SparkPlan> unapply(RowToVeloxColumnarExec x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)x$0.child());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RowToVeloxColumnarExec$.class);
    }

    private RowToVeloxColumnarExec$() {
    }
}

