/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.datasource;

import java.util.HashMap;
import org.apache.arrow.c.ArrowSchema;
import org.apache.gluten.backendsapi.BackendsApiManager$;
import org.apache.gluten.datasource.VeloxDataSourceJniWrapper;
import org.apache.gluten.memory.arrow.alloc.ArrowBufferAllocators;
import org.apache.gluten.runtime.Runtime;
import org.apache.gluten.runtime.Runtimes$;
import org.apache.gluten.shaded.org.apache.arrow.memory.BufferAllocator;
import org.apache.gluten.utils.ArrowAbiUtil$;
import org.apache.hadoop.fs.FileStatus;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.utils.SparkSchemaUtil$;
import scala.Option;
import scala.Option$;
import scala.collection.immutable.Seq;

public final class VeloxDataSourceUtil$ {
    public static final VeloxDataSourceUtil$ MODULE$ = new VeloxDataSourceUtil$();

    public Option<StructType> readSchema(Seq<FileStatus> files) {
        if (files.isEmpty()) {
            throw new IllegalArgumentException("No input file specified");
        }
        return this.readSchema((FileStatus)files.toList().head());
    }

    public Option<StructType> readSchema(FileStatus file) {
        Option option;
        BufferAllocator allocator = ArrowBufferAllocators.contextInstance();
        Runtime runtime = Runtimes$.MODULE$.contextInstance(BackendsApiManager$.MODULE$.getBackendName(), "VeloxWriter");
        VeloxDataSourceJniWrapper datasourceJniWrapper = VeloxDataSourceJniWrapper.create(runtime);
        long dsHandle = datasourceJniWrapper.init(file.getPath().toString(), -1L, new HashMap<String, String>());
        ArrowSchema cSchema = ArrowSchema.allocateNew(allocator);
        datasourceJniWrapper.inspectSchema(dsHandle, cSchema.memoryAddress());
        try {
            option = Option$.MODULE$.apply((Object)SparkSchemaUtil$.MODULE$.fromArrowSchema(ArrowAbiUtil$.MODULE$.importToSchema(allocator, cSchema)));
        }
        finally {
            cSchema.close();
            datasourceJniWrapper.close(dsHandle);
        }
        return option;
    }

    private VeloxDataSourceUtil$() {
    }
}

