/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.datasource;

import java.io.Serializable;
import java.util.Optional;
import org.apache.arrow.dataset.file.FileSystemDatasetFactory;
import org.apache.arrow.dataset.jni.NativeDataset;
import org.apache.arrow.dataset.jni.NativeScanner;
import org.apache.arrow.dataset.scanner.ScanOptions;
import org.apache.arrow.dataset.scanner.csv.CsvFragmentScanOptions;
import org.apache.gluten.columnarbatch.ColumnarBatches;
import org.apache.gluten.config.VeloxConfig$;
import org.apache.gluten.execution.RowToVeloxColumnarExec$;
import org.apache.gluten.iterator.Iterators$;
import org.apache.gluten.memory.arrow.alloc.ArrowBufferAllocators;
import org.apache.gluten.shaded.org.apache.arrow.memory.BufferAllocator;
import org.apache.gluten.shaded.org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.gluten.shaded.org.apache.arrow.vector.VectorUnloader;
import org.apache.gluten.shaded.org.apache.arrow.vector.ipc.ArrowReader;
import org.apache.gluten.shaded.org.apache.arrow.vector.types.pojo.Schema;
import org.apache.gluten.utils.ArrowUtil$;
import org.apache.gluten.vectorized.ArrowWritableColumnVector;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.TaskContext$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.csv.CSVHeaderChecker;
import org.apache.spark.sql.catalyst.csv.CSVHeaderCheckerHelper$;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.csv.UnivocityParser;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.execution.datasources.HadoopFileLinesReader;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.csv.CSVDataSource$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction0;

public final class ArrowCSVFileFormat$
implements Serializable {
    public static final ArrowCSVFileFormat$ MODULE$ = new ArrowCSVFileFormat$();

    public Iterator<ColumnarBatch> readArrow(BufferAllocator allocator, PartitionedFile file, Schema actualReadFields, StructType missingSchema, StructType partitionSchema, FileSystemDatasetFactory factory, int batchSize, CsvFragmentScanOptions arrowConfig) {
        String[] actualReadFieldNames = (String[])((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(actualReadFields.getFields()).asScala()).map((Function1 & Serializable)x$9 -> x$9.getName())).toArray(ClassTag$.MODULE$.apply(String.class));
        NativeDataset dataset = factory.finish(actualReadFields);
        ScanOptions scanOptions = new ScanOptions.Builder(batchSize).columns(Optional.of(actualReadFieldNames)).fragmentScanOptions(arrowConfig).build();
        NativeScanner scanner = dataset.newScan(scanOptions);
        ArrowWritableColumnVector[] partitionVectors = ArrowUtil$.MODULE$.loadPartitionColumns(batchSize, partitionSchema, file.partitionValues());
        ArrowWritableColumnVector[] nullVectors = missingSchema.nonEmpty() ? ArrowUtil$.MODULE$.loadMissingColumns(batchSize, missingSchema) : (ArrowWritableColumnVector[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ArrowWritableColumnVector.class));
        ArrowReader reader = scanner.scanBatches();
        return Iterators$.MODULE$.wrap(new Iterator<ColumnarBatch>(reader, allocator, actualReadFields, partitionVectors, nullVectors){
            private final ArrowReader reader$1;
            private final BufferAllocator allocator$1;
            private final Schema actualReadFields$1;
            private final ArrowWritableColumnVector[] partitionVectors$1;
            private final ArrowWritableColumnVector[] nullVectors$1;

            public final boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public final Iterator<ColumnarBatch> iterator() {
                return Iterator.iterator$((Iterator)this);
            }

            public Option<ColumnarBatch> nextOption() {
                return Iterator.nextOption$((Iterator)this);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public BufferedIterator<ColumnarBatch> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator<B> padTo(int len, B elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Tuple2<Iterator<ColumnarBatch>, Iterator<ColumnarBatch>> partition(Function1<ColumnarBatch, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, ColumnarBatch, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<ColumnarBatch, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public int indexWhere(Function1<ColumnarBatch, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public int indexWhere$default$2() {
                return Iterator.indexWhere$default$2$((Iterator)this);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public final int length() {
                return Iterator.length$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public Iterator<ColumnarBatch> filter(Function1<ColumnarBatch, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public Iterator<ColumnarBatch> filterNot(Function1<ColumnarBatch, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public Iterator<ColumnarBatch> filterImpl(Function1<ColumnarBatch, Object> p, boolean isFlipped) {
                return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
            }

            public Iterator<ColumnarBatch> withFilter(Function1<ColumnarBatch, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<ColumnarBatch, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public Iterator<ColumnarBatch> distinct() {
                return Iterator.distinct$((Iterator)this);
            }

            public <B> Iterator<ColumnarBatch> distinctBy(Function1<ColumnarBatch, B> f) {
                return Iterator.distinctBy$((Iterator)this, f);
            }

            public <B> Iterator<B> map(Function1<ColumnarBatch, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> flatMap(Function1<ColumnarBatch, IterableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public <B> Iterator<B> flatten(Function1<ColumnarBatch, IterableOnce<B>> ev) {
                return Iterator.flatten$((Iterator)this, ev);
            }

            public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
                return Iterator.concat$((Iterator)this, xs);
            }

            public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
                return Iterator.$plus$plus$((Iterator)this, xs);
            }

            public Iterator<ColumnarBatch> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<ColumnarBatch> takeWhile(Function1<ColumnarBatch, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Iterator<ColumnarBatch> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<ColumnarBatch> dropWhile(Function1<ColumnarBatch, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<ColumnarBatch>, Iterator<ColumnarBatch>> span(Function1<ColumnarBatch, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<ColumnarBatch> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<ColumnarBatch> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<Tuple2<ColumnarBatch, B>> zip(IterableOnce<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public Iterator<Tuple2<ColumnarBatch, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B> boolean sameElements(IterableOnce<B> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Tuple2<Iterator<ColumnarBatch>, Iterator<ColumnarBatch>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <U> Iterator<ColumnarBatch> tapEach(Function1<ColumnarBatch, U> f) {
                return Iterator.tapEach$((Iterator)this, f);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public Iterator<ColumnarBatch> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public Tuple2<Iterator<ColumnarBatch>, Iterator<ColumnarBatch>> splitAt(int n) {
                return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
            }

            public boolean isTraversableAgain() {
                return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
            }

            public <U> void foreach(Function1<ColumnarBatch, U> f) {
                IterableOnceOps.foreach$((IterableOnceOps)this, f);
            }

            public boolean forall(Function1<ColumnarBatch, Object> p) {
                return IterableOnceOps.forall$((IterableOnceOps)this, p);
            }

            public boolean exists(Function1<ColumnarBatch, Object> p) {
                return IterableOnceOps.exists$((IterableOnceOps)this, p);
            }

            public int count(Function1<ColumnarBatch, Object> p) {
                return IterableOnceOps.count$((IterableOnceOps)this, p);
            }

            public Option<ColumnarBatch> find(Function1<ColumnarBatch, Object> p) {
                return IterableOnceOps.find$((IterableOnceOps)this, p);
            }

            public <B> B foldLeft(B z, Function2<B, ColumnarBatch, B> op) {
                return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
            }

            public <B> B foldRight(B z, Function2<ColumnarBatch, B, B> op) {
                return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
            }

            public final <B> B $div$colon(B z, Function2<B, ColumnarBatch, B> op) {
                return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
            }

            public final <B> B $colon$bslash(B z, Function2<ColumnarBatch, B, B> op) {
                return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
            }

            public <B> B reduce(Function2<B, B, B> op) {
                return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
            }

            public <B> B reduceLeft(Function2<B, ColumnarBatch, B> op) {
                return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
            }

            public <B> B reduceRight(Function2<ColumnarBatch, B, B> op) {
                return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, ColumnarBatch, B> op) {
                return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<ColumnarBatch, B, B> op) {
                return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
            }

            public boolean nonEmpty() {
                return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
            }

            public int size() {
                return IterableOnceOps.size$((IterableOnceOps)this);
            }

            public final <B> void copyToBuffer(Buffer<B> dest) {
                IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
            }

            public <B> int copyToArray(Object dest) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)dest);
            }

            public <B> int copyToArray(Object dest, int start) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)dest, (int)start);
            }

            public <B> int copyToArray(Object dest, int start, int n) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)dest, (int)start, (int)n);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
            }

            public Object min(Ordering ord) {
                return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<ColumnarBatch> minOption(Ordering<B> ord) {
                return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
            }

            public Object max(Ordering ord) {
                return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<ColumnarBatch> maxOption(Ordering<B> ord) {
                return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
            }

            public Object maxBy(Function1 f, Ordering ord) {
                return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
            }

            public <B> Option<ColumnarBatch> maxByOption(Function1<ColumnarBatch, B> f, Ordering<B> ord) {
                return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, ord);
            }

            public Object minBy(Function1 f, Ordering ord) {
                return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
            }

            public <B> Option<ColumnarBatch> minByOption(Function1<ColumnarBatch, B> f, Ordering<B> ord) {
                return IterableOnceOps.minByOption$((IterableOnceOps)this, f, ord);
            }

            public <B> Option<B> collectFirst(PartialFunction<ColumnarBatch, B> pf) {
                return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, ColumnarBatch, B> seqop, Function2<B, B, B> combop) {
                return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
            }

            public <B> boolean corresponds(IterableOnce<B> that, Function2<ColumnarBatch, B, Object> p) {
                return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
            }

            public final String mkString(String start, String sep, String end) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
            }

            public final String mkString(String sep) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
            }

            public final String mkString() {
                return IterableOnceOps.mkString$((IterableOnceOps)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public final StringBuilder addString(StringBuilder b, String sep) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
            }

            public final StringBuilder addString(StringBuilder b) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
            }

            public <C1> C1 to(Factory<ColumnarBatch, C1> factory) {
                return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
            }

            public final Iterator<ColumnarBatch> toIterator() {
                return IterableOnceOps.toIterator$((IterableOnceOps)this);
            }

            public List<ColumnarBatch> toList() {
                return IterableOnceOps.toList$((IterableOnceOps)this);
            }

            public Vector<ColumnarBatch> toVector() {
                return IterableOnceOps.toVector$((IterableOnceOps)this);
            }

            public <K, V> Map<K, V> toMap(.less.colon.less<ColumnarBatch, Tuple2<K, V>> ev) {
                return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
            }

            public <B> Set<B> toSet() {
                return IterableOnceOps.toSet$((IterableOnceOps)this);
            }

            public Seq<ColumnarBatch> toSeq() {
                return IterableOnceOps.toSeq$((IterableOnceOps)this);
            }

            public IndexedSeq<ColumnarBatch> toIndexedSeq() {
                return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
            }

            public final Stream<ColumnarBatch> toStream() {
                return IterableOnceOps.toStream$((IterableOnceOps)this);
            }

            public final <B> Buffer<B> toBuffer() {
                return IterableOnceOps.toBuffer$((IterableOnceOps)this);
            }

            public <B> Object toArray(ClassTag<B> evidence$2) {
                return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
            }

            public Iterable<ColumnarBatch> reversed() {
                return IterableOnceOps.reversed$((IterableOnceOps)this);
            }

            public <S extends Stepper<?>> S stepper(StepperShape<ColumnarBatch, S> shape) {
                return (S)IterableOnce.stepper$((IterableOnce)this, shape);
            }

            public int knownSize() {
                return IterableOnce.knownSize$((IterableOnce)this);
            }

            public boolean hasNext() {
                return this.reader$1.loadNextBatch();
            }

            public ColumnarBatch next() {
                VectorSchemaRoot root = this.reader$1.getVectorSchemaRoot();
                VectorUnloader unloader = new VectorUnloader(root);
                ColumnarBatch batch = ArrowUtil$.MODULE$.loadBatch(this.allocator$1, unloader.getRecordBatch(), this.actualReadFields$1, this.partitionVectors$1, this.nullVectors$1);
                return batch;
            }
            {
                this.reader$1 = reader$1;
                this.allocator$1 = allocator$1;
                this.actualReadFields$1 = actualReadFields$1;
                this.partitionVectors$1 = partitionVectors$1;
                this.nullVectors$1 = nullVectors$1;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
            }
        }).recycleIterator((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            scanner.close();
            dataset.close();
            factory.close();
            reader.close();
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])partitionVectors), (Function1 & Serializable)x$10 -> {
                x$10.close();
                return BoxedUnit.UNIT;
            });
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])nullVectors), (Function1 & Serializable)x$11 -> {
                x$11.close();
                return BoxedUnit.UNIT;
            });
        }).recyclePayload((Function1<ColumnarBatch, BoxedUnit>)(Function1 & Serializable)x$12 -> {
            x$12.close();
            return BoxedUnit.UNIT;
        }).create();
    }

    public void checkHeader(PartitionedFile file, StructType actualDataSchema, StructType actualRequiredSchema, CSVOptions parsedOptions, Seq<Filter> actualFilters, Configuration conf) {
        boolean isStartOfFile;
        boolean bl = isStartOfFile = file.start() == 0L;
        if (!isStartOfFile) {
            return;
        }
        UnivocityParser parser = new UnivocityParser(actualDataSchema, actualRequiredSchema, parsedOptions, actualFilters);
        StructType schema = parsedOptions.columnPruning() ? actualRequiredSchema : actualDataSchema;
        CSVHeaderChecker headerChecker = new CSVHeaderChecker(schema, parsedOptions, "CSV file: " + file.filePath(), isStartOfFile);
        HadoopFileLinesReader linesReader = new HadoopFileLinesReader(file, parser.options().lineSeparatorInRead(), conf);
        Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1 & Serializable)x$13 -> x$13.addTaskCompletionListener((Function1 & Serializable)x$14 -> {
            linesReader.close();
            return BoxedUnit.UNIT;
        }));
        Iterator lines = linesReader.map((Function1 & Serializable)line -> new String(line.getBytes(), 0, line.getLength(), parser.options().charset()));
        CSVHeaderCheckerHelper$.MODULE$.checkHeaderColumnNames(headerChecker, (Iterator<String>)lines, parser.tokenizer());
    }

    public Iterator<ColumnarBatch> rowToColumn(StructType schema, int batchSize, Iterator<InternalRow> it) {
        Iterator<ColumnarBatch> veloxBatch = RowToVeloxColumnarExec$.MODULE$.toColumnarBatchIterator(it, schema, batchSize, VeloxConfig$.MODULE$.get().veloxPreferredBatchBytes());
        return veloxBatch.map((Function1 & Serializable)v -> ColumnarBatches.load(ArrowBufferAllocators.contextInstance(), v));
    }

    private AttributeReference toAttribute(StructField field) {
        String x$1 = field.name();
        DataType x$2 = field.dataType();
        boolean x$3 = field.nullable();
        Metadata x$4 = field.metadata();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
        Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
        return new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
    }

    private Seq<AttributeReference> toAttributes(StructType schema) {
        return (Seq)schema.map((Function1 & Serializable)field -> MODULE$.toAttribute((StructField)field));
    }

    public Tuple2<StructType, Iterator<InternalRow>> withPartitionValue(StructType requiredSchema, StructType partitionSchema, Iterator<InternalRow> iter, PartitionedFile file) {
        LazyRef appendPartitionColumns$lzy = new LazyRef();
        Seq fullSchema = (Seq)this.toAttributes(requiredSchema).$plus$plus(this.toAttributes(partitionSchema));
        UnsafeProjection converter = ArrowCSVFileFormat$.appendPartitionColumns$1(appendPartitionColumns$lzy, fullSchema);
        if (partitionSchema.isEmpty()) {
            Iterator rows = iter.map((Function1 & Serializable)dataRow -> converter.apply(dataRow));
            return new Tuple2((Object)StructType$.MODULE$.apply((Seq)requiredSchema.$plus$plus((IterableOnce)partitionSchema)), (Object)rows);
        }
        JoinedRow joinedRow = new JoinedRow();
        Iterator rows = iter.map((Function1 & Serializable)dataRow -> converter.apply((InternalRow)joinedRow.apply(dataRow, file.partitionValues())));
        return new Tuple2((Object)StructType$.MODULE$.apply((Seq)requiredSchema.$plus$plus((IterableOnce)partitionSchema)), (Object)rows);
    }

    public Iterator<InternalRow> fallbackReadVanilla(StructType dataSchema, StructType requiredSchema, Configuration conf, CSVOptions parsedOptions, PartitionedFile file, Seq<Filter> actualFilters, boolean columnPruning) {
        StructType actualDataSchema = StructType$.MODULE$.apply((Seq)dataSchema.filterNot((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)ArrowCSVFileFormat$.$anonfun$fallbackReadVanilla$1(parsedOptions, x$15))));
        StructType actualRequiredSchema = StructType$.MODULE$.apply((Seq)requiredSchema.filterNot((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)ArrowCSVFileFormat$.$anonfun$fallbackReadVanilla$2(parsedOptions, x$16))));
        UnivocityParser parser = new UnivocityParser(actualDataSchema, actualRequiredSchema, parsedOptions, actualFilters);
        StructType schema = columnPruning ? actualRequiredSchema : actualDataSchema;
        boolean isStartOfFile = file.start() == 0L;
        CSVHeaderChecker headerChecker = new CSVHeaderChecker(schema, parsedOptions, "CSV file: " + file.filePath(), isStartOfFile);
        return CSVDataSource$.MODULE$.apply(parsedOptions).readFile(conf, file, parser, headerChecker, requiredSchema);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ArrowCSVFileFormat$.class);
    }

    private static final /* synthetic */ UnsafeProjection appendPartitionColumns$lzycompute$1(LazyRef appendPartitionColumns$lzy$1, Seq fullSchema$1) {
        UnsafeProjection unsafeProjection;
        LazyRef lazyRef = appendPartitionColumns$lzy$1;
        synchronized (lazyRef) {
            unsafeProjection = appendPartitionColumns$lzy$1.initialized() ? (UnsafeProjection)appendPartitionColumns$lzy$1.value() : (UnsafeProjection)appendPartitionColumns$lzy$1.initialize(GenerateUnsafeProjection$.MODULE$.generate((Object)fullSchema$1, fullSchema$1));
        }
        return unsafeProjection;
    }

    private static final UnsafeProjection appendPartitionColumns$1(LazyRef appendPartitionColumns$lzy$1, Seq fullSchema$1) {
        if (appendPartitionColumns$lzy$1.initialized()) {
            return (UnsafeProjection)appendPartitionColumns$lzy$1.value();
        }
        return ArrowCSVFileFormat$.appendPartitionColumns$lzycompute$1(appendPartitionColumns$lzy$1, fullSchema$1);
    }

    public static final /* synthetic */ boolean $anonfun$fallbackReadVanilla$1(CSVOptions parsedOptions$1, StructField x$15) {
        String string = x$15.name();
        String string2 = parsedOptions$1.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$fallbackReadVanilla$2(CSVOptions parsedOptions$1, StructField x$16) {
        String string = x$16.name();
        String string2 = parsedOptions$1.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private ArrowCSVFileFormat$() {
    }
}

