/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.component;

import java.io.Serializable;
import java.util.Map;
import org.apache.gluten.component.Component;
import org.apache.gluten.exception.GlutenException;
import org.apache.gluten.utils.ResourceUtil;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.SparkReflectionUtil$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.runtime.BoxedUnit;
import scala.util.matching.Regex;

public final class Discovery$
implements Logging {
    public static final Discovery$ MODULE$ = new Discovery$();
    private static final String container;
    private static final Regex componentFilePattern;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        container = "META-INF/gluten-components";
        componentFilePattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(.+)$"));
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String container() {
        return container;
    }

    private Regex componentFilePattern() {
        return componentFilePattern;
    }

    public Seq<Component> discoverAll() {
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Start discovering components in the current classpath... ");
        long prev = System.currentTimeMillis();
        Buffer allFiles = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(ResourceUtil.getResources(this.container(), this.componentFilePattern().pattern())).asScala();
        long duration = System.currentTimeMillis() - prev;
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Discovered component files: " + allFiles.mkString(", ") + ". Duration: " + duration + " ms.");
        Set deDup = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        Seq out = ((IterableOnceOps)allFiles.flatMap((Function1 & Serializable)x0$1 -> {
            Option option;
            String string = x0$1;
            if (string != null && !(option = MODULE$.componentFilePattern().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
                Class clazz;
                String className = (String)((LinearSeqOps)option.get()).apply(0);
                if (!deDup.add((Object)className)) {
                    MODULE$.logWarning((Function0<String>)(Function0 & Serializable)() -> "Found duplicated component class " + className + " in the classpath, ignoring.");
                    return None$.MODULE$;
                }
                try {
                    clazz = SparkReflectionUtil$.MODULE$.classForName(className, SparkReflectionUtil$.MODULE$.classForName$default$2(), SparkReflectionUtil$.MODULE$.classForName$default$3());
                }
                catch (ClassNotFoundException e) {
                    throw new GlutenException("Component class not found: " + className, e);
                }
                Class clazz2 = clazz;
                Component instance = (Component)clazz2.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return new Some((Object)instance);
            }
            return None$.MODULE$;
        })).toSeq();
        return out;
    }

    private Discovery$() {
    }
}

