/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.columnarbatch;

import java.util.Arrays;
import java.util.Objects;
import org.apache.gluten.backendsapi.BackendsApiManager;
import org.apache.gluten.columnarbatch.ColumnarBatches;
import org.apache.gluten.columnarbatch.IndicatorVector;
import org.apache.gluten.columnarbatch.VeloxColumnarBatchJniWrapper;
import org.apache.gluten.memory.arrow.alloc.ArrowBufferAllocators;
import org.apache.gluten.runtime.Runtime;
import org.apache.gluten.runtime.Runtimes;
import org.apache.gluten.shaded.com.google.common.base.Preconditions;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.sql.vectorized.SparkColumnarBatchUtil;

public final class VeloxColumnarBatches {
    public static final String COMPREHENSIVE_TYPE_VELOX = "velox";

    private static boolean isVeloxBatch(ColumnarBatch batch) {
        String comprehensiveType = ColumnarBatches.getComprehensiveLightBatchType(batch);
        return Objects.equals(comprehensiveType, COMPREHENSIVE_TYPE_VELOX);
    }

    public static void checkVeloxBatch(ColumnarBatch batch) {
        if (ColumnarBatches.isZeroColumnBatch(batch)) {
            return;
        }
        Preconditions.checkArgument(VeloxColumnarBatches.isVeloxBatch(batch), String.format("Expected comprehensive batch type %s, but got %s", COMPREHENSIVE_TYPE_VELOX, ColumnarBatches.getComprehensiveLightBatchType(batch)));
    }

    public static ColumnarBatch toVeloxBatch(ColumnarBatch input) {
        long i;
        ColumnarBatches.checkOffloaded(input);
        if (ColumnarBatches.isZeroColumnBatch(input)) {
            return input;
        }
        Preconditions.checkArgument(!VeloxColumnarBatches.isVeloxBatch(input));
        Runtime runtime = Runtimes.contextInstance(BackendsApiManager.getBackendName(), "VeloxColumnarBatches#toVeloxBatch");
        long handle = ColumnarBatches.getNativeHandle(BackendsApiManager.getBackendName(), input);
        long outHandle = VeloxColumnarBatchJniWrapper.create(runtime).from(handle);
        ColumnarBatch output = ColumnarBatches.create(outHandle);
        long refCnt = ColumnarBatches.getRefCntLight(input);
        IndicatorVector giv = (IndicatorVector)output.column(0);
        for (i = 0L; i < refCnt - 1L; ++i) {
            giv.retain();
        }
        for (i = 0L; i < refCnt; ++i) {
            input.close();
        }
        SparkColumnarBatchUtil.transferVectors(output, input);
        return input;
    }

    public static ColumnarBatch ensureVeloxBatch(ColumnarBatch input) {
        ColumnarBatch light = ColumnarBatches.ensureOffloaded(ArrowBufferAllocators.contextInstance(), input);
        if (VeloxColumnarBatches.isVeloxBatch(light)) {
            return light;
        }
        return VeloxColumnarBatches.toVeloxBatch(light);
    }

    public static ColumnarBatch compose(ColumnarBatch ... batches) {
        Runtime runtime = Runtimes.contextInstance(BackendsApiManager.getBackendName(), "VeloxColumnarBatches#compose");
        long[] handles = Arrays.stream(batches).mapToLong(b -> ColumnarBatches.getNativeHandle(BackendsApiManager.getBackendName(), b)).toArray();
        long handle = VeloxColumnarBatchJniWrapper.create(runtime).compose(handles);
        return ColumnarBatches.create(handle);
    }

    public static ColumnarBatch slice(ColumnarBatch batch, int offset, int limit) {
        int totalRows = batch.numRows();
        if (limit >= totalRows) {
            return batch;
        }
        Runtime runtime = Runtimes.contextInstance(BackendsApiManager.getBackendName(), "VeloxColumnarBatches#sliceBatch");
        long nativeHandle = ColumnarBatches.getNativeHandle(BackendsApiManager.getBackendName(), batch);
        long handle = VeloxColumnarBatchJniWrapper.create(runtime).slice(nativeHandle, offset, limit);
        return ColumnarBatches.create(handle);
    }

    public static ColumnarBatch repeatedThenCompose(ColumnarBatch batch1, ColumnarBatch batch2, int[] rowId2RowNums) {
        Runtime runtime = Runtimes.contextInstance(BackendsApiManager.getBackendName(), "VeloxColumnarBatches#repeatedThenCompose");
        long handle = VeloxColumnarBatchJniWrapper.create(runtime).repeatedThenCompose(ColumnarBatches.getNativeHandle(BackendsApiManager.getBackendName(), batch1), ColumnarBatches.getNativeHandle(BackendsApiManager.getBackendName(), batch2), rowId2RowNums);
        return ColumnarBatches.create(handle);
    }
}

