/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.columnarbatch;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.gluten.columnarbatch.IndicatorVector;
import org.apache.spark.task.TaskResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndicatorVectorPool
implements TaskResource {
    private static final Logger LOG = LoggerFactory.getLogger(IndicatorVectorPool.class);
    private final Map<Long, IndicatorVector> uniqueInstances = new ConcurrentHashMap<Long, IndicatorVector>();

    IndicatorVectorPool() {
    }

    @Override
    public void release() throws Exception {
        if (!this.uniqueInstances.isEmpty()) {
            LOG.warn("There are still unreleased native columnar batches during ending the task. Will close them automatically however the batches should be better released manually to minimize memory pressure.");
        }
    }

    IndicatorVector obtain(long handle) {
        return this.uniqueInstances.computeIfAbsent(handle, h2 -> new IndicatorVector(this, handle));
    }

    void remove(long handle) {
        if (this.uniqueInstances.remove(handle) == null) {
            throw new IllegalStateException("Indicator vector not found in pool, this should not happen");
        }
    }

    @Override
    public int priority() {
        return 20;
    }

    @Override
    public String resourceName() {
        return IndicatorVectorPool.class.getName();
    }
}

