/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.columnarbatch;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.gluten.columnarbatch.ColumnarBatchJniWrapper;
import org.apache.gluten.columnarbatch.IndicatorVectorBase;
import org.apache.gluten.columnarbatch.IndicatorVectorPool;
import org.apache.spark.task.TaskResources;

public class IndicatorVector
extends IndicatorVectorBase {
    private final IndicatorVectorPool pool;
    private final AtomicLong refCnt = new AtomicLong(1L);

    protected IndicatorVector(IndicatorVectorPool pool, long handle) {
        super(handle);
        this.pool = pool;
    }

    static IndicatorVector obtain(long handle) {
        IndicatorVectorPool pool = (IndicatorVectorPool)TaskResources.addResourceIfNotRegistered(IndicatorVectorPool.class.getName(), IndicatorVectorPool::new);
        return pool.obtain(handle);
    }

    @Override
    long refCnt() {
        return this.refCnt.get();
    }

    @Override
    void retain() {
        this.refCnt.getAndIncrement();
    }

    @Override
    void release() {
        if (this.refCnt.get() == 0L) {
            return;
        }
        if (this.refCnt.decrementAndGet() == 0L) {
            this.pool.remove(this.handle);
            ColumnarBatchJniWrapper.close(this.handle);
        }
    }
}

