/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.columnarbatch;

import java.util.Arrays;
import java.util.NoSuchElementException;
import org.apache.arrow.c.ArrowArray;
import org.apache.arrow.c.ArrowSchema;
import org.apache.gluten.columnarbatch.ColumnarBatchJniWrapper;
import org.apache.gluten.columnarbatch.IndicatorVector;
import org.apache.gluten.columnarbatch.PlaceholderVector;
import org.apache.gluten.memory.arrow.alloc.ArrowBufferAllocators;
import org.apache.gluten.runtime.Runtime;
import org.apache.gluten.runtime.Runtimes;
import org.apache.gluten.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.gluten.shaded.org.apache.arrow.memory.BufferAllocator;
import org.apache.gluten.utils.ArrowAbiUtil;
import org.apache.gluten.utils.ArrowUtil;
import org.apache.gluten.utils.InternalRowUtil;
import org.apache.gluten.vectorized.ArrowColumnarBatch;
import org.apache.gluten.vectorized.ArrowWritableColumnVector;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.utils.SparkArrowUtil;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.sql.vectorized.SparkColumnarBatchUtil;
import scala.collection.Iterator;
import scala.collection.JavaConverters;

public final class ColumnarBatches {
    private static final String INTERNAL_BACKEND_KIND = "internal";

    private ColumnarBatches() {
    }

    private static BatchType identifyBatchType(ColumnarBatch batch) {
        if (batch.numCols() == 0) {
            return BatchType.ZERO_COLUMN;
        }
        ColumnVector col0 = batch.column(0);
        if (col0 instanceof IndicatorVector) {
            for (int i = 1; i < batch.numCols(); ++i) {
                ColumnVector col = batch.column(i);
                if (col instanceof PlaceholderVector) continue;
                throw new IllegalStateException("Light batch should consist of one indicator vector and (numCols - 1) placeholder vectors");
            }
            return BatchType.LIGHT;
        }
        for (int i = 0; i < batch.numCols(); ++i) {
            ColumnVector col = batch.column(i);
            if (col instanceof ArrowWritableColumnVector) continue;
            throw new IllegalStateException("Heavy batch should consist of arrow vectors");
        }
        return BatchType.HEAVY;
    }

    @VisibleForTesting
    static boolean isHeavyBatch(ColumnarBatch batch) {
        return ColumnarBatches.identifyBatchType(batch) == BatchType.HEAVY;
    }

    @VisibleForTesting
    static boolean isLightBatch(ColumnarBatch batch) {
        return ColumnarBatches.identifyBatchType(batch) == BatchType.LIGHT;
    }

    @VisibleForTesting
    static boolean isZeroColumnBatch(ColumnarBatch batch) {
        return ColumnarBatches.identifyBatchType(batch) == BatchType.ZERO_COLUMN;
    }

    public static ColumnarBatch select(String backendName, ColumnarBatch batch, int[] columnIndices) {
        Runtime runtime = Runtimes.contextInstance(backendName, "ColumnarBatches#select");
        switch (ColumnarBatches.identifyBatchType(batch)) {
            case LIGHT: {
                IndicatorVector iv = ColumnarBatches.getIndicatorVector(batch);
                long outputBatchHandle = ColumnarBatchJniWrapper.create(runtime).select(iv.handle(), columnIndices);
                return ColumnarBatches.create(outputBatchHandle);
            }
            case HEAVY: {
                return new ColumnarBatch((ColumnVector[])Arrays.stream(columnIndices).mapToObj(arg_0 -> ((ColumnarBatch)batch).column(arg_0)).toArray(ColumnVector[]::new), batch.numRows());
            }
        }
        throw new IllegalStateException();
    }

    static ColumnarBatch ensureOffloaded(BufferAllocator allocator, ColumnarBatch batch) {
        if (ColumnarBatches.isLightBatch(batch)) {
            return batch;
        }
        return ColumnarBatches.offload(allocator, batch);
    }

    static ColumnarBatch ensureLoaded(BufferAllocator allocator, ColumnarBatch batch) {
        if (ColumnarBatches.isHeavyBatch(batch)) {
            return batch;
        }
        return ColumnarBatches.load(allocator, batch);
    }

    public static void checkLoaded(ColumnarBatch batch) {
        BatchType type = ColumnarBatches.identifyBatchType(batch);
        switch (type) {
            case HEAVY: 
            case ZERO_COLUMN: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Input batch is not loaded");
            }
        }
    }

    public static void checkOffloaded(ColumnarBatch batch) {
        BatchType type = ColumnarBatches.identifyBatchType(batch);
        switch (type) {
            case LIGHT: 
            case ZERO_COLUMN: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Input batch is not offloaded");
            }
        }
    }

    public static ArrowColumnarBatch convertToArrowColumnarBatch(ColumnarBatch sparkColumnarBatch) {
        int numCols = sparkColumnarBatch.numCols();
        ArrowWritableColumnVector[] writableColumns = new ArrowWritableColumnVector[numCols];
        for (int i = 0; i < numCols; ++i) {
            writableColumns[i] = (ArrowWritableColumnVector)sparkColumnarBatch.column(i);
        }
        return new ArrowColumnarBatch(writableColumns, sparkColumnarBatch.numRows());
    }

    /*
     * Exception decompiling
     */
    public static ColumnarBatch load(BufferAllocator allocator, ColumnarBatch input) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static ColumnarBatch offload(BufferAllocator allocator, ColumnarBatch input) {
        if (ColumnarBatches.isZeroColumnBatch(input)) {
            return input;
        }
        if (!ColumnarBatches.isHeavyBatch(input)) {
            throw new IllegalArgumentException("batch is not Arrow columnar batch");
        }
        if (input.numCols() == 0) {
            throw new IllegalArgumentException("batch with zero columns cannot be offloaded");
        }
        Runtime runtime = Runtimes.contextInstance(INTERNAL_BACKEND_KIND, "ColumnarBatches#offload");
        try (ArrowArray cArray = ArrowArray.allocateNew(allocator);){
            ArrowSchema cSchema = ArrowSchema.allocateNew(allocator);
            try {
                long i;
                ArrowAbiUtil.exportFromSparkColumnarBatch(allocator, input, cSchema, cArray);
                long handle = ColumnarBatchJniWrapper.create(runtime).createWithArrowArray(cSchema.memoryAddress(), cArray.memoryAddress());
                ColumnarBatch output = ColumnarBatches.create(handle);
                long refCnt = ColumnarBatches.getRefCntHeavy(input);
                IndicatorVector giv = (IndicatorVector)output.column(0);
                for (i = 0L; i < refCnt - 1L; ++i) {
                    giv.retain();
                }
                for (i = 0L; i < refCnt; ++i) {
                    input.close();
                }
                SparkColumnarBatchUtil.transferVectors(output, input);
                ColumnarBatch columnarBatch = input;
                if (cSchema != null) {
                    cSchema.close();
                }
                return columnarBatch;
            }
            catch (Throwable throwable) {
                if (cSchema != null) {
                    try {
                        cSchema.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    public static java.util.Iterator<InternalRow> emptyRowIterator(int numRows) {
        final int maxRows = numRows;
        return new java.util.Iterator<InternalRow>(){
            int rowId = 0;

            @Override
            public boolean hasNext() {
                return this.rowId < maxRows;
            }

            @Override
            public InternalRow next() {
                if (this.rowId >= maxRows) {
                    throw new NoSuchElementException();
                }
                ++this.rowId;
                return new UnsafeRow(0);
            }
        };
    }

    static long getRefCntLight(ColumnarBatch input) {
        if (!ColumnarBatches.isLightBatch(input)) {
            throw new UnsupportedOperationException("Input batch is not light batch");
        }
        IndicatorVector iv = (IndicatorVector)input.column(0);
        return iv.refCnt();
    }

    static long getRefCntHeavy(ColumnarBatch input) {
        if (!ColumnarBatches.isHeavyBatch(input)) {
            throw new UnsupportedOperationException("Input batch is not heavy batch");
        }
        if (input.numCols() == 0) {
            throw new IllegalArgumentException("batch with zero columns doesn't have meaningful reference count");
        }
        long refCnt = -1L;
        for (int i = 0; i < input.numCols(); ++i) {
            ArrowWritableColumnVector col = (ArrowWritableColumnVector)input.column(i);
            long colRefCnt = col.refCnt();
            if (refCnt == -1L) {
                refCnt = colRefCnt;
                continue;
            }
            if (colRefCnt == refCnt) continue;
            throw new IllegalStateException();
        }
        if (refCnt == -1L) {
            throw new IllegalStateException();
        }
        return refCnt;
    }

    @VisibleForTesting
    static long getRefCnt(ColumnarBatch input) {
        switch (ColumnarBatches.identifyBatchType(input)) {
            case LIGHT: {
                return ColumnarBatches.getRefCntLight(input);
            }
            case HEAVY: {
                return ColumnarBatches.getRefCntHeavy(input);
            }
        }
        throw new IllegalStateException();
    }

    public static void forceClose(ColumnarBatch input) {
        if (ColumnarBatches.isZeroColumnBatch(input)) {
            return;
        }
        for (long i = 0L; i < ColumnarBatches.getRefCnt(input); ++i) {
            input.close();
        }
    }

    private static ColumnarBatch create(IndicatorVector iv) {
        int numColumns = Math.toIntExact(iv.getNumColumns());
        int numRows = Math.toIntExact(iv.getNumRows());
        if (numColumns == 0) {
            return new ColumnarBatch(new ColumnVector[0], numRows);
        }
        ColumnVector[] columnVectors = new ColumnVector[numColumns];
        columnVectors[0] = iv;
        long numPlaceholders = numColumns - 1;
        int i = 0;
        while ((long)i < numPlaceholders) {
            PlaceholderVector pv = PlaceholderVector.INSTANCE;
            columnVectors[i + 1] = pv;
            ++i;
        }
        return new ColumnarBatch(columnVectors, numRows);
    }

    public static ColumnarBatch create(long nativeHandle) {
        return ColumnarBatches.create(IndicatorVector.obtain(nativeHandle));
    }

    public static void retain(ColumnarBatch b) {
        switch (ColumnarBatches.identifyBatchType(b)) {
            case LIGHT: {
                IndicatorVector iv = (IndicatorVector)b.column(0);
                iv.retain();
                break;
            }
            case HEAVY: {
                for (int i = 0; i < b.numCols(); ++i) {
                    ArrowWritableColumnVector col = (ArrowWritableColumnVector)b.column(i);
                    col.retain();
                }
                break;
            }
            case ZERO_COLUMN: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public static void release(ColumnarBatch b) {
        b.close();
    }

    private static IndicatorVector getIndicatorVector(ColumnarBatch input) {
        if (!ColumnarBatches.isLightBatch(input)) {
            throw new UnsupportedOperationException("Input batch is not light batch");
        }
        return (IndicatorVector)input.column(0);
    }

    public static long getNativeHandle(String backendName, ColumnarBatch batch) {
        if (ColumnarBatches.isZeroColumnBatch(batch)) {
            ColumnarBatchJniWrapper jniWrapper = ColumnarBatchJniWrapper.create(Runtimes.contextInstance(backendName, "ColumnarBatches#getNativeHandle"));
            return jniWrapper.getForEmptySchema(batch.numRows());
        }
        return ColumnarBatches.getIndicatorVector(batch).handle();
    }

    static String getComprehensiveLightBatchType(ColumnarBatch batch) {
        return ColumnarBatches.getIndicatorVector(batch).getType();
    }

    public static String toString(ColumnarBatch batch, int start, int length) {
        ColumnarBatch loadedBatch = ColumnarBatches.ensureLoaded(ArrowBufferAllocators.contextInstance(), batch);
        StructType type = SparkArrowUtil.fromArrowSchema(ArrowUtil.toSchema(loadedBatch));
        return InternalRowUtil.toString(type, (Iterator<InternalRow>)JavaConverters.asScalaIterator((java.util.Iterator)loadedBatch.rowIterator()), start, length);
    }

    private static enum BatchType {
        LIGHT,
        HEAVY,
        ZERO_COLUMN;

    }
}

