/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.backendsapi.velox;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.gluten.backendsapi.BackendSettingsApi;
import org.apache.gluten.backendsapi.velox.VeloxBackend$;
import org.apache.gluten.backendsapi.velox.VeloxBatchType$;
import org.apache.gluten.backendsapi.velox.VeloxValidatorApi$;
import org.apache.gluten.config.GlutenConfig;
import org.apache.gluten.config.GlutenConfig$;
import org.apache.gluten.config.VeloxConfig$;
import org.apache.gluten.exception.GlutenNotSupportException;
import org.apache.gluten.execution.ValidationResult;
import org.apache.gluten.execution.ValidationResult$;
import org.apache.gluten.execution.WriteFilesExecTransformer$;
import org.apache.gluten.expression.WindowFunctionsBuilder$;
import org.apache.gluten.extension.columnar.transition.Convention;
import org.apache.gluten.sql.shims.SparkShimLoader$;
import org.apache.gluten.substrait.rel.LocalFilesNode;
import org.apache.gluten.utils.ParquetMetadataUtils$;
import org.apache.gluten.utils.VeloxFileSystemValidationJniWrapper;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.CumeDist;
import org.apache.spark.sql.catalyst.expressions.DenseRank;
import org.apache.spark.sql.catalyst.expressions.Descending$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.FrameType;
import org.apache.spark.sql.catalyst.expressions.Lag;
import org.apache.spark.sql.catalyst.expressions.Lead;
import org.apache.spark.sql.catalyst.expressions.NTile;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NthValue;
import org.apache.spark.sql.catalyst.expressions.PercentRank;
import org.apache.spark.sql.catalyst.expressions.RangeFrame$;
import org.apache.spark.sql.catalyst.expressions.Rank;
import org.apache.spark.sql.catalyst.expressions.RowNumber;
import org.apache.spark.sql.catalyst.expressions.SortDirection;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SpecialFrameBoundary;
import org.apache.spark.sql.catalyst.expressions.SpecifiedWindowFrame;
import org.apache.spark.sql.catalyst.expressions.WindowExpression;
import org.apache.spark.sql.catalyst.expressions.WindowFrame;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproximatePercentile;
import org.apache.spark.sql.catalyst.expressions.aggregate.HyperLogLogPlusPlus;
import org.apache.spark.sql.catalyst.expressions.aggregate.Percentile;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.LeftOuter$;
import org.apache.spark.sql.catalyst.plans.RightOuter$;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.execution.command.CreateDataSourceTableAsSelectCommand;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.InsertIntoHadoopFsRelationCommand;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.apache.spark.sql.hive.execution.HiveFileFormat;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.Breaks$;
import scala.util.matching.Regex;

public final class VeloxBackendSettings$
implements BackendSettingsApi {
    public static final VeloxBackendSettings$ MODULE$ = new VeloxBackendSettings$();
    private static final Set<String> SHUFFLE_SUPPORTED_CODEC;
    private static final String GLUTEN_VELOX_UDF_LIB_PATHS;
    private static final String GLUTEN_VELOX_DRIVER_UDF_LIB_PATHS;
    private static final String GLUTEN_VELOX_INTERNAL_UDF_LIB_PATHS;
    private static final String GLUTEN_VELOX_UDF_ALLOW_TYPE_CONVERSION;

    static {
        BackendSettingsApi.$init$(MODULE$);
        SHUFFLE_SUPPORTED_CODEC = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"lz4", "zstd"}));
        GLUTEN_VELOX_UDF_LIB_PATHS = VeloxBackend$.MODULE$.CONF_PREFIX() + ".udfLibraryPaths";
        GLUTEN_VELOX_DRIVER_UDF_LIB_PATHS = VeloxBackend$.MODULE$.CONF_PREFIX() + ".driver.udfLibraryPaths";
        GLUTEN_VELOX_INTERNAL_UDF_LIB_PATHS = VeloxBackend$.MODULE$.CONF_PREFIX() + ".internal.udfLibraryPaths";
        GLUTEN_VELOX_UDF_ALLOW_TYPE_CONVERSION = VeloxBackend$.MODULE$.CONF_PREFIX() + ".udfAllowTypeConversion";
    }

    @Override
    public boolean supportNativeMetadataColumns() {
        return BackendSettingsApi.supportNativeMetadataColumns$(this);
    }

    @Override
    public boolean supportNativeRowIndexColumn() {
        return BackendSettingsApi.supportNativeRowIndexColumn$(this);
    }

    @Override
    public boolean supportStructType() {
        return BackendSettingsApi.supportStructType$(this);
    }

    @Override
    public boolean structFieldToLowerCase() {
        return BackendSettingsApi.structFieldToLowerCase$(this);
    }

    @Override
    public boolean excludeScanExecFromCollapsedStage() {
        return BackendSettingsApi.excludeScanExecFromCollapsedStage$(this);
    }

    @Override
    public boolean transformCheckOverflow() {
        return BackendSettingsApi.transformCheckOverflow$(this);
    }

    @Override
    public boolean needOutputSchemaForPlan() {
        return BackendSettingsApi.needOutputSchemaForPlan$(this);
    }

    @Override
    public boolean requireBloomFilterAggMightContainJointFallback() {
        return BackendSettingsApi.requireBloomFilterAggMightContainJointFallback$(this);
    }

    @Override
    public boolean supportCartesianProductExecWithCondition() {
        return BackendSettingsApi.supportCartesianProductExecWithCondition$(this);
    }

    private /* synthetic */ Function1 super$supportHashBuildJoinTypeOnLeft() {
        return BackendSettingsApi.supportHashBuildJoinTypeOnLeft$(this);
    }

    private /* synthetic */ Function1 super$supportHashBuildJoinTypeOnRight() {
        return BackendSettingsApi.supportHashBuildJoinTypeOnRight$(this);
    }

    public Set<String> SHUFFLE_SUPPORTED_CODEC() {
        return SHUFFLE_SUPPORTED_CODEC;
    }

    public String GLUTEN_VELOX_UDF_LIB_PATHS() {
        return GLUTEN_VELOX_UDF_LIB_PATHS;
    }

    public String GLUTEN_VELOX_DRIVER_UDF_LIB_PATHS() {
        return GLUTEN_VELOX_DRIVER_UDF_LIB_PATHS;
    }

    public String GLUTEN_VELOX_INTERNAL_UDF_LIB_PATHS() {
        return GLUTEN_VELOX_INTERNAL_UDF_LIB_PATHS;
    }

    public String GLUTEN_VELOX_UDF_ALLOW_TYPE_CONVERSION() {
        return GLUTEN_VELOX_UDF_ALLOW_TYPE_CONVERSION;
    }

    @Override
    public Convention.BatchType primaryBatchType() {
        return VeloxBatchType$.MODULE$;
    }

    @Override
    public ValidationResult validateScanExec(LocalFilesNode.ReadFileFormat format, StructField[] fields, StructType dataSchema, Seq<String> rootPaths, Map<String, String> properties, Configuration hadoopConf, Set<LocalFilesNode.ReadFileFormat> partitionFileFormats) {
        ValidationResult validationResult;
        Object object = new Object();
        try {
            .colon.colon validationChecks = new .colon.colon((Object)this.validateScheme$1(rootPaths), (List)new .colon.colon((Object)VeloxBackendSettings$.validateFormats$1(partitionFileFormats, format, properties, fields, dataSchema), (List)new .colon.colon((Object)VeloxBackendSettings$.validateMetadata$1(format, rootPaths, dataSchema, properties, hadoopConf), (List)new .colon.colon((Object)VeloxBackendSettings$.validateDataSchema$1(dataSchema), (List)Nil$.MODULE$))));
            validationChecks.foreach((Function1 & Serializable)check -> {
                VeloxBackendSettings$.$anonfun$validateScanExec$6(object, check);
                return BoxedUnit.UNIT;
            });
            validationResult = ValidationResult$.MODULE$.succeeded();
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                validationResult = (ValidationResult)ex.value();
            }
            throw ex;
        }
        return validationResult;
    }

    public Seq<String> distinctRootPaths(Seq<String> paths) {
        return ((IterableOnceOps)((IterableOps)((IterableOps)paths.map((Function1 & Serializable)p -> new Tuple2((Object)new Path(p).toUri().getScheme(), p))).groupBy((Function1 & Serializable)x$1 -> (String)x$1._1()).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)VeloxBackendSettings$.$anonfun$distinctRootPaths$3(x$2)))).map((Function1 & Serializable)x$3 -> (String)((Tuple2)((IterableOps)x$3._2()).head())._2())).toSeq();
    }

    @Override
    public LocalFilesNode.ReadFileFormat getSubstraitReadFileFormatV1(FileFormat fileFormat) {
        String string = fileFormat.getClass().getSimpleName();
        switch (string == null ? 0 : string.hashCode()) {
            case -1303469689: {
                if (!"ParquetFileFormat".equals(string)) break;
                return LocalFilesNode.ReadFileFormat.ParquetReadFormat;
            }
            case -1149827303: {
                if (!"CSVFileFormat".equals(string)) break;
                return LocalFilesNode.ReadFileFormat.TextReadFormat;
            }
            case 1740337011: {
                if (!"OrcFileFormat".equals(string)) break;
                return LocalFilesNode.ReadFileFormat.OrcReadFormat;
            }
            case 1774983706: {
                if (!"DwrfFileFormat".equals(string)) break;
                return LocalFilesNode.ReadFileFormat.DwrfReadFormat;
            }
        }
        return LocalFilesNode.ReadFileFormat.UnknownFormat;
    }

    @Override
    public LocalFilesNode.ReadFileFormat getSubstraitReadFileFormatV2(Scan scan) {
        String string = scan.getClass().getSimpleName();
        switch (string == null ? 0 : string.hashCode()) {
            case -666475919: {
                if (!"ParquetScan".equals(string)) break;
                return LocalFilesNode.ReadFileFormat.ParquetReadFormat;
            }
            case -148732604: {
                if (!"DwrfScan".equals(string)) break;
                return LocalFilesNode.ReadFileFormat.DwrfReadFormat;
            }
            case 456069469: {
                if (!"OrcScan".equals(string)) break;
                return LocalFilesNode.ReadFileFormat.OrcReadFormat;
            }
        }
        return LocalFilesNode.ReadFileFormat.UnknownFormat;
    }

    @Override
    public ValidationResult supportWriteFilesExec(FileFormat format, StructField[] fields, Option<BucketSpec> bucketSpec, boolean isPartitionedTable, Map<String, String> options) {
        Option option = VeloxBackendSettings$.validateCompressionCodec$1(options).orElse((Function0 & Serializable)() -> VeloxBackendSettings$.validateFileFormat$1(format)).orElse((Function0 & Serializable)() -> VeloxBackendSettings$.validateFieldMetadata$1(fields)).orElse((Function0 & Serializable)() -> VeloxBackendSettings$.validateDataTypes$1(format, fields)).orElse((Function0 & Serializable)() -> VeloxBackendSettings$.validateWriteFilesOptions$1(options)).orElse((Function0 & Serializable)() -> VeloxBackendSettings$.validateBucketSpec$1(bucketSpec, options));
        if (option instanceof Some) {
            Some some = (Some)option;
            String reason = (String)some.value();
            return ValidationResult$.MODULE$.failed(reason, ValidationResult$.MODULE$.failed$default$2());
        }
        return ValidationResult$.MODULE$.succeeded();
    }

    @Override
    public boolean supportNativeWrite(StructField[] fields) {
        return !ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)field -> BoxesRunTime.boxToBoolean((boolean)VeloxBackendSettings$.isNotSupported$1(field.dataType())));
    }

    @Override
    public boolean supportExpandExec() {
        return true;
    }

    @Override
    public boolean supportSortExec() {
        return true;
    }

    @Override
    public boolean supportSortMergeJoinExec() {
        return GlutenConfig$.MODULE$.get().enableColumnarSortMergeJoin();
    }

    @Override
    public boolean supportWindowGroupLimitExec(Expression rankLikeFunction) {
        Expression expression = rankLikeFunction;
        return expression instanceof RowNumber;
    }

    @Override
    public boolean supportWindowExec(Seq<NamedExpression> windowFunctions) {
        BooleanRef allSupported = BooleanRef.create((boolean)true);
        Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable)() -> windowFunctions.foreach((Function1 & Serializable)func -> {
            VeloxBackendSettings$.$anonfun$supportWindowExec$2(allSupported, func);
            return BoxedUnit.UNIT;
        }));
        return allSupported.elem;
    }

    @Override
    public boolean supportColumnarShuffleExec() {
        GlutenConfig conf = GlutenConfig$.MODULE$.get();
        return conf.enableColumnarShuffle() && (conf.isUseGlutenShuffleManager() || conf.shuffleManagerSupportsColumnarShuffle());
    }

    @Override
    public boolean enableJoinKeysRewrite() {
        return false;
    }

    @Override
    public Function1<JoinType, Object> supportHashBuildJoinTypeOnLeft() {
        return (Function1 & Serializable)t2 -> BoxesRunTime.boxToBoolean((boolean)VeloxBackendSettings$.$anonfun$supportHashBuildJoinTypeOnLeft$1(t2));
    }

    @Override
    public Function1<JoinType, Object> supportHashBuildJoinTypeOnRight() {
        return (Function1 & Serializable)t2 -> BoxesRunTime.boxToBoolean((boolean)VeloxBackendSettings$.$anonfun$supportHashBuildJoinTypeOnRight$1(t2));
    }

    @Override
    public boolean fallbackAggregateWithEmptyOutputChild() {
        return true;
    }

    @Override
    public boolean recreateJoinExecOnFallback() {
        return true;
    }

    @Override
    public boolean rescaleDecimalArithmetic() {
        return true;
    }

    @Override
    public Set<String> shuffleSupportedCodec() {
        return this.SHUFFLE_SUPPORTED_CODEC();
    }

    @Override
    public boolean insertPostProjectForGenerate() {
        return true;
    }

    @Override
    public boolean skipNativeCtas(CreateDataSourceTableAsSelectCommand ctas) {
        return true;
    }

    @Override
    public boolean skipNativeInsertInto(InsertIntoHadoopFsRelationCommand insertInto) {
        return insertInto.bucketSpec().nonEmpty();
    }

    @Override
    public boolean alwaysFailOnMapExpression() {
        return true;
    }

    @Override
    public boolean requiredChildOrderingForWindowGroupLimit() {
        return false;
    }

    @Override
    public boolean staticPartitionWriteOnly() {
        return true;
    }

    @Override
    public boolean enableNativeWriteFiles() {
        return BoxesRunTime.unboxToBoolean((Object)GlutenConfig$.MODULE$.get().enableNativeWriter().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> SparkShimLoader$.MODULE$.getSparkShims().enableNativeWriteFilesByDefault()));
    }

    @Override
    public boolean enableNativeArrowReadFiles() {
        return GlutenConfig$.MODULE$.get().enableNativeArrowReader();
    }

    @Override
    public boolean shouldRewriteCount() {
        return true;
    }

    @Override
    public boolean supportCartesianProductExec() {
        return true;
    }

    @Override
    public boolean supportSampleExec() {
        return true;
    }

    @Override
    public boolean supportColumnarArrowUdf() {
        return true;
    }

    @Override
    public boolean needPreComputeRangeFrameBoundary() {
        return true;
    }

    @Override
    public boolean supportIcebergEqualityDeleteRead() {
        return false;
    }

    @Override
    public boolean reorderColumnsForPartitionWrite() {
        return true;
    }

    @Override
    public boolean enableEnhancedFeatures() {
        return VeloxConfig$.MODULE$.get().enableEnhancedFeatures();
    }

    @Override
    public boolean supportAppendDataExec() {
        return this.enableEnhancedFeatures();
    }

    @Override
    public boolean supportReplaceDataExec() {
        return this.enableEnhancedFeatures();
    }

    @Override
    public boolean supportOverwriteByExpression() {
        return this.enableEnhancedFeatures();
    }

    @Override
    public boolean supportOverwritePartitionsDynamic() {
        return this.enableEnhancedFeatures();
    }

    @Override
    public boolean supportWriteToDataSourceV2() {
        return this.enableEnhancedFeatures();
    }

    @Override
    public boolean supportEmptySchemaColumnarShuffle() {
        return false;
    }

    private final Option validateScheme$1(Seq rootPaths$1) {
        Seq<String> filteredRootPaths = this.distinctRootPaths((Seq<String>)rootPaths$1);
        if (filteredRootPaths.nonEmpty() && !VeloxFileSystemValidationJniWrapper.allSupportedByRegisteredFileSystems((String[])filteredRootPaths.toArray(ClassTag$.MODULE$.apply(String.class)))) {
            return new Some((Object)("Scheme of [" + filteredRootPaths + "] is not supported by registered file systems."));
        }
        return None$.MODULE$;
    }

    private static final Option validateTypes$1(PartialFunction validatorFunc, StructField[] fieldsToValidate, LocalFilesNode.ReadFileFormat format$1) {
        String[] unsupportedDataTypeReason = (String[])ArrayOps$.MODULE$.collect$extension(Predef$.MODULE$.refArrayOps((Object[])fieldsToValidate), validatorFunc, ClassTag$.MODULE$.apply(String.class));
        if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])unsupportedDataTypeReason))) {
            return new Some((Object)("Found unsupported data type in " + format$1 + ": " + Predef$.MODULE$.wrapRefArray((Object[])unsupportedDataTypeReason).mkString(", ") + "."));
        }
        return None$.MODULE$;
    }

    public static final boolean org$apache$gluten$backendsapi$velox$VeloxBackendSettings$$isCharType$1(StringType stringType, Metadata metadata) {
        Regex charTypePattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("char\\((\\d+)\\)"));
        return GlutenConfig$.MODULE$.get().forceOrcCharTypeScanFallbackEnabled() && charTypePattern.findFirstIn((CharSequence)CharVarcharUtils$.MODULE$.getRawTypeString(metadata).getOrElse((Function0 & Serializable)() -> stringType.catalogString())).isDefined();
    }

    public static final /* synthetic */ Option $anonfun$validateScanExec$2(PartialFunction schemaTypeValidator$1, StructType dataSchema$1, LocalFilesNode.ReadFileFormat format$1) {
        return VeloxBackendSettings$.validateTypes$1(schemaTypeValidator$1, dataSchema$1.fields(), format$1);
    }

    private static final Option validateFormat$1(LocalFilesNode.ReadFileFormat format, Map properties$1, StructField[] fields$1, StructType dataSchema$1) {
        LocalFilesNode.ReadFileFormat readFileFormat = format;
        if (((Object)((Object)LocalFilesNode.ReadFileFormat.ParquetReadFormat)).equals((Object)readFileFormat)) {
            ParquetOptions parquetOptions = new ParquetOptions(CaseInsensitiveMap$.MODULE$.apply(properties$1), SQLConf$.MODULE$.get());
            if (parquetOptions.mergeSchema()) {
                return new Some((Object)"not support when merge schema is true");
            }
            return None$.MODULE$;
        }
        if (((Object)((Object)LocalFilesNode.ReadFileFormat.DwrfReadFormat)).equals((Object)readFileFormat)) {
            return None$.MODULE$;
        }
        if (((Object)((Object)LocalFilesNode.ReadFileFormat.OrcReadFormat)).equals((Object)readFileFormat)) {
            if (!VeloxConfig$.MODULE$.get().veloxOrcScanEnabled()) {
                return new Some((Object)("Velox ORC scan is turned off, " + VeloxConfig$.MODULE$.VELOX_ORC_SCAN_ENABLED().key()));
            }
            Serializable fieldTypeValidator = new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends StructField, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    DataType dataType;
                    MapType mapType;
                    DataType mapType2;
                    MapType mapType3;
                    DataType mapType4;
                    ArrayType arrayType;
                    DataType arrayType2;
                    ArrayType arrayType3;
                    DataType arrayType4;
                    A1 A1 = x1;
                    if (A1 != null && (arrayType4 = A1.dataType()) instanceof ArrayType && (arrayType3 = (ArrayType)arrayType4).elementType() instanceof StructType) {
                        return (B1)"StructType as element in ArrayType";
                    }
                    if (A1 != null && (arrayType2 = A1.dataType()) instanceof ArrayType && (arrayType = (ArrayType)arrayType2).elementType() instanceof ArrayType) {
                        return (B1)"ArrayType as element in ArrayType";
                    }
                    if (A1 != null && (mapType4 = A1.dataType()) instanceof MapType && (mapType3 = (MapType)mapType4).keyType() instanceof StructType) {
                        return (B1)"StructType as Key in MapType";
                    }
                    if (A1 != null && (mapType2 = A1.dataType()) instanceof MapType && (mapType = (MapType)mapType2).valueType() instanceof ArrayType) {
                        return (B1)"ArrayType as Value in MapType";
                    }
                    if (A1 != null && TimestampType$.MODULE$.equals(dataType = A1.dataType())) {
                        return (B1)"TimestampType";
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(StructField x1) {
                    DataType dataType;
                    MapType mapType;
                    DataType mapType2;
                    MapType mapType3;
                    DataType mapType4;
                    ArrayType arrayType;
                    DataType arrayType2;
                    ArrayType arrayType3;
                    DataType arrayType4;
                    StructField structField = x1;
                    if (structField != null && (arrayType4 = structField.dataType()) instanceof ArrayType && (arrayType3 = (ArrayType)arrayType4).elementType() instanceof StructType) {
                        return true;
                    }
                    if (structField != null && (arrayType2 = structField.dataType()) instanceof ArrayType && (arrayType = (ArrayType)arrayType2).elementType() instanceof ArrayType) {
                        return true;
                    }
                    if (structField != null && (mapType4 = structField.dataType()) instanceof MapType && (mapType3 = (MapType)mapType4).keyType() instanceof StructType) {
                        return true;
                    }
                    if (structField != null && (mapType2 = structField.dataType()) instanceof MapType && (mapType = (MapType)mapType2).valueType() instanceof ArrayType) {
                        return true;
                    }
                    return structField != null && TimestampType$.MODULE$.equals(dataType = structField.dataType());
                }
            };
            Serializable schemaTypeValidator = new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends StructField, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    if (A1 != null) {
                        StringType stringType;
                        DataType stringType2 = A1.dataType();
                        Metadata metadata = A1.metadata();
                        if (stringType2 instanceof StringType && VeloxBackendSettings$.org$apache$gluten$backendsapi$velox$VeloxBackendSettings$$isCharType$1(stringType = (StringType)stringType2, metadata)) {
                            return (B1)Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)CharVarcharUtils$.MODULE$.getRawTypeString(metadata)), "(force fallback)");
                        }
                    }
                    return (B1)function1.apply(x2);
                }

                public final boolean isDefinedAt(StructField x2) {
                    StructField structField = x2;
                    if (structField != null) {
                        StringType stringType;
                        DataType stringType2 = structField.dataType();
                        Metadata metadata = structField.metadata();
                        if (stringType2 instanceof StringType && VeloxBackendSettings$.org$apache$gluten$backendsapi$velox$VeloxBackendSettings$$isCharType$1(stringType = (StringType)stringType2, metadata)) {
                            return true;
                        }
                    }
                    return false;
                }
            };
            return VeloxBackendSettings$.validateTypes$1((PartialFunction)fieldTypeValidator, fields$1, format).orElse(() -> VeloxBackendSettings$.$anonfun$validateScanExec$2((PartialFunction)schemaTypeValidator, dataSchema$1, format));
        }
        return new Some((Object)("Unsupported file format " + format + "."));
    }

    private static final Option validateFormats$1(Set partitionFileFormats$1, LocalFilesNode.ReadFileFormat format$2, Map properties$1, StructField[] fields$1, StructType dataSchema$1) {
        Set distinctFileFormats = (Set)partitionFileFormats$1.$plus((Object)format$2);
        return (Option)distinctFileFormats.iterator().foldLeft((Object)Option$.MODULE$.empty(), (Function2 & Serializable)(acc, format) -> {
            if (acc.isDefined()) {
                return acc;
            }
            return VeloxBackendSettings$.validateFormat$1(format, properties$1, fields$1, dataSchema$1);
        });
    }

    private static final Option validateMetadata$1(LocalFilesNode.ReadFileFormat format$2, Seq rootPaths$1, StructType dataSchema$1, Map properties$1, Configuration hadoopConf$1) {
        block3: {
            block2: {
                LocalFilesNode.ReadFileFormat readFileFormat = format$2;
                LocalFilesNode.ReadFileFormat readFileFormat2 = LocalFilesNode.ReadFileFormat.ParquetReadFormat;
                if (readFileFormat != null ? !((Object)((Object)readFileFormat)).equals((Object)readFileFormat2) : readFileFormat2 != null) break block2;
                if (!rootPaths$1.isEmpty() && !dataSchema$1.isEmpty()) break block3;
            }
            return None$.MODULE$;
        }
        int fileLimit = GlutenConfig$.MODULE$.get().parquetMetadataFallbackFileLimit();
        ParquetOptions parquetOptions = new ParquetOptions(CaseInsensitiveMap$.MODULE$.apply(properties$1), SQLConf$.MODULE$.get());
        Option<String> parquetMetadataValidationResult = ParquetMetadataUtils$.MODULE$.validateMetadata((Seq<String>)rootPaths$1, hadoopConf$1, parquetOptions, fileLimit);
        return parquetMetadataValidationResult.map((Function1 & Serializable)reason -> "Detected unsupported metadata in parquet files: " + reason);
    }

    private static final Option validateDataSchema$1(StructType dataSchema$1) {
        if (VeloxConfig$.MODULE$.get().parquetUseColumnNames() && VeloxConfig$.MODULE$.get().orcUseColumnNames()) {
            return None$.MODULE$;
        }
        String[] validationResults = (String[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])dataSchema$1.fields()), (Function1 & Serializable)field -> VeloxValidatorApi$.MODULE$.validateSchema(field.dataType()), ClassTag$.MODULE$.apply(String.class));
        if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])validationResults))) {
            return new Some((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Found unsupported data type(s) in file\n                |schema: " + Predef$.MODULE$.wrapRefArray((Object[])validationResults).mkString(", ") + ".")));
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$validateScanExec$6(Object nonLocalReturnKey1$1, Option check) {
        if (check.isDefined()) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)ValidationResult$.MODULE$.failed((String)check.get(), ValidationResult$.MODULE$.failed$default$2()));
        }
    }

    public static final /* synthetic */ boolean $anonfun$distinctRootPaths$3(Tuple2 x$2) {
        Object object = x$2._1();
        String string = "file";
        return object == null ? string != null : !object.equals(string);
    }

    private static final Option validateHiveFileFormat$1(HiveFileFormat hiveFileFormat, FileFormat format$3) {
        Object outputFileFormatClassName;
        Field fileSinkConfField = format$3.getClass().getDeclaredField("fileSinkConf");
        fileSinkConfField.setAccessible(true);
        Object fileSinkConf = fileSinkConfField.get(hiveFileFormat);
        Field tableInfoField = fileSinkConf.getClass().getDeclaredField("tableInfo");
        tableInfoField.setAccessible(true);
        Object tableInfo = tableInfoField.get(fileSinkConf);
        Method getOutputFileFormatClassNameMethod = tableInfo.getClass().getDeclaredMethod("getOutputFileFormatClassName", new Class[0]);
        Object object = outputFileFormatClassName = getOutputFileFormatClassNameMethod.invoke(tableInfo, new Object[0]);
        if ("org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat".equals(object)) {
            return None$.MODULE$;
        }
        return new Some((Object)"HiveFileFormat is supported only with Parquet as the output file type");
    }

    private static final Option validateCompressionCodec$1(Map options$1) {
        String compressionCodec;
        Set unSupportedCompressions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"brotli", "lzo", "lz4raw", "lz4_raw"}));
        if (unSupportedCompressions.contains((Object)(compressionCodec = WriteFilesExecTransformer$.MODULE$.getCompressionCodec((Map<String, String>)options$1)))) {
            return new Some((Object)(compressionCodec + " compression codec is unsupported in Velox backend."));
        }
        return None$.MODULE$;
    }

    private static final Option validateDataTypes$1(FileFormat format$3, StructField[] fields$2) {
        String[] unsupportedTypes;
        FileFormat fileFormat = format$3;
        String[] stringArray = unsupportedTypes = fileFormat instanceof ParquetFileFormat ? (String[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])fields$2), (Function1 & Serializable)x0$1 -> {
            StructField structField = x0$1;
            if (structField != null && structField.dataType() instanceof YearMonthIntervalType) {
                return new Some((Object)"YearMonthIntervalType");
            }
            if (structField != null && structField.dataType() instanceof StructType) {
                return new Some((Object)"StructType");
            }
            return None$.MODULE$;
        }, ClassTag$.MODULE$.apply(String.class)) : (String[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])fields$2), (Function1 & Serializable)field -> {
            DataType dataType = field.dataType();
            if (dataType instanceof StructType) {
                return new Some((Object)"StructType");
            }
            if (dataType instanceof ArrayType) {
                return new Some((Object)"ArrayType");
            }
            if (dataType instanceof MapType) {
                return new Some((Object)"MapType");
            }
            if (dataType instanceof YearMonthIntervalType) {
                return new Some((Object)"YearMonthIntervalType");
            }
            return None$.MODULE$;
        }, ClassTag$.MODULE$.apply(String.class));
        if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])unsupportedTypes))) {
            return new Some((Object)Predef$.MODULE$.wrapRefArray((Object[])unsupportedTypes).mkString("Found unsupported type:", ",", ""));
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$supportWriteFilesExec$3(StructField x$4) {
        Metadata metadata = x$4.metadata();
        Metadata metadata2 = Metadata$.MODULE$.empty();
        return metadata == null ? metadata2 != null : !metadata.equals(metadata2);
    }

    private static final Option validateFieldMetadata$1(StructField[] fields$2) {
        return ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])fields$2), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)VeloxBackendSettings$.$anonfun$supportWriteFilesExec$3(x$4))).map((Function1 & Serializable)filed -> "StructField contain the metadata information: " + filed + ", metadata: " + filed.metadata());
    }

    private static final Option validateFileFormat$1(FileFormat format$3) {
        FileFormat fileFormat = format$3;
        if (fileFormat instanceof ParquetFileFormat) {
            return None$.MODULE$;
        }
        if (fileFormat instanceof HiveFileFormat) {
            HiveFileFormat hiveFileFormat = (HiveFileFormat)fileFormat;
            if (GlutenConfig$.MODULE$.get().enableHiveFileFormatWriter()) {
                return VeloxBackendSettings$.validateHiveFileFormat$1(hiveFileFormat, format$3);
            }
        }
        return new Some((Object)"Only ParquetFileFormat and HiveFileFormat are supported.");
    }

    private static final Option validateWriteFilesOptions$1(Map options$1) {
        long maxRecordsPerFile = BoxesRunTime.unboxToLong((Object)options$1.get((Object)"maxRecordsPerFile").map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$5)))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> SQLConf$.MODULE$.get().maxRecordsPerFile()));
        if (maxRecordsPerFile > 0L) {
            return new Some((Object)"Unsupported native write: maxRecordsPerFile not supported.");
        }
        return None$.MODULE$;
    }

    private static final Option validateBucketSpec$1(Option bucketSpec$1, Map options$1) {
        boolean isHiveCompatibleBucketTable;
        boolean bl = isHiveCompatibleBucketTable = bucketSpec$1.nonEmpty() && ((String)options$1.getOrElse((Object)"__hive_compatible_bucketed_table_insertion__", (Function0 & Serializable)() -> "false")).equals("true");
        if (bucketSpec$1.isEmpty() || isHiveCompatibleBucketTable) {
            return None$.MODULE$;
        }
        return new Some((Object)"Unsupported native write: non-compatible hive bucket write is not supported.");
    }

    private static final boolean isNotSupported$1(DataType dataType) {
        DataType dataType2 = dataType;
        return dataType2 instanceof StructType ? true : (dataType2 instanceof ArrayType ? true : dataType2 instanceof MapType);
    }

    public static final /* synthetic */ void $anonfun$supportWindowExec$3(SortOrder order) {
        SortDirection sortDirection = order.direction();
        if (Descending$.MODULE$.equals(sortDirection)) {
            throw new GlutenNotSupportException("DESC order is not supported when literal bound type is used!");
        }
    }

    public static final /* synthetic */ void $anonfun$supportWindowExec$4(SortOrder order) {
        DataType dataType = order.dataType();
        if (ByteType$.MODULE$.equals(dataType) ? true : (ShortType$.MODULE$.equals(dataType) ? true : (IntegerType$.MODULE$.equals(dataType) ? true : (LongType$.MODULE$.equals(dataType) ? true : DateType$.MODULE$.equals(dataType))))) {
            return;
        }
        throw new GlutenNotSupportException("Only integral type & date type are supported for sort key when literal bound type is used!");
    }

    private static final void doCheck$1(Expression bound, Seq orderSpec$1) {
        Expression expression = bound;
        if (expression instanceof SpecialFrameBoundary) {
            return;
        }
        if (expression.foldable()) {
            orderSpec$1.foreach((Function1 & Serializable)order -> {
                VeloxBackendSettings$.$anonfun$supportWindowExec$3(order);
                return BoxedUnit.UNIT;
            });
            orderSpec$1.foreach((Function1 & Serializable)order -> {
                VeloxBackendSettings$.$anonfun$supportWindowExec$4(order);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private static final void checkLimitations$1(SpecifiedWindowFrame swf, Seq orderSpec) {
        VeloxBackendSettings$.doCheck$1(swf.upper(), orderSpec);
        VeloxBackendSettings$.doCheck$1(swf.lower(), orderSpec);
    }

    public static final /* synthetic */ void $anonfun$supportWindowExec$2(BooleanRef allSupported$1, NamedExpression func) {
        AggregateExpression aggregateExpression;
        Lead lead;
        Lag lag;
        NthValue nthValue;
        WindowExpression we;
        NamedExpression namedExpression = func;
        if (namedExpression instanceof Alias) {
            Alias alias = (Alias)namedExpression;
            we = WindowFunctionsBuilder$.MODULE$.extractWindowExpression(alias.child());
            if (we == null) {
                throw new GlutenNotSupportException(func + " is not supported.");
            }
        } else {
            throw new GlutenNotSupportException(func + " is not supported.");
        }
        WindowExpression windowExpression = we;
        WindowFrame windowFrame = windowExpression.windowSpec().frameSpecification();
        if (windowFrame instanceof SpecifiedWindowFrame) {
            SpecifiedWindowFrame specifiedWindowFrame = (SpecifiedWindowFrame)windowFrame;
            FrameType frameType = specifiedWindowFrame.frameType();
            if (RangeFrame$.MODULE$.equals(frameType)) {
                VeloxBackendSettings$.checkLimitations$1(specifiedWindowFrame, windowExpression.windowSpec().orderSpec());
            }
        }
        Expression expression = windowExpression.windowFunction();
        if (expression instanceof RowNumber ? true : (expression instanceof Rank ? true : (expression instanceof CumeDist ? true : (expression instanceof DenseRank ? true : (expression instanceof PercentRank ? true : expression instanceof NTile))))) {
            return;
        }
        if (expression instanceof NthValue && !(nthValue = (NthValue)expression).input().foldable()) {
            return;
        }
        if (expression instanceof Lag && !(lag = (Lag)expression).input().foldable()) {
            return;
        }
        if (expression instanceof Lead && !(lead = (Lead)expression).input().foldable()) {
            return;
        }
        if (expression instanceof AggregateExpression && !((aggregateExpression = (AggregateExpression)expression).aggregateFunction() instanceof ApproximatePercentile) && !(aggregateExpression.aggregateFunction() instanceof Percentile) && !(aggregateExpression.aggregateFunction() instanceof HyperLogLogPlusPlus)) {
            return;
        }
        allSupported$1.elem = false;
    }

    public static final /* synthetic */ boolean $anonfun$supportHashBuildJoinTypeOnLeft$1(JoinType t2) {
        if (BoxesRunTime.unboxToBoolean((Object)MODULE$.super$supportHashBuildJoinTypeOnLeft().apply((Object)t2))) {
            return true;
        }
        JoinType joinType = t2;
        return LeftOuter$.MODULE$.equals(joinType);
    }

    public static final /* synthetic */ boolean $anonfun$supportHashBuildJoinTypeOnRight$1(JoinType t2) {
        if (BoxesRunTime.unboxToBoolean((Object)MODULE$.super$supportHashBuildJoinTypeOnRight().apply((Object)t2))) {
            return true;
        }
        JoinType joinType = t2;
        return RightOuter$.MODULE$.equals(joinType);
    }

    private VeloxBackendSettings$() {
    }
}

