/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten;

import java.io.Serializable;
import java.util.Map;
import org.apache.gluten.component.Component;
import org.apache.gluten.config.GlutenCoreConfig$;
import org.apache.gluten.exception.GlutenException;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.sql.internal.SparkConfigUtil$;
import org.apache.spark.util.SparkResourceUtil$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class GlutenDriverPlugin$
implements Logging {
    public static final GlutenDriverPlugin$ MODULE$ = new GlutenDriverPlugin$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private void checkOffHeapSettings(SparkConf conf) {
        if (BoxesRunTime.unboxToBoolean((Object)SparkConfigUtil$.MODULE$.RichSparkConf(conf).get(GlutenCoreConfig$.MODULE$.DYNAMIC_OFFHEAP_SIZING_ENABLED()))) {
            return;
        }
        if (BoxesRunTime.unboxToBoolean((Object)SparkConfigUtil$.MODULE$.RichSparkConf(conf).get(GlutenCoreConfig$.MODULE$.COLUMNAR_MEMORY_UNTRACKED()))) {
            return;
        }
        String minOffHeapSize = "1MB";
        if (!conf.getBoolean(GlutenCoreConfig$.MODULE$.SPARK_OFFHEAP_ENABLED_KEY(), false) || conf.getSizeAsBytes(GlutenCoreConfig$.MODULE$.SPARK_OFFHEAP_SIZE_KEY(), 0L) < JavaUtils.byteStringAsBytes((String)minOffHeapSize)) {
            throw new GlutenException("Must set '" + GlutenCoreConfig$.MODULE$.SPARK_OFFHEAP_ENABLED_KEY() + "' to true and set '" + GlutenCoreConfig$.MODULE$.SPARK_OFFHEAP_SIZE_KEY() + "' to be greater than " + minOffHeapSize);
        }
    }

    public void org$apache$gluten$GlutenDriverPlugin$$setPredefinedConfigs(SparkConf conf) {
        long l;
        this.checkOffHeapSettings(conf);
        if (conf.getBoolean(GlutenCoreConfig$.MODULE$.DYNAMIC_OFFHEAP_SIZING_ENABLED().key(), false)) {
            long onHeapSize;
            long l2 = onHeapSize = conf.contains(GlutenCoreConfig$.MODULE$.SPARK_ONHEAP_SIZE_KEY()) ? conf.getSizeAsBytes(GlutenCoreConfig$.MODULE$.SPARK_ONHEAP_SIZE_KEY()) : 0x40000000L;
            if (conf.contains(GlutenCoreConfig$.MODULE$.SPARK_OFFHEAP_ENABLED_KEY())) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Dynamic off-heap sizing is enabled. Ignoring user-defined '" + GlutenCoreConfig$.MODULE$.SPARK_OFFHEAP_SIZE_KEY() + "' setting.");
            }
            if (conf.contains(GlutenCoreConfig$.MODULE$.SPARK_OFFHEAP_SIZE_KEY())) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Dynamic off-heap sizing is enabled. Ignoring user-defined '" + GlutenCoreConfig$.MODULE$.SPARK_OFFHEAP_SIZE_KEY() + "' setting.");
            }
            conf.set(GlutenCoreConfig$.MODULE$.SPARK_OFFHEAP_SIZE_KEY(), "0");
            conf.set(GlutenCoreConfig$.MODULE$.SPARK_OFFHEAP_ENABLED_KEY(), "false");
            l = (long)((double)(onHeapSize - 314572800L) * conf.getDouble(GlutenCoreConfig$.MODULE$.DYNAMIC_OFFHEAP_SIZING_MEMORY_FRACTION().key(), 0.6));
        } else {
            l = conf.getSizeAsBytes(GlutenCoreConfig$.MODULE$.SPARK_OFFHEAP_SIZE_KEY());
        }
        long offHeapSize = l;
        SparkConfigUtil$.MODULE$.RichSparkConf(conf).set(GlutenCoreConfig$.MODULE$.COLUMNAR_OFFHEAP_SIZE_IN_BYTES(), BoxesRunTime.boxToLong((long)offHeapSize));
        int taskSlots = SparkResourceUtil$.MODULE$.getTaskSlots(conf);
        SparkConfigUtil$.MODULE$.RichSparkConf(conf).set(GlutenCoreConfig$.MODULE$.NUM_TASK_SLOTS_PER_EXECUTOR(), BoxesRunTime.boxToInteger((int)taskSlots));
        long offHeapPerTask = offHeapSize / (long)taskSlots;
        SparkConfigUtil$.MODULE$.RichSparkConf(conf).set(GlutenCoreConfig$.MODULE$.COLUMNAR_TASK_OFFHEAP_SIZE_IN_BYTES(), BoxesRunTime.boxToLong((long)offHeapPerTask));
        double fraction = 1.0 - conf.getDouble("spark.memory.storageFraction", 0.5);
        long conservativeOffHeapPerTask = (long)((double)offHeapSize * fraction) / (long)taskSlots;
        SparkConfigUtil$.MODULE$.RichSparkConf(conf).set(GlutenCoreConfig$.MODULE$.COLUMNAR_CONSERVATIVE_TASK_OFFHEAP_SIZE_IN_BYTES(), BoxesRunTime.boxToLong((long)conservativeOffHeapPerTask));
    }

    public void org$apache$gluten$GlutenDriverPlugin$$printComponentInfo(Seq<Component> components) {
        String loggingInfo = ((IterableOnceOps)components.map((Function1 & Serializable)c -> {
            String infoStr = c.info().isEmpty() ? "" : "\n" + ((IterableOnceOps)c.info().map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    return "  " + k + " = " + v;
                }
                throw new MatchError((Object)tuple2);
            })).mkString("\n");
            return "Component " + c.name() + infoStr;
        })).mkString("Gluten components:\n==============================================================\n", "\n", "\n==============================================================");
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> loggingInfo);
    }

    private GlutenDriverPlugin$() {
    }
}

