/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.dataset.scanner;

import java.nio.ByteBuffer;
import java.util.Optional;
import org.apache.arrow.dataset.scanner.FragmentScanOptions;
import org.apache.gluten.shaded.org.apache.arrow.util.Preconditions;

public class ScanOptions {
    private final long batchSize;
    private final Optional<String[]> columns;
    private final Optional<ByteBuffer> substraitProjection;
    private final Optional<ByteBuffer> substraitFilter;
    private final Optional<FragmentScanOptions> fragmentScanOptions;

    @Deprecated
    public ScanOptions(String[] columns, long batchSize) {
        this(batchSize, Optional.of(columns).map(present -> {
            if (((String[])present).length == 0) {
                return null;
            }
            return present;
        }));
    }

    public ScanOptions(long batchSize, Optional<String[]> columns) {
        Preconditions.checkNotNull(columns);
        this.batchSize = batchSize;
        this.columns = columns;
        this.substraitProjection = Optional.empty();
        this.substraitFilter = Optional.empty();
        this.fragmentScanOptions = Optional.empty();
    }

    public ScanOptions(long batchSize) {
        this(batchSize, Optional.empty());
    }

    public Optional<String[]> getColumns() {
        return this.columns;
    }

    public long getBatchSize() {
        return this.batchSize;
    }

    public Optional<ByteBuffer> getSubstraitProjection() {
        return this.substraitProjection;
    }

    public Optional<ByteBuffer> getSubstraitFilter() {
        return this.substraitFilter;
    }

    public Optional<FragmentScanOptions> getFragmentScanOptions() {
        return this.fragmentScanOptions;
    }

    private ScanOptions(Builder builder) {
        this.batchSize = builder.batchSize;
        this.columns = builder.columns;
        this.substraitProjection = Optional.ofNullable(builder.substraitProjection);
        this.substraitFilter = Optional.ofNullable(builder.substraitFilter);
        this.fragmentScanOptions = Optional.ofNullable(builder.fragmentScanOptions);
    }

    public static class Builder {
        private final long batchSize;
        private Optional<String[]> columns;
        private ByteBuffer substraitProjection;
        private ByteBuffer substraitFilter;
        private FragmentScanOptions fragmentScanOptions;

        public Builder(long batchSize) {
            this.batchSize = batchSize;
        }

        public Builder columns(Optional<String[]> columns) {
            Preconditions.checkNotNull(columns);
            this.columns = columns;
            return this;
        }

        public Builder substraitProjection(ByteBuffer substraitProjection) {
            Preconditions.checkNotNull(substraitProjection);
            this.substraitProjection = substraitProjection;
            return this;
        }

        public Builder substraitFilter(ByteBuffer substraitFilter) {
            Preconditions.checkNotNull(substraitFilter);
            this.substraitFilter = substraitFilter;
            return this;
        }

        public Builder fragmentScanOptions(FragmentScanOptions fragmentScanOptions) {
            Preconditions.checkNotNull(fragmentScanOptions);
            this.fragmentScanOptions = fragmentScanOptions;
            return this;
        }

        public ScanOptions build() {
            return new ScanOptions(this);
        }
    }
}

