/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.dataset.jni;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.arrow.dataset.jni.ReservationListener;
import org.apache.gluten.shaded.org.apache.arrow.util.VisibleForTesting;

public class DirectReservationListener
implements ReservationListener {
    private final Method methodReserve;
    private final Method methodUnreserve;
    private static final DirectReservationListener INSTANCE = new DirectReservationListener();

    private DirectReservationListener() {
        try {
            Class<?> classBits = Class.forName("java.nio.Bits");
            this.methodReserve = this.getDeclaredMethodBaseOnJDKVersion(classBits, "reserveMemory");
            this.methodReserve.setAccessible(true);
            this.methodUnreserve = this.getDeclaredMethodBaseOnJDKVersion(classBits, "unreserveMemory");
            this.methodUnreserve.setAccessible(true);
        }
        catch (Exception e) {
            RuntimeException failure = new RuntimeException("Failed to initialize DirectReservationListener. When starting Java you must include `--add-opens=java.base/java.nio=org.apache.arrow.dataset,org.apache.arrow.memory.core,ALL-UNNAMED` (See https://arrow.apache.org/docs/java/install.html)", e);
            failure.printStackTrace();
            throw failure;
        }
    }

    public static DirectReservationListener instance() {
        return INSTANCE;
    }

    @Override
    public void reserve(long size) {
        try {
            if (size > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("reserve size should not be larger than Integer.MAX_VALUE (0x7fffffff)");
            }
            this.methodReserve.invoke(null, (int)size, (int)size);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void unreserve(long size) {
        try {
            if (size > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("unreserve size should not be larger than Integer.MAX_VALUE (0x7fffffff)");
            }
            this.methodUnreserve.invoke(null, (int)size, (int)size);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    public long getCurrentDirectMemReservation() {
        try {
            Field f;
            Class<?> classBits = Class.forName("java.nio.Bits");
            try {
                f = classBits.getDeclaredField("reservedMemory");
            }
            catch (NoSuchFieldException e) {
                try {
                    f = classBits.getDeclaredField("RESERVED_MEMORY");
                }
                catch (NoSuchFieldException ex) {
                    throw new AssertionError((Object)ex);
                }
            }
            f.setAccessible(true);
            return ((AtomicLong)f.get(null)).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Method getDeclaredMethodBaseOnJDKVersion(Class<?> classBits, String name) {
        try {
            return classBits.getDeclaredMethod(name, Long.TYPE, Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            try {
                return classBits.getDeclaredMethod(name, Long.TYPE, Long.TYPE);
            }
            catch (NoSuchMethodException ex) {
                throw new AssertionError((Object)ex);
            }
        }
    }
}

