/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.c;

import java.util.ArrayList;
import java.util.List;
import org.apache.gluten.shaded.org.apache.arrow.memory.ArrowBuf;
import org.apache.gluten.shaded.org.apache.arrow.vector.BaseVariableWidthViewVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.FieldVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.TypeLayout;
import org.apache.gluten.shaded.org.apache.arrow.vector.complex.StructVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.compression.CompressionCodec;
import org.apache.gluten.shaded.org.apache.arrow.vector.compression.CompressionUtil;
import org.apache.gluten.shaded.org.apache.arrow.vector.compression.NoCompressionCodec;
import org.apache.gluten.shaded.org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import org.apache.gluten.shaded.org.apache.arrow.vector.ipc.message.ArrowRecordBatch;

public class StructVectorUnloader {
    private final StructVector root;
    private final boolean includeNullCount;
    private final CompressionCodec codec;
    private final boolean alignBuffers;

    public StructVectorUnloader(StructVector root) {
        this(root, true, NoCompressionCodec.INSTANCE, true);
    }

    public StructVectorUnloader(StructVector root, boolean includeNullCount, boolean alignBuffers) {
        this(root, includeNullCount, NoCompressionCodec.INSTANCE, alignBuffers);
    }

    public StructVectorUnloader(StructVector root, boolean includeNullCount, CompressionCodec codec, boolean alignBuffers) {
        this.root = root;
        this.includeNullCount = includeNullCount;
        this.codec = codec;
        this.alignBuffers = alignBuffers;
    }

    public ArrowRecordBatch getRecordBatch() {
        ArrayList<ArrowFieldNode> nodes = new ArrayList<ArrowFieldNode>();
        ArrayList<ArrowBuf> buffers = new ArrayList<ArrowBuf>();
        ArrayList<Long> variadicBufferCounts = new ArrayList<Long>();
        for (FieldVector vector : this.root.getChildrenFromFields()) {
            this.appendNodes(vector, nodes, buffers, variadicBufferCounts);
        }
        return new ArrowRecordBatch(this.root.getValueCount(), nodes, buffers, CompressionUtil.createBodyCompression(this.codec), variadicBufferCounts, this.alignBuffers);
    }

    private long getVariadicBufferCount(FieldVector vector) {
        if (vector instanceof BaseVariableWidthViewVector) {
            return ((BaseVariableWidthViewVector)vector).getDataBuffers().size();
        }
        return 0L;
    }

    private void appendNodes(FieldVector vector, List<ArrowFieldNode> nodes, List<ArrowBuf> buffers, List<Long> variadicBufferCounts) {
        nodes.add(new ArrowFieldNode(vector.getValueCount(), this.includeNullCount ? (long)vector.getNullCount() : -1L));
        List<ArrowBuf> fieldBuffers = vector.getFieldBuffers();
        long variadicBufferCount = this.getVariadicBufferCount(vector);
        int expectedBufferCount = (int)((long)TypeLayout.getTypeBufferCount(vector.getField().getType()) + variadicBufferCount);
        if (vector instanceof BaseVariableWidthViewVector) {
            variadicBufferCounts.add(variadicBufferCount);
        }
        if (fieldBuffers.size() != expectedBufferCount) {
            throw new IllegalArgumentException(String.format("wrong number of buffers for field %s in vector %s. found: %s", vector.getField(), vector.getClass().getSimpleName(), fieldBuffers));
        }
        for (ArrowBuf buf : fieldBuffers) {
            buffers.add(this.codec.compress(vector.getAllocator(), buf));
        }
        for (FieldVector child : vector.getChildrenFromFields()) {
            this.appendNodes(child, nodes, buffers, variadicBufferCounts);
        }
    }
}

