/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.c;

import java.util.ArrayList;
import java.util.List;
import org.apache.arrow.c.ArrowSchema;
import org.apache.arrow.c.Flags;
import org.apache.arrow.c.Format;
import org.apache.arrow.c.Metadata;
import org.apache.arrow.c.NativeUtil;
import org.apache.arrow.c.jni.JniWrapper;
import org.apache.arrow.c.jni.PrivateData;
import org.apache.gluten.shaded.org.apache.arrow.memory.ArrowBuf;
import org.apache.gluten.shaded.org.apache.arrow.memory.BufferAllocator;
import org.apache.gluten.shaded.org.apache.arrow.util.Preconditions;
import org.apache.gluten.shaded.org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.gluten.shaded.org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.gluten.shaded.org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import org.apache.gluten.shaded.org.apache.arrow.vector.types.pojo.Field;

final class SchemaExporter {
    private final BufferAllocator allocator;

    public SchemaExporter(BufferAllocator allocator) {
        this.allocator = allocator;
    }

    void export(ArrowSchema schema, Field field, DictionaryProvider dictionaryProvider) {
        String name = field.getName();
        String format = Format.asString(field.getType());
        long flags = Flags.forField(field);
        List<Field> children = field.getChildren();
        DictionaryEncoding dictionaryEncoding = field.getDictionary();
        ExportedSchemaPrivateData data = new ExportedSchemaPrivateData();
        try {
            data.format = NativeUtil.toNativeString(this.allocator, format);
            data.name = NativeUtil.toNativeString(this.allocator, name);
            data.metadata = Metadata.encode(this.allocator, field.getMetadata());
            if (children != null) {
                data.children = new ArrayList<ArrowSchema>(children.size());
                data.children_ptrs = this.allocator.buffer((long)children.size() * 8L);
                for (int i = 0; i < children.size(); ++i) {
                    ArrowSchema child = ArrowSchema.allocateNew(this.allocator);
                    data.children.add(child);
                    data.children_ptrs.writeLong(child.memoryAddress());
                }
            }
            if (dictionaryEncoding != null) {
                Dictionary dictionary = dictionaryProvider.lookup(dictionaryEncoding.getId());
                Preconditions.checkNotNull(dictionary, "Dictionary lookup failed on export of field with dictionary");
                data.dictionary = ArrowSchema.allocateNew(this.allocator);
                this.export(data.dictionary, dictionary.getVector().getField(), dictionaryProvider);
            }
            ArrowSchema.Snapshot snapshot = new ArrowSchema.Snapshot();
            snapshot.format = data.format.memoryAddress();
            snapshot.name = NativeUtil.addressOrNull(data.name);
            snapshot.metadata = NativeUtil.addressOrNull(data.metadata);
            snapshot.flags = flags;
            snapshot.n_children = data.children != null ? (long)data.children.size() : 0L;
            snapshot.children = NativeUtil.addressOrNull(data.children_ptrs);
            snapshot.dictionary = NativeUtil.addressOrNull(data.dictionary);
            snapshot.release = 0L;
            schema.save(snapshot);
            JniWrapper.get().exportSchema(schema.memoryAddress(), data);
        }
        catch (Exception e) {
            data.close();
            throw e;
        }
        if (children != null) {
            for (int i = 0; i < children.size(); ++i) {
                Field childField = children.get(i);
                ArrowSchema child = data.children.get(i);
                this.export(child, childField, dictionaryProvider);
            }
        }
    }

    static class ExportedSchemaPrivateData
    implements PrivateData {
        ArrowBuf format;
        ArrowBuf name;
        ArrowBuf metadata;
        ArrowBuf children_ptrs;
        ArrowSchema dictionary;
        List<ArrowSchema> children;

        ExportedSchemaPrivateData() {
        }

        @Override
        public void close() {
            NativeUtil.closeBuffer(this.format);
            NativeUtil.closeBuffer(this.name);
            NativeUtil.closeBuffer(this.metadata);
            NativeUtil.closeBuffer(this.children_ptrs);
            if (this.dictionary != null) {
                this.dictionary.close();
            }
            if (this.children != null) {
                for (ArrowSchema child : this.children) {
                    child.close();
                }
            }
        }
    }
}

