/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.c;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.arrow.c.ArrowArray;
import org.apache.gluten.shaded.org.apache.arrow.memory.ArrowBuf;
import org.apache.gluten.shaded.org.apache.arrow.memory.BufferAllocator;
import org.apache.gluten.shaded.org.apache.arrow.memory.ForeignAllocation;

final class ReferenceCountedArrowArray {
    private final ArrowArray array;
    private final AtomicInteger refCnt;

    ReferenceCountedArrowArray(ArrowArray array) {
        this.array = array;
        this.refCnt = new AtomicInteger(1);
    }

    void retain() {
        if (this.refCnt.addAndGet(1) - 1 <= 0) {
            throw new IllegalStateException("Tried to retain a released ArrowArray");
        }
    }

    void release() {
        int refcnt = this.refCnt.addAndGet(-1);
        if (refcnt == 0) {
            this.array.release();
            this.array.close();
        } else if (refcnt < 0) {
            throw new IllegalStateException("Reference count went negative for imported ArrowArray");
        }
    }

    ArrowBuf unsafeAssociateAllocation(BufferAllocator trackingAllocator, long capacity, long memoryAddress) {
        this.retain();
        return trackingAllocator.wrapForeignAllocation(new ForeignAllocation(capacity, memoryAddress){

            @Override
            protected void release0() {
                ReferenceCountedArrowArray.this.release();
            }
        });
    }
}

