/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.c;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.apache.arrow.c.BaseStruct;
import org.apache.gluten.shaded.org.apache.arrow.memory.ArrowBuf;
import org.apache.gluten.shaded.org.apache.arrow.memory.BufferAllocator;
import org.apache.gluten.shaded.org.apache.arrow.memory.util.MemoryUtil;

public final class NativeUtil {
    public static final byte NULL = 0;
    static final int MAX_STRING_LENGTH = Short.MAX_VALUE;

    private NativeUtil() {
    }

    public static String toJavaString(long cstringPtr) {
        if (cstringPtr == 0L) {
            return null;
        }
        ByteBuffer reader = MemoryUtil.directBuffer(cstringPtr, Short.MAX_VALUE).order(ByteOrder.nativeOrder());
        int length = 0;
        while (reader.get() != 0) {
            ++length;
        }
        byte[] bytes = new byte[length];
        ((ByteBuffer)((Buffer)reader).rewind()).get(bytes);
        return new String(bytes, 0, length, StandardCharsets.UTF_8);
    }

    public static long[] toJavaArray(long arrayPtr, int size) {
        if (arrayPtr == 0L) {
            return null;
        }
        if (size < 0) {
            throw new IllegalArgumentException("Invalid native array size");
        }
        long[] result = new long[size];
        ByteBuffer reader = MemoryUtil.directBuffer(arrayPtr, 8 * size).order(ByteOrder.nativeOrder());
        for (int i = 0; i < size; ++i) {
            result[i] = reader.getLong();
        }
        return result;
    }

    public static ArrowBuf toNativeString(BufferAllocator allocator, String string) {
        if (string == null) {
            return null;
        }
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        ArrowBuf buffer = allocator.buffer(bytes.length + 1);
        buffer.writeBytes(bytes);
        buffer.writeByte((byte)0);
        return buffer;
    }

    public static void closeBuffer(ArrowBuf buf) {
        if (buf != null) {
            buf.close();
        }
    }

    public static long addressOrNull(ArrowBuf buf) {
        if (buf == null) {
            return 0L;
        }
        return buf.memoryAddress();
    }

    public static long addressOrNull(BaseStruct struct) {
        if (struct == null) {
            return 0L;
        }
        return struct.memoryAddress();
    }
}

