/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.c;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import org.apache.arrow.c.ArrowArray;
import org.apache.arrow.c.ArrowArrayStream;
import org.apache.arrow.c.ArrowSchema;
import org.apache.arrow.c.Data;
import org.apache.arrow.c.jni.JniWrapper;
import org.apache.arrow.c.jni.PrivateData;
import org.apache.gluten.shaded.org.apache.arrow.memory.BufferAllocator;
import org.apache.gluten.shaded.org.apache.arrow.vector.ipc.ArrowReader;
import org.apache.gluten.shaded.org.apache.arrow.vector.types.pojo.Schema;

final class ArrayStreamExporter {
    private final BufferAllocator allocator;

    ArrayStreamExporter(BufferAllocator allocator) {
        this.allocator = allocator;
    }

    void export(ArrowArrayStream stream, ArrowReader reader) {
        ExportedArrayStreamPrivateData data = new ExportedArrayStreamPrivateData(this.allocator, reader);
        try {
            JniWrapper.get().exportArrayStream(stream.memoryAddress(), data);
        }
        catch (Exception e) {
            data.close();
            throw e;
        }
    }

    static class ExportedArrayStreamPrivateData
    implements PrivateData {
        final BufferAllocator allocator;
        final ArrowReader reader;
        byte[] lastError;

        ExportedArrayStreamPrivateData(BufferAllocator allocator, ArrowReader reader) {
            this.allocator = allocator;
            this.reader = reader;
        }

        private int setLastError(Throwable err) {
            try {
                StringWriter buf = new StringWriter();
                PrintWriter writer = new PrintWriter(buf);
                err.printStackTrace(writer);
                this.lastError = buf.toString().getBytes(StandardCharsets.UTF_8);
            }
            catch (Throwable e) {
                this.lastError = null;
            }
            return 5;
        }

        int getNext(long arrayAddress) {
            ArrowArray out = ArrowArray.wrap(arrayAddress);
            try {
                if (this.reader.loadNextBatch()) {
                    Data.exportVectorSchemaRoot(this.allocator, this.reader.getVectorSchemaRoot(), this.reader, out);
                } else {
                    out.markReleased();
                }
                int n = 0;
                if (out != null) {
                    out.close();
                }
                return n;
            }
            catch (Throwable throwable) {
                try {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    return this.setLastError(e);
                }
            }
        }

        int getSchema(long schemaAddress) {
            ArrowSchema out = ArrowSchema.wrap(schemaAddress);
            try {
                Schema schema = this.reader.getVectorSchemaRoot().getSchema();
                Data.exportSchema(this.allocator, schema, this.reader, out);
                int n = 0;
                if (out != null) {
                    out.close();
                }
                return n;
            }
            catch (Throwable throwable) {
                try {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    return this.setLastError(e);
                }
            }
        }

        @Override
        public void close() {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

