/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.c;

import java.util.Collections;
import java.util.List;
import org.apache.arrow.c.ArrowArray;
import org.apache.arrow.c.BufferImportTypeVisitor;
import org.apache.arrow.c.NativeUtil;
import org.apache.arrow.c.ReferenceCountedArrowArray;
import org.apache.gluten.shaded.org.apache.arrow.memory.ArrowBuf;
import org.apache.gluten.shaded.org.apache.arrow.memory.BufferAllocator;
import org.apache.gluten.shaded.org.apache.arrow.memory.util.LargeMemoryUtil;
import org.apache.gluten.shaded.org.apache.arrow.util.Preconditions;
import org.apache.gluten.shaded.org.apache.arrow.vector.FieldVector;
import org.apache.gluten.shaded.org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.gluten.shaded.org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.gluten.shaded.org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import org.apache.gluten.shaded.org.apache.arrow.vector.types.pojo.DictionaryEncoding;

final class ArrayImporter {
    private static final int MAX_IMPORT_RECURSION_LEVEL = 64;
    private final BufferAllocator allocator;
    private final FieldVector vector;
    private final DictionaryProvider dictionaryProvider;
    private ReferenceCountedArrowArray underlyingAllocation;
    private int recursionLevel;

    ArrayImporter(BufferAllocator allocator, FieldVector vector, DictionaryProvider dictionaryProvider) {
        this.allocator = Preconditions.checkNotNull(allocator);
        this.vector = Preconditions.checkNotNull(vector);
        this.dictionaryProvider = dictionaryProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void importArray(ArrowArray src) {
        ArrowArray.Snapshot snapshot = src.snapshot();
        Preconditions.checkState(snapshot.release != 0L, "Cannot import released ArrowArray");
        ArrowArray ownedArray = ArrowArray.allocateNew(this.allocator);
        ownedArray.save(snapshot);
        src.markReleased();
        src.close();
        this.recursionLevel = 0;
        this.underlyingAllocation = new ReferenceCountedArrowArray(ownedArray);
        try {
            this.doImport(snapshot);
        }
        finally {
            this.underlyingAllocation.release();
        }
    }

    private void importChild(ArrayImporter parent, ArrowArray src) {
        ArrowArray.Snapshot snapshot = src.snapshot();
        Preconditions.checkState(snapshot.release != 0L, "Cannot import released ArrowArray");
        this.recursionLevel = parent.recursionLevel + 1;
        Preconditions.checkState(this.recursionLevel <= 64, "Recursion level in ArrowArray struct exceeded");
        this.underlyingAllocation = parent.underlyingAllocation;
        this.doImport(snapshot);
    }

    private void doImport(ArrowArray.Snapshot snapshot) {
        long[] children = NativeUtil.toJavaArray(snapshot.children, LargeMemoryUtil.checkedCastToInt(snapshot.n_children));
        if (children != null && children.length > 0) {
            List<FieldVector> childVectors = this.vector.getChildrenFromFields();
            Preconditions.checkState(children.length == childVectors.size(), "ArrowArray struct has %s children (expected %s)", children.length, childVectors.size());
            for (int i = 0; i < children.length; ++i) {
                Preconditions.checkState(children[i] != 0L, "ArrowArray struct has NULL child at position %s", i);
                ArrayImporter childImporter = new ArrayImporter(this.allocator, childVectors.get(i), this.dictionaryProvider);
                childImporter.importChild(this, ArrowArray.wrap(children[i]));
            }
        }
        if (snapshot.dictionary != 0L) {
            DictionaryEncoding encoding = this.vector.getField().getDictionary();
            Preconditions.checkNotNull(encoding, "Missing encoding on import of ArrowArray with dictionary");
            Dictionary dictionary = this.dictionaryProvider.lookup(encoding.getId());
            Preconditions.checkNotNull(dictionary, "Dictionary lookup failed on import of ArrowArray with dictionary");
            dictionary.getVector().clear();
            ArrayImporter dictionaryImporter = new ArrayImporter(this.allocator, dictionary.getVector(), this.dictionaryProvider);
            dictionaryImporter.importChild(this, ArrowArray.wrap(snapshot.dictionary));
        }
        ArrowFieldNode fieldNode = new ArrowFieldNode(snapshot.length, snapshot.null_count);
        long[] bufferPointers = NativeUtil.toJavaArray(snapshot.buffers, LargeMemoryUtil.checkedCastToInt(snapshot.n_buffers));
        try (BufferImportTypeVisitor visitor = new BufferImportTypeVisitor(this.allocator, this.underlyingAllocation, fieldNode, bufferPointers);){
            List<ArrowBuf> buffers = bufferPointers == null || bufferPointers.length == 0 ? Collections.emptyList() : this.vector.getField().getType().accept(visitor);
            this.vector.loadFieldBuffers(fieldNode, buffers);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not load buffers for field " + String.valueOf(this.vector.getField()) + ". error message: " + e.getMessage(), e);
        }
    }
}

