/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.jimfs;

import com.google.common.jimfs.AclAttributeProvider;
import com.google.common.jimfs.AttributeProvider;
import com.google.common.jimfs.BasicAttributeProvider;
import com.google.common.jimfs.DosAttributeProvider;
import com.google.common.jimfs.OwnerAttributeProvider;
import com.google.common.jimfs.PosixAttributeProvider;
import com.google.common.jimfs.UnixAttributeProvider;
import com.google.common.jimfs.UserDefinedAttributeProvider;
import org.apache.gluten.shaded.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.nullness.qual.Nullable;

final class StandardAttributeProviders {
    private static final ImmutableMap<String, AttributeProvider> PROVIDERS = new ImmutableMap.Builder<String, BasicAttributeProvider>().put("basic", new BasicAttributeProvider()).put("owner", (BasicAttributeProvider)((Object)new OwnerAttributeProvider())).put("posix", (BasicAttributeProvider)((Object)new PosixAttributeProvider())).put("dos", (BasicAttributeProvider)((Object)new DosAttributeProvider())).put("acl", (BasicAttributeProvider)((Object)new AclAttributeProvider())).put("user", (BasicAttributeProvider)((Object)new UserDefinedAttributeProvider())).build();

    private StandardAttributeProviders() {
    }

    public static @Nullable AttributeProvider get(String view) {
        AttributeProvider provider = PROVIDERS.get(view);
        if (provider == null && view.equals("unix")) {
            return new UnixAttributeProvider();
        }
        return provider;
    }
}

