/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.jimfs;

import com.google.common.jimfs.Util;
import org.apache.gluten.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.gluten.shaded.com.google.common.base.Function;
import org.apache.gluten.shaded.com.google.common.base.Preconditions;
import org.apache.gluten.shaded.com.google.common.collect.Ordering;
import org.checkerframework.checker.nullness.qual.Nullable;

final class Name {
    static final Name EMPTY = new Name("", "");
    public static final Name SELF = new Name(".", ".");
    public static final Name PARENT = new Name("..", "..");
    private final String display;
    private final String canonical;
    private static final Ordering<Name> DISPLAY_ORDERING = Ordering.natural().onResultOf(new Function<Name, String>(){

        @Override
        public String apply(Name name) {
            return name.display;
        }
    });
    private static final Ordering<Name> CANONICAL_ORDERING = Ordering.natural().onResultOf(new Function<Name, String>(){

        @Override
        public String apply(Name name) {
            return name.canonical;
        }
    });

    @VisibleForTesting
    static Name simple(String name) {
        switch (name) {
            case ".": {
                return SELF;
            }
            case "..": {
                return PARENT;
            }
        }
        return new Name(name, name);
    }

    public static Name create(String display, String canonical) {
        return new Name(display, canonical);
    }

    private Name(String display, String canonical) {
        this.display = Preconditions.checkNotNull(display);
        this.canonical = Preconditions.checkNotNull(canonical);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof Name) {
            Name other = (Name)obj;
            return this.canonical.equals(other.canonical);
        }
        return false;
    }

    public int hashCode() {
        return Util.smearHash(this.canonical.hashCode());
    }

    public String toString() {
        return this.display;
    }

    public static Ordering<Name> displayOrdering() {
        return DISPLAY_ORDERING;
    }

    public static Ordering<Name> canonicalOrdering() {
        return CANONICAL_ORDERING;
    }
}

