/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.fluss.server.metrics.group;

import org.apache.fluss.metadata.TablePath;
import org.apache.fluss.metrics.registry.NOPMetricRegistry;
import org.apache.fluss.server.metrics.UserMetrics;
import org.apache.fluss.testutils.common.ScheduledTask;
import org.apache.fluss.utils.concurrent.Scheduler;

import java.util.concurrent.ScheduledFuture;

/** Utilities for various metric groups for testing. */
public class TestingMetricGroups {

    public static final TabletServerMetricGroup TABLET_SERVER_METRICS =
            new TabletServerMetricGroup(NOPMetricRegistry.INSTANCE, "fluss", "host", "rack", 0);

    public static final CoordinatorMetricGroup COORDINATOR_METRICS =
            new CoordinatorMetricGroup(NOPMetricRegistry.INSTANCE, "cluster1", "host", "0");

    public static final TableMetricGroup TABLE_METRICS =
            new TableMetricGroup(
                    NOPMetricRegistry.INSTANCE,
                    TablePath.of("mydb", "mytable"),
                    false,
                    TABLET_SERVER_METRICS);

    public static final BucketMetricGroup BUCKET_METRICS =
            new BucketMetricGroup(NOPMetricRegistry.INSTANCE, null, 0, TABLE_METRICS);

    public static final UserMetrics USER_METRICS =
            new UserMetrics(
                    new TestingScheduler(), NOPMetricRegistry.INSTANCE, TABLET_SERVER_METRICS);

    // ------------------------------------------------------------------------------------------

    private static class TestingScheduler implements Scheduler {
        @Override
        public void startup() {
            // no-op
        }

        @Override
        public void shutdown() throws InterruptedException {
            // no-op
        }

        @Override
        public ScheduledFuture<?> schedule(
                String name, Runnable task, long delayMs, long periodMs) {
            // Directly run the task for testing purpose.
            task.run();
            return new ScheduledTask<>(() -> null, delayMs, periodMs);
        }
    }
}
