/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.raft;

import com.google.protobuf.ByteString;
import com.google.protobuf.ProtocolStringList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.bifromq.base.util.CompletableFutureUtil;
import org.apache.bifromq.basekv.raft.ILogEntryIterator;
import org.apache.bifromq.basekv.raft.IRaftNode;
import org.apache.bifromq.basekv.raft.IRaftStateStore;
import org.apache.bifromq.basekv.raft.PeerLogTracker;
import org.apache.bifromq.basekv.raft.QuorumTracker;
import org.apache.bifromq.basekv.raft.RaftConfig;
import org.apache.bifromq.basekv.raft.RaftConfigChanger;
import org.apache.bifromq.basekv.raft.RaftNodeState;
import org.apache.bifromq.basekv.raft.RaftNodeStateFollower;
import org.apache.bifromq.basekv.raft.ReadProgressTracker;
import org.apache.bifromq.basekv.raft.exception.ClusterConfigChangeException;
import org.apache.bifromq.basekv.raft.exception.DropProposalException;
import org.apache.bifromq.basekv.raft.exception.LeaderTransferException;
import org.apache.bifromq.basekv.raft.exception.ReadIndexException;
import org.apache.bifromq.basekv.raft.exception.RecoveryException;
import org.apache.bifromq.basekv.raft.proto.AppendEntries;
import org.apache.bifromq.basekv.raft.proto.AppendEntriesReply;
import org.apache.bifromq.basekv.raft.proto.ClusterConfig;
import org.apache.bifromq.basekv.raft.proto.InstallSnapshot;
import org.apache.bifromq.basekv.raft.proto.InstallSnapshotReply;
import org.apache.bifromq.basekv.raft.proto.LogEntry;
import org.apache.bifromq.basekv.raft.proto.Propose;
import org.apache.bifromq.basekv.raft.proto.ProposeReply;
import org.apache.bifromq.basekv.raft.proto.RaftMessage;
import org.apache.bifromq.basekv.raft.proto.RaftNodeStatus;
import org.apache.bifromq.basekv.raft.proto.RaftNodeSyncState;
import org.apache.bifromq.basekv.raft.proto.RequestReadIndex;
import org.apache.bifromq.basekv.raft.proto.RequestReadIndexReply;
import org.apache.bifromq.basekv.raft.proto.Snapshot;
import org.apache.bifromq.basekv.raft.proto.TimeoutNow;

class RaftNodeStateLeader
extends RaftNodeState {
    private final QuorumTracker activityTracker;
    private final PeerLogTracker peerLogTracker;
    private final RaftConfigChanger configChanger;
    private final ReadProgressTracker readProgressTracker;
    private final Deque<SnapshotTask> pendingCompactions = new ArrayDeque<SnapshotTask>();
    private LeaderTransferTask leaderTransferTask;
    private PendingCompaction activeCompaction;
    private int electionElapsedTick;

    RaftNodeStateLeader(long term, long commitIndex, RaftConfig config, IRaftStateStore stateStorage, LinkedHashMap<Long, RaftNodeState.ProposeTask> uncommittedProposals, IRaftNode.IRaftMessageSender sender, IRaftNode.IRaftEventListener listener, IRaftNode.ISnapshotInstaller installer, RaftNodeState.OnSnapshotInstalled onSnapshotInstalled, String ... tags) {
        super(term, commitIndex, config, stateStorage, uncommittedProposals, sender, listener, installer, onSnapshotInstalled, tags);
        this.peerLogTracker = new PeerLogTracker(this.id(), config, stateStorage, listener, this.log);
        this.configChanger = new RaftConfigChanger(config, stateStorage, this.peerLogTracker, this.log);
        ClusterConfig clusterConfig = stateStorage.latestClusterConfig();
        this.activityTracker = new QuorumTracker(clusterConfig, this.log);
        this.readProgressTracker = new ReadProgressTracker(stateStorage, this.log);
        HashSet<String> peersToStartTracking = new HashSet<String>((Collection<String>)clusterConfig.getVotersList());
        peersToStartTracking.addAll((Collection<String>)clusterConfig.getLearnersList());
        this.peerLogTracker.startTracking(peersToStartTracking, false);
        this.peerLogTracker.confirmMatch(stateStorage.local(), stateStorage.lastIndex());
        if (this.isJoint(clusterConfig)) {
            this.log.debug("Resume cluster config change process in current term");
            this.changeClusterConfig(clusterConfig.getCorrelateId(), new HashSet<String>((Collection<String>)clusterConfig.getNextVotersList()), new HashSet<String>((Collection<String>)clusterConfig.getNextLearnersList()), new CompletableFuture<Void>());
        } else {
            this.log.debug("Propose cluster config as first log entry in current term to conclude commit index");
            this.changeClusterConfig(clusterConfig.getCorrelateId(), new HashSet<String>((Collection<String>)clusterConfig.getVotersList()), new HashSet<String>((Collection<String>)clusterConfig.getLearnersList()), new CompletableFuture<Void>());
        }
    }

    @Override
    public RaftNodeStatus getState() {
        return RaftNodeStatus.Leader;
    }

    @Override
    public String currentLeader() {
        return this.stateStorage.local();
    }

    @Override
    RaftNodeState stepDown() {
        this.log.debug("leader is asked to step down to follower");
        RaftNodeStateFollower nextState = new RaftNodeStateFollower(this.currentTerm(), this.commitIndex, null, this.config, this.stateStorage, this.uncommittedProposals, this.sender, this.listener, this.snapshotInstaller, this.onSnapshotInstalled, this.tags);
        this.abortPendingRequests(AbortReason.LeaderStepDown);
        this.checkPendingCompaction(true);
        return nextState;
    }

    @Override
    void recover(CompletableFuture<Void> onDone) {
        onDone.completeExceptionally(RecoveryException.notLostQuorum());
    }

    @Override
    RaftNodeState tick() {
        Map<String, List<RaftMessage>> appendEntriesToSend;
        ++this.electionElapsedTick;
        this.peerLogTracker.tick();
        this.onPendingCompactionTick();
        if (this.configChanger.tick(this.currentTerm()) && (this.configChanger.state() == RaftConfigChanger.State.JointConfigCommitting || this.configChanger.state() == RaftConfigChanger.State.TargetConfigCommitting || this.configChanger.state() == RaftConfigChanger.State.FallbackConfigCommitting)) {
            ClusterConfig clusterConfig = this.stateStorage.latestClusterConfig();
            this.log.debug("Activate config in current term: {}", (Object)clusterConfig);
            this.activityTracker.refresh(clusterConfig);
            this.electionElapsedTick = 0;
            if (this.leaderTransferTask != null && !clusterConfig.getVotersList().contains((Object)this.leaderTransferTask.nextLeader) && !clusterConfig.getNextVotersList().contains((Object)this.leaderTransferTask.nextLeader)) {
                this.log.debug("Abort leadership transfer, new leader[{}] has been removed from new cluster config", (Object)this.leaderTransferTask.nextLeader);
                this.leaderTransferTask.abort(LeaderTransferException.notFoundOrQualified());
                this.leaderTransferTask = null;
            }
        }
        if (this.electionElapsedTick >= this.config.getElectionTimeoutTick()) {
            this.electionElapsedTick = 0;
            if (this.leaderTransferTask != null) {
                this.log.debug("Leadership cannot be transferred to {} in electionTimeoutTicks[{}]", (Object)this.leaderTransferTask.nextLeader, (Object)this.config.getElectionTimeoutTick());
                this.leaderTransferTask.abort(LeaderTransferException.transferTimeout());
                this.leaderTransferTask = null;
            }
            this.activityTracker.poll(this.stateStorage.local(), true);
            QuorumTracker.JointVoteResult quorumCheckResult = this.activityTracker.tally();
            if (quorumCheckResult.result == QuorumTracker.VoteResult.Won) {
                this.log.trace("Quorum check succeed[{}], leadership remain", (Object)quorumCheckResult);
                this.activityTracker.reset();
            } else {
                this.log.warn("Quorum check failed[{}], leader stepped down to follower", (Object)quorumCheckResult);
                this.abortPendingRequests(AbortReason.LeaderStepDown);
                this.checkPendingCompaction(true);
                return new RaftNodeStateFollower(this.currentTerm(), this.commitIndex, null, this.config, this.stateStorage, this.uncommittedProposals, this.sender, this.listener, this.snapshotInstaller, this.onSnapshotInstalled, this.tags);
            }
        }
        if (!(appendEntriesToSend = this.prepareAppendEntriesIfAbsent(false)).isEmpty()) {
            this.submitRaftMessages(appendEntriesToSend);
        }
        this.checkPendingCompaction(false);
        return this;
    }

    @Override
    void propose(ByteString fsmCmd, CompletableFuture<Long> onDone) {
        if (this.leaderTransferTask != null) {
            this.log.debug("Dropped proposal due to transferring leadership");
            onDone.completeExceptionally(DropProposalException.transferringLeader());
            return;
        }
        if (this.isProposeThrottled()) {
            this.log.debug("Dropped proposal due to log growing[uncommittedProposals:{}] exceeds threshold[maxUncommittedProposals:{}]", (Object)this.uncommittedProposals.size(), (Object)this.maxUncommittedProposals);
            onDone.completeExceptionally(DropProposalException.throttledByThreshold());
            return;
        }
        LogEntry entry = LogEntry.newBuilder().setTerm(this.currentTerm()).setIndex(this.stateStorage.lastIndex() + 1L).setData(fsmCmd).build();
        this.stateStorage.append(Collections.singletonList(entry), !this.config.isAsyncAppend());
        this.peerLogTracker.replicateBy(this.stateStorage.local(), this.stateStorage.lastIndex());
        RaftNodeState.ProposeTask prev = this.uncommittedProposals.put(entry.getIndex(), new RaftNodeState.ProposeTask(entry.getTerm(), onDone));
        assert (prev == null);
        Map<String, List<RaftMessage>> appendEntriesToSend = this.prepareAppendEntriesIfAbsent(false);
        if (!appendEntriesToSend.isEmpty()) {
            this.submitRaftMessages(appendEntriesToSend);
        }
    }

    @Override
    RaftNodeState stableTo(long stabledIndex) {
        this.log.trace("Log entries before index[{}] stabilized", (Object)stabledIndex);
        this.peerLogTracker.confirmMatch(this.stateStorage.local(), stabledIndex);
        this.checkPendingCompaction(false);
        return this.commit();
    }

    @Override
    protected void onSnapshotReady(Snapshot snapshot, CompletableFuture<Void> onDone) {
        this.pendingCompactions.addLast(new SnapshotTask(snapshot, onDone));
        this.scheduleCompactionQueue();
    }

    @Override
    void readIndex(CompletableFuture<Long> onDone) {
        if (this.commitIndexNotConfirmed()) {
            this.log.debug("No log entry of current term committed");
            onDone.completeExceptionally(ReadIndexException.commitIndexNotConfirmed());
            return;
        }
        if (this.config.isReadOnlyLeaderLeaseMode() && this.leaderTransferTask == null) {
            onDone.complete(this.commitIndex);
        } else {
            this.readProgressTracker.add(this.commitIndex, onDone);
            if (this.readProgressTracker.underConfirming() > this.config.getReadOnlyBatch()) {
                Map<String, List<RaftMessage>> appendEntriesToSend = this.prepareAppendEntriesIfAbsent(true);
                this.submitRaftMessages(appendEntriesToSend);
            }
        }
    }

    @Override
    RaftNodeState receive(String fromPeer, RaftMessage message) {
        this.log.trace("Receive[{}] from {}", (Object)message, (Object)fromPeer);
        RaftNodeState nextState = this;
        if (message.getTerm() > this.currentTerm()) {
            switch (message.getMessageTypeCase()) {
                case REQUESTPREVOTE: {
                    this.sendRequestPreVoteReply(fromPeer, message.getTerm(), false);
                    return nextState;
                }
                case REQUESTPREVOTEREPLY: {
                    return nextState;
                }
                case REQUESTVOTE: {
                    boolean leaderTransfer = message.getRequestVote().getLeaderTransfer();
                    if (!leaderTransfer && !this.voters().contains(fromPeer)) {
                        this.log.debug("Vote[{}] from candidate[{}] not granted, lease is not expired", (Object)message.getTerm(), (Object)fromPeer);
                        this.sendRequestVoteReply(fromPeer, message.getTerm(), false);
                        return nextState;
                    }
                    if (this.leaderTransferTask == null) break;
                    if (leaderTransfer) {
                        this.leaderTransferTask.done();
                    } else {
                        this.leaderTransferTask.abort(LeaderTransferException.stepDownByOther());
                    }
                    this.leaderTransferTask = null;
                    break;
                }
            }
            this.log.debug("Got higher term[{}] message[{}] from peer[{}], start to step down", new Object[]{message.getTerm(), message.getMessageTypeCase(), fromPeer});
            this.abortPendingRequests(AbortReason.LeaderStepDown);
            this.checkPendingCompaction(true);
            nextState = new RaftNodeStateFollower(message.getTerm(), this.commitIndex, null, this.config, this.stateStorage, this.uncommittedProposals, this.sender, this.listener, this.snapshotInstaller, this.onSnapshotInstalled, this.tags);
            nextState.receive(fromPeer, message);
        } else {
            if (message.getTerm() < this.currentTerm()) {
                this.handleLowTermMessage(fromPeer, message);
                return nextState;
            }
            switch (message.getMessageTypeCase()) {
                case APPENDENTRIESREPLY: {
                    return this.handleAppendEntriesReply(fromPeer, message.getAppendEntriesReply());
                }
                case INSTALLSNAPSHOTREPLY: {
                    return this.handleInstallSnapshotReply(fromPeer, message.getInstallSnapshotReply());
                }
                case REQUESTREADINDEX: {
                    this.handleRequestReadIndex(fromPeer, message.getRequestReadIndex());
                    break;
                }
                case PROPOSE: {
                    this.handlePropose(fromPeer, message.getPropose());
                    break;
                }
                case REQUESTPREVOTE: {
                    this.sendRequestPreVoteReply(fromPeer, this.currentTerm(), false);
                    break;
                }
            }
        }
        return nextState;
    }

    @Override
    void transferLeadership(String newLeader, CompletableFuture<Void> onDone) {
        if (this.commitIndexNotConfirmed()) {
            onDone.completeExceptionally(LeaderTransferException.leaderNotReady());
            return;
        }
        if (this.leaderTransferTask != null) {
            onDone.completeExceptionally(LeaderTransferException.transferringInProgress());
            return;
        }
        if (newLeader.equals(this.stateStorage.local())) {
            onDone.completeExceptionally(LeaderTransferException.selfTransfer());
            return;
        }
        ClusterConfig clusterConfig = this.stateStorage.latestClusterConfig();
        if (clusterConfig.getLearnersList().contains((Object)newLeader) || !clusterConfig.getVotersList().contains((Object)newLeader) && !clusterConfig.getNextVotersList().contains((Object)newLeader)) {
            onDone.completeExceptionally(LeaderTransferException.notFoundOrQualified());
            return;
        }
        this.electionElapsedTick = 0;
        this.leaderTransferTask = new LeaderTransferTask(newLeader, onDone);
        if (this.peerLogTracker.matchIndex(newLeader) == this.stateStorage.lastIndex()) {
            this.sendTimeoutNow(newLeader);
        } else {
            this.submitRaftMessages(newLeader, this.prepareAppendEntriesForPeer(newLeader, true));
        }
    }

    @Override
    void changeClusterConfig(String correlateId, Set<String> nextVoters, Set<String> nextLearners, CompletableFuture<Void> onDone) {
        this.configChanger.submit(correlateId, nextVoters, nextLearners, onDone);
    }

    @Override
    void onSnapshotRestored(ByteString requested, ByteString installed, Throwable ex, CompletableFuture<Void> onDone) {
        onDone.complete(null);
    }

    @Override
    public void stop() {
        super.stop();
        this.abortPendingRequests(AbortReason.Cancelled);
        this.checkPendingCompaction(true);
    }

    private RaftNodeState handleAppendEntriesReply(String fromPeer, AppendEntriesReply reply) {
        if (!this.peerLogTracker.isTracking(fromPeer)) {
            this.log.debug("No tracker available for peer[{}]", (Object)fromPeer);
            return this;
        }
        this.activityTracker.poll(fromPeer, true);
        if (!this.config.isReadOnlyLeaderLeaseMode()) {
            this.readProgressTracker.confirm(reply.getReadIndex(), fromPeer);
        }
        if (this.peerLogTracker.status(fromPeer) != RaftNodeSyncState.SnapshotSyncing) {
            if (reply.getResultCase() == AppendEntriesReply.ResultCase.REJECT) {
                AppendEntriesReply.Reject reject = reply.getReject();
                this.log.debug("Follower[{}] with last entry[index:{},term:{}] rejected entries appending from index[{}]", new Object[]{fromPeer, reject.getLastIndex(), reject.getTerm(), reject.getRejectedIndex()});
                this.peerLogTracker.backoff(fromPeer, reject.getRejectedIndex(), reject.getLastIndex());
                this.checkPendingCompaction(false);
                List<RaftMessage> messages = this.prepareAppendEntriesForPeer(fromPeer, true);
                this.submitRaftMessages(fromPeer, messages);
                return this;
            }
            AppendEntriesReply.Accept accept = reply.getAccept();
            this.log.trace("Follower[{}] accepted entries, and advance match index[{}]", (Object)fromPeer, (Object)accept.getLastIndex());
            this.peerLogTracker.confirmMatch(fromPeer, accept.getLastIndex());
            this.checkPendingCompaction(false);
            if (this.leaderTransferTask != null && fromPeer.equals(this.leaderTransferTask.nextLeader) && this.peerLogTracker.matchIndex(fromPeer) == this.stateStorage.lastIndex()) {
                this.log.info("Started leadership transfer by sending TimeoutNow to follower[{}]", (Object)fromPeer);
                this.sendTimeoutNow(this.leaderTransferTask.nextLeader);
            }
            return this.commit();
        }
        return this;
    }

    private RaftNodeState handleInstallSnapshotReply(String fromPeer, InstallSnapshotReply reply) {
        if (!this.peerLogTracker.isTracking(fromPeer)) {
            this.log.debug("No tracker available for peer[{}] when handleInstallSnapshotReply", (Object)fromPeer);
            return this;
        }
        this.activityTracker.poll(fromPeer, true);
        if (!this.config.isReadOnlyLeaderLeaseMode()) {
            this.readProgressTracker.confirm(reply.getReadIndex(), fromPeer);
        }
        if (this.peerLogTracker.status(fromPeer) != RaftNodeSyncState.SnapshotSyncing) {
            return this;
        }
        if (reply.getRejected()) {
            this.log.debug("Follower[{}] rejected snapshot with last entry of index[{}]", (Object)fromPeer, (Object)reply.getLastIndex());
            this.peerLogTracker.backoff(fromPeer, reply.getLastIndex(), reply.getLastIndex());
            this.checkPendingCompaction(false);
            return this;
        }
        this.log.debug("Follower[{}] installed snapshot, advance last index[{}]", (Object)fromPeer, (Object)reply.getLastIndex());
        this.peerLogTracker.confirmMatch(fromPeer, reply.getLastIndex());
        this.checkPendingCompaction(false);
        return this.commit();
    }

    private Map<String, List<RaftMessage>> prepareAppendEntriesIfAbsent(boolean forceHeartbeat) {
        HashMap<String, List<RaftMessage>> appendEntriesToSend = new HashMap<String, List<RaftMessage>>();
        for (String peer : this.configChanger.remotePeers()) {
            appendEntriesToSend.computeIfAbsent(peer, p -> this.prepareAppendEntriesForPeer((String)p, forceHeartbeat));
        }
        return appendEntriesToSend;
    }

    private List<RaftMessage> prepareAppendEntriesForPeer(String peer, boolean forceHeartbeat) {
        ArrayList<RaftMessage> messages = new ArrayList<RaftMessage>();
        long readIndex = this.readProgressTracker.highestReadIndex();
        switch (this.peerLogTracker.status(peer)) {
            case SnapshotSyncing: {
                Snapshot snapshot = this.stateStorage.latestSnapshot();
                if (!this.peerLogTracker.pauseReplicating(peer)) {
                    if (snapshot.getIndex() == this.peerLogTracker.matchIndex(peer)) {
                        this.log.debug("Prepared snapshot[index:{},term:{}] for peer[{}] when {}", new Object[]{snapshot.getIndex(), snapshot.getTerm(), peer, this.peerLogTracker.status(peer)});
                        messages.add(RaftMessage.newBuilder().setTerm(this.currentTerm()).setInstallSnapshot(InstallSnapshot.newBuilder().setLeaderId(this.stateStorage.local()).setSnapshot(snapshot).setReadIndex(readIndex).build()).build());
                        this.peerLogTracker.replicateBy(peer, snapshot.getIndex());
                        break;
                    }
                    this.log.debug("New snapshot[index:{},term:{}] generated, reset the tracker for peer[{}]", new Object[]{snapshot.getIndex(), snapshot.getTerm(), peer});
                    this.peerLogTracker.backoff(peer, this.peerLogTracker.matchIndex(peer), this.peerLogTracker.matchIndex(peer));
                    this.checkPendingCompaction(false);
                    break;
                }
                if (!forceHeartbeat && !this.peerLogTracker.needHeartbeat(peer)) break;
                this.log.trace("Prepare heartbeat after entry[index:{},term:{}] for peer[{}] with readIndex[{}] when {}", new Object[]{snapshot.getIndex(), snapshot.getTerm(), peer, readIndex, this.peerLogTracker.status(peer)});
                messages.add(RaftMessage.newBuilder().setTerm(this.currentTerm()).setAppendEntries(AppendEntries.newBuilder().setLeaderId(this.stateStorage.local()).setPrevLogIndex(snapshot.getIndex()).setPrevLogTerm(snapshot.getTerm()).setCommitIndex(snapshot.getIndex()).setReadIndex(readIndex).build()).build());
                this.peerLogTracker.replicateBy(peer, snapshot.getIndex());
                break;
            }
            case Probing: {
                if (this.peerLogTracker.pauseReplicating(peer) && !forceHeartbeat && !this.peerLogTracker.needHeartbeat(peer)) break;
                long nextIndex = Math.max(this.peerLogTracker.nextIndex(peer), this.stateStorage.firstIndex());
                long preLogIndex = nextIndex - 1L;
                long preLogTerm = this.stateStorage.entryAt(preLogIndex).map(LogEntry::getTerm).orElseGet(() -> this.stateStorage.latestSnapshot().getTerm());
                this.log.debug("Prepare probing after entry[index:{},term:{}] for peer[{}] with readIndex[{}] when {}", new Object[]{preLogIndex, preLogTerm, peer, readIndex, this.peerLogTracker.status(peer)});
                messages.add(RaftMessage.newBuilder().setTerm(this.currentTerm()).setAppendEntries(AppendEntries.newBuilder().setLeaderId(this.stateStorage.local()).setPrevLogIndex(preLogIndex).setPrevLogTerm(preLogTerm).setCommitIndex(Math.min(preLogIndex, this.commitIndex)).setReadIndex(readIndex).build()).build());
                this.peerLogTracker.replicateBy(peer, preLogIndex);
                break;
            }
            case Replicating: {
                long nextIndex = Math.max(this.peerLogTracker.nextIndex(peer), this.stateStorage.firstIndex());
                long preLogIndex = nextIndex - 1L;
                long preLogTerm = this.stateStorage.entryAt(preLogIndex).map(LogEntry::getTerm).orElseGet(() -> this.stateStorage.latestSnapshot().getTerm());
                if (!this.peerLogTracker.pauseReplicating(peer) && nextIndex <= this.stateStorage.lastIndex()) {
                    try (ILogEntryIterator entries = this.stateStorage.entries(nextIndex, this.stateStorage.lastIndex() + 1L, this.config.getMaxSizePerAppend());){
                        AppendEntries.Builder builder = AppendEntries.newBuilder().setLeaderId(this.stateStorage.local()).setPrevLogIndex(preLogIndex).setPrevLogTerm(preLogTerm).setCommitIndex(this.commitIndex).setReadIndex(readIndex);
                        entries.forEachRemaining(arg_0 -> ((AppendEntries.Builder)builder).addEntries(arg_0));
                        AppendEntries appendEntries = builder.build();
                        messages.add(RaftMessage.newBuilder().setTerm(this.currentTerm()).setAppendEntries(appendEntries).build());
                        assert (appendEntries.getEntriesCount() != 0);
                        this.log.trace("Prepare {} entries after entry[index:{},term:{}] for peer[{}] with readIndex[{}] when {}", new Object[]{appendEntries.getEntriesCount(), preLogIndex, preLogTerm, peer, readIndex, this.peerLogTracker.status(peer)});
                        this.peerLogTracker.replicateBy(peer, appendEntries.getEntries(appendEntries.getEntriesCount() - 1).getIndex());
                        break;
                    }
                }
                if (!forceHeartbeat && !this.peerLogTracker.needHeartbeat(peer)) break;
                this.log.trace("Prepare heartbeat after entry[index:{},term:{}] for peer[{}] with readIndex[{}] when {}", new Object[]{preLogIndex, preLogTerm, peer, readIndex, this.peerLogTracker.status(peer)});
                messages.add(RaftMessage.newBuilder().setTerm(this.currentTerm()).setAppendEntries(AppendEntries.newBuilder().setLeaderId(this.stateStorage.local()).setPrevLogIndex(preLogIndex).setPrevLogTerm(preLogTerm).setCommitIndex(this.commitIndex).setReadIndex(readIndex).build()).build());
                this.peerLogTracker.replicateBy(peer, preLogIndex);
                break;
            }
        }
        return messages;
    }

    private RaftNodeState commit() {
        boolean needNotify;
        Optional<LogEntry> committed;
        ProtocolStringList voters = this.stateStorage.latestClusterConfig().getVotersList();
        ProtocolStringList nextVoters = this.stateStorage.latestClusterConfig().getNextVotersList();
        List mIdx = voters.stream().map(this.peerLogTracker::matchIndex).sorted(Long::compareTo).collect(Collectors.toList());
        long newCommitIndex = (Long)mIdx.get(mIdx.size() - ((mIdx.size() >> 1) + 1));
        if (!nextVoters.isEmpty()) {
            mIdx = nextVoters.stream().map(this.peerLogTracker::matchIndex).collect(Collectors.toList());
            mIdx.sort(Long::compareTo);
            newCommitIndex = Math.min(newCommitIndex, (Long)mIdx.get(mIdx.size() - ((mIdx.size() >> 1) + 1)));
        }
        if ((committed = this.stateStorage.entryAt(newCommitIndex = Math.max(this.commitIndex, newCommitIndex))).isPresent() && committed.get().getTerm() != this.currentTerm()) {
            return this;
        }
        boolean bl = needNotify = this.commitIndex != newCommitIndex;
        if (needNotify) {
            this.commitIndex = newCommitIndex;
        }
        RaftNodeState nextState = this;
        if (this.configChanger.commitTo(this.commitIndex, this.currentTerm())) {
            switch (this.configChanger.state()) {
                case Waiting: {
                    String localId = this.stateStorage.local();
                    if (!this.stateStorage.latestClusterConfig().getVotersList().contains((Object)localId)) {
                        HashSet<String> allRemotePeers = new HashSet<String>((Collection<String>)this.configChanger.prevConfig().getVotersList());
                        allRemotePeers.addAll((Collection<String>)this.configChanger.prevConfig().getLearnersList());
                        allRemotePeers.addAll(this.configChanger.remotePeers());
                        allRemotePeers.remove(this.stateStorage.local());
                        if (!allRemotePeers.isEmpty()) {
                            Map<String, List<RaftMessage>> appendEntriesToSend = allRemotePeers.stream().collect(Collectors.toMap(peerId -> peerId, peerId -> this.prepareAppendEntriesForPeer((String)peerId, true)));
                            this.log.debug("Leader is about to step down, send final heartbeats to all remote peers[{}]", allRemotePeers);
                            this.submitRaftMessages(appendEntriesToSend);
                        }
                        this.log.debug("Leader stepped down due to being removed from cluster config");
                        this.readProgressTracker.abort(ReadIndexException.leaderStepDown());
                        if (this.leaderTransferTask != null) {
                            this.leaderTransferTask.abort(LeaderTransferException.leaderStepDown());
                        }
                        nextState = new RaftNodeStateFollower(this.currentTerm(), this.commitIndex, null, this.config, this.stateStorage, this.uncommittedProposals, this.sender, this.listener, this.snapshotInstaller, this.onSnapshotInstalled, this.tags);
                        this.configChanger.confirmCommit(false);
                        break;
                    }
                    HashSet removedPeers = new HashSet(this.configChanger.prevConfig().getVotersList());
                    removedPeers.addAll(this.configChanger.prevConfig().getLearnersList());
                    removedPeers.removeAll(this.configChanger.remotePeers());
                    removedPeers.remove(this.stateStorage.local());
                    if (!removedPeers.isEmpty()) {
                        Map<String, List<RaftMessage>> appendEntriesToSend = removedPeers.stream().collect(Collectors.toMap(peerId -> peerId, peerId -> this.prepareAppendEntriesForPeer((String)peerId, true)));
                        this.log.debug("Send final heartbeats to removed peers[{}]", removedPeers);
                        this.submitRaftMessages(appendEntriesToSend);
                    }
                    this.configChanger.confirmCommit(true);
                    break;
                }
                case TargetConfigCommitting: {
                    ClusterConfig clusterConfig = this.stateStorage.latestClusterConfig();
                    this.activityTracker.refresh(clusterConfig);
                    if (this.leaderTransferTask == null || clusterConfig.getVotersList().contains((Object)this.leaderTransferTask.nextLeader)) break;
                    this.log.info("Aborted transfer leadership to follower[{}], it's removed from target cluster config", (Object)this.leaderTransferTask.nextLeader);
                    this.leaderTransferTask.abort(LeaderTransferException.notFoundOrQualified());
                    this.leaderTransferTask = null;
                    break;
                }
                case FallbackConfigCommitting: {
                    break;
                }
            }
        }
        if (needNotify) {
            this.notifyCommit(true);
        }
        return nextState;
    }

    private void handleRequestReadIndex(String fromPeer, RequestReadIndex request) {
        this.log.trace("Received forwarded ReadIndex request from peer[{}]", (Object)fromPeer);
        CompletableFuture<Long> onDone = new CompletableFuture<Long>();
        onDone.whenComplete((readIndex, e) -> {
            if (e != null) {
                this.log.debug("Failed to finish forwarded ReadIndex request from peer[{}]", (Object)fromPeer, e);
            } else {
                this.submitRaftMessages(fromPeer, RaftMessage.newBuilder().setTerm(this.currentTerm()).setRequestReadIndexReply(RequestReadIndexReply.newBuilder().setId(request.getId()).setReadIndex(readIndex.longValue()).build()).build());
            }
        });
        this.readIndex(onDone);
    }

    private void handlePropose(String fromPeer, Propose propose) {
        this.log.trace("Received forwarded Propose request from peer[{}]", (Object)fromPeer);
        CompletableFuture<Long> onDone = new CompletableFuture<Long>();
        onDone.whenComplete(CompletableFutureUtil.unwrap((v, e) -> {
            if (e != null) {
                this.log.debug("Failed to finish forwarded Propose request from peer[{}]", (Object)fromPeer, e);
                ProposeReply.Builder replyBuilder = ProposeReply.newBuilder().setId(propose.getId());
                assert (e instanceof DropProposalException);
                switch (((DropProposalException)e).code) {
                    case NoLeader: {
                        replyBuilder.setCode(ProposeReply.Code.DropByNoLeader);
                        break;
                    }
                    case Overridden: {
                        replyBuilder.setCode(ProposeReply.Code.DropByOverridden);
                        break;
                    }
                    case ForwardTimeout: {
                        replyBuilder.setCode(ProposeReply.Code.DropByForwardTimeout);
                        break;
                    }
                    case TransferringLeader: {
                        replyBuilder.setCode(ProposeReply.Code.DropByLeaderTransferring);
                        break;
                    }
                    case LeaderForwardDisabled: {
                        replyBuilder.setCode(ProposeReply.Code.DropByLeaderForwardDisabled);
                        break;
                    }
                    case ThrottleByThreshold: {
                        replyBuilder.setCode(ProposeReply.Code.DropByMaxUnappliedEntries);
                        break;
                    }
                    case SupersededBySnapshot: {
                        replyBuilder.setCode(ProposeReply.Code.DropBySupersededBySnapshot);
                        break;
                    }
                    default: {
                        replyBuilder.setCode(ProposeReply.Code.DropByCancel);
                    }
                }
                this.submitRaftMessages(fromPeer, RaftMessage.newBuilder().setTerm(this.currentTerm()).setProposeReply(replyBuilder.build()).build());
            } else {
                this.submitRaftMessages(fromPeer, RaftMessage.newBuilder().setTerm(this.currentTerm()).setProposeReply(ProposeReply.newBuilder().setId(propose.getId()).setCode(ProposeReply.Code.Success).setLogIndex(v.longValue()).build()).build());
            }
        }));
        this.propose(propose.getCommand(), onDone);
    }

    private void sendTimeoutNow(String toPeer) {
        this.submitRaftMessages(toPeer, RaftMessage.newBuilder().setTerm(this.currentTerm()).setTimeoutNow(TimeoutNow.getDefaultInstance()).build());
    }

    private boolean isJoint(ClusterConfig clusterConfig) {
        return !clusterConfig.getNextVotersList().isEmpty();
    }

    private boolean commitIndexNotConfirmed() {
        Optional<LogEntry> committed = this.stateStorage.entryAt(this.commitIndex);
        return committed.map(logEntry -> logEntry.getTerm() == this.currentTerm()).orElseGet(() -> this.stateStorage.latestSnapshot().getTerm() == this.currentTerm()) == false;
    }

    private void abortPendingRequests(AbortReason reason) {
        switch (reason) {
            case LeaderStepDown: {
                this.configChanger.abort(ClusterConfigChangeException.leaderStepDown());
                this.readProgressTracker.abort(ReadIndexException.leaderStepDown());
                if (this.leaderTransferTask == null) break;
                this.leaderTransferTask.abort(LeaderTransferException.leaderStepDown());
                break;
            }
            case Cancelled: {
                this.configChanger.abort(ClusterConfigChangeException.cancelled());
                this.readProgressTracker.abort(ReadIndexException.cancelled());
                if (this.leaderTransferTask == null) break;
                this.leaderTransferTask.abort(LeaderTransferException.cancelled());
                break;
            }
        }
    }

    private void checkPendingCompaction(boolean force) {
        PendingCompaction pending = this.activeCompaction;
        if (pending == null) {
            return;
        }
        if (force) {
            this.log.debug("Force finish pending compaction at index[{}]", (Object)pending.snapshot.getIndex());
            this.completePendingCompaction(pending);
            return;
        }
        pending.refresh();
        if (pending.isDone()) {
            this.completePendingCompaction(pending);
        }
    }

    private void onPendingCompactionTick() {
        PendingCompaction pending = this.activeCompaction;
        if (pending != null) {
            pending.onTick();
        }
    }

    private void completePendingCompaction(PendingCompaction pending) {
        if (this.activeCompaction != pending) {
            return;
        }
        this.activeCompaction = null;
        this.applySnapshot(pending.snapshot, pending.onDone);
        this.scheduleCompactionQueue();
    }

    private void scheduleCompactionQueue() {
        if (this.activeCompaction != null) {
            return;
        }
        while (!this.pendingCompactions.isEmpty()) {
            SnapshotTask task = this.pendingCompactions.pollFirst();
            PendingCompaction pending = new PendingCompaction(task.snapshot, task.onDone);
            if (pending.isDone()) {
                this.applySnapshot(task.snapshot, task.onDone);
                continue;
            }
            this.log.debug("Delay compaction at index[{}] until peers{} catch up", (Object)task.snapshot.getIndex(), pending.waitingPeers);
            this.activeCompaction = pending;
            break;
        }
    }

    private static enum AbortReason {
        LeaderStepDown,
        Cancelled;

    }

    private static class LeaderTransferTask {
        final String nextLeader;
        private final CompletableFuture<Void> onDone;

        LeaderTransferTask(String nextLeader, CompletableFuture<Void> onDone) {
            this.nextLeader = nextLeader;
            this.onDone = onDone;
        }

        void abort(Throwable t) {
            this.onDone.completeExceptionally(t);
        }

        void done() {
            this.onDone.complete(null);
        }
    }

    private static final class SnapshotTask {
        final Snapshot snapshot;
        final CompletableFuture<Void> onDone;

        SnapshotTask(Snapshot snapshot, CompletableFuture<Void> onDone) {
            this.snapshot = snapshot;
            this.onDone = onDone;
        }
    }

    private final class PendingCompaction {
        final Snapshot snapshot;
        final CompletableFuture<Void> onDone;
        final Set<String> waitingPeers = new HashSet<String>();
        final Map<String, Integer> waitTicks = new HashMap<String, Integer>();

        PendingCompaction(Snapshot snapshot, CompletableFuture<Void> onDone) {
            this.snapshot = snapshot;
            this.onDone = onDone;
            long targetIndex = snapshot.getIndex();
            for (String peer : RaftNodeStateLeader.this.peerLogTracker.peers()) {
                if (peer.equals(RaftNodeStateLeader.this.stateStorage.local()) || RaftNodeStateLeader.this.peerLogTracker.status(peer) != RaftNodeSyncState.Replicating || RaftNodeStateLeader.this.peerLogTracker.matchIndex(peer) >= targetIndex) continue;
                this.waitingPeers.add(peer);
                this.waitTicks.put(peer, 0);
            }
        }

        void onTick() {
            this.waitingPeers.forEach(peer -> this.waitTicks.merge((String)peer, 1, Integer::sum));
        }

        void refresh() {
            Iterator<String> itr = this.waitingPeers.iterator();
            while (itr.hasNext()) {
                String peer = itr.next();
                if (!RaftNodeStateLeader.this.peerLogTracker.isTracking(peer)) {
                    itr.remove();
                    this.waitTicks.remove(peer);
                    continue;
                }
                if (RaftNodeStateLeader.this.peerLogTracker.status(peer) != RaftNodeSyncState.Replicating) {
                    itr.remove();
                    this.waitTicks.remove(peer);
                    continue;
                }
                if (RaftNodeStateLeader.this.peerLogTracker.matchIndex(peer) >= this.snapshot.getIndex()) {
                    itr.remove();
                    this.waitTicks.remove(peer);
                    continue;
                }
                int elapsed = this.waitTicks.getOrDefault(peer, 0);
                if (elapsed < RaftNodeStateLeader.this.config.getElectionTimeoutTick()) continue;
                itr.remove();
                this.waitTicks.remove(peer);
                RaftNodeStateLeader.this.log.debug("Follower[{}] wait timeout for pending compaction at index[{}]", (Object)peer, (Object)this.snapshot.getIndex());
            }
        }

        boolean isDone() {
            return this.waitingPeers.isEmpty();
        }
    }
}

