/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.util.index;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.bifromq.util.index.Branch;
import org.apache.bifromq.util.index.BranchTable;
import org.apache.bifromq.util.index.EmptyBranchTable;
import org.apache.bifromq.util.index.PMapBranchTable;
import org.pcollections.HashPMap;
import org.pcollections.HashTreePMap;

final class SingleEntryBranchTable<V>
implements BranchTable<V> {
    private final String key;
    private final Branch<V> value;

    SingleEntryBranchTable(String key, Branch<V> value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public Branch<V> get(String key) {
        return Objects.equals(this.key, key) ? this.value : null;
    }

    @Override
    public BranchTable<V> plus(String key, Branch<V> value) {
        if (Objects.equals(this.key, key)) {
            if (this.value == value) {
                return this;
            }
            return new SingleEntryBranchTable<V>(key, value);
        }
        HashPMap m = HashTreePMap.empty();
        m = m.plus((Object)this.key, this.value);
        m = m.plus((Object)key, value);
        return new PMapBranchTable(m);
    }

    @Override
    public BranchTable<V> minus(String key) {
        if (Objects.equals(this.key, key)) {
            return EmptyBranchTable.empty();
        }
        return this;
    }

    @Override
    public void forEach(BiConsumer<String, Branch<V>> consumer) {
        consumer.accept(this.key, this.value);
    }

    @Override
    public Map<String, Branch<V>> asMapView() {
        return Collections.singletonMap(this.key, this.value);
    }
}

