/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.service;

import com.google.protobuf.ByteString;
import io.reactivex.rxjava3.core.Observable;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;
import org.apache.bifromq.basecluster.IAgentHost;
import org.apache.bifromq.basecrdt.core.api.ICRDTOperation;
import org.apache.bifromq.basecrdt.core.api.ICausalCRDT;
import org.apache.bifromq.basecrdt.proto.Replica;
import org.apache.bifromq.basecrdt.service.CRDTService;
import org.apache.bifromq.basecrdt.service.CRDTServiceOptions;

public interface ICRDTService
extends AutoCloseable {
    public static ICRDTService newInstance(IAgentHost agentHost, @NonNull CRDTServiceOptions options) {
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        return new CRDTService(agentHost, options);
    }

    public String id();

    public ByteString agentHostId();

    public <O extends ICRDTOperation, C extends ICausalCRDT<O>> C host(String var1);

    public CompletableFuture<Void> stopHosting(String var1);

    public Observable<Set<Replica>> aliveReplicas(String var1);

    public Observable<Set<String>> aliveCRDTs();

    public Observable<Long> refreshSignal();

    @Override
    public void close();
}

