/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.geoparquet;

import java.util.List;

public record GeoParquetSchema(String name, List<Field> fields) {

    public record GroupField(String name, Cardinality cardinality, GeoParquetSchema schema) implements Field
    {
        @Override
        public Type type() {
            return Type.GROUP;
        }
    }

    record EnvelopeField(String name, Cardinality cardinality, GeoParquetSchema schema) implements Field
    {
        @Override
        public Type type() {
            return Type.ENVELOPE;
        }
    }

    record GeometryField(String name, Cardinality cardinality) implements Field
    {
        @Override
        public Type type() {
            return Type.GEOMETRY;
        }
    }

    record StringField(String name, Cardinality cardinality) implements Field
    {
        @Override
        public Type type() {
            return Type.STRING;
        }
    }

    record LongField(String name, Cardinality cardinality) implements Field
    {
        @Override
        public Type type() {
            return Type.LONG;
        }
    }

    record Int96Field(String name, Cardinality cardinality) implements Field
    {
        @Override
        public Type type() {
            return Type.INT96;
        }
    }

    record IntegerField(String name, Cardinality cardinality) implements Field
    {
        @Override
        public Type type() {
            return Type.INTEGER;
        }
    }

    record FloatField(String name, Cardinality cardinality) implements Field
    {
        @Override
        public Type type() {
            return Type.FLOAT;
        }
    }

    record DoubleField(String name, Cardinality cardinality) implements Field
    {
        @Override
        public Type type() {
            return Type.DOUBLE;
        }
    }

    record BooleanField(String name, Cardinality cardinality) implements Field
    {
        @Override
        public Type type() {
            return Type.BOOLEAN;
        }
    }

    record BinaryField(String name, Cardinality cardinality) implements Field
    {
        @Override
        public Type type() {
            return Type.BINARY;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Field {
        public String name();

        public Type type();

        public Cardinality cardinality();
    }

    public static enum Cardinality {
        REQUIRED,
        OPTIONAL,
        REPEATED;

    }

    public static enum Type {
        BINARY,
        BOOLEAN,
        DOUBLE,
        FLOAT,
        INTEGER,
        INT96,
        LONG,
        STRING,
        GEOMETRY,
        ENVELOPE,
        GROUP;

    }
}

