/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.geoparquet;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.baremaps.geoparquet.GeoParquetException;
import org.apache.baremaps.geoparquet.GeoParquetGroup;
import org.apache.baremaps.geoparquet.GeoParquetGroupFactory;
import org.apache.baremaps.geoparquet.GeoParquetMetadata;
import org.apache.baremaps.geoparquet.GeoParquetSchema;
import org.apache.baremaps.geoparquet.GeoParquetSpliterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.locationtech.jts.geom.Envelope;

public class GeoParquetReader {
    protected final Configuration configuration;
    protected final List<FileStatus> files;
    private final AtomicLong groupCount = new AtomicLong(-1L);
    private final Envelope envelope;

    public GeoParquetReader(Path path) {
        this(path, null, new Configuration());
    }

    public GeoParquetReader(Path path, Envelope envelope) {
        this(path, envelope, new Configuration());
    }

    public GeoParquetReader(Path path, Envelope envelope, Configuration configuration) {
        this.configuration = configuration;
        this.files = GeoParquetReader.initializeFiles(path, configuration);
        this.envelope = envelope;
    }

    public MessageType getParquetSchema() {
        return this.files.stream().findFirst().map((Function<FileStatus, FileInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getFileInfo(org.apache.hadoop.fs.FileStatus ), (Lorg/apache/hadoop/fs/FileStatus;)Lorg/apache/baremaps/geoparquet/GeoParquetReader$FileInfo;)((GeoParquetReader)this)).orElseThrow((Supplier<GeoParquetException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$getParquetSchema$0(), ()Lorg/apache/baremaps/geoparquet/GeoParquetException;)()).messageType;
    }

    public GeoParquetMetadata getGeoParquetMetadata() {
        return this.files.stream().findFirst().map(this::getFileInfo).orElseThrow(this::noParquetFilesAvailable).metadata();
    }

    public GeoParquetSchema getGeoParquetSchema() {
        return this.files.stream().findFirst().map(this::getFileInfo).orElseThrow(this::noParquetFilesAvailable).geoParquetSchema();
    }

    public GeoParquetException noParquetFilesAvailable() {
        return new GeoParquetException("No parquet files available.");
    }

    public boolean validateSchemasAreIdentical() {
        Set schemas = this.files.parallelStream().map(this::getFileInfo).map(fileInfo -> fileInfo.messageType).collect(Collectors.toSet());
        return schemas.size() == 1;
    }

    public long size() {
        if (this.groupCount.get() == -1L) {
            long totalCount = this.files.parallelStream().map(this::getFileInfo).mapToLong(fileInfo -> fileInfo.recordCount).sum();
            this.groupCount.set(totalCount);
        }
        return this.groupCount.get();
    }

    private FileInfo getFileInfo(FileStatus fileStatus) {
        try {
            ParquetMetadata parquetMetadata = ParquetFileReader.readFooter((Configuration)this.configuration, (Path)fileStatus.getPath());
            long recordCount = parquetMetadata.getBlocks().stream().mapToLong(BlockMetaData::getRowCount).sum();
            FileMetaData fileMetaData = parquetMetadata.getFileMetaData();
            Map keyValueMetadata = fileMetaData.getKeyValueMetaData();
            MessageType messageType = fileMetaData.getSchema();
            GeoParquetMetadata geoParquetMetadata = null;
            GeoParquetSchema geoParquetSchema = null;
            if (keyValueMetadata.containsKey("geo")) {
                ObjectMapper objectMapper = new ObjectMapper();
                objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                geoParquetMetadata = (GeoParquetMetadata)objectMapper.readValue((String)keyValueMetadata.get("geo"), GeoParquetMetadata.class);
                geoParquetSchema = GeoParquetGroupFactory.createGeoParquetSchema((GroupType)messageType, geoParquetMetadata);
            }
            return new FileInfo(fileStatus, recordCount, keyValueMetadata, messageType, geoParquetMetadata, geoParquetSchema);
        }
        catch (IOException e) {
            throw new GeoParquetException("Failed to build FileInfo for file: " + String.valueOf(fileStatus), e);
        }
    }

    private static List<FileStatus> initializeFiles(Path path, Configuration configuration) {
        try {
            FileSystem fileSystem = FileSystem.get((URI)path.toUri(), (Configuration)configuration);
            FileStatus[] fileStatuses = fileSystem.globStatus(path);
            if (fileStatuses == null) {
                throw new GeoParquetException("No files found at the specified URI.");
            }
            return Collections.unmodifiableList(Arrays.asList(fileStatuses));
        }
        catch (IOException e) {
            throw new GeoParquetException("IOException while attempting to list files.", e);
        }
    }

    private Stream<GeoParquetGroup> streamGeoParquetGroups(boolean inParallel) {
        GeoParquetSpliterator spliterator = new GeoParquetSpliterator(this.files, this.envelope, this.configuration, 0, this.files.size());
        return StreamSupport.stream(spliterator, inParallel);
    }

    public Stream<GeoParquetGroup> read() {
        return this.streamGeoParquetGroups(false);
    }

    public Stream<GeoParquetGroup> readParallel() {
        return this.streamGeoParquetGroups(true);
    }

    private static /* synthetic */ GeoParquetException lambda$getParquetSchema$0() {
        return new GeoParquetException("No files available to read schema.");
    }

    private record FileInfo(FileStatus file, long recordCount, Map<String, String> keyValueMetadata, MessageType messageType, GeoParquetMetadata metadata, GeoParquetSchema geoParquetSchema) {
    }
}

