/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.user;

import java.util.Iterator;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.Pagination;
import mil.nga.geopackage.user.UserColumn;
import mil.nga.geopackage.user.UserCoreDao;
import mil.nga.geopackage.user.UserCoreResult;
import mil.nga.geopackage.user.UserCoreRow;
import mil.nga.geopackage.user.UserTable;

public abstract class UserCorePaginatedResults<TColumn extends UserColumn, TTable extends UserTable<TColumn>, TRow extends UserCoreRow<TColumn, TTable>, TResult extends UserCoreResult<TColumn, TTable, TRow>>
implements Iterable<TRow> {
    private final UserCoreDao<TColumn, TTable, TRow, TResult> dao;
    private UserCoreResult<TColumn, TTable, TRow> results;
    private final String sql;
    private final String[] args;
    private final String[] columns;
    private Pagination pagination;

    protected UserCorePaginatedResults(UserCoreDao<TColumn, TTable, TRow, TResult> dao, UserCoreResult<TColumn, TTable, TRow> results) {
        this.dao = dao;
        this.results = results;
        this.sql = results.getSql();
        this.columns = results.getColumns().getColumnNames();
        this.args = results.getSelectionArgs();
        this.pagination = Pagination.find(this.sql);
        if (this.pagination == null) {
            throw new GeoPackageException("Results are not paginated. SQL: " + this.sql);
        }
    }

    public UserCoreDao<TColumn, TTable, TRow, TResult> getDao() {
        return this.dao;
    }

    public UserCoreResult<TColumn, TTable, TRow> getResults() {
        return this.results;
    }

    public String getSql() {
        return this.sql;
    }

    public String[] getArgs() {
        return this.args;
    }

    public String[] getColumns() {
        return this.columns;
    }

    public Pagination getPagination() {
        return this.pagination;
    }

    public void setPagination(Pagination pagination) {
        this.pagination = pagination;
    }

    @Override
    public Iterator<TRow> iterator() {
        return new Iterator<TRow>(){
            private Iterator<TRow> rows;
            {
                this.rows = UserCorePaginatedResults.this.results.iterator();
            }

            @Override
            public boolean hasNext() {
                boolean hasNext = this.rows.hasNext();
                if (!hasNext) {
                    UserCorePaginatedResults.this.close();
                    if (UserCorePaginatedResults.this.pagination.hasLimit()) {
                        UserCorePaginatedResults.this.pagination.incrementOffset();
                        String query = UserCorePaginatedResults.this.pagination.replace(UserCorePaginatedResults.this.sql);
                        UserCorePaginatedResults.this.results = UserCorePaginatedResults.this.dao.rawQuery(query, UserCorePaginatedResults.this.columns, UserCorePaginatedResults.this.args);
                        this.rows = UserCorePaginatedResults.this.results.iterator();
                        hasNext = UserCorePaginatedResults.this.results.moveToNext();
                        if (!hasNext) {
                            UserCorePaginatedResults.this.close();
                        }
                    }
                }
                return hasNext;
            }

            @Override
            public TRow next() {
                return (UserCoreRow)this.rows.next();
            }
        };
    }

    public Iterable<Long> ids() {
        return new Iterable<Long>(){
            private Iterator<Long> ids;
            {
                this.ids = UserCorePaginatedResults.this.results.ids().iterator();
            }

            @Override
            public Iterator<Long> iterator() {
                return new Iterator<Long>(){

                    @Override
                    public boolean hasNext() {
                        boolean hasNext = ids.hasNext();
                        if (!hasNext) {
                            UserCorePaginatedResults.this.close();
                            if (UserCorePaginatedResults.this.pagination.hasLimit()) {
                                UserCorePaginatedResults.this.pagination.incrementOffset();
                                String query = UserCorePaginatedResults.this.pagination.replace(UserCorePaginatedResults.this.sql);
                                UserCorePaginatedResults.this.results = UserCorePaginatedResults.this.dao.rawQuery(query, UserCorePaginatedResults.this.columns, UserCorePaginatedResults.this.args);
                                ids = UserCorePaginatedResults.this.results.ids().iterator();
                                hasNext = UserCorePaginatedResults.this.results.moveToNext();
                                if (!hasNext) {
                                    UserCorePaginatedResults.this.close();
                                }
                            }
                        }
                        return hasNext;
                    }

                    @Override
                    public Long next() {
                        return ids.next();
                    }
                };
            }
        };
    }

    public void close() {
        this.results.close();
    }
}

