/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.nga.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageCoreCache;
import mil.nga.geopackage.extension.nga.properties.PropertiesCoreExtension;

public abstract class PropertiesManagerCore<T extends GeoPackageCore> {
    private final Map<String, PropertiesCoreExtension<T, ?, ?, ?>> propertiesMap = new HashMap();

    protected PropertiesManagerCore() {
    }

    protected PropertiesManagerCore(T geoPackage) {
        this.addGeoPackage(geoPackage);
    }

    protected PropertiesManagerCore(Collection<T> geoPackages) {
        this.addGeoPackages(geoPackages);
    }

    protected PropertiesManagerCore(GeoPackageCoreCache<T> cache) {
        this(cache.getGeoPackages());
    }

    protected abstract PropertiesCoreExtension<T, ?, ?, ?> getPropertiesExtension(T var1);

    public Set<String> getGeoPackageNames() {
        return this.propertiesMap.keySet();
    }

    public int numGeoPackages() {
        return this.propertiesMap.size();
    }

    public List<T> getGeoPackages() {
        ArrayList<T> geoPackages = new ArrayList<T>();
        for (PropertiesCoreExtension<T, ?, ?, ?> properties : this.propertiesMap.values()) {
            geoPackages.add(properties.getGeoPackage());
        }
        return geoPackages;
    }

    public boolean hasGeoPackage(String name) {
        return this.propertiesMap.containsKey(name);
    }

    public T getGeoPackage(String name) {
        T geoPackage = null;
        PropertiesCoreExtension<T, ?, ?, ?> properties = this.propertiesMap.get(name);
        if (properties != null) {
            geoPackage = properties.getGeoPackage();
        }
        return geoPackage;
    }

    public void addGeoPackages(Collection<T> geoPackages) {
        for (GeoPackageCore geoPackage : geoPackages) {
            this.addGeoPackage(geoPackage);
        }
    }

    public void addGeoPackage(T geoPackage) {
        PropertiesCoreExtension<T, ?, ?, ?> propertiesExtension = this.getPropertiesExtension(geoPackage);
        this.propertiesMap.put(geoPackage.getName(), propertiesExtension);
    }

    public void closeGeoPackages() {
        for (PropertiesCoreExtension<T, ?, ?, ?> properties : this.propertiesMap.values()) {
            properties.getGeoPackage().close();
        }
        this.propertiesMap.clear();
    }

    public T removeGeoPackage(String name) {
        T removed = null;
        PropertiesCoreExtension<T, ?, ?, ?> properties = this.propertiesMap.remove(name);
        if (properties != null) {
            removed = properties.getGeoPackage();
        }
        return removed;
    }

    public void clearGeoPackages() {
        this.propertiesMap.clear();
    }

    public boolean removeAndCloseGeoPackage(String name) {
        return this.closeGeoPackage(name);
    }

    public boolean closeGeoPackage(String name) {
        T geoPackage = this.removeGeoPackage(name);
        if (geoPackage != null) {
            geoPackage.close();
        }
        return geoPackage != null;
    }

    public void closeRetainGeoPackages(Collection<String> retain) {
        HashSet<String> close = new HashSet<String>(this.propertiesMap.keySet());
        close.removeAll(retain);
        for (String name : close) {
            this.closeGeoPackage(name);
        }
    }

    public void closeGeoPackages(Collection<String> names) {
        for (String name : names) {
            this.closeGeoPackage(name);
        }
    }

    public int numProperties() {
        return this.getProperties().size();
    }

    public Set<String> getProperties() {
        HashSet<String> allProperties = new HashSet<String>();
        for (PropertiesCoreExtension<T, ?, ?, ?> properties : this.propertiesMap.values()) {
            allProperties.addAll(properties.getProperties());
        }
        return allProperties;
    }

    public List<T> hasProperty(String property) {
        ArrayList<T> geoPackages = new ArrayList<T>();
        for (PropertiesCoreExtension<T, ?, ?, ?> properties : this.propertiesMap.values()) {
            if (!properties.hasProperty(property)) continue;
            geoPackages.add(properties.getGeoPackage());
        }
        return geoPackages;
    }

    public List<T> missingProperty(String property) {
        ArrayList<T> geoPackages = new ArrayList<T>();
        for (PropertiesCoreExtension<T, ?, ?, ?> properties : this.propertiesMap.values()) {
            if (properties.hasProperty(property)) continue;
            geoPackages.add(properties.getGeoPackage());
        }
        return geoPackages;
    }

    public int numValues(String property) {
        return this.getValues(property).size();
    }

    public boolean hasValues(String property) {
        return this.numValues(property) > 0;
    }

    public Set<String> getValues(String property) {
        HashSet<String> allValues = new HashSet<String>();
        for (PropertiesCoreExtension<T, ?, ?, ?> properties : this.propertiesMap.values()) {
            allValues.addAll(properties.getValues(property));
        }
        return allValues;
    }

    public List<T> hasValue(String property, String value) {
        ArrayList<T> geoPackages = new ArrayList<T>();
        for (PropertiesCoreExtension<T, ?, ?, ?> properties : this.propertiesMap.values()) {
            if (!properties.hasValue(property, value)) continue;
            geoPackages.add(properties.getGeoPackage());
        }
        return geoPackages;
    }

    public List<T> missingValue(String property, String value) {
        ArrayList<T> geoPackages = new ArrayList<T>();
        for (PropertiesCoreExtension<T, ?, ?, ?> properties : this.propertiesMap.values()) {
            if (properties.hasValue(property, value)) continue;
            geoPackages.add(properties.getGeoPackage());
        }
        return geoPackages;
    }

    public int addValue(String property, String value) {
        int count = 0;
        for (String geoPackage : this.propertiesMap.keySet()) {
            if (!this.addValue(geoPackage, property, value)) continue;
            ++count;
        }
        return count;
    }

    public boolean addValue(String geoPackage, String property, String value) {
        boolean added = false;
        PropertiesCoreExtension<T, ?, ?, ?> properties = this.propertiesMap.get(geoPackage);
        if (properties != null) {
            added = properties.addValue(property, value);
        }
        return added;
    }

    public int deleteProperty(String property) {
        int count = 0;
        for (String geoPackage : this.propertiesMap.keySet()) {
            if (!this.deleteProperty(geoPackage, property)) continue;
            ++count;
        }
        return count;
    }

    public boolean deleteProperty(String geoPackage, String property) {
        boolean deleted = false;
        PropertiesCoreExtension<T, ?, ?, ?> properties = this.propertiesMap.get(geoPackage);
        if (properties != null) {
            deleted = properties.deleteProperty(property) > 0;
        }
        return deleted;
    }

    public int deleteValue(String property, String value) {
        int count = 0;
        for (String geoPackage : this.propertiesMap.keySet()) {
            if (!this.deleteValue(geoPackage, property, value)) continue;
            ++count;
        }
        return count;
    }

    public boolean deleteValue(String geoPackage, String property, String value) {
        boolean deleted = false;
        PropertiesCoreExtension<T, ?, ?, ?> properties = this.propertiesMap.get(geoPackage);
        if (properties != null) {
            deleted = properties.deleteValue(property, value) > 0;
        }
        return deleted;
    }

    public int deleteAll() {
        int count = 0;
        for (String geoPackage : this.propertiesMap.keySet()) {
            if (!this.deleteAll(geoPackage)) continue;
            ++count;
        }
        return count;
    }

    public boolean deleteAll(String geoPackage) {
        boolean deleted = false;
        PropertiesCoreExtension<T, ?, ?, ?> properties = this.propertiesMap.get(geoPackage);
        if (properties != null) {
            deleted = properties.deleteAll() > 0;
        }
        return deleted;
    }

    public void removeExtension() {
        for (String geoPackage : this.propertiesMap.keySet()) {
            this.removeExtension(geoPackage);
        }
    }

    public void removeExtension(String geoPackage) {
        PropertiesCoreExtension<T, ?, ?, ?> properties = this.propertiesMap.get(geoPackage);
        if (properties != null) {
            properties.removeExtension();
        }
    }
}

