/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.data.type;

import java.nio.ByteBuffer;
import org.apache.baremaps.data.type.DataType;

public class NullableDataType<T>
implements DataType<T> {
    private final DataType<T> dataType;

    public NullableDataType(DataType<T> dataType) {
        this.dataType = dataType;
    }

    @Override
    public int size(T value) {
        return 1 + this.dataType.size(value);
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        return 1 + this.dataType.size(buffer, position + 1);
    }

    @Override
    public void write(ByteBuffer buffer, int position, T value) {
        if (value == null) {
            buffer.put(position, (byte)0);
        } else {
            buffer.put(position, (byte)1);
            this.dataType.write(buffer, position + 1, value);
        }
    }

    @Override
    public T read(ByteBuffer buffer, int position) {
        if (buffer.get(position) == 0) {
            return null;
        }
        return this.dataType.read(buffer, position + 1);
    }
}

