/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.data.memory;

import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.apache.baremaps.data.memory.Memory;
import org.apache.baremaps.data.memory.MemoryException;
import org.apache.baremaps.data.util.FileUtils;
import org.apache.baremaps.data.util.MappedByteBufferUtils;

public class MemoryMappedDirectory
extends Memory<MappedByteBuffer> {
    private final Path directory;

    public MemoryMappedDirectory(Path directory) {
        this(directory, 0x40000000);
    }

    public MemoryMappedDirectory(Path directory, int segmentBytes) {
        super(segmentBytes);
        this.directory = directory;
    }

    @Override
    protected MappedByteBuffer allocate(int index, int size) {
        MappedByteBuffer mappedByteBuffer;
        block8: {
            Path file = this.directory.resolve(String.format("%s.part", index));
            FileChannel channel = FileChannel.open(file, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
            try {
                mappedByteBuffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, size);
                if (channel == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MemoryException(e);
                }
            }
            channel.close();
        }
        return mappedByteBuffer;
    }

    @Override
    public void close() throws IOException {
        for (MappedByteBuffer buffer : this.segments) {
            MappedByteBufferUtils.unmap(buffer);
        }
    }

    @Override
    public void clear() throws IOException {
        this.close();
        this.segments.clear();
        FileUtils.deleteRecursively(this.directory);
    }
}

