/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.data.collection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;

public interface DataMap<K, V> {
    public long size();

    public V get(Object var1);

    default public Iterable<V> getAll(Iterable<K> keys) {
        ArrayList values = new ArrayList();
        keys.forEach((? super T key) -> values.add(this.get(key)));
        return values;
    }

    public V put(K var1, V var2);

    default public void putAll(Iterable<Map.Entry<K, V>> entries) {
        entries.forEach((? super T entry) -> this.put(entry.getKey(), entry.getValue()));
    }

    public boolean containsKey(Object var1);

    public boolean containsValue(V var1);

    public void clear();

    default public boolean isEmpty() {
        return this.size() == 0L;
    }

    public Iterator<K> keyIterator();

    default public Iterable<K> keys() {
        return this::keyIterator;
    }

    public Iterator<V> valueIterator();

    default public Iterable<V> values() {
        return this::valueIterator;
    }

    public Iterator<Map.Entry<K, V>> entryIterator();

    default public Iterable<Map.Entry<K, V>> entries() {
        return this::entryIterator;
    }

    default public void forEach(BiConsumer<? super K, ? super V> action) {
        for (Map.Entry<K, V> entry : this.entries()) {
            action.accept(entry.getKey(), entry.getValue());
        }
    }
}

