/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.function;

import java.util.function.Function;
import org.apache.baremaps.openstreetmap.model.Blob;
import org.apache.baremaps.openstreetmap.model.Block;
import org.apache.baremaps.openstreetmap.pbf.DataBlockReader;
import org.apache.baremaps.openstreetmap.pbf.HeaderBlockReader;
import org.apache.baremaps.openstreetmap.stream.StreamException;

public class BlobToBlockMapper
implements Function<Blob, Block> {
    @Override
    public Block apply(Blob blob) {
        try {
            switch (blob.header().getType()) {
                case "OSMHeader": {
                    return new HeaderBlockReader(blob).read();
                }
                case "OSMData": {
                    return new DataBlockReader(blob).read();
                }
            }
            throw new StreamException("Unknown blob type");
        }
        catch (StreamException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new StreamException(exception);
        }
    }
}

