/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import org.apache.sis.measure.Latitude;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.AuthalicConversion;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.util.internal.DoubleDouble;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

public class AlbersEqualArea
extends AuthalicConversion {
    private static final long serialVersionUID = -3024658742514888646L;
    final double nm;
    final double C;

    public AlbersEqualArea(OperationMethod method, Parameters parameters) {
        this(AlbersEqualArea.initializer(method, parameters));
    }

    private static Initializer initializer(OperationMethod method, Parameters parameters) {
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>> roles = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>>(NormalizedProjection.ParameterRole.class);
        roles.put(NormalizedProjection.ParameterRole.FALSE_EASTING, org.apache.sis.referencing.operation.provider.AlbersEqualArea.EASTING_AT_FALSE_ORIGIN);
        roles.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, org.apache.sis.referencing.operation.provider.AlbersEqualArea.NORTHING_AT_FALSE_ORIGIN);
        roles.put(NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN, org.apache.sis.referencing.operation.provider.AlbersEqualArea.LONGITUDE_OF_FALSE_ORIGIN);
        return new Initializer(method, parameters, roles, null);
    }

    private AlbersEqualArea(Initializer initializer) {
        super(initializer, null);
        double \u03c60 = initializer.getAndStore(org.apache.sis.referencing.operation.provider.AlbersEqualArea.LATITUDE_OF_FALSE_ORIGIN);
        double \u03c61 = initializer.getAndStore(org.apache.sis.referencing.operation.provider.AlbersEqualArea.STANDARD_PARALLEL_1, \u03c60);
        double \u03c62 = initializer.getAndStore(org.apache.sis.referencing.operation.provider.AlbersEqualArea.STANDARD_PARALLEL_2, \u03c61);
        if (Math.abs(\u03c61 + \u03c62) < 8.999280057595393E-8) {
            throw new IllegalArgumentException(Resources.format((short)31, new Latitude(\u03c61), new Latitude(\u03c62)));
        }
        boolean secant = Math.abs(\u03c61 - \u03c62) >= 8.999280057595393E-8;
        \u03c60 = Math.toRadians(\u03c60);
        \u03c61 = Math.toRadians(\u03c61);
        \u03c62 = Math.toRadians(\u03c62);
        double sin\u03c60 = Math.sin(\u03c60);
        double sin\u03c61 = Math.sin(\u03c61);
        double cos\u03c61 = Math.cos(\u03c61);
        double sin\u03c62 = Math.sin(\u03c62);
        double cos\u03c62 = Math.cos(\u03c62);
        double m1 = initializer.scaleAt\u03c6(sin\u03c61, cos\u03c61);
        double \u03b11 = this.qm(sin\u03c61);
        if (secant) {
            double m2 = initializer.scaleAt\u03c6(sin\u03c62, cos\u03c62);
            double \u03b12 = this.qm(sin\u03c62);
            this.nm = (m1 * m1 - m2 * m2) / (\u03b12 - \u03b11);
        } else {
            this.nm = sin\u03c61;
        }
        this.C = m1 * m1 + this.nm * \u03b11;
        DoubleDouble rn = DoubleDouble.ONE.subtract(initializer.eccentricitySquared).divide(this.nm, false);
        DoubleDouble \u03c10 = DoubleDouble.sum((double)this.C, (double)(-this.nm * this.qm(sin\u03c60))).sqrt().multiply(rn);
        MatrixSIS normalize = this.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
        MatrixSIS denormalize = this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        denormalize.convertBefore(0, (Number)rn, null);
        denormalize.convertBefore(1, (Number)rn.negate(), (Number)\u03c10);
        normalize.convertAfter(0, (Number)rn.inverse(), null);
    }

    AlbersEqualArea(AlbersEqualArea other) {
        super(other);
        this.nm = other.nm;
        this.C = other.C;
    }

    @Override
    final String[] getInternalParameterNames() {
        return new String[]{"n", "C"};
    }

    @Override
    final double[] getInternalParameterValues() {
        return new double[]{this.nm / (1.0 - this.eccentricitySquared), this.C};
    }

    @Override
    public MathTransform createMapProjection(MathTransformFactory factory) throws FactoryException {
        AlbersEqualArea kernel = this;
        if (this.eccentricity == 0.0) {
            kernel = new Spherical(this);
        }
        return kernel.completeWithWraparound(factory);
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws ProjectionException {
        double \u03b8 = srcPts[srcOff];
        double \u03c6 = srcPts[srcOff + 1];
        double cos\u03b8 = Math.cos(\u03b8);
        double sin\u03b8 = Math.sin(\u03b8);
        double sin\u03c6 = Math.sin(\u03c6);
        double \u03c1 = Math.sqrt(this.C - this.nm * this.qm(sin\u03c6));
        if (dstPts != null) {
            dstPts[dstOff] = \u03c1 * sin\u03b8;
            dstPts[dstOff + 1] = \u03c1 * cos\u03b8;
        }
        if (!derivate) {
            return null;
        }
        double ome = 1.0 - this.eccentricitySquared;
        double d\u03c1_d\u03c6 = -0.5 * this.nm * this.dqm_d\u03c6(sin\u03c6, Math.cos(\u03c6) * ome) / (ome * \u03c1);
        return new Matrix2(cos\u03b8 * \u03c1, d\u03c1_d\u03c6 * sin\u03b8, -sin\u03b8 * \u03c1, d\u03c1_d\u03c6 * cos\u03b8);
    }

    @Override
    protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) throws ProjectionException {
        double x = srcPts[srcOff];
        double y = srcPts[srcOff + 1];
        dstPts[dstOff] = Math.atan2(x, y);
        dstPts[dstOff + 1] = this.\u03c6((this.C - (x * x + y * y)) / (this.nm * this.qmPolar));
    }

    static final class Spherical
    extends AlbersEqualArea {
        private static final long serialVersionUID = -7238296545347764989L;

        protected Spherical(AlbersEqualArea other) {
            super(other);
        }

        @Override
        public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) {
            double \u03b8 = srcPts[srcOff];
            double \u03c6 = srcPts[srcOff + 1];
            double cos\u03b8 = Math.cos(\u03b8);
            double sin\u03b8 = Math.sin(\u03b8);
            double sin\u03c6 = Math.sin(\u03c6);
            double \u03c1 = Math.sqrt(this.C - 2.0 * this.nm * sin\u03c6);
            if (dstPts != null) {
                dstPts[dstOff] = \u03c1 * sin\u03b8;
                dstPts[dstOff + 1] = \u03c1 * cos\u03b8;
            }
            if (!derivate) {
                return null;
            }
            double d\u03c1_d\u03c6 = -this.nm * Math.cos(\u03c6) / \u03c1;
            return new Matrix2(cos\u03b8 * \u03c1, d\u03c1_d\u03c6 * sin\u03b8, -sin\u03b8 * \u03c1, d\u03c1_d\u03c6 * cos\u03b8);
        }

        @Override
        protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) {
            double x = srcPts[srcOff];
            double y = srcPts[srcOff + 1];
            dstPts[dstOff] = Math.atan2(x, y);
            dstPts[dstOff + 1] = Math.asin((this.C - (x * x + y * y)) / (this.nm * 2.0));
        }
    }
}

