/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import javax.measure.Unit;
import javax.measure.quantity.Angle;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.Matrix4;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.referencing.util.ReferencingUtilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.FactoryException;

final class MathTransformContext
extends DefaultMathTransformFactory.Context {
    private static final long serialVersionUID = 8765209303733056283L;
    private double sourceMeridian;
    private double targetMeridian;

    MathTransformContext(GeodeticDatum source, GeodeticDatum target) {
        double rs = ReferencingUtilities.getGreenwichLongitude(source.getPrimeMeridian(), (Unit<Angle>)Units.DEGREE);
        double rt = ReferencingUtilities.getGreenwichLongitude(target.getPrimeMeridian(), (Unit<Angle>)Units.DEGREE);
        if (rs != rt) {
            this.sourceMeridian = rs;
            this.targetMeridian = rt;
        }
    }

    @Override
    public Matrix getMatrix(ContextualParameters.MatrixRole role) throws FactoryException {
        CoordinateSystem cs;
        double rotation;
        boolean inverse = false;
        switch (role) {
            default: {
                throw new IllegalArgumentException(Errors.format((short)45, (Object)"role", (Object)((Object)role)));
            }
            case INVERSE_NORMALIZATION: {
                inverse = true;
            }
            case NORMALIZATION: {
                rotation = this.sourceMeridian;
                cs = this.getSourceCS();
                break;
            }
            case INVERSE_DENORMALIZATION: {
                inverse = true;
            }
            case DENORMALIZATION: {
                inverse = !inverse;
                rotation = this.targetMeridian;
                cs = this.getTargetCS();
            }
        }
        Matrix matrix = super.getMatrix(role);
        if (rotation != 0.0) {
            if (inverse) {
                rotation = -rotation;
            }
            MatrixSIS cm = MatrixSIS.castOrCopy(matrix);
            if (cs instanceof CartesianCS) {
                rotation = Math.toRadians(rotation);
                Matrix4 rot = new Matrix4();
                rot.m00 = rot.m11 = Math.cos(rotation);
                rot.m10 = Math.sin(rotation);
                rot.m01 = -rot.m10;
                matrix = inverse ? Matrices.multiply(rot, cm) : cm.multiply(rot);
            } else if (cs == null || cs instanceof EllipsoidalCS || cs instanceof SphericalCS) {
                Double value = rotation;
                if (inverse) {
                    cm.convertBefore(0, null, value);
                } else {
                    cm.convertAfter(0, null, value);
                }
                matrix = cm;
            } else {
                throw new FactoryException(Errors.format((short)178, (Object)cs.getName()));
            }
        }
        return matrix;
    }
}

