/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.pmtiles;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public enum Compression {
    UNKNOWN,
    NONE,
    GZIP,
    BROTLI,
    ZSTD;


    InputStream decompress(InputStream inputStream) throws IOException {
        return switch (this) {
            case NONE -> inputStream;
            case GZIP -> Compression.decompressGzip(inputStream);
            case BROTLI -> Compression.decompressBrotli(inputStream);
            case ZSTD -> Compression.decompressZstd(inputStream);
            default -> throw new UnsupportedOperationException("Unknown compression format");
        };
    }

    static InputStream decompressGzip(InputStream inputStream) throws IOException {
        return new GZIPInputStream(inputStream);
    }

    static InputStream decompressBrotli(InputStream buffer) {
        throw new UnsupportedOperationException("Brotli compression not implemented");
    }

    static InputStream decompressZstd(InputStream buffer) {
        throw new UnsupportedOperationException("Zstd compression not implemented");
    }

    OutputStream compress(OutputStream outputStream) throws IOException {
        return switch (this) {
            case NONE -> outputStream;
            case GZIP -> Compression.compressGzip(outputStream);
            case BROTLI -> Compression.compressBrotli(outputStream);
            case ZSTD -> Compression.compressZstd(outputStream);
            default -> throw new UnsupportedOperationException("Unknown compression format");
        };
    }

    static OutputStream compressGzip(OutputStream outputStream) throws IOException {
        return new GZIPOutputStream(outputStream);
    }

    static OutputStream compressBrotli(OutputStream outputStream) {
        throw new UnsupportedOperationException("Brotli compression not implemented");
    }

    static OutputStream compressZstd(OutputStream outputStream) {
        throw new UnsupportedOperationException("Zstd compression not implemented");
    }
}

