/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql.postgis;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import org.apache.sis.storage.sql.feature.Column;
import org.apache.sis.storage.sql.feature.Database;
import org.apache.sis.storage.sql.feature.InfoStatements;
import org.apache.sis.storage.sql.feature.TableReference;
import org.apache.sis.storage.sql.postgis.RasterReader;

final class ExtendedInfo
extends InfoStatements {
    private PreparedStatement geographyColumns;
    protected PreparedStatement rasterColumns;
    private RasterReader rasterReader;

    ExtendedInfo(Database<?> session, Connection connection) {
        super(session, connection);
    }

    @Override
    public void completeIntrospection(TableReference source, Map<String, Column> columns) throws Exception {
        if (this.geometryColumns == null) {
            this.geometryColumns = this.prepareIntrospectionStatement("geometry_columns", 'f', "geometry_column", "type");
        }
        if (this.geographyColumns == null) {
            this.geographyColumns = this.prepareIntrospectionStatement("geography_columns", 'f', "geography_column", "type");
        }
        if (this.rasterColumns == null) {
            this.rasterColumns = this.prepareIntrospectionStatement("raster_columns", 'r', "raster_column", null);
        }
        this.configureSpatialColumns(this.geometryColumns, source, columns, InfoStatements.GeometryTypeEncoding.TEXTUAL);
        this.configureSpatialColumns(this.geographyColumns, source, columns, InfoStatements.GeometryTypeEncoding.TEXTUAL);
        this.configureSpatialColumns(this.rasterColumns, source, columns, null);
    }

    final RasterReader getRasterReader() {
        if (this.rasterReader == null) {
            this.rasterReader = new RasterReader(this);
        }
        return this.rasterReader;
    }

    @Override
    public void close() throws SQLException {
        if (this.geographyColumns != null) {
            this.geographyColumns.close();
            this.geographyColumns = null;
        }
        super.close();
    }
}

