/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.dem;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.GeometryFixer;
import org.locationtech.jts.geom.util.GeometryTransformer;
import org.locationtech.jts.operation.linemerge.LineMerger;

public class ContourTracer {
    private static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();
    private static final double EPSILON = 1.0E-10;
    private final double[] grid;
    private final int width;
    private final int height;
    private final boolean normalize;
    private final boolean polygonize;

    public ContourTracer(double[] grid, int width, int height, boolean normalize, boolean polygonize) {
        ContourTracer.validateInput(grid, width, height);
        this.grid = Arrays.copyOf(grid, grid.length);
        this.width = width;
        this.height = height;
        this.normalize = normalize;
        this.polygonize = polygonize;
    }

    public List<Geometry> traceContours(double level) {
        ArrayList<LineString> cells = new ArrayList<LineString>();
        for (int y = 0; y < this.height - 1; ++y) {
            for (int x = 0; x < this.width - 1; ++x) {
                cells.addAll(this.processCell(level, x, y));
            }
        }
        List<Geometry> contours = this.merge(cells);
        if (this.polygonize) {
            contours = this.polygonize(contours);
        }
        if (this.normalize) {
            contours = this.normalize(contours);
        }
        return contours;
    }

    public List<Geometry> merge(List<LineString> lineStrings) {
        LineMerger cellMerger = new LineMerger();
        cellMerger.add(lineStrings);
        ArrayList<Geometry> mergedLineStrings = new ArrayList<Geometry>();
        for (Object geometry : cellMerger.getMergedLineStrings()) {
            if (!(geometry instanceof LineString)) continue;
            LineString lineString = (LineString)geometry;
            mergedLineStrings.add(new GeometryFixer((Geometry)lineString).getResult());
        }
        return mergedLineStrings;
    }

    private List<Geometry> polygonize(List<Geometry> geometries) {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>(geometries.stream().map(Geometry::getCoordinates).map(arg_0 -> ((GeometryFactory)GEOMETRY_FACTORY).createPolygon(arg_0)).map(polygon -> new GeometryFixer((Geometry)polygon).getResult()).map(Polygon.class::cast).sorted((a, b) -> Double.compare(b.getArea(), a.getArea())).toList());
        ArrayList<Geometry> polygonized = new ArrayList<Geometry>();
        for (int i = 0; i < polygons.size(); ++i) {
            if (polygons.get(i) == null) continue;
            Polygon shell = polygons.get(i);
            ArrayList<Polygon> holes = new ArrayList<Polygon>();
            for (int j = i + 1; j < polygons.size(); ++j) {
                Polygon polygon2;
                if (polygons.get(j) == null || !shell.contains((Geometry)(polygon2 = polygons.get(j)))) continue;
                boolean within = false;
                for (Polygon hole : holes) {
                    if (!hole.contains((Geometry)polygon2)) continue;
                    within = true;
                    break;
                }
                if (within) continue;
                holes.add(polygon2);
                polygons.set(j, null);
            }
            Polygon combinedPolygon = GEOMETRY_FACTORY.createPolygon(shell.getExteriorRing(), (LinearRing[])holes.stream().map(Polygon::getExteriorRing).toArray(LinearRing[]::new));
            polygonized.add((Geometry)combinedPolygon);
            polygons.set(i, null);
        }
        return polygonized;
    }

    private List<Geometry> normalize(List<Geometry> contours) {
        NormalizationTransformer transformer = new NormalizationTransformer();
        return contours.stream().map(geometry -> transformer.transform(geometry.copy())).toList();
    }

    public List<Geometry> traceContours(int start, int end, int interval) {
        ContourTracer.validateInput(this.grid, this.width, this.height);
        ArrayList<Geometry> contours = new ArrayList<Geometry>();
        for (int level = start; level < end; level += interval) {
            contours.addAll(this.traceContours(level));
        }
        return contours;
    }

    private static void validateInput(double[] grid, int width, int height) {
        if (grid == null || grid.length == 0) {
            throw new IllegalArgumentException("Grid array cannot be null or empty");
        }
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Width and height must be positive");
        }
        if (grid.length != width * height) {
            throw new IllegalArgumentException("Grid array length does not match width * height");
        }
    }

    private List<LineString> processCell(double level, int x, int y) {
        ArrayList<LineString> segments = new ArrayList<LineString>();
        boolean htb = this.polygonize && y == this.height - 2;
        boolean hrb = this.polygonize && x == this.width - 2;
        boolean hbb = this.polygonize && y == 0;
        boolean hlb = this.polygonize && x == 0;
        Coordinate tlc = new Coordinate((double)x, (double)y + 1.0);
        Coordinate tmc = this.interpolateCoordinate(level, x, y + 1, x + 1, y + 1);
        Coordinate trc = new Coordinate((double)x + 1.0, (double)y + 1.0);
        Coordinate mrc = this.interpolateCoordinate(level, x + 1, y, x + 1, y + 1);
        Coordinate brc = new Coordinate((double)x + 1.0, (double)y);
        Coordinate bmc = this.interpolateCoordinate(level, x, y, x + 1, y);
        Coordinate blc = new Coordinate((double)x, (double)y);
        Coordinate mlc = this.interpolateCoordinate(level, x, y, x, y + 1);
        double tlv = this.grid[y * this.width + x];
        double trv = this.grid[y * this.width + (x + 1)];
        double brv = this.grid[(y + 1) * this.width + (x + 1)];
        double blv = this.grid[(y + 1) * this.width + x];
        int index = (tlv >= level ? 1 : 0) | (trv >= level ? 2 : 0) | (brv >= level ? 4 : 0) | (blv >= level ? 8 : 0);
        switch (index) {
            case 1: {
                segments.add(this.createSegment(mlc, bmc));
                if (hbb) {
                    segments.add(this.createSegment(bmc, blc));
                }
                if (!hlb) break;
                segments.add(this.createSegment(blc, mlc));
                break;
            }
            case 2: {
                segments.add(this.createSegment(bmc, mrc));
                if (hrb) {
                    segments.add(this.createSegment(mrc, brc));
                }
                if (!hbb) break;
                segments.add(this.createSegment(brc, bmc));
                break;
            }
            case 3: {
                segments.add(this.createSegment(mlc, mrc));
                if (hrb) {
                    segments.add(this.createSegment(mrc, brc));
                }
                if (hbb) {
                    segments.add(this.createSegment(brc, blc));
                }
                if (!hlb) break;
                segments.add(this.createSegment(blc, mlc));
                break;
            }
            case 4: {
                segments.add(this.createSegment(mrc, tmc));
                if (htb) {
                    segments.add(this.createSegment(tmc, trc));
                }
                if (!hrb) break;
                segments.add(this.createSegment(trc, mrc));
                break;
            }
            case 5: {
                segments.add(this.createSegment(mlc, tmc));
                if (htb) {
                    segments.add(this.createSegment(tmc, trc));
                }
                if (hrb) {
                    segments.add(this.createSegment(trc, mrc));
                }
                segments.add(this.createSegment(mrc, bmc));
                if (hbb) {
                    segments.add(this.createSegment(bmc, blc));
                }
                if (!hlb) break;
                segments.add(this.createSegment(blc, mlc));
                break;
            }
            case 6: {
                segments.add(this.createSegment(bmc, tmc));
                if (htb) {
                    segments.add(this.createSegment(tmc, trc));
                }
                if (hrb) {
                    segments.add(this.createSegment(trc, brc));
                }
                if (!hbb) break;
                segments.add(this.createSegment(brc, bmc));
                break;
            }
            case 7: {
                segments.add(this.createSegment(mlc, tmc));
                if (htb) {
                    segments.add(this.createSegment(tmc, trc));
                }
                if (hrb) {
                    segments.add(this.createSegment(trc, brc));
                }
                if (hbb) {
                    segments.add(this.createSegment(brc, blc));
                }
                if (!hlb) break;
                segments.add(this.createSegment(blc, mlc));
                break;
            }
            case 8: {
                segments.add(this.createSegment(tmc, mlc));
                if (hlb) {
                    segments.add(this.createSegment(mlc, tlc));
                }
                if (!htb) break;
                segments.add(this.createSegment(tlc, tmc));
                break;
            }
            case 9: {
                segments.add(this.createSegment(tmc, bmc));
                if (hbb) {
                    segments.add(this.createSegment(bmc, blc));
                }
                if (hlb) {
                    segments.add(this.createSegment(blc, tlc));
                }
                if (!htb) break;
                segments.add(this.createSegment(tlc, tmc));
                break;
            }
            case 10: {
                segments.add(this.createSegment(bmc, mlc));
                if (hlb) {
                    segments.add(this.createSegment(mlc, tlc));
                }
                if (htb) {
                    segments.add(this.createSegment(tlc, tmc));
                }
                segments.add(this.createSegment(tmc, mrc));
                if (hrb) {
                    segments.add(this.createSegment(mrc, brc));
                }
                if (!hbb) break;
                segments.add(this.createSegment(brc, bmc));
                break;
            }
            case 11: {
                segments.add(this.createSegment(tmc, mrc));
                if (hrb) {
                    segments.add(this.createSegment(mrc, brc));
                }
                if (hbb) {
                    segments.add(this.createSegment(brc, blc));
                }
                if (hlb) {
                    segments.add(this.createSegment(blc, tlc));
                }
                if (!htb) break;
                segments.add(this.createSegment(tlc, tmc));
                break;
            }
            case 12: {
                segments.add(this.createSegment(mrc, mlc));
                if (hlb) {
                    segments.add(this.createSegment(mlc, tlc));
                }
                if (htb) {
                    segments.add(this.createSegment(tlc, trc));
                }
                if (!hrb) break;
                segments.add(this.createSegment(trc, mrc));
                break;
            }
            case 13: {
                segments.add(this.createSegment(mrc, bmc));
                if (hbb) {
                    segments.add(this.createSegment(bmc, blc));
                }
                if (hlb) {
                    segments.add(this.createSegment(blc, tlc));
                }
                if (htb) {
                    segments.add(this.createSegment(tlc, trc));
                }
                if (!hrb) break;
                segments.add(this.createSegment(trc, mrc));
                break;
            }
            case 14: {
                segments.add(this.createSegment(bmc, mlc));
                if (hlb) {
                    segments.add(this.createSegment(mlc, tlc));
                }
                if (htb) {
                    segments.add(this.createSegment(tlc, trc));
                }
                if (hrb) {
                    segments.add(this.createSegment(trc, brc));
                }
                if (!hbb) break;
                segments.add(this.createSegment(brc, bmc));
                break;
            }
            case 15: {
                if (htb) {
                    segments.add(this.createSegment(tlc, trc));
                }
                if (hrb) {
                    segments.add(this.createSegment(trc, brc));
                }
                if (hbb) {
                    segments.add(this.createSegment(brc, blc));
                }
                if (!hlb) break;
                segments.add(this.createSegment(blc, tlc));
                break;
            }
        }
        return segments;
    }

    private LineString createSegment(Coordinate c1, Coordinate c2) {
        return GEOMETRY_FACTORY.createLineString(new Coordinate[]{c1, c2});
    }

    private Coordinate interpolateCoordinate(double level, int x1, int y1, int x2, int y2) {
        double t;
        double v2 = this.grid[y2 * this.width + x2];
        double v1 = this.grid[y1 * this.width + x1];
        double d = t = Math.abs(v2 - v1) < 1.0E-10 ? 0.5 : (level - v1) / (v2 - v1);
        if (t < 1.0E-10) {
            t = 1.0E-10;
        } else if (t > 0.9999999999) {
            t = 0.9999999999;
        }
        double x = (double)x1 + t * (double)(x2 - x1);
        double y = (double)y1 + t * (double)(y2 - y1);
        return new Coordinate(x, y);
    }

    private class NormalizationTransformer
    extends GeometryTransformer {
        private NormalizationTransformer() {
        }

        protected CoordinateSequence transformCoordinates(CoordinateSequence coords, Geometry parent) {
            for (int i = 0; i < coords.size(); ++i) {
                Coordinate coordinate = coords.getCoordinate(i);
                double x = coordinate.getX() / (double)ContourTracer.this.width * (double)(ContourTracer.this.width + 1);
                double y = coordinate.getY() / (double)ContourTracer.this.height * (double)(ContourTracer.this.height + 1);
                coords.setOrdinate(i, 0, x);
                coords.setOrdinate(i, 1, y);
            }
            return coords;
        }
    }
}

