/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ManagerException;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.appender.ManagerRegistry;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.status.StatusLogger;

public abstract class AbstractManager
implements AutoCloseable {
    protected static final Logger LOGGER = StatusLogger.getLogger();
    private static final ManagerRegistry REGISTRY = new ManagerRegistry();
    protected int count;
    protected final Lock writeLock = new ReentrantLock();
    private final String name;
    private final LoggerContext loggerContext;

    protected AbstractManager(LoggerContext loggerContext, String name) {
        this.loggerContext = loggerContext;
        this.name = name;
        LOGGER.debug("Starting {} {}", (Object)this.getClass().getSimpleName(), (Object)name);
    }

    @Override
    public void close() {
        this.stop(0L, AbstractLifeCycle.DEFAULT_STOP_TIMEUNIT);
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        return REGISTRY.releaseManager(this, timeout, timeUnit);
    }

    public static <M extends AbstractManager, T> M getManager(String name, ManagerFactory<M, T> factory, T data) {
        return REGISTRY.getOrCreateManager(name, factory, data);
    }

    public void updateData(Object data) {
    }

    public static boolean hasManager(String name) {
        return REGISTRY.hasManager(name);
    }

    protected static <M extends AbstractManager> M narrow(Class<M> narrowClass, AbstractManager manager) {
        try {
            return (M)((AbstractManager)narrowClass.cast(manager));
        }
        catch (ClassCastException e) {
            throw new ManagerException("Configuration has multiple incompatible Appenders pointing to the same resource '" + manager.getName() + "'", e);
        }
    }

    protected static StatusLogger logger() {
        return StatusLogger.getLogger();
    }

    protected boolean releaseSub(long timeout, TimeUnit timeUnit) {
        return true;
    }

    protected int getCount() {
        return this.count;
    }

    public LoggerContext getLoggerContext() {
        return this.loggerContext;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getContentFormat() {
        return new HashMap<String, String>();
    }

    protected StrSubstitutor getStrSubstitutor() {
        if (this.loggerContext == null) {
            return null;
        }
        Configuration configuration = this.loggerContext.getConfiguration();
        if (configuration == null) {
            return null;
        }
        return configuration.getStrSubstitutor();
    }

    protected void log(Level level, String message, Throwable throwable) {
        Message m = LOGGER.getMessageFactory().newMessage("{} {} {}: {}", (Object)this.getClass().getSimpleName(), (Object)this.getName(), (Object)message, (Object)throwable);
        LOGGER.log(level, m, throwable);
    }

    protected void logDebug(String message, Throwable throwable) {
        this.log(Level.DEBUG, message, throwable);
    }

    protected void logError(String message, Throwable throwable) {
        this.log(Level.ERROR, message, throwable);
    }

    protected void logWarn(String message, Throwable throwable) {
        this.log(Level.WARN, message, throwable);
    }

    protected static abstract class AbstractFactoryData {
        private final Configuration configuration;

        protected AbstractFactoryData(Configuration configuration) {
            this.configuration = configuration;
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }
    }
}

