/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.schema;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.cache.query.index.SortOrder;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyDefinition;
import org.apache.ignite.internal.processors.cache.GridCacheContextInfo;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.QueryField;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.IgniteScalarFunction;
import org.apache.ignite.internal.processors.query.calcite.schema.CacheIndexImpl;
import org.apache.ignite.internal.processors.query.calcite.schema.CacheTableDescriptor;
import org.apache.ignite.internal.processors.query.calcite.schema.CacheTableDescriptorImpl;
import org.apache.ignite.internal.processors.query.calcite.schema.CacheTableImpl;
import org.apache.ignite.internal.processors.query.calcite.schema.ColumnDescriptor;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteCacheTable;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteIndex;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteSchema;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteTable;
import org.apache.ignite.internal.processors.query.calcite.schema.SchemaHolder;
import org.apache.ignite.internal.processors.query.calcite.schema.SystemViewTableDescriptorImpl;
import org.apache.ignite.internal.processors.query.calcite.schema.SystemViewTableImpl;
import org.apache.ignite.internal.processors.query.calcite.trait.TraitUtils;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeFactory;
import org.apache.ignite.internal.processors.query.calcite.util.AbstractService;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.processors.query.schema.SchemaChangeListener;
import org.apache.ignite.internal.processors.query.schema.management.IndexDescriptor;
import org.apache.ignite.internal.processors.subscription.GridInternalSubscriptionProcessor;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.spi.systemview.view.SystemView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaHolderImpl
extends AbstractService
implements SchemaHolder,
SchemaChangeListener {
    private final Map<String, IgniteSchema> igniteSchemas = new HashMap<String, IgniteSchema>();
    private final GridKernalContext ctx;
    private GridInternalSubscriptionProcessor subscriptionProcessor;
    private volatile SchemaPlus calciteSchema;

    public SchemaHolderImpl(GridKernalContext ctx) {
        super(ctx);
        this.ctx = ctx;
        this.subscriptionProcessor(ctx.internalSubscriptionProcessor());
        this.init();
    }

    public void subscriptionProcessor(GridInternalSubscriptionProcessor subscriptionProcessor) {
        this.subscriptionProcessor = subscriptionProcessor;
    }

    @Override
    public void init() {
        this.subscriptionProcessor.registerSchemaChangeListener((SchemaChangeListener)this);
    }

    @Override
    public void onStart(GridKernalContext ctx) {
    }

    public void onSchemaCreated(String schemaName) {
        this.igniteSchemas.putIfAbsent(schemaName, new IgniteSchema(schemaName));
        this.rebuild();
    }

    public void onSchemaDropped(String schemaName) {
        this.igniteSchemas.remove(schemaName);
        this.rebuild();
    }

    public void onSqlTypeCreated(String schemaName, GridQueryTypeDescriptor typeDesc, GridCacheContextInfo<?, ?> cacheInfo) {
        this.publishTable(schemaName, typeDesc.tableName(), this.createTable(typeDesc, cacheInfo));
    }

    public void onColumnsAdded(String schemaName, GridQueryTypeDescriptor typeDesc, GridCacheContextInfo<?, ?> cacheInfo, List<QueryField> cols) {
        IgniteCacheTable oldTbl = this.table(schemaName, typeDesc.tableName());
        assert (oldTbl != null);
        IgniteCacheTable newTbl = this.createTable(typeDesc, cacheInfo);
        for (IgniteIndex idx : oldTbl.indexes().values()) {
            CacheIndexImpl idx0 = (CacheIndexImpl)idx;
            newTbl.addIndex(new CacheIndexImpl(idx0.collation(), idx0.name(), idx0.queryIndex(), newTbl));
        }
        this.publishTable(schemaName, typeDesc.tableName(), newTbl);
    }

    public void onColumnsDropped(String schemaName, GridQueryTypeDescriptor typeDesc, GridCacheContextInfo<?, ?> cacheInfo, List<String> cols) {
        IgniteCacheTable oldTbl = this.table(schemaName, typeDesc.tableName());
        assert (oldTbl != null);
        IgniteCacheTable newTbl = this.createTable(typeDesc, cacheInfo);
        int colsCnt = oldTbl.descriptor().columnDescriptors().size();
        ImmutableBitSet.Builder retainedCols = ImmutableBitSet.builder();
        retainedCols.set(0, colsCnt);
        for (String droppedCol : cols) {
            retainedCols.clear(oldTbl.descriptor().columnDescriptor(droppedCol).fieldIndex());
        }
        Mappings.TargetMapping mapping = Commons.mapping(retainedCols.build(), colsCnt);
        for (IgniteIndex idx : oldTbl.indexes().values()) {
            CacheIndexImpl idx0 = (CacheIndexImpl)idx;
            newTbl.addIndex(new CacheIndexImpl(RelCollations.permute((RelCollation)idx0.collation(), (Mappings.TargetMapping)mapping), idx0.name(), idx0.queryIndex(), newTbl));
        }
        this.publishTable(schemaName, typeDesc.tableName(), newTbl);
    }

    private IgniteCacheTable createTable(GridQueryTypeDescriptor typeDesc, GridCacheContextInfo<?, ?> cacheInfo) {
        CacheTableDescriptorImpl desc = new CacheTableDescriptorImpl(cacheInfo, typeDesc, SchemaHolderImpl.affinityIdentity(cacheInfo.config()));
        return new CacheTableImpl(this.ctx, desc);
    }

    private void publishTable(String schemaName, String tblName, IgniteTable tbl) {
        IgniteSchema schema = this.igniteSchemas.computeIfAbsent(schemaName, IgniteSchema::new);
        schema.addTable(tblName, tbl);
        this.rebuild();
    }

    private static Object affinityIdentity(CacheConfiguration<?, ?> ccfg) {
        if (ccfg.getCacheMode() == CacheMode.PARTITIONED) {
            return new AffinityIdentity(ccfg.getAffinity(), ccfg.getBackups(), (IgnitePredicate<ClusterNode>)ccfg.getNodeFilter());
        }
        return null;
    }

    public void onSqlTypeDropped(String schemaName, GridQueryTypeDescriptor typeDesc, boolean destroy) {
        IgniteSchema schema = this.igniteSchemas.computeIfAbsent(schemaName, IgniteSchema::new);
        schema.removeTable(typeDesc.tableName());
        this.rebuild();
    }

    public void onIndexCreated(String schemaName, String tblName, String idxName, IndexDescriptor idxDesc) {
        IgniteCacheTable tbl = this.table(schemaName, tblName);
        assert (tbl != null);
        RelCollation idxCollation = SchemaHolderImpl.deriveSecondaryIndexCollation(idxDesc, tbl);
        CacheIndexImpl idx = new CacheIndexImpl(idxCollation, idxName, idxDesc.index(), tbl);
        tbl.addIndex(idx);
    }

    @NotNull
    private static RelCollation deriveSecondaryIndexCollation(IndexDescriptor idxDesc, IgniteCacheTable tbl) {
        CacheTableDescriptor tblDesc = tbl.descriptor();
        ArrayList<RelFieldCollation> collations = new ArrayList<RelFieldCollation>(idxDesc.keyDefinitions().size());
        for (Map.Entry keyDef : idxDesc.keyDefinitions().entrySet()) {
            ColumnDescriptor fieldDesc = tblDesc.columnDescriptor((String)keyDef.getKey());
            assert (fieldDesc != null);
            boolean descending = ((IndexKeyDefinition)keyDef.getValue()).order().sortOrder() == SortOrder.DESC;
            int fieldIdx = fieldDesc.fieldIndex();
            collations.add(TraitUtils.createFieldCollation(fieldIdx, !descending));
        }
        return RelCollations.of(collations);
    }

    public void onIndexDropped(String schemaName, String tblName, String idxName) {
        IgniteCacheTable tbl = this.table(schemaName, tblName);
        assert (tbl != null);
        tbl.removeIndex(idxName);
        this.rebuild();
    }

    public void onIndexRebuildStarted(String schemaName, String tblName) {
        IgniteCacheTable tbl = this.table(schemaName, tblName);
        assert (tbl != null);
        tbl.markIndexRebuildInProgress(true);
    }

    public void onIndexRebuildFinished(String schemaName, String tblName) {
        IgniteCacheTable tbl = this.table(schemaName, tblName);
        assert (tbl != null);
        tbl.markIndexRebuildInProgress(false);
    }

    public void onFunctionCreated(String schemaName, String name, boolean deterministic, Method method) {
        IgniteSchema schema = this.igniteSchemas.computeIfAbsent(schemaName, IgniteSchema::new);
        schema.addFunction(name.toUpperCase(), (Function)IgniteScalarFunction.create(method));
        this.rebuild();
    }

    public void onSystemViewCreated(String schemaName, SystemView<?> sysView) {
        IgniteSchema schema = this.igniteSchemas.computeIfAbsent(schemaName, IgniteSchema::new);
        SystemViewTableDescriptorImpl desc = new SystemViewTableDescriptorImpl(sysView);
        schema.addTable(desc.name(), new SystemViewTableImpl(desc));
        this.rebuild();
    }

    public void onViewCreated(String schemaName, String viewName, String viewSql) {
        IgniteSchema schema = this.igniteSchemas.computeIfAbsent(schemaName, IgniteSchema::new);
        schema.addView(viewName, viewSql);
        this.rebuild();
    }

    public void onViewDropped(String schemaName, String viewName) {
        IgniteSchema schema = this.igniteSchemas.get(schemaName);
        if (schema != null) {
            schema.removeView(viewName);
            this.rebuild();
        }
    }

    @Override
    public SchemaPlus schema(@Nullable String schema) {
        return schema != null ? this.calciteSchema.getSubSchema(schema) : this.calciteSchema;
    }

    private IgniteCacheTable table(String schemaName, String tableName) {
        IgniteSchema schema = this.igniteSchemas.get(schemaName);
        if (schema != null) {
            return (IgniteCacheTable)schema.getTable(tableName);
        }
        return null;
    }

    private void rebuild() {
        SchemaPlus newCalciteSchema = Frameworks.createRootSchema((boolean)false);
        newCalciteSchema.add("UUID", typeFactory -> ((IgniteTypeFactory)((Object)typeFactory)).createCustomType((Type)((Object)UUID.class)));
        newCalciteSchema.add("OTHER", typeFactory -> ((IgniteTypeFactory)((Object)typeFactory)).createCustomType((Type)((Object)Object.class)));
        newCalciteSchema.add("PUBLIC", (Schema)new IgniteSchema("PUBLIC"));
        for (IgniteSchema schema : this.igniteSchemas.values()) {
            schema.register(newCalciteSchema);
        }
        this.calciteSchema = newCalciteSchema;
    }

    private static class AffinityIdentity {
        private final Class<?> affFuncCls;
        private final int backups;
        private final int partsCnt;
        private final Class<?> filterCls;
        private final int hash;

        public AffinityIdentity(AffinityFunction aff, int backups, IgnitePredicate<ClusterNode> nodeFilter) {
            this.affFuncCls = aff.getClass();
            this.backups = backups;
            this.partsCnt = aff.partitions();
            this.filterCls = nodeFilter == null ? CacheConfiguration.IgniteAllNodesPredicate.class : nodeFilter.getClass();
            int hash = backups;
            hash = 31 * hash + this.affFuncCls.hashCode();
            hash = 31 * hash + this.filterCls.hashCode();
            this.hash = hash = 31 * hash + this.partsCnt;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AffinityIdentity identity = (AffinityIdentity)o;
            return this.backups == identity.backups && this.affFuncCls == identity.affFuncCls && this.filterCls == identity.filterCls && this.partsCnt == identity.partsCnt;
        }

        public String toString() {
            return S.toString(AffinityIdentity.class, (Object)this);
        }
    }
}

