/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.schema.management;

import java.util.LinkedHashMap;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.internal.cache.query.index.Index;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyDefinition;
import org.apache.ignite.internal.processors.query.schema.management.TableDescriptor;

public class IndexDescriptor {
    private final String name;
    private final QueryIndexType type;
    private final LinkedHashMap<String, IndexKeyDefinition> keyDefs;
    private final boolean isPk;
    private final boolean isAff;
    private final int inlineSize;
    private final Index idx;
    private final TableDescriptor tbl;
    private final IndexDescriptor targetIdx;

    public IndexDescriptor(TableDescriptor tbl, String name, QueryIndexType type, LinkedHashMap<String, IndexKeyDefinition> keyDefs, boolean isPk, boolean isAff, int inlineSize, Index idx) {
        this.tbl = tbl;
        this.name = name;
        this.type = type;
        this.keyDefs = keyDefs;
        this.isPk = isPk;
        this.isAff = isAff;
        this.targetIdx = null;
        this.inlineSize = inlineSize;
        this.idx = idx;
    }

    public IndexDescriptor(String name, LinkedHashMap<String, IndexKeyDefinition> keyDefs, IndexDescriptor targetIdx) {
        this.name = name;
        this.keyDefs = keyDefs;
        this.isPk = false;
        this.isAff = false;
        this.targetIdx = targetIdx;
        this.tbl = targetIdx.table();
        this.type = targetIdx.type();
        this.inlineSize = targetIdx.inlineSize();
        this.idx = targetIdx.index();
    }

    public String name() {
        return this.name;
    }

    public QueryIndexType type() {
        return this.type;
    }

    public LinkedHashMap<String, IndexKeyDefinition> keyDefinitions() {
        return this.keyDefs;
    }

    public boolean isPk() {
        return this.isPk;
    }

    public boolean isAffinity() {
        return this.isAff;
    }

    public boolean isProxy() {
        return this.targetIdx != null;
    }

    public int inlineSize() {
        return this.inlineSize;
    }

    public Index index() {
        return this.idx;
    }

    public IndexDescriptor targetIdx() {
        return this.targetIdx;
    }

    public TableDescriptor table() {
        return this.tbl;
    }
}

