/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.pagemem;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.events.PageReplacementStartedEvent;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRowCache;
import org.apache.ignite.internal.managers.encryption.GridEncryptionManager;
import org.apache.ignite.internal.mem.DirectMemoryProvider;
import org.apache.ignite.internal.mem.DirectMemoryRegion;
import org.apache.ignite.internal.mem.IgniteOutOfMemoryException;
import org.apache.ignite.internal.metric.IoStatisticsHolder;
import org.apache.ignite.internal.metric.IoStatisticsHolderNoOp;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.PageIdAllocator;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.record.CheckpointRecord;
import org.apache.ignite.internal.pagemem.wal.record.PageSnapshot;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.InitNewPageRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.CheckpointLockStateChecker;
import org.apache.ignite.internal.processors.cache.persistence.DataRegionMetricsImpl;
import org.apache.ignite.internal.processors.cache.persistence.PageStoreWriter;
import org.apache.ignite.internal.processors.cache.persistence.StorageException;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.CheckpointMetricsTracker;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.CheckpointPages;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.ClockPageReplacementPolicyFactory;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.DelayedPageReplacementTracker;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.FullPageIdTable;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.LoadedPagesMap;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageHeader;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryEx;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMetrics;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PagePool;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageReadWriteManager;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageReplacementPolicy;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageReplacementPolicyFactory;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PagesWriteSpeedBasedThrottle;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PagesWriteThrottle;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PagesWriteThrottlePolicy;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.RandomLruPageReplacementPolicyFactory;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.RobinHoodBackwardShiftHashMap;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.SegmentedLruPageReplacementPolicyFactory;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.AbstractDataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.DataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.TrackingPageIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.IgniteDataIntegrityViolationException;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.GridMultiCollectionWrapper;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.OffheapReadWriteLock;
import org.apache.ignite.internal.util.future.CountDownFuture;
import org.apache.ignite.internal.util.lang.GridPlainRunnable;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteOutClosure;
import org.apache.ignite.spi.encryption.noop.NoopEncryptionSpi;
import org.apache.ignite.thread.IgniteThreadFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PageMemoryImpl
implements PageMemoryEx {
    public static final long RELATIVE_PTR_MASK = 0xFFFFFFFFFFFFFFL;
    static final long INVALID_REL_PTR = 0xFFFFFFFFFFFFFFL;
    static final long OUTDATED_REL_PTR = 0x100000000000000L;
    public static final int PAGE_LOCK_OFFSET = 32;
    public static final int PAGE_OVERHEAD = 48;
    public static final int TRY_AGAIN_TAG = -1;
    public static final boolean DFLT_DELAYED_REPLACED_PAGE_WRITE = true;
    public static final boolean DFLT_LOADED_PAGES_BACKWARD_SHIFT_MAP = true;
    private static final TrackingPageIO trackingIO = TrackingPageIO.VERSIONS.latest();
    public static final String CHECKPOINT_POOL_OVERFLOW_ERROR_MSG = "Failed to allocate temporary buffer for checkpoint (increase checkpointPageBufferSize configuration property)";
    private final int sysPageSize;
    private final int encPageSize;
    private final GridCacheSharedContext<?, ?> ctx;
    private final CheckpointLockStateChecker stateChecker;
    private final boolean useBackwardShiftMap = IgniteSystemProperties.getBoolean("IGNITE_LOADED_PAGES_BACKWARD_SHIFT_MAP", true);
    private final PageReplacementPolicyFactory pageReplacementPolicyFactory;
    private final ExecutorService asyncRunner;
    private final PageReadWriteManager pmPageMgr;
    private final IgniteWriteAheadLogManager walMgr;
    private final GridEncryptionManager encMgr;
    private final boolean encryptionDisabled;
    private final IgniteLogger log;
    private final DirectMemoryProvider directMemoryProvider;
    private volatile Segment[] segments;
    private final AtomicBoolean safeToUpdate = new AtomicBoolean(true);
    private final Object segmentsLock = new Object();
    private PagePool checkpointPool;
    private final OffheapReadWriteLock rwLock;
    private final PageStoreWriter flushDirtyPage;
    @Nullable
    private final DelayedPageReplacementTracker delayedPageReplacementTracker;
    private final boolean trackable;
    private PagesWriteThrottlePolicy writeThrottle;
    private final ThrottlingPolicy throttlingPlc;
    @Nullable
    private final IgniteOutClosure<CheckpointProgress> cpProgressProvider;
    private static final AtomicIntegerFieldUpdater<PageMemoryImpl> pageReplacementWarnedFieldUpdater = AtomicIntegerFieldUpdater.newUpdater(PageMemoryImpl.class, "pageReplacementWarned");
    private volatile int pageReplacementWarned;
    private final long[] sizes;
    private final DataRegionMetricsImpl dataRegionMetrics;
    private final DataRegionConfiguration dataRegionCfg;
    private volatile boolean started;

    public PageMemoryImpl(DirectMemoryProvider directMemoryProvider, long[] sizes, GridCacheSharedContext<?, ?> ctx, PageReadWriteManager pmPageMgr, int pageSize, PageStoreWriter flushDirtyPage, boolean trackable, CheckpointLockStateChecker stateChecker, DataRegionMetricsImpl dataRegionMetrics, DataRegionConfiguration dataRegionCfg, @Nullable ThrottlingPolicy throttlingPlc, IgniteOutClosure<CheckpointProgress> cpProgressProvider) {
        assert (ctx != null);
        assert (pageSize > 0);
        assert (dataRegionMetrics != null);
        this.log = ctx.logger(PageMemoryImpl.class);
        this.ctx = ctx;
        this.directMemoryProvider = directMemoryProvider;
        this.sizes = sizes;
        this.flushDirtyPage = flushDirtyPage;
        this.delayedPageReplacementTracker = IgniteSystemProperties.getBoolean("IGNITE_DELAYED_REPLACED_PAGE_WRITE", true) ? new DelayedPageReplacementTracker(pageSize, flushDirtyPage, this.log, sizes.length - 1) : null;
        this.trackable = trackable;
        this.stateChecker = stateChecker;
        this.throttlingPlc = throttlingPlc != null ? throttlingPlc : ThrottlingPolicy.CHECKPOINT_BUFFER_ONLY;
        this.cpProgressProvider = cpProgressProvider;
        this.pmPageMgr = pmPageMgr;
        this.walMgr = ctx.wal();
        this.encMgr = ctx.kernalContext().encryption();
        this.encryptionDisabled = ctx.gridConfig().getEncryptionSpi() instanceof NoopEncryptionSpi;
        assert (pmPageMgr != null);
        assert (this.walMgr != null);
        assert (this.encMgr != null);
        this.sysPageSize = pageSize + 48;
        this.encPageSize = CU.encryptedPageSize(pageSize, ctx.kernalContext().config().getEncryptionSpi());
        this.rwLock = new OffheapReadWriteLock(128);
        this.dataRegionMetrics = dataRegionMetrics;
        this.dataRegionCfg = dataRegionCfg;
        this.asyncRunner = new ThreadPoolExecutor(0, Runtime.getRuntime().availableProcessors(), 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(Runtime.getRuntime().availableProcessors()), new IgniteThreadFactory(ctx.igniteInstanceName(), "page-mem-op"));
        switch (dataRegionCfg.getPageReplacementMode()) {
            case RANDOM_LRU: {
                this.pageReplacementPolicyFactory = new RandomLruPageReplacementPolicyFactory();
                break;
            }
            case SEGMENTED_LRU: {
                this.pageReplacementPolicyFactory = new SegmentedLruPageReplacementPolicyFactory();
                break;
            }
            case CLOCK: {
                this.pageReplacementPolicyFactory = new ClockPageReplacementPolicyFactory();
                break;
            }
            default: {
                throw new IgniteException("Unexpected page replacement mode: " + dataRegionCfg.getPageReplacementMode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IgniteException {
        Object object = this.segmentsLock;
        synchronized (object) {
            DirectMemoryRegion reg;
            if (this.started) {
                return;
            }
            this.started = true;
            this.directMemoryProvider.initialize(this.sizes);
            ArrayList<DirectMemoryRegion> regions = new ArrayList<DirectMemoryRegion>(this.sizes.length);
            while ((reg = this.directMemoryProvider.nextRegion()) != null) {
                regions.add(reg);
            }
            int regs = regions.size();
            Segment[] segments = new Segment[regs - 1];
            DirectMemoryRegion cpReg = (DirectMemoryRegion)regions.get(regs - 1);
            this.checkpointPool = new PagePool(regs - 1, cpReg, this.sysPageSize, this.rwLock);
            long checkpointBuf = cpReg.size();
            long totalAllocated = 0L;
            int pages = 0;
            long totalTblSize = 0L;
            long totalReplSize = 0L;
            for (int i = 0; i < regs - 1; ++i) {
                assert (i < segments.length);
                DirectMemoryRegion reg2 = (DirectMemoryRegion)regions.get(i);
                totalAllocated += reg2.size();
                segments[i] = new Segment(i, (DirectMemoryRegion)regions.get(i), this.checkpointPool.pages() / segments.length, this.throttlingPlc);
                pages += segments[i].pages();
                totalTblSize += segments[i].tableSize();
                totalReplSize += segments[i].replacementSize();
            }
            this.initWriteThrottle();
            this.segments = segments;
            if (this.log.isInfoEnabled()) {
                this.log.info("Started page memory [memoryAllocated=" + U.readableSize(totalAllocated, false) + ", pages=" + pages + ", tableSize=" + U.readableSize(totalTblSize, false) + ", replacementSize=" + U.readableSize(totalReplSize, false) + ", checkpointBuffer=" + U.readableSize(checkpointBuf, false) + "]");
            }
        }
    }

    private void initWriteThrottle() {
        if (this.throttlingPlc == ThrottlingPolicy.SPEED_BASED) {
            this.writeThrottle = new PagesWriteSpeedBasedThrottle(this, this.cpProgressProvider, this.stateChecker, this.log);
        } else if (this.throttlingPlc == ThrottlingPolicy.TARGET_RATIO_BASED) {
            this.writeThrottle = new PagesWriteThrottle(this, this.cpProgressProvider, this.stateChecker, false, this.log);
        } else if (this.throttlingPlc == ThrottlingPolicy.CHECKPOINT_BUFFER_ONLY) {
            this.writeThrottle = new PagesWriteThrottle(this, null, this.stateChecker, true, this.log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(boolean deallocate) throws IgniteException {
        Object object = this.segmentsLock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Stopping page memory.");
            }
            U.shutdownNow(this.getClass(), this.asyncRunner, this.log);
            if (this.segments != null) {
                for (Segment seg : this.segments) {
                    seg.close();
                }
            }
            this.started = false;
            this.directMemoryProvider.shutdown(deallocate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releasePage(int grpId, long pageId, long page) {
        assert (this.started);
        Segment seg = this.segment(grpId, pageId);
        seg.readLock().lock();
        try {
            seg.releasePage(page);
        }
        finally {
            seg.readLock().unlock();
        }
    }

    @Override
    public long readLock(int grpId, long pageId, long page) {
        assert (this.started);
        return this.readLock(page, pageId, false);
    }

    @Override
    public void readUnlock(int grpId, long pageId, long page) {
        assert (this.started);
        this.readUnlockPage(page);
    }

    @Override
    public long writeLock(int grpId, long pageId, long page) {
        assert (this.started);
        return this.writeLock(grpId, pageId, page, false);
    }

    @Override
    public long writeLock(int grpId, long pageId, long page, boolean restore) {
        assert (this.started);
        return this.writeLockPage(page, new FullPageId(pageId, grpId), !restore);
    }

    @Override
    public long tryWriteLock(int grpId, long pageId, long page) {
        assert (this.started);
        return this.tryWriteLockPage(page, new FullPageId(pageId, grpId), true);
    }

    @Override
    public void writeUnlock(int grpId, long pageId, long page, Boolean walPlc, boolean dirtyFlag) {
        assert (this.started);
        this.writeUnlock(grpId, pageId, page, walPlc, dirtyFlag, false);
    }

    @Override
    public void writeUnlock(int grpId, long pageId, long page, Boolean walPlc, boolean dirtyFlag, boolean restore) {
        assert (this.started);
        this.writeUnlockPage(page, new FullPageId(pageId, grpId), walPlc, dirtyFlag, restore);
    }

    @Override
    public boolean isDirty(int grpId, long pageId, long page) {
        assert (this.started);
        return this.isDirty(page);
    }

    @Override
    public long allocatePage(int grpId, int partId, byte flags) throws IgniteCheckedException {
        boolean isTrackingPage;
        assert (flags != 2 && partId <= 65500 || flags == 2 && partId == 65535) : "flags = " + flags + ", partId = " + partId;
        assert (this.started);
        assert (this.stateChecker.checkpointLockIsHeldByThread());
        if (this.isThrottlingEnabled()) {
            this.writeThrottle.onMarkDirty(false);
        }
        long pageId = this.pmPageMgr.allocatePage(grpId, partId, flags);
        assert (PageIdUtils.pageIndex(pageId) > 0);
        Segment seg = this.segment(grpId, pageId);
        seg.writeLock().lock();
        boolean bl = isTrackingPage = this.trackable && PageIdUtils.pageIndex(trackingIO.trackingPageFor(pageId, this.realPageSize(grpId))) == PageIdUtils.pageIndex(pageId);
        if (isTrackingPage && PageIdUtils.flag(pageId) == 4) {
            pageId = PageIdUtils.pageId(PageIdUtils.partId(pageId), (byte)1, PageIdUtils.pageIndex(pageId));
        }
        FullPageId fullId = new FullPageId(pageId, grpId);
        try {
            long pageAddr;
            long relPtr = seg.loadedPages.get(grpId, PageIdUtils.effectivePageId(pageId), seg.partGeneration(grpId, partId), 0xFFFFFFFFFFFFFFL, 0x100000000000000L);
            boolean pageReplaced = false;
            if (relPtr == 0x100000000000000L) {
                relPtr = seg.refreshOutdatedPage(grpId, pageId, false);
                seg.pageReplacementPolicy.onRemove(relPtr);
                pageReplaced = true;
            }
            if (relPtr == 0xFFFFFFFFFFFFFFL) {
                relPtr = seg.borrowOrAllocateFreePage(pageId);
            }
            if (relPtr == 0xFFFFFFFFFFFFFFL) {
                relPtr = seg.removePageForReplacement();
                pageReplaced = true;
            }
            long absPtr = seg.absolute(relPtr);
            GridUnsafe.zeroMemory(absPtr + 48L, this.pageSize());
            PageHeader.fullPageId(absPtr, fullId);
            this.touchPage(absPtr, pageReplaced);
            this.rwLock.init(absPtr + 32L, PageIdUtils.tag(pageId));
            assert (PageIO.getCrc(absPtr + 48L) == 0);
            assert (!PageHeader.isAcquired(absPtr)) : "Pin counter must be 0 for a new page [relPtr=" + U.hexLong(relPtr) + ", absPtr=" + U.hexLong(absPtr) + ", pinCntr=" + PageHeader.pinCount(absPtr) + "]";
            this.setDirty(fullId, absPtr, true, true);
            if (isTrackingPage && PageIO.getType(pageAddr = absPtr + 48L) == 0) {
                PageMetrics metrics = this.dataRegionMetrics.cacheGrpPageMetrics(grpId);
                trackingIO.initNewPage(pageAddr, pageId, this.realPageSize(grpId), metrics);
                if (!this.ctx.wal().disabled(fullId.groupId(), fullId.pageId())) {
                    if (!this.ctx.wal().isAlwaysWriteFullPages()) {
                        this.ctx.wal().log(new InitNewPageRecord(grpId, pageId, trackingIO.getType(), trackingIO.getVersion(), pageId));
                    } else {
                        this.ctx.wal().log(new PageSnapshot(fullId, absPtr + 48L, this.pageSize(), this.realPageSize(fullId.groupId())));
                    }
                }
            }
            seg.pageReplacementPolicy.onMiss(relPtr);
            seg.loadedPages.put(grpId, PageIdUtils.effectivePageId(pageId), relPtr, seg.partGeneration(grpId, partId));
        }
        catch (IgniteOutOfMemoryException oom) {
            IgniteOutOfMemoryException e = new IgniteOutOfMemoryException("Out of memory in data region [name=" + this.dataRegionCfg.getName() + ", initSize=" + U.readableSize(this.dataRegionCfg.getInitialSize(), false) + ", maxSize=" + U.readableSize(this.dataRegionCfg.getMaxSize(), false) + ", persistenceEnabled=" + this.dataRegionCfg.isPersistenceEnabled() + "] Try the following:" + U.nl() + "  ^-- Increase maximum off-heap memory size (DataRegionConfiguration.maxSize)" + U.nl() + "  ^-- Enable eviction or expiration policies");
            e.initCause(oom);
            this.ctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            throw e;
        }
        finally {
            seg.writeLock().unlock();
        }
        if (this.delayedPageReplacementTracker != null) {
            this.delayedPageReplacementTracker.delayedPageWrite().finishReplacement();
        }
        return isTrackingPage ? this.allocatePage(grpId, partId, flags) : pageId;
    }

    @Override
    public ByteBuffer pageBuffer(long pageAddr) {
        return GridUnsafe.wrapPointer(pageAddr, this.pageSize());
    }

    @Override
    public boolean freePage(int grpId, long pageId) {
        assert (false) : "Free page should be never called directly when persistence is enabled.";
        return false;
    }

    @Override
    public long partitionMetaPageId(int grpId, int partId) {
        assert (this.started);
        return PageIdUtils.pageId(partId, (byte)1, 0);
    }

    @Override
    public long acquirePage(int grpId, long pageId) throws IgniteCheckedException {
        return this.acquirePage(grpId, pageId, IoStatisticsHolderNoOp.INSTANCE, false);
    }

    @Override
    public long acquirePage(int grpId, long pageId, IoStatisticsHolder statHolder) throws IgniteCheckedException {
        assert (this.started);
        return this.acquirePage(grpId, pageId, statHolder, false);
    }

    @Override
    public long acquirePage(int grpId, long pageId, AtomicBoolean pageAllocated) throws IgniteCheckedException {
        return this.acquirePage(grpId, pageId, IoStatisticsHolderNoOp.INSTANCE, false, pageAllocated);
    }

    @Override
    public long acquirePage(int grpId, long pageId, IoStatisticsHolder statHolder, boolean restore) throws IgniteCheckedException {
        return this.acquirePage(grpId, pageId, statHolder, restore, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long acquirePage(int grpId, long pageId, IoStatisticsHolder statHolder, boolean restore, @Nullable AtomicBoolean pageAllocated) throws IgniteCheckedException {
        long l;
        assert (this.started);
        int partId = PageIdUtils.partId(pageId);
        Segment seg = this.segment(grpId, pageId);
        seg.readLock().lock();
        try {
            long relPtr = seg.loadedPages.get(grpId, PageIdUtils.effectivePageId(pageId), seg.partGeneration(grpId, partId), 0xFFFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL);
            if (relPtr != 0xFFFFFFFFFFFFFFL) {
                long absPtr = seg.absolute(relPtr);
                seg.acquirePage(absPtr);
                seg.pageReplacementPolicy.onHit(relPtr);
                statHolder.trackLogicalRead(absPtr + 48L);
                long l2 = absPtr;
                return l2;
            }
        }
        finally {
            seg.readLock().unlock();
        }
        FullPageId fullId = new FullPageId(pageId, grpId);
        seg.writeLock().lock();
        long lockedPageAbsPtr = -1L;
        boolean readPageFromStore = false;
        try {
            long absPtr;
            long relPtr = seg.loadedPages.get(grpId, fullId.effectivePageId(), seg.partGeneration(grpId, partId), 0xFFFFFFFFFFFFFFL, 0x100000000000000L);
            if (relPtr == 0xFFFFFFFFFFFFFFL) {
                relPtr = seg.borrowOrAllocateFreePage(pageId);
                if (pageAllocated != null) {
                    pageAllocated.set(true);
                }
                boolean pageReplaced = false;
                if (relPtr == 0xFFFFFFFFFFFFFFL) {
                    relPtr = seg.removePageForReplacement();
                    pageReplaced = true;
                }
                absPtr = seg.absolute(relPtr);
                PageHeader.fullPageId(absPtr, fullId);
                this.touchPage(absPtr, pageReplaced);
                assert (!PageHeader.isAcquired(absPtr)) : "Pin counter must be 0 for a new page [relPtr=" + U.hexLong(relPtr) + ", absPtr=" + U.hexLong(absPtr) + "]";
                this.setDirty(fullId, absPtr, false, false);
                seg.pageReplacementPolicy.onMiss(relPtr);
                seg.loadedPages.put(grpId, fullId.effectivePageId(), relPtr, seg.partGeneration(grpId, partId));
                long pageAddr = absPtr + 48L;
                if (!restore) {
                    if (this.delayedPageReplacementTracker != null) {
                        this.delayedPageReplacementTracker.waitUnlock(fullId);
                    }
                    readPageFromStore = true;
                } else {
                    GridUnsafe.zeroMemory(absPtr + 48L, this.pageSize());
                    PageIO.setPageId(pageAddr, pageId);
                }
                this.rwLock.init(absPtr + 32L, PageIdUtils.tag(pageId));
                if (readPageFromStore) {
                    boolean locked = this.rwLock.writeLock(absPtr + 32L, -1);
                    assert (locked) : "Page ID " + fullId + " expected to be locked";
                    lockedPageAbsPtr = absPtr;
                }
            } else if (relPtr == 0x100000000000000L) {
                assert (PageIdUtils.pageIndex(pageId) == 0) : fullId;
                relPtr = seg.refreshOutdatedPage(grpId, pageId, false);
                absPtr = seg.absolute(relPtr);
                long pageAddr = absPtr + 48L;
                GridUnsafe.zeroMemory(pageAddr, this.pageSize());
                PageHeader.fullPageId(absPtr, fullId);
                this.touchPage(absPtr, true);
                PageIO.setPageId(pageAddr, pageId);
                assert (!PageHeader.isAcquired(absPtr)) : "Pin counter must be 0 for a new page [relPtr=" + U.hexLong(relPtr) + ", absPtr=" + U.hexLong(absPtr) + "]";
                this.rwLock.init(absPtr + 32L, PageIdUtils.tag(pageId));
                seg.pageReplacementPolicy.onRemove(relPtr);
                seg.pageReplacementPolicy.onMiss(relPtr);
            } else {
                absPtr = seg.absolute(relPtr);
                seg.pageReplacementPolicy.onHit(relPtr);
            }
            seg.acquirePage(absPtr);
            if (!readPageFromStore) {
                statHolder.trackLogicalRead(absPtr + 48L);
            }
            l = absPtr;
        }
        catch (IgniteOutOfMemoryException oom) {
            try {
                this.ctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, oom));
                throw oom;
            }
            catch (Throwable throwable) {
                seg.writeLock().unlock();
                if (this.delayedPageReplacementTracker != null) {
                    this.delayedPageReplacementTracker.delayedPageWrite().finishReplacement();
                }
                if (readPageFromStore) {
                    assert (lockedPageAbsPtr != -1L) : "Page is expected to have a valid address [pageId=" + fullId + ", lockedPageAbsPtr=" + U.hexLong(lockedPageAbsPtr) + "]";
                    assert (this.isPageWriteLocked(lockedPageAbsPtr)) : "Page is expected to be locked: [pageId=" + fullId + "]";
                    long pageAddr = lockedPageAbsPtr + 48L;
                    ByteBuffer buf = GridUnsafe.wrapPointer(pageAddr, this.pageSize());
                    long actualPageId = 0L;
                    long startReadTs = System.nanoTime();
                    try {
                        this.pmPageMgr.read(grpId, pageId, buf, false);
                        statHolder.trackPhysicalAndLogicalRead(pageAddr);
                        actualPageId = PageIO.getPageId(buf);
                        this.dataRegionMetrics.onPageRead(System.nanoTime() - startReadTs);
                        if (PageIO.isIndexPage(PageIO.getType(buf))) {
                            this.dataRegionMetrics.cacheGrpPageMetrics(grpId).indexPages().increment();
                        }
                        this.rwLock.writeUnlock(lockedPageAbsPtr + 32L, actualPageId == 0L ? -1 : PageIdUtils.tag(actualPageId));
                    }
                    catch (IgniteDataIntegrityViolationException e) {
                        try {
                            U.warn(this.log, "Failed to read page (data integrity violation encountered, will try to restore using existing WAL) [fullPageId=" + fullId + "]", e);
                            buf.rewind();
                            this.tryToRestorePage(fullId, buf);
                            this.setDirty(fullId, lockedPageAbsPtr, true, false);
                            this.beforeReleaseWrite(fullId, pageAddr, true);
                            statHolder.trackPhysicalAndLogicalRead(pageAddr);
                            this.dataRegionMetrics.onPageRead(System.nanoTime() - startReadTs);
                            this.rwLock.writeUnlock(lockedPageAbsPtr + 32L, actualPageId == 0L ? -1 : PageIdUtils.tag(actualPageId));
                        }
                        catch (Throwable throwable2) {
                            this.rwLock.writeUnlock(lockedPageAbsPtr + 32L, actualPageId == 0L ? -1 : PageIdUtils.tag(actualPageId));
                            throw throwable2;
                        }
                    }
                }
                throw throwable;
            }
        }
        seg.writeLock().unlock();
        if (this.delayedPageReplacementTracker != null) {
            this.delayedPageReplacementTracker.delayedPageWrite().finishReplacement();
        }
        if (readPageFromStore) {
            assert (lockedPageAbsPtr != -1L) : "Page is expected to have a valid address [pageId=" + fullId + ", lockedPageAbsPtr=" + U.hexLong(lockedPageAbsPtr) + "]";
            assert (this.isPageWriteLocked(lockedPageAbsPtr)) : "Page is expected to be locked: [pageId=" + fullId + "]";
            long pageAddr = lockedPageAbsPtr + 48L;
            ByteBuffer buf = GridUnsafe.wrapPointer(pageAddr, this.pageSize());
            long actualPageId = 0L;
            long startReadTs = System.nanoTime();
            try {
                this.pmPageMgr.read(grpId, pageId, buf, false);
                statHolder.trackPhysicalAndLogicalRead(pageAddr);
                actualPageId = PageIO.getPageId(buf);
                this.dataRegionMetrics.onPageRead(System.nanoTime() - startReadTs);
                if (PageIO.isIndexPage(PageIO.getType(buf))) {
                    this.dataRegionMetrics.cacheGrpPageMetrics(grpId).indexPages().increment();
                }
                this.rwLock.writeUnlock(lockedPageAbsPtr + 32L, actualPageId == 0L ? -1 : PageIdUtils.tag(actualPageId));
            }
            catch (IgniteDataIntegrityViolationException e) {
                try {
                    U.warn(this.log, "Failed to read page (data integrity violation encountered, will try to restore using existing WAL) [fullPageId=" + fullId + "]", e);
                    buf.rewind();
                    this.tryToRestorePage(fullId, buf);
                    this.setDirty(fullId, lockedPageAbsPtr, true, false);
                    this.beforeReleaseWrite(fullId, pageAddr, true);
                    statHolder.trackPhysicalAndLogicalRead(pageAddr);
                    this.dataRegionMetrics.onPageRead(System.nanoTime() - startReadTs);
                    this.rwLock.writeUnlock(lockedPageAbsPtr + 32L, actualPageId == 0L ? -1 : PageIdUtils.tag(actualPageId));
                }
                catch (Throwable throwable) {
                    this.rwLock.writeUnlock(lockedPageAbsPtr + 32L, actualPageId == 0L ? -1 : PageIdUtils.tag(actualPageId));
                    throw throwable;
                }
            }
        }
        return l;
    }

    private void releaseCheckpointBufferPage(long tmpBufPtr) {
        int resCntr = this.checkpointPool.releaseFreePage(tmpBufPtr);
        if (resCntr == this.checkpointBufferPagesSize() / 2 && this.writeThrottle != null) {
            this.writeThrottle.wakeupThrottledThreads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToRestorePage(FullPageId fullId, ByteBuffer buf) throws IgniteCheckedException {
        Long tmpAddr = null;
        try {
            ByteBuffer restored;
            ByteBuffer curPage = null;
            ByteBuffer lastValidPage = null;
            try (WALIterator it = this.walMgr.replay(null);){
                block13: for (IgniteBiTuple tuple : it) {
                    switch (((WALRecord)tuple.getValue()).type()) {
                        case PAGE_RECORD: {
                            PageSnapshot snapshot = (PageSnapshot)tuple.getValue();
                            if (!snapshot.fullPageId().equals(fullId)) continue block13;
                            if (tmpAddr == null) {
                                assert (snapshot.pageDataSize() <= this.pageSize()) : snapshot.pageDataSize();
                                tmpAddr = GridUnsafe.allocateMemory(this.pageSize());
                            }
                            if (curPage == null) {
                                curPage = GridUnsafe.wrapPointer(tmpAddr, this.pageSize());
                            }
                            PageUtils.putBytes(tmpAddr, 0, snapshot.pageData());
                            if (PageIO.getCompressionType(tmpAddr) == 0) continue block13;
                            int realPageSize = this.realPageSize(snapshot.groupId());
                            assert (snapshot.pageDataSize() < realPageSize) : snapshot.pageDataSize();
                            this.ctx.kernalContext().compress().decompressPage(curPage, realPageSize);
                            continue block13;
                        }
                        case CHECKPOINT_RECORD: {
                            CheckpointRecord rec = (CheckpointRecord)tuple.getValue();
                            assert (!rec.end());
                            if (curPage == null) continue block13;
                            lastValidPage = curPage;
                            curPage = null;
                            continue block13;
                        }
                        case MEMORY_RECOVERY: {
                            curPage = null;
                            continue block13;
                        }
                    }
                    if (!(tuple.getValue() instanceof PageDeltaRecord)) continue;
                    PageDeltaRecord deltaRecord = (PageDeltaRecord)tuple.getValue();
                    if (curPage == null || deltaRecord.pageId() != fullId.pageId() || deltaRecord.groupId() != fullId.groupId()) continue;
                    assert (tmpAddr != null);
                    deltaRecord.applyDelta(this, tmpAddr);
                }
            }
            ByteBuffer byteBuffer = restored = curPage == null ? lastValidPage : curPage;
            if (restored == null) {
                throw new StorageException(String.format("Page is broken. Can't restore it from WAL. (grpId = %d, pageId = %X).", fullId.groupId(), fullId.pageId()));
            }
            buf.put(restored);
        }
        finally {
            if (tmpAddr != null) {
                GridUnsafe.freeMemory(tmpAddr);
            }
        }
    }

    @Override
    public int pageSize() {
        return this.sysPageSize - 48;
    }

    @Override
    public int systemPageSize() {
        return this.sysPageSize;
    }

    @Override
    public int realPageSize(int grpId) {
        if (this.encryptionDisabled || this.encMgr.getActiveKey(grpId) == null) {
            return this.pageSize();
        }
        return this.encPageSize;
    }

    @Override
    public boolean safeToUpdate() {
        if (this.segments != null) {
            return this.safeToUpdate.get();
        }
        return true;
    }

    boolean shouldThrottle(double dirtyRatioThreshold) {
        if (this.segments == null) {
            return false;
        }
        for (Segment segment : this.segments) {
            if (!segment.shouldThrottle(dirtyRatioThreshold)) continue;
            return true;
        }
        return false;
    }

    double getDirtyPagesRatio() {
        if (this.segments == null) {
            return 0.0;
        }
        double res = 0.0;
        for (Segment segment : this.segments) {
            res = Math.max(res, segment.getDirtyPagesRatio());
        }
        return res;
    }

    @Override
    public long totalPages() {
        if (this.segments == null) {
            return 0L;
        }
        long res = 0L;
        for (Segment segment : this.segments) {
            res += (long)segment.pages();
        }
        return res;
    }

    @Override
    public GridMultiCollectionWrapper<FullPageId> beginCheckpoint(IgniteInternalFuture allowToReplace) throws IgniteException {
        if (this.segments == null) {
            return new GridMultiCollectionWrapper<FullPageId>(Collections.emptyList());
        }
        Collection[] collections = new Collection[this.segments.length];
        for (int i = 0; i < this.segments.length; ++i) {
            Collection<FullPageId> dirtyPages;
            Segment seg = this.segments[i];
            if (seg.checkpointPages != null) {
                throw new IgniteException("Failed to begin checkpoint (it is already in progress).");
            }
            collections[i] = dirtyPages = seg.dirtyPages;
            seg.checkpointPages = new CheckpointPages(dirtyPages, allowToReplace);
            seg.resetDirtyPages();
        }
        this.safeToUpdate.set(true);
        this.dataRegionMetrics.resetDirtyPages();
        if (this.throttlingPlc != ThrottlingPolicy.DISABLED) {
            this.writeThrottle.onBeginCheckpoint();
        }
        return new GridMultiCollectionWrapper<FullPageId>(collections);
    }

    private boolean isThrottlingEnabled() {
        return this.throttlingPlc != ThrottlingPolicy.CHECKPOINT_BUFFER_ONLY && this.throttlingPlc != ThrottlingPolicy.DISABLED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishCheckpoint() {
        if (this.segments == null) {
            return;
        }
        Object object = this.segmentsLock;
        synchronized (object) {
            for (Segment seg : this.segments) {
                seg.checkpointPages = null;
            }
        }
        if (this.throttlingPlc != ThrottlingPolicy.DISABLED) {
            this.writeThrottle.onFinishCheckpoint();
        }
    }

    @Override
    public PageReadWriteManager pageManager() {
        return this.pmPageMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkpointWritePage(FullPageId fullId, ByteBuffer buf, PageStoreWriter pageStoreWriter, CheckpointMetricsTracker metricsTracker) throws IgniteCheckedException {
        long relPtr;
        int tag;
        assert (buf.remaining() == this.pageSize());
        Segment seg = this.segment(fullId.groupId(), fullId.pageId());
        long absPtr = 0L;
        boolean pageSingleAcquire = false;
        seg.readLock().lock();
        try {
            if (!this.isInCheckpoint(fullId)) {
                return;
            }
            tag = this.generationTag(seg, fullId);
            relPtr = this.resolveRelativePointer(seg, fullId, tag);
            if (relPtr == 0xFFFFFFFFFFFFFFL) {
                return;
            }
            if (relPtr != 0x100000000000000L) {
                absPtr = seg.absolute(relPtr);
                if (PageHeader.tempBufferPointer(absPtr) == 0xFFFFFFFFFFFFFFL) {
                    PageHeader.acquirePage(absPtr);
                } else {
                    pageSingleAcquire = true;
                }
            }
        }
        finally {
            seg.readLock().unlock();
        }
        if (relPtr == 0x100000000000000L) {
            seg.writeLock().lock();
            try {
                relPtr = this.resolveRelativePointer(seg, fullId, this.generationTag(seg, fullId));
                if (relPtr == 0xFFFFFFFFFFFFFFL) {
                    return;
                }
                if (relPtr == 0x100000000000000L) {
                    relPtr = seg.refreshOutdatedPage(fullId.groupId(), fullId.effectivePageId(), true);
                    this.dataRegionMetrics.decrementPagesWithTimestamp(PageHeader.readTimestamp(seg.absolute(relPtr)));
                    seg.pageReplacementPolicy.onRemove(relPtr);
                    seg.pool.releaseFreePage(relPtr);
                }
                return;
            }
            finally {
                seg.writeLock().unlock();
            }
        }
        this.copyPageForCheckpoint(absPtr, fullId, buf, tag, pageSingleAcquire, pageStoreWriter, metricsTracker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyPageForCheckpoint(long absPtr, FullPageId fullId, ByteBuffer buf, Integer tag, boolean pageSingleAcquire, PageStoreWriter pageStoreWriter, CheckpointMetricsTracker tracker) throws IgniteCheckedException {
        assert (absPtr != 0L);
        assert (PageHeader.isAcquired(absPtr) || !this.isInCheckpoint(fullId));
        boolean canWrite = false;
        boolean locked = this.rwLock.tryWriteLock(absPtr + 32L, -1);
        if (!locked) {
            if (!pageSingleAcquire) {
                PageHeader.releasePage(absPtr);
            }
            buf.clear();
            if (this.isInCheckpoint(fullId)) {
                pageStoreWriter.writePage(fullId, buf, -1);
            }
            return;
        }
        if (!this.clearCheckpoint(fullId)) {
            this.rwLock.writeUnlock(absPtr + 32L, -1);
            if (!pageSingleAcquire) {
                PageHeader.releasePage(absPtr);
            }
            return;
        }
        try {
            long tmpRelPtr = PageHeader.tempBufferPointer(absPtr);
            if (tmpRelPtr != 0xFFFFFFFFFFFFFFL) {
                PageHeader.tempBufferPointer(absPtr, 0xFFFFFFFFFFFFFFL);
                long tmpAbsPtr = this.checkpointPool.absolute(tmpRelPtr);
                this.copyInBuffer(tmpAbsPtr, buf);
                PageHeader.fullPageId(tmpAbsPtr, FullPageId.NULL_PAGE);
                GridUnsafe.zeroMemory(tmpAbsPtr + 48L, this.pageSize());
                if (tracker != null) {
                    tracker.onCowPageWritten();
                }
                this.releaseCheckpointBufferPage(tmpRelPtr);
                if (!pageSingleAcquire) {
                    PageHeader.releasePage(absPtr);
                }
            } else {
                this.copyInBuffer(absPtr, buf);
                PageHeader.dirty(absPtr, false);
            }
            assert (PageIO.getType(buf) != 0) : "Invalid state. Type is 0! pageId = " + U.hexLong(fullId.pageId());
            assert (PageIO.getVersion(buf) != 0) : "Invalid state. Version is 0! pageId = " + U.hexLong(fullId.pageId());
            canWrite = true;
        }
        finally {
            this.rwLock.writeUnlock(absPtr + 32L, -1);
            if (canWrite) {
                buf.rewind();
                pageStoreWriter.writePage(fullId, buf, tag);
                this.dataRegionMetrics.onPageWritten();
                buf.rewind();
            }
            PageHeader.releasePage(absPtr);
        }
    }

    private void copyInBuffer(long absPtr, ByteBuffer buf) {
        if (buf.isDirect()) {
            long tmpPtr = GridUnsafe.bufferAddress(buf);
            GridUnsafe.copyMemory(absPtr + 48L, tmpPtr, this.pageSize());
            assert (PageIO.getCrc(absPtr + 48L) == 0);
            assert (PageIO.getCrc(tmpPtr) == 0);
        } else {
            byte[] arr = buf.array();
            assert (arr != null);
            assert (arr.length == this.pageSize());
            GridUnsafe.copyMemory(null, absPtr + 48L, arr, GridUnsafe.BYTE_ARR_OFF, this.pageSize());
        }
    }

    private int generationTag(Segment seg, FullPageId fullId) {
        return seg.partGeneration(fullId.groupId(), PageIdUtils.partId(fullId.pageId()));
    }

    private long resolveRelativePointer(Segment seg, FullPageId fullId, int reqVer) {
        return seg.loadedPages.get(fullId.groupId(), fullId.effectivePageId(), reqVer, 0xFFFFFFFFFFFFFFL, 0x100000000000000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int invalidate(int grpId, int partId) {
        Object object = this.segmentsLock;
        synchronized (object) {
            if (!this.started) {
                return 0;
            }
            int tag = 0;
            for (Segment seg : this.segments) {
                seg.writeLock().lock();
                try {
                    int newTag = seg.incrementPartGeneration(grpId, partId);
                    if (tag == 0) {
                        tag = newTag;
                    }
                    if ($assertionsDisabled || tag == newTag) continue;
                    throw new AssertionError();
                }
                finally {
                    seg.writeLock().unlock();
                }
            }
            return tag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCacheGroupDestroyed(int grpId) {
        for (Segment seg : this.segments) {
            seg.writeLock().lock();
            try {
                seg.resetGroupPartitionsGeneration(grpId);
            }
            finally {
                seg.writeLock().unlock();
            }
        }
    }

    @Override
    public IgniteInternalFuture<Void> clearAsync(LoadedPagesMap.KeyPredicate pred, boolean cleanDirty) {
        CountDownFuture completeFut = new CountDownFuture(this.segments.length);
        for (Segment seg : this.segments) {
            ClearSegmentRunnable clear = new ClearSegmentRunnable(seg, this.dataRegionMetrics, pred, cleanDirty, completeFut, this.pageSize());
            try {
                this.asyncRunner.execute(clear);
            }
            catch (RejectedExecutionException ignore) {
                clear.run();
            }
        }
        return completeFut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long loadedPages() {
        long total = 0L;
        Segment[] segments = this.segments;
        if (segments != null) {
            for (Segment seg : segments) {
                if (seg == null) break;
                seg.readLock().lock();
                try {
                    if (seg.closed) continue;
                    total += (long)seg.loadedPages.size();
                }
                finally {
                    seg.readLock().unlock();
                }
            }
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long acquiredPages() {
        if (this.segments == null) {
            return 0L;
        }
        long total = 0L;
        for (Segment seg : this.segments) {
            seg.readLock().lock();
            try {
                if (seg.closed) continue;
                total += (long)seg.acquiredPages();
            }
            finally {
                seg.readLock().unlock();
            }
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLoadedPage(FullPageId fullPageId) {
        int grpId = fullPageId.groupId();
        long pageId = fullPageId.effectivePageId();
        int partId = PageIdUtils.partId(pageId);
        Segment seg = this.segment(grpId, pageId);
        seg.readLock().lock();
        try {
            long res = seg.loadedPages.get(grpId, pageId, seg.partGeneration(grpId, partId), 0xFFFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL);
            boolean bl = res != 0xFFFFFFFFFFFFFFL;
            return bl;
        }
        finally {
            seg.readLock().unlock();
        }
    }

    private long readLock(long absPtr, long pageId, boolean force) {
        return this.readLock(absPtr, pageId, force, true);
    }

    @Override
    public long readLock(long absPtr, long pageId, boolean force, boolean touch) {
        assert (this.started);
        int tag = force ? -1 : PageIdUtils.tag(pageId);
        boolean locked = this.rwLock.readLock(absPtr + 32L, tag);
        if (!locked) {
            return 0L;
        }
        if (touch) {
            this.touchPage(absPtr, true);
        }
        assert (PageIO.getCrc(absPtr + 48L) == 0);
        return absPtr + 48L;
    }

    @Override
    public long readLockForce(int grpId, long pageId, long page) {
        assert (this.started);
        return this.readLock(page, pageId, true);
    }

    void readUnlockPage(long absPtr) {
        this.rwLock.readUnlock(absPtr + 32L);
    }

    public boolean hasTempCopy(long absPtr) {
        return PageHeader.tempBufferPointer(absPtr) != 0xFFFFFFFFFFFFFFL;
    }

    long tryWriteLockPage(long absPtr, FullPageId fullId, boolean checkTag) {
        int tag;
        int n = tag = checkTag ? PageIdUtils.tag(fullId.pageId()) : -1;
        if (!this.rwLock.tryWriteLock(absPtr + 32L, tag)) {
            return 0L;
        }
        return this.postWriteLockPage(absPtr, fullId);
    }

    private long writeLockPage(long absPtr, FullPageId fullId, boolean checkTag) {
        int tag = checkTag ? PageIdUtils.tag(fullId.pageId()) : -1;
        boolean locked = this.rwLock.writeLock(absPtr + 32L, tag);
        return locked ? this.postWriteLockPage(absPtr, fullId) : 0L;
    }

    private long postWriteLockPage(long absPtr, FullPageId fullId) {
        this.touchPage(absPtr, true);
        if (this.isInCheckpoint(fullId) && PageHeader.tempBufferPointer(absPtr) == 0xFFFFFFFFFFFFFFL) {
            long tmpRelPtr = this.checkpointPool.borrowOrAllocateFreePage(PageIdUtils.tag(fullId.pageId()));
            if (tmpRelPtr == 0xFFFFFFFFFFFFFFL) {
                this.rwLock.writeUnlock(absPtr + 32L, -1);
                throw new IgniteException("Failed to allocate temporary buffer for checkpoint (increase checkpointPageBufferSize configuration property): " + this.dataRegionMetrics.getName());
            }
            PageHeader.acquirePage(absPtr);
            long tmpAbsPtr = this.checkpointPool.absolute(tmpRelPtr);
            GridUnsafe.copyMemory(null, absPtr + 48L, null, tmpAbsPtr + 48L, this.pageSize());
            assert (PageIO.getType(tmpAbsPtr + 48L) != 0) : "Invalid state. Type is 0! pageId = " + U.hexLong(fullId.pageId());
            assert (PageIO.getVersion(tmpAbsPtr + 48L) != 0) : "Invalid state. Version is 0! pageId = " + U.hexLong(fullId.pageId());
            PageHeader.dirty(absPtr, false);
            PageHeader.tempBufferPointer(absPtr, tmpRelPtr);
            PageHeader.fullPageId(tmpAbsPtr, fullId);
            assert (PageIO.getCrc(absPtr + 48L) == 0);
            assert (PageIO.getCrc(tmpAbsPtr + 48L) == 0);
        }
        assert (PageIO.getCrc(absPtr + 48L) == 0);
        return absPtr + 48L;
    }

    private void writeUnlockPage(long page, FullPageId fullId, Boolean walPlc, boolean markDirty, boolean restore) {
        boolean wasDirty = this.isDirty(page);
        try {
            boolean pageWalRec;
            boolean bl = pageWalRec = markDirty && walPlc != Boolean.FALSE && (walPlc == Boolean.TRUE || !wasDirty);
            assert (PageIO.getCrc(page + 48L) == 0);
            if (markDirty) {
                this.setDirty(fullId, page, true, false);
            }
            this.beforeReleaseWrite(fullId, page + 48L, pageWalRec);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
        finally {
            long pageId = PageIO.getPageId(page + 48L);
            try {
                assert (pageId != 0L) : U.hexLong(PageHeader.readPageId(page));
                this.rwLock.writeUnlock(page + 32L, PageIdUtils.tag(pageId));
                assert (PageIO.getVersion(page + 48L) != 0) : this.dumpPage(pageId, fullId.groupId());
                assert (PageIO.getType(page + 48L) != 0) : U.hexLong(pageId);
                if (this.throttlingPlc != ThrottlingPolicy.DISABLED && !restore && markDirty && !wasDirty) {
                    this.writeThrottle.onMarkDirty(this.isInCheckpoint(fullId));
                }
            }
            catch (AssertionError ex) {
                U.error(this.log, "Failed to unlock page [fullPageId=" + fullId + ", binPage=" + U.toHexString(page, this.systemPageSize()) + "]");
                throw ex;
            }
        }
    }

    @NotNull
    private String dumpPage(long pageId, int grpId) {
        int pageIdx = PageIdUtils.pageIndex(pageId);
        int partId = PageIdUtils.partId(pageId);
        long off = (long)(pageIdx + 1) * (long)this.pageSize();
        return U.hexLong(pageId) + " (grpId=" + grpId + ", pageIdx=" + pageIdx + ", partId=" + partId + ", offH=" + Long.toHexString(off) + ")";
    }

    boolean isPageWriteLocked(long absPtr) {
        return this.rwLock.isWriteLocked(absPtr + 32L);
    }

    boolean isPageReadLocked(long absPtr) {
        return this.rwLock.isReadLocked(absPtr + 32L);
    }

    boolean isInCheckpoint(FullPageId pageId) {
        Segment seg = this.segment(pageId.groupId(), pageId.pageId());
        CheckpointPages pages0 = seg.checkpointPages;
        return pages0 != null && pages0.contains(pageId);
    }

    boolean clearCheckpoint(FullPageId fullPageId) {
        Segment seg = this.segment(fullPageId.groupId(), fullPageId.pageId());
        CheckpointPages pages0 = seg.checkpointPages;
        assert (pages0 != null);
        return pages0.markAsSaved(fullPageId);
    }

    boolean isDirty(long absPtr) {
        return PageHeader.dirty(absPtr);
    }

    public int activePagesCount() {
        if (this.segments == null) {
            return 0;
        }
        int total = 0;
        for (Segment seg : this.segments) {
            total += seg.acquiredPages();
        }
        return total;
    }

    @Override
    public int checkpointBufferPagesCount() {
        return this.checkpointPool == null ? 0 : this.checkpointPool.size();
    }

    public int checkpointBufferPagesSize() {
        return this.checkpointPool == null ? 0 : this.checkpointPool.pages();
    }

    private void setDirty(FullPageId pageId, long absPtr, boolean dirty, boolean forceAdd) {
        boolean wasDirty = PageHeader.dirty(absPtr, dirty);
        if (dirty) {
            assert (this.stateChecker.checkpointLockIsHeldByThread());
            if (!wasDirty || forceAdd) {
                Segment seg = this.segment(pageId.groupId(), pageId.pageId());
                if (seg.dirtyPages.add(pageId)) {
                    long dirtyPagesCnt = seg.dirtyPagesCntr.incrementAndGet();
                    if (dirtyPagesCnt >= seg.maxDirtyPages) {
                        this.safeToUpdate.set(false);
                    }
                    this.dataRegionMetrics.incrementDirtyPages();
                }
            }
        } else {
            Segment seg = this.segment(pageId.groupId(), pageId.pageId());
            if (seg.dirtyPages.remove(pageId)) {
                seg.dirtyPagesCntr.decrementAndGet();
                this.dataRegionMetrics.decrementDirtyPages();
            }
        }
    }

    void beforeReleaseWrite(FullPageId pageId, long ptr, boolean pageWalRec) throws IgniteCheckedException {
        boolean pageRecOrAlwaysWriteFullPage;
        boolean walIsNotDisabled = this.walMgr != null && !this.walMgr.disabled(pageId.groupId(), pageId.pageId());
        boolean bl = pageRecOrAlwaysWriteFullPage = this.walMgr != null && (pageWalRec || this.walMgr.isAlwaysWriteFullPages());
        if (pageRecOrAlwaysWriteFullPage && walIsNotDisabled) {
            this.walMgr.log(new PageSnapshot(pageId, ptr, this.pageSize(), this.realPageSize(pageId.groupId())));
        }
    }

    private Segment segment(int grpId, long pageId) {
        int idx = PageMemoryImpl.segmentIndex(grpId, pageId, this.segments.length);
        return this.segments[idx];
    }

    public static int segmentIndex(int grpId, long pageId, int segments) {
        pageId = PageIdUtils.effectivePageId(pageId);
        int hash = U.hash(pageId * 65537L + (long)grpId);
        return U.safeAbs(hash) % segments;
    }

    @Override
    public boolean isCpBufferOverflowThresholdExceeded() {
        return this.writeThrottle.isCpBufferOverflowThresholdExceeded();
    }

    @Override
    public DataRegionMetricsImpl metrics() {
        return this.dataRegionMetrics;
    }

    @Override
    public FullPageId pullPageFromCpBuffer() {
        long idx = GridUnsafe.getLong(this.checkpointPool.lastAllocatedIdxPtr);
        long lastIdx = ThreadLocalRandom.current().nextLong(idx / 2L, idx);
        while (--lastIdx > 1L) {
            assert ((lastIdx & 0xFFFFFF0000000000L) == 0L);
            long relative = this.checkpointPool.relative(lastIdx);
            long freePageAbsPtr = this.checkpointPool.absolute(relative);
            FullPageId pageToReplace = PageHeader.fullPageId(freePageAbsPtr);
            if (pageToReplace.pageId() == FullPageId.NULL_PAGE.pageId() || pageToReplace.groupId() == FullPageId.NULL_PAGE.groupId() || !this.isInCheckpoint(pageToReplace)) continue;
            return pageToReplace;
        }
        return FullPageId.NULL_PAGE;
    }

    public Collection<FullPageId> dirtyPages() {
        if (this.segments == null) {
            return Collections.emptySet();
        }
        HashSet<FullPageId> res = new HashSet<FullPageId>((int)this.loadedPages());
        for (Segment seg : this.segments) {
            res.addAll(seg.dirtyPages);
        }
        return res;
    }

    private static int updateAtomicInt(long ptr, int delta) {
        int updated;
        int old;
        while (!GridUnsafe.compareAndSwapInt(null, ptr, old = GridUnsafe.getInt(ptr), updated = old + delta)) {
        }
        return updated;
    }

    private static long updateAtomicLong(long ptr, long delta) {
        long updated;
        long old;
        while (!GridUnsafe.compareAndSwapLong(null, ptr, old = GridUnsafe.getLong(ptr), updated = old + delta)) {
        }
        return updated;
    }

    private void touchPage(long absPtr, boolean pageExists) {
        long newTs = U.currentTimeMillis();
        long oldTs = PageHeader.writeTimestamp(absPtr, newTs);
        if (pageExists) {
            this.dataRegionMetrics.decrementPagesWithTimestamp(oldTs);
        }
        this.dataRegionMetrics.incrementPagesWithTimestamp(newTs & 0xFFFFFFFFFFFFFF00L);
    }

    public static enum ThrottlingPolicy {
        DISABLED,
        CHECKPOINT_BUFFER_ONLY,
        TARGET_RATIO_BASED,
        SPEED_BASED;

    }

    private static class ClearSegmentRunnable
    implements Runnable {
        private final Segment seg;
        LoadedPagesMap.KeyPredicate clearPred;
        private final CountDownFuture doneFut;
        private final int pageSize;
        private final boolean rmvDirty;
        private final DataRegionMetricsImpl memMetrics;

        private ClearSegmentRunnable(Segment seg, DataRegionMetricsImpl memMetrics, LoadedPagesMap.KeyPredicate clearPred, boolean rmvDirty, CountDownFuture doneFut, int pageSize) {
            this.seg = seg;
            this.memMetrics = memMetrics;
            this.clearPred = clearPred;
            this.rmvDirty = rmvDirty;
            this.doneFut = doneFut;
            this.pageSize = pageSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int cap = this.seg.loadedPages.capacity();
            int chunkSize = 1000;
            GridLongList ptrs = new GridLongList(chunkSize);
            try {
                int base = 0;
                while (base < cap) {
                    int boundary = Math.min(cap, base + chunkSize);
                    this.seg.writeLock().lock();
                    try {
                        GridLongList list = this.seg.loadedPages.removeIf(base, boundary, this.clearPred);
                        ptrs.addAll(list);
                        base = boundary;
                    }
                    finally {
                        this.seg.writeLock().unlock();
                    }
                    for (int i = 0; i < ptrs.size(); ++i) {
                        FullPageId fullId;
                        long relPtr = ptrs.get(i);
                        long absPtr = this.seg.pool.absolute(relPtr);
                        this.memMetrics.decrementPagesWithTimestamp(PageHeader.readTimestamp(absPtr));
                        if (this.rmvDirty && this.seg.dirtyPages.remove(fullId = PageHeader.fullPageId(absPtr))) {
                            this.seg.dirtyPagesCntr.decrementAndGet();
                        }
                        this.seg.pageReplacementPolicy.onRemove(relPtr);
                        this.seg.pool.releaseFreePage(relPtr);
                    }
                    ptrs.clear();
                }
                this.doneFut.onDone((Void)null);
            }
            catch (Throwable e) {
                this.doneFut.onDone(e);
            }
        }
    }

    class Segment
    extends ReentrantReadWriteLock {
        private static final long serialVersionUID = 0L;
        private static final int ACQUIRED_PAGES_SIZEOF = 4;
        private static final int ACQUIRED_PAGES_PADDING = 4;
        private final LoadedPagesMap loadedPages;
        private final long acquiredPagesPtr;
        private final PagePool pool;
        private final PageReplacementPolicy pageReplacementPolicy;
        private final long memPerTbl;
        private long memPerRepl;
        private volatile Collection<FullPageId> dirtyPages = new GridConcurrentHashSet<FullPageId>();
        private final AtomicLong dirtyPagesCntr = new AtomicLong();
        private volatile CheckpointPages checkpointPages;
        private final long maxDirtyPages;
        private static final int INIT_PART_GENERATION = 1;
        private final Map<GroupPartitionId, Integer> partGenerationMap = new HashMap<GroupPartitionId, Integer>();
        private boolean closed;

        private Segment(int idx, DirectMemoryRegion region, int cpPoolPages, ThrottlingPolicy throttlingPlc) {
            long totalMemory = region.size();
            int pages = (int)(totalMemory / (long)PageMemoryImpl.this.sysPageSize);
            this.acquiredPagesPtr = region.address();
            GridUnsafe.putIntVolatile(null, this.acquiredPagesPtr, 0);
            int ldPagesMapOffInRegion = 8;
            long ldPagesAddr = region.address() + (long)ldPagesMapOffInRegion;
            this.memPerTbl = PageMemoryImpl.this.useBackwardShiftMap ? RobinHoodBackwardShiftHashMap.requiredMemory(pages) : FullPageIdTable.requiredMemory(pages);
            this.loadedPages = PageMemoryImpl.this.useBackwardShiftMap ? new RobinHoodBackwardShiftHashMap(ldPagesAddr, this.memPerTbl) : new FullPageIdTable(ldPagesAddr, this.memPerTbl, true);
            pages = (int)((totalMemory - this.memPerTbl - (long)ldPagesMapOffInRegion) / (long)PageMemoryImpl.this.sysPageSize);
            this.memPerRepl = PageMemoryImpl.this.pageReplacementPolicyFactory.requiredMemory(pages);
            DirectMemoryRegion poolRegion = region.slice(this.memPerTbl + this.memPerRepl + (long)ldPagesMapOffInRegion);
            this.pool = new PagePool(idx, poolRegion, PageMemoryImpl.this.sysPageSize, PageMemoryImpl.this.rwLock);
            this.pageReplacementPolicy = PageMemoryImpl.this.pageReplacementPolicyFactory.create(this, region.address() + this.memPerTbl + (long)ldPagesMapOffInRegion, this.pool.pages());
            this.maxDirtyPages = throttlingPlc != ThrottlingPolicy.DISABLED ? (long)this.pool.pages() * 3L / 4L : Math.min((long)this.pool.pages() * 2L / 3L, (long)cpPoolPages);
        }

        private void close() {
            this.writeLock().lock();
            try {
                this.closed = true;
            }
            finally {
                this.writeLock().unlock();
            }
        }

        private boolean shouldThrottle(double dirtyRatioThreshold) {
            return this.getDirtyPagesRatio() > dirtyRatioThreshold;
        }

        private double getDirtyPagesRatio() {
            return this.dirtyPagesCntr.doubleValue() / (double)this.pages();
        }

        private int pages() {
            return this.pool.pages();
        }

        private long tableSize() {
            return this.memPerTbl;
        }

        private long replacementSize() {
            return this.memPerRepl;
        }

        private void acquirePage(long absPtr) {
            PageHeader.acquirePage(absPtr);
            PageMemoryImpl.updateAtomicInt(this.acquiredPagesPtr, 1);
        }

        private void releasePage(long absPtr) {
            PageHeader.releasePage(absPtr);
            PageMemoryImpl.updateAtomicInt(this.acquiredPagesPtr, -1);
        }

        private int acquiredPages() {
            return GridUnsafe.getInt(this.acquiredPagesPtr);
        }

        private long borrowOrAllocateFreePage(long pageId) {
            return this.pool.borrowOrAllocateFreePage(PageIdUtils.tag(pageId));
        }

        private void resetDirtyPages() {
            this.dirtyPages = new GridConcurrentHashSet<FullPageId>();
            this.dirtyPagesCntr.set(0L);
        }

        public boolean tryToRemovePage(FullPageId fullPageId, long absPtr) throws IgniteCheckedException {
            assert (this.writeLock().isHeldByCurrentThread());
            if (fullPageId.pageId() == PageIdAllocator.META_PAGE_ID) {
                return false;
            }
            if (PageHeader.isAcquired(absPtr)) {
                return false;
            }
            this.clearRowCache(fullPageId, absPtr);
            if (PageMemoryImpl.this.isDirty(absPtr)) {
                CheckpointPages checkpointPages = this.checkpointPages;
                if (checkpointPages == null || !checkpointPages.allowToSave(fullPageId)) {
                    return false;
                }
                assert (PageMemoryImpl.this.pmPageMgr != null);
                PageStoreWriter saveDirtyPage = PageMemoryImpl.this.delayedPageReplacementTracker != null ? PageMemoryImpl.this.delayedPageReplacementTracker.delayedPageWrite() : PageMemoryImpl.this.flushDirtyPage;
                saveDirtyPage.writePage(fullPageId, GridUnsafe.wrapPointer(absPtr + 48L, PageMemoryImpl.this.pageSize()), this.partGeneration(fullPageId.groupId(), PageIdUtils.partId(fullPageId.pageId())));
                PageMemoryImpl.this.setDirty(fullPageId, absPtr, false, true);
                checkpointPages.markAsSaved(fullPageId);
            }
            this.loadedPages.remove(fullPageId.groupId(), fullPageId.effectivePageId());
            if (PageIO.isIndexPage(PageIO.getType(absPtr + 48L))) {
                int grpId = fullPageId.groupId();
                PageMemoryImpl.this.dataRegionMetrics.cacheGrpPageMetrics(grpId).indexPages().decrement();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clearRowCache(FullPageId fullPageId, long absPtr) throws IgniteCheckedException {
            assert (this.writeLock().isHeldByCurrentThread());
            if (PageMemoryImpl.this.ctx.kernalContext().query() == null || !PageMemoryImpl.this.ctx.kernalContext().query().moduleEnabled()) {
                return;
            }
            long pageAddr = PageMemoryImpl.this.readLock(absPtr, fullPageId.pageId(), true, false);
            try {
                if (PageIO.getType(pageAddr) != 1) {
                    return;
                }
                final IndexRowCache cleaner = PageMemoryImpl.this.ctx.kernalContext().indexProcessor().rowCacheCleaner(fullPageId.groupId());
                if (cleaner == null) {
                    return;
                }
                DataPageIO io = DataPageIO.VERSIONS.forPage(pageAddr);
                io.forAllItems(pageAddr, new AbstractDataPageIO.CC<Void>(){

                    @Override
                    public Void apply(long link) {
                        cleaner.remove(link);
                        return null;
                    }
                });
            }
            finally {
                PageMemoryImpl.this.readUnlockPage(absPtr);
            }
        }

        public long refreshOutdatedPage(int grpId, long pageId, boolean rmv) {
            Collection<FullPageId> dirtyPages;
            CheckpointPages cpPages;
            assert (this.writeLock().isHeldByCurrentThread());
            int tag = this.partGeneration(grpId, PageIdUtils.partId(pageId));
            long relPtr = this.loadedPages.refresh(grpId, PageIdUtils.effectivePageId(pageId), tag);
            long absPtr = this.absolute(relPtr);
            GridUnsafe.zeroMemory(absPtr + 48L, PageMemoryImpl.this.pageSize());
            PageHeader.dirty(absPtr, false);
            long tmpBufPtr = PageHeader.tempBufferPointer(absPtr);
            if (tmpBufPtr != 0xFFFFFFFFFFFFFFL) {
                GridUnsafe.zeroMemory(PageMemoryImpl.this.checkpointPool.absolute(tmpBufPtr) + 48L, PageMemoryImpl.this.pageSize());
                PageHeader.tempBufferPointer(absPtr, 0xFFFFFFFFFFFFFFL);
                PageHeader.releasePage(absPtr);
                PageMemoryImpl.this.releaseCheckpointBufferPage(tmpBufPtr);
            }
            if (rmv) {
                this.loadedPages.remove(grpId, PageIdUtils.effectivePageId(pageId));
            }
            if ((cpPages = this.checkpointPages) != null) {
                cpPages.markAsSaved(new FullPageId(pageId, grpId));
            }
            if ((dirtyPages = this.dirtyPages) != null && dirtyPages.remove(new FullPageId(pageId, grpId))) {
                this.dirtyPagesCntr.decrementAndGet();
            }
            return relPtr;
        }

        private long removePageForReplacement() throws IgniteCheckedException {
            assert (this.getWriteHoldCount() > 0);
            if (PageMemoryImpl.this.pageReplacementWarned == 0 && pageReplacementWarnedFieldUpdater.compareAndSet(PageMemoryImpl.this, 0, 1)) {
                final String msg = "Page replacements started, pages will be rotated with disk, this will affect storage performance (consider increasing DataRegionConfiguration#setMaxSize for data region): " + PageMemoryImpl.this.dataRegionMetrics.getName();
                U.warn(PageMemoryImpl.this.log, msg);
                if (PageMemoryImpl.this.ctx.gridEvents().isRecordable(142)) {
                    PageMemoryImpl.this.ctx.kernalContext().closure().runLocalSafe(new GridPlainRunnable(){

                        @Override
                        public void run() {
                            PageMemoryImpl.this.ctx.gridEvents().record(new PageReplacementStartedEvent(PageMemoryImpl.this.ctx.localNode(), msg, PageMemoryImpl.this.dataRegionMetrics.getName()));
                        }
                    });
                }
            }
            if (this.acquiredPages() >= this.loadedPages.size()) {
                throw this.oomException("all pages are acquired");
            }
            long replaceStartTs = System.nanoTime();
            long page = this.pageReplacementPolicy.replace();
            PageMemoryImpl.this.dataRegionMetrics.onPageReplaced(U.currentTimeMillis() - PageHeader.readTimestamp(this.absolute(page)), System.nanoTime() - replaceStartTs);
            return page;
        }

        public IgniteOutOfMemoryException oomException(String reason) {
            return new IgniteOutOfMemoryException("Failed to find a page for eviction (" + reason + ") [segmentCapacity=" + this.loadedPages.capacity() + ", loaded=" + this.loadedPages.size() + ", maxDirtyPages=" + this.maxDirtyPages + ", dirtyPages=" + this.dirtyPagesCntr + ", cpPages=" + (this.checkpointPages() == null ? 0 : this.checkpointPages().size()) + ", pinned=" + this.acquiredPages() + "]" + U.nl() + "Out of memory in data region [name=" + PageMemoryImpl.this.dataRegionCfg.getName() + ", initSize=" + U.readableSize(PageMemoryImpl.this.dataRegionCfg.getInitialSize(), false) + ", maxSize=" + U.readableSize(PageMemoryImpl.this.dataRegionCfg.getMaxSize(), false) + ", persistenceEnabled=" + PageMemoryImpl.this.dataRegionCfg.isPersistenceEnabled() + "] Try the following:" + U.nl() + "  ^-- Increase maximum off-heap memory size (DataRegionConfiguration.maxSize)" + U.nl() + "  ^-- Enable eviction or expiration policies");
        }

        public long absolute(long relPtr) {
            return this.pool.absolute(relPtr);
        }

        public long relative(long pageIdx) {
            return this.pool.relative(pageIdx);
        }

        public long pageIndex(long relPtr) {
            return this.pool.pageIndex(relPtr);
        }

        public int partGeneration(int grpId, int partId) {
            assert (this.getReadHoldCount() > 0 || this.getWriteHoldCount() > 0);
            Integer tag = this.partGenerationMap.get(new GroupPartitionId(grpId, partId));
            assert (tag == null || tag >= 0) : "Negative tag=" + tag;
            return tag == null ? 1 : tag;
        }

        public LoadedPagesMap loadedPages() {
            return this.loadedPages;
        }

        public CheckpointPages checkpointPages() {
            return this.checkpointPages;
        }

        public PagePool pool() {
            return this.pool;
        }

        private int incrementPartGeneration(int grpId, int partId) {
            assert (this.getWriteHoldCount() > 0);
            GroupPartitionId grpPart = new GroupPartitionId(grpId, partId);
            Integer gen = this.partGenerationMap.get(grpPart);
            if (gen == null) {
                gen = 1;
            }
            if (gen == Integer.MAX_VALUE) {
                U.warn(PageMemoryImpl.this.log, "Partition tag overflow [grpId=" + grpId + ", partId=" + partId + "]");
                this.partGenerationMap.put(grpPart, 0);
                return 0;
            }
            this.partGenerationMap.put(grpPart, gen + 1);
            return gen + 1;
        }

        private void resetGroupPartitionsGeneration(int grpId) {
            assert (this.getWriteHoldCount() > 0);
            this.partGenerationMap.keySet().removeIf(grpPart -> grpPart.getGroupId() == grpId);
        }
    }
}

