/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.MemoryCalculator;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageLockDump;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageLockThreadState;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageLockTracker;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageLockTrackerFactory;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.SharedPageLockTrackerDump;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.ThreadPageLockState;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageLockListener;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.worker.CycleThread;

public class SharedPageLockTracker {
    private static final long OVERHEAD_SIZE = 92L;
    public static final int DFLT_PAGE_LOCK_TRACKER_CHECK_INTERVAL = 60000;
    private final MemoryCalculator memCalc;
    public final int threadLimits;
    private final Map<Long, PageLockTracker<?>> threadStacks = new HashMap();
    private final Map<Long, Thread> threadIdToThreadRef = new HashMap<Long, Thread>();
    private final Map<String, Integer> structureNameToId = new ConcurrentHashMap<String, Integer>();
    private final TimeOutWorker timeOutWorker;
    private Map<Long, PageLockThreadState> prevThreadsState = new HashMap<Long, PageLockThreadState>();
    private final AtomicInteger idGen = new AtomicInteger();
    private final Consumer<Set<PageLockThreadState>> hangThreadsCallBack;
    private final ThreadLocal<PageLockTracker<?>> lockTracker = ThreadLocal.withInitial(this::createTracker);

    public SharedPageLockTracker() {
        this(ids -> {}, new MemoryCalculator());
    }

    public SharedPageLockTracker(Consumer<Set<PageLockThreadState>> hangThreadsCallBack, MemoryCalculator memCalc) {
        this(1000, IgniteSystemProperties.getInteger("IGNITE_PAGE_LOCK_TRACKER_CHECK_INTERVAL", 60000), hangThreadsCallBack, memCalc);
    }

    public SharedPageLockTracker(int threadLimits, int timeOutWorkerInterval, Consumer<Set<PageLockThreadState>> hangThreadsCallBack, MemoryCalculator memCalc) {
        this.threadLimits = threadLimits;
        this.timeOutWorker = new TimeOutWorker((long)timeOutWorkerInterval);
        this.hangThreadsCallBack = hangThreadsCallBack;
        this.memCalc = memCalc;
        this.memCalc.onHeapAllocated(92L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PageLockTracker<?> createTracker() {
        Thread thread = Thread.currentThread();
        String name = "name=" + thread.getName();
        long threadId = thread.getId();
        PageLockTracker<? extends PageLockDump> tracker = PageLockTrackerFactory.create(PageLockTrackerFactory.DEFAULT_TYPE, PageLockTrackerFactory.DEFAULT_CAPACITY, name, this.memCalc);
        SharedPageLockTracker sharedPageLockTracker = this;
        synchronized (sharedPageLockTracker) {
            this.threadStacks.put(threadId, tracker);
            this.threadIdToThreadRef.put(threadId, thread);
            this.memCalc.onHeapAllocated(80L);
            if (this.threadIdToThreadRef.size() > this.threadLimits) {
                this.cleanTerminatedThreads();
            }
        }
        return tracker;
    }

    public PageLockListener registerStructure(final String structureName) {
        final int structureId = this.structureNameToId.computeIfAbsent(structureName, name -> {
            this.memCalc.onHeapAllocated(name.getBytes().length + 16 + 28);
            return this.idGen.incrementAndGet();
        });
        this.memCalc.onHeapAllocated(28L);
        return new PageLockListener(){

            @Override
            public void onBeforeWriteLock(int cacheId, long pageId, long page) {
                SharedPageLockTracker.this.lockTracker.get().onBeforeWriteLock(structureId, pageId, page);
            }

            @Override
            public void onWriteLock(int cacheId, long pageId, long page, long pageAddr) {
                SharedPageLockTracker.this.lockTracker.get().onWriteLock(structureId, pageId, page, pageAddr);
            }

            @Override
            public void onWriteUnlock(int cacheId, long pageId, long page, long pageAddr) {
                SharedPageLockTracker.this.lockTracker.get().onWriteUnlock(structureId, pageId, page, pageAddr);
            }

            @Override
            public void onBeforeReadLock(int cacheId, long pageId, long page) {
                SharedPageLockTracker.this.lockTracker.get().onBeforeReadLock(structureId, pageId, page);
            }

            @Override
            public void onReadLock(int cacheId, long pageId, long page, long pageAddr) {
                SharedPageLockTracker.this.lockTracker.get().onReadLock(structureId, pageId, page, pageAddr);
            }

            @Override
            public void onReadUnlock(int cacheId, long pageId, long page, long pageAddr) {
                SharedPageLockTracker.this.lockTracker.get().onReadUnlock(structureId, pageId, page, pageAddr);
            }

            @Override
            public void close() {
                SharedPageLockTracker.this.structureNameToId.remove(structureName);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SharedPageLockTrackerDump dump() {
        Collection<PageLockTracker<?>> trackers = this.threadStacks.values();
        ArrayList<ThreadPageLockState> threadPageLockStates = new ArrayList<ThreadPageLockState>(this.threadStacks.size());
        for (PageLockTracker<?> pageLockTracker : trackers) {
            boolean acquired = pageLockTracker.acquireSafePoint();
            assert (acquired);
        }
        for (Map.Entry entry : this.threadStacks.entrySet()) {
            Long threadId = (Long)entry.getKey();
            Thread thread = this.threadIdToThreadRef.get(threadId);
            PageLockTracker tracker = (PageLockTracker)entry.getValue();
            try {
                Object pageLockDump = tracker.dump();
                threadPageLockStates.add(new ThreadPageLockState(threadId, thread.getName(), thread.getState(), (PageLockDump)pageLockDump, tracker.invalidContext()));
            }
            finally {
                tracker.releaseSafePoint();
            }
        }
        Map<Integer, String> idToStructureName = this.structureNameToId.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        long l = !threadPageLockStates.isEmpty() ? ((ThreadPageLockState)threadPageLockStates.get((int)0)).pageLockDump.time : System.currentTimeMillis();
        return new SharedPageLockTrackerDump(l, idToStructureName, threadPageLockStates);
    }

    private synchronized void cleanTerminatedThreads() {
        Iterator<Map.Entry<Long, Thread>> it = this.threadIdToThreadRef.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Long, Thread> entry = it.next();
            long threadId = entry.getKey();
            Thread thread = entry.getValue();
            if (thread.getState() != Thread.State.TERMINATED) continue;
            PageLockTracker<?> tracker = this.threadStacks.remove(threadId);
            if (tracker != null) {
                this.memCalc.onHeapFree(40L);
                tracker.close();
            }
            it.remove();
            this.memCalc.onHeapFree(40L);
        }
    }

    private Map<Long, PageLockThreadState> getThreadOperationState() {
        return this.threadStacks.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            PageLockTracker lt = (PageLockTracker)e.getValue();
            return new PageLockThreadState(lt.operationsCounter(), lt.heldLocksNumber(), this.threadIdToThreadRef.get(e.getKey()));
        }));
    }

    private synchronized Set<PageLockThreadState> hangThreads() {
        HashSet<PageLockThreadState> hangsThreads = new HashSet<PageLockThreadState>();
        Map<Long, PageLockThreadState> curThreadsOperationState = this.getThreadOperationState();
        this.prevThreadsState.forEach((threadId, prevState) -> {
            boolean threadHoldedLocks;
            PageLockThreadState state = (PageLockThreadState)curThreadsOperationState.get(threadId);
            if (state == null) {
                return;
            }
            boolean bl = threadHoldedLocks = state.heldLockCnt != 0L;
            if (prevState.equals(state) && threadHoldedLocks) {
                hangsThreads.add(state);
            }
        });
        this.prevThreadsState = curThreadsOperationState;
        return hangsThreads;
    }

    public void start() {
        this.timeOutWorker.setDaemon(true);
        this.timeOutWorker.start();
    }

    public void stop() {
        this.timeOutWorker.interrupt();
        try {
            this.timeOutWorker.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInterruptedException(e);
        }
    }

    private class TimeOutWorker
    extends CycleThread {
        TimeOutWorker(long interval) {
            super("page-lock-tracker-timeout", interval);
        }

        @Override
        public void iteration() {
            Set<PageLockThreadState> threadIds;
            SharedPageLockTracker.this.cleanTerminatedThreads();
            if (SharedPageLockTracker.this.hangThreadsCallBack != null && !F.isEmpty(threadIds = SharedPageLockTracker.this.hangThreads())) {
                SharedPageLockTracker.this.hangThreadsCallBack.accept(threadIds);
            }
        }
    }
}

