/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.management.tx.TxCommandArg;
import org.apache.ignite.internal.management.tx.TxInfo;
import org.apache.ignite.internal.management.tx.TxSortOrder;
import org.apache.ignite.internal.management.tx.TxTask;
import org.apache.ignite.internal.management.tx.TxTaskResult;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.internal.visor.VisorTaskResult;
import org.apache.ignite.mxbean.TransactionsMXBean;

public class TransactionsMXBeanImpl
implements TransactionsMXBean {
    private final GridKernalContext ctx;

    public TransactionsMXBeanImpl(GridKernalContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public String getActiveTransactions(Long minDuration, Integer minSize, String prj, String consistentIds, String xid, String lbRegex, Integer limit, String order, boolean detailed, boolean kill) {
        try {
            String[] consIds = null;
            if (consistentIds != null) {
                consIds = consistentIds.split(",");
            }
            TxSortOrder sortOrder = null;
            if (order != null) {
                sortOrder = TxSortOrder.valueOf(order.toUpperCase());
            }
            TxCommandArg arg = new TxCommandArg();
            if (kill) {
                arg.kill(true);
            }
            arg.limit(limit);
            arg.minDuration(minDuration);
            arg.minSize(minSize);
            if (prj != null) {
                if ("clients".equals(prj)) {
                    arg.clients(true);
                } else if ("servers".equals(prj)) {
                    arg.servers(true);
                }
            }
            arg.nodes(consIds);
            arg.xid(xid);
            arg.label(lbRegex);
            arg.order(sortOrder);
            Map res = (Map)((VisorTaskResult)this.ctx.task().execute(new TxTask(), new VisorTaskArgument<TxCommandArg>(this.ctx.cluster().get().localNode().id(), arg, false)).get()).result();
            if (detailed) {
                StringWriter sw = new StringWriter();
                PrintWriter w = new PrintWriter(sw);
                for (Map.Entry entry : res.entrySet()) {
                    if (((TxTaskResult)entry.getValue()).getInfos().isEmpty()) continue;
                    ClusterNode key = (ClusterNode)entry.getKey();
                    w.println(key.toString());
                    for (TxInfo info : ((TxTaskResult)entry.getValue()).getInfos()) {
                        w.println(info.toUserString());
                    }
                }
                w.flush();
                return sw.toString();
            }
            int cnt = 0;
            for (TxTaskResult result : res.values()) {
                cnt += result.getInfos().size();
            }
            return Integer.toString(cnt);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void cancel(String xid) {
        A.notNull(xid, "xid");
        try {
            TxCommandArg arg = new TxCommandArg();
            arg.kill(true);
            arg.limit(1);
            arg.xid(xid);
            this.ctx.task().execute(new TxTask(), new VisorTaskArgument<TxCommandArg>(this.ctx.localNodeId(), arg, false)).get();
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public long getTxTimeoutOnPartitionMapExchange() {
        return this.ctx.config().getTransactionConfiguration().getTxTimeoutOnPartitionMapExchange();
    }

    @Override
    public void setTxTimeoutOnPartitionMapExchange(long timeout) {
        try {
            this.ctx.cache().context().tm().setTxTimeoutOnPartitionMapExchange(timeout);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public boolean getTxOwnerDumpRequestsAllowed() {
        return this.ctx.cache().context().tm().txOwnerDumpRequestsAllowed();
    }

    @Override
    public void setTxOwnerDumpRequestsAllowed(boolean allowed) {
        this.ctx.cache().context().tm().setTxOwnerDumpRequestsAllowedDistributed(allowed);
    }

    @Override
    public long getLongTransactionTimeDumpThreshold() {
        return this.ctx.cache().context().tm().longTransactionTimeDumpThreshold();
    }

    @Override
    public void setLongTransactionTimeDumpThreshold(long threshold) {
        this.ctx.cache().context().tm().longTransactionTimeDumpThresholdDistributed(threshold);
    }

    @Override
    public double getTransactionTimeDumpSamplesCoefficient() {
        return this.ctx.cache().context().tm().transactionTimeDumpSamplesCoefficient();
    }

    @Override
    public void setTransactionTimeDumpSamplesCoefficient(double coefficient) {
        this.ctx.cache().context().tm().transactionTimeDumpSamplesCoefficientDistributed(coefficient);
    }

    @Override
    public int getTransactionTimeDumpSamplesPerSecondLimit() {
        return this.ctx.cache().context().tm().transactionTimeDumpSamplesPerSecondLimit();
    }

    @Override
    public void setTransactionTimeDumpSamplesPerSecondLimit(int limit) {
        this.ctx.cache().context().tm().longTransactionTimeDumpSamplesPerSecondLimit(limit);
    }

    @Override
    public void setLongOperationsDumpTimeout(long timeout) {
        this.ctx.cache().context().tm().longOperationsDumpTimeoutDistributed(timeout);
    }

    @Override
    public long getLongOperationsDumpTimeout() {
        return this.ctx.cache().context().tm().longOperationsDumpTimeout();
    }

    @Override
    public void setTxKeyCollisionsInterval(int timeout) {
        this.ctx.cache().context().tm().collisionsDumpIntervalDistributed(timeout);
    }

    @Override
    public int getTxKeyCollisionsInterval() {
        return this.ctx.cache().context().tm().collisionsDumpInterval();
    }

    public String toString() {
        return S.toString(TransactionsMXBeanImpl.class, this);
    }
}

