/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastructures;

import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.processors.cache.GridCacheInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;

public class GridCacheSetHeader
implements GridCacheInternal,
Externalizable {
    private static final long serialVersionUID = 0L;
    private IgniteUuid id;
    private boolean collocated;
    private boolean separated;

    public GridCacheSetHeader() {
    }

    public GridCacheSetHeader(IgniteUuid id, boolean collocated, boolean separated) {
        assert (!separated || !collocated);
        this.id = id;
        this.collocated = collocated;
        this.separated = separated;
    }

    public IgniteUuid id() {
        return this.id;
    }

    public boolean collocated() {
        return this.collocated;
    }

    public boolean separated() {
        return this.separated;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeIgniteUuid(out, this.id);
        out.writeBoolean(this.collocated);
        out.writeBoolean(this.separated);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.id = U.readIgniteUuid(in);
        this.collocated = in.readBoolean();
        try {
            this.separated = in.readBoolean();
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public String toString() {
        return S.toString(GridCacheSetHeader.class, this);
    }
}

