/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.file;

import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.file.Path;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.U;

public class FileDownloader {
    private final IgniteLogger log;
    private static final int CHUNK_SIZE = 0x1000000;
    private final Path path;
    private long bytesReceived;
    private boolean doneTransfer;
    private long bytesSent = -1L;
    private ServerSocketChannel srvChan;
    private SocketChannel readChan;
    private final GridFutureAdapter<Void> finishFut = new GridFutureAdapter();

    public FileDownloader(IgniteLogger log, Path path) {
        this.log = log;
        this.path = path;
    }

    public IgniteInternalFuture<Void> finishFuture() {
        return this.finishFut;
    }

    public InetSocketAddress start() throws IgniteCheckedException {
        try {
            ServerSocketChannel ch = ServerSocketChannel.open();
            ch.bind(null);
            this.srvChan = ch;
            return (InetSocketAddress)ch.getLocalAddress();
        }
        catch (Exception ex) {
            throw new IgniteCheckedException(ex);
        }
    }

    /*
     * Exception decompiling
     */
    public void download() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResult(long size, Throwable th) {
        FileDownloader fileDownloader = this;
        synchronized (fileDownloader) {
            if (th != null) {
                this.bytesSent = 0L;
                this.finishFut.onDone(th);
                U.closeQuiet(this.readChan);
            } else {
                this.bytesSent = size;
                this.checkCompleted();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean onBytesReceived(long transferred) {
        FileDownloader fileDownloader = this;
        synchronized (fileDownloader) {
            this.bytesReceived += transferred;
            return this.bytesSent != -1L && this.bytesSent == this.bytesReceived;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDoneTransfer() {
        FileDownloader fileDownloader = this;
        synchronized (fileDownloader) {
            this.doneTransfer = true;
            this.checkCompleted();
        }
    }

    private void checkCompleted() {
        if (this.doneTransfer && this.bytesSent != -1L) {
            if (this.bytesReceived == this.bytesSent) {
                this.finishFut.onDone();
            } else {
                this.finishFut.onDone(new IgniteException("Failed to transfer file (sent and received sizes mismatch) [bytesReceived=" + this.bytesReceived + ", bytesSent=" + this.bytesSent + ", file=" + this.path + "]"));
            }
        }
    }
}

