/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.io.Externalizable;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.management.api.CommandUtils;
import org.apache.ignite.internal.management.api.ComputeCommand;
import org.apache.ignite.internal.management.cache.CacheValidateIndexesCommandArg;
import org.apache.ignite.internal.management.cache.IndexIntegrityCheckIssue;
import org.apache.ignite.internal.management.cache.IndexValidationIssue;
import org.apache.ignite.internal.management.cache.ValidateIndexesCheckSizeIssue;
import org.apache.ignite.internal.management.cache.ValidateIndexesCheckSizeResult;
import org.apache.ignite.internal.management.cache.ValidateIndexesJobResult;
import org.apache.ignite.internal.management.cache.ValidateIndexesPartitionResult;
import org.apache.ignite.internal.management.cache.ValidateIndexesTask;
import org.apache.ignite.internal.management.cache.ValidateIndexesTaskResult;
import org.apache.ignite.internal.util.typedef.F;

public class CacheValidateIndexesCommand
implements ComputeCommand<CacheValidateIndexesCommandArg, ValidateIndexesTaskResult> {
    @Override
    public String description() {
        return "Validates indexes for the specified caches/cache groups on an idle cluster on all or specified cluster nodes. validate_indexes checks consistence between primary/secondary indexes against each other and data entries";
    }

    @Override
    public Class<CacheValidateIndexesCommandArg> argClass() {
        return CacheValidateIndexesCommandArg.class;
    }

    @Override
    public Class<ValidateIndexesTask> taskClass() {
        return ValidateIndexesTask.class;
    }

    @Override
    public Collection<GridClientNode> nodes(Collection<GridClientNode> nodes, CacheValidateIndexesCommandArg arg) {
        if (F.isEmpty(arg.nodeIds())) {
            return null;
        }
        return CommandUtils.nodes(arg.nodeIds(), nodes);
    }

    @Override
    public void printResult(CacheValidateIndexesCommandArg arg, ValidateIndexesTaskResult res0, Consumer<String> printer) {
        boolean errors;
        boolean bl = errors = !F.isEmpty(res0.exceptions());
        if (errors) {
            printer.accept("Index validation failed on nodes:");
            res0.exceptions().forEach((node, err) -> CommandUtils.printNodeError(printer, node.id(), node.consistentId(), err));
        }
        for (Map.Entry<ValidateIndexesTaskResult.NodeInfo, ValidateIndexesJobResult> nodeEntry : res0.results().entrySet()) {
            Externalizable res;
            ValidateIndexesJobResult jobRes = nodeEntry.getValue();
            if (!jobRes.hasIssues()) continue;
            errors = true;
            printer.accept("Index issues found on node " + nodeEntry.getKey().id() + " [consistentId='" + nodeEntry.getKey().consistentId() + "']:");
            for (IndexIntegrityCheckIssue indexIntegrityCheckIssue : jobRes.integrityCheckFailures()) {
                printer.accept("  " + indexIntegrityCheckIssue);
            }
            for (Map.Entry entry : jobRes.partitionResult().entrySet()) {
                res = (ValidateIndexesPartitionResult)entry.getValue();
                if (((ValidateIndexesPartitionResult)res).issues().isEmpty()) continue;
                printer.accept("  " + CommandUtils.join(" ", entry.getKey(), entry.getValue()));
                for (IndexValidationIssue is : ((ValidateIndexesPartitionResult)res).issues()) {
                    printer.accept("    " + is);
                }
            }
            for (Map.Entry entry : jobRes.indexResult().entrySet()) {
                res = (ValidateIndexesPartitionResult)entry.getValue();
                if (((ValidateIndexesPartitionResult)res).issues().isEmpty()) continue;
                printer.accept("  " + CommandUtils.join(" ", "SQL Index", entry.getKey(), entry.getValue()));
                for (IndexValidationIssue is : ((ValidateIndexesPartitionResult)res).issues()) {
                    printer.accept("    " + is);
                }
            }
            for (Map.Entry entry : jobRes.checkSizeResult().entrySet()) {
                res = (ValidateIndexesCheckSizeResult)entry.getValue();
                Collection<ValidateIndexesCheckSizeIssue> issues = ((ValidateIndexesCheckSizeResult)res).issues();
                if (issues.isEmpty()) continue;
                printer.accept("  " + CommandUtils.join(" ", "Size check", entry.getKey(), res));
                for (ValidateIndexesCheckSizeIssue issue : issues) {
                    printer.accept("    " + issue);
                }
            }
        }
        if (!errors) {
            printer.accept("no issues found.");
        } else {
            printer.accept("issues found (listed above).");
        }
        printer.accept("");
    }
}

