/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.command;

import org.apache.ignite.internal.sql.SqlLexer;
import org.apache.ignite.internal.sql.SqlParserUtils;
import org.apache.ignite.internal.sql.command.SqlCommand;
import org.apache.ignite.internal.sql.command.SqlQualifiedName;
import org.apache.ignite.internal.util.typedef.internal.S;

public class SqlDropViewCommand
implements SqlCommand {
    private String schemaName;
    private String viewName;
    private boolean ifExists;

    public SqlDropViewCommand() {
    }

    public SqlDropViewCommand(String schemaName, String viewName, boolean ifExists) {
        this.schemaName = schemaName;
        this.viewName = viewName;
        this.ifExists = ifExists;
    }

    @Override
    public String schemaName() {
        return this.schemaName;
    }

    @Override
    public void schemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String viewName() {
        return this.viewName;
    }

    public boolean ifExists() {
        return this.ifExists;
    }

    @Override
    public SqlCommand parse(SqlLexer lex) {
        this.ifExists = SqlParserUtils.parseIfExists(lex);
        SqlQualifiedName viewQName = this.ifExists ? SqlParserUtils.parseQualifiedIdentifier(lex, new String[0]) : SqlParserUtils.parseQualifiedIdentifier(lex, "IF");
        this.schemaName = viewQName.schemaName();
        this.viewName = viewQName.name();
        return this;
    }

    public String toString() {
        return S.toString(SqlDropViewCommand.class, this);
    }
}

